/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Ch34xSerialDriver
implements UsbSerialDriver {
    private static final String TAG = Ch34xSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;
    private static final int LCR_ENABLE_RX = 128;
    private static final int LCR_ENABLE_TX = 64;
    private static final int LCR_MARK_SPACE = 32;
    private static final int LCR_PAR_EVEN = 16;
    private static final int LCR_ENABLE_PAR = 8;
    private static final int LCR_STOP_BITS_2 = 4;
    private static final int LCR_CS8 = 3;
    private static final int LCR_CS7 = 2;
    private static final int LCR_CS6 = 1;
    private static final int LCR_CS5 = 0;
    private static final int GCL_CTS = 1;
    private static final int GCL_DSR = 2;
    private static final int GCL_RI = 4;
    private static final int GCL_CD = 8;
    private static final int SCL_DTR = 32;
    private static final int SCL_RTS = 64;

    public Ch34xSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new Ch340SerialPort(this.mDevice, 0);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6790, new int[]{29987, 21795});
        return supportedDevices;
    }

    public class Ch340SerialPort
    extends CommonUsbSerialPort {
        private static final int USB_TIMEOUT_MILLIS = 5000;
        private final int DEFAULT_BAUD_RATE = 9600;
        private boolean dtr;
        private boolean rts;

        public Ch340SerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.DEFAULT_BAUD_RATE = 9600;
            this.dtr = false;
            this.rts = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return Ch34xSerialDriver.this;
        }

        @Override
        protected void openInt(UsbDeviceConnection connection) throws IOException {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbIface = this.mDevice.getInterface(i);
                if (this.mConnection.claimInterface(usbIface, true)) continue;
                throw new IOException("Could not claim data interface");
            }
            UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
            for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                UsbEndpoint ep = dataIface.getEndpoint(i);
                if (ep.getType() != 2) continue;
                if (ep.getDirection() == 128) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                this.mWriteEndpoint = ep;
            }
            this.initialize();
            this.setBaudRate(9600);
        }

        @Override
        protected void closeInt() {
            try {
                for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                    this.mConnection.releaseInterface(this.mDevice.getInterface(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int controlOut(int request, int value, int index) {
            int REQTYPE_HOST_TO_DEVICE = 64;
            return this.mConnection.controlTransfer(64, request, value, index, null, 0, 5000);
        }

        private int controlIn(int request, int value, int index, byte[] buffer) {
            int REQTYPE_DEVICE_TO_HOST = 192;
            return this.mConnection.controlTransfer(192, request, value, index, buffer, buffer.length, 5000);
        }

        private void checkState(String msg, int request, int value, int[] expected) throws IOException {
            byte[] buffer = new byte[expected.length];
            int ret = this.controlIn(request, value, 0, buffer);
            if (ret < 0) {
                throw new IOException("Failed send cmd [" + msg + "]");
            }
            if (ret != expected.length) {
                throw new IOException("Expected " + expected.length + " bytes, but get " + ret + " [" + msg + "]");
            }
            for (int i = 0; i < expected.length; ++i) {
                int current;
                if (expected[i] == -1 || expected[i] == (current = buffer[i] & 0xFF)) continue;
                throw new IOException("Expected 0x" + Integer.toHexString(expected[i]) + " byte, but get 0x" + Integer.toHexString(current) + " [" + msg + "]");
            }
        }

        private void setControlLines() throws IOException {
            if (this.controlOut(164, ~((this.dtr ? 32 : 0) | (this.rts ? 64 : 0)), 0) < 0) {
                throw new IOException("Failed to set control lines");
            }
        }

        private byte getStatus() throws IOException {
            byte[] buffer = new byte[2];
            int ret = this.controlIn(149, 1798, 0, buffer);
            if (ret < 0) {
                throw new IOException("Error getting control lines");
            }
            return buffer[0];
        }

        private void initialize() throws IOException {
            this.checkState("init #1", 95, 0, new int[]{-1, 0});
            if (this.controlOut(161, 0, 0) < 0) {
                throw new IOException("Init failed: #2");
            }
            this.setBaudRate(9600);
            this.checkState("init #4", 149, 9496, new int[]{-1, 0});
            if (this.controlOut(154, 9496, 195) < 0) {
                throw new IOException("Init failed: #5");
            }
            this.checkState("init #6", 149, 1798, new int[]{-1, -1});
            if (this.controlOut(161, 20511, 55562) < 0) {
                throw new IOException("Init failed: #7");
            }
            this.setBaudRate(9600);
            this.setControlLines();
            this.checkState("init #10", 149, 1798, new int[]{-1, -1});
        }

        private void setBaudRate(int baudRate) throws IOException {
            long factor;
            long divisor;
            if (baudRate == 921600) {
                divisor = 7L;
                factor = 62208L;
            } else {
                long BAUDBASE_FACTOR = 1532620800L;
                int BAUDBASE_DIVMAX = 3;
                factor = 1532620800L / (long)baudRate;
                for (divisor = 3L; factor > 65520L && divisor > 0L; factor >>= 3, --divisor) {
                }
                if (factor > 65520L) {
                    throw new UnsupportedOperationException("Unsupported baud rate: " + baudRate);
                }
                factor = 65536L - factor;
            }
            int val1 = (int)(factor & 0xFF00L | (divisor |= 0x80L));
            int val2 = (int)(factor & 0xFFL);
            Log.d((String)TAG, (String)String.format("baud rate=%d, 0x1312=0x%04x, 0x0f2c=0x%04x", baudRate, val1, val2));
            int ret = this.controlOut(154, 4882, val1);
            if (ret < 0) {
                throw new IOException("Error setting baud rate: #1)");
            }
            ret = this.controlOut(154, 3884, val2);
            if (ret < 0) {
                throw new IOException("Error setting baud rate: #2");
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            this.setBaudRate(baudRate);
            int lcr = 192;
            switch (dataBits) {
                case 5: {
                    lcr |= 0;
                    break;
                }
                case 6: {
                    lcr |= 1;
                    break;
                }
                case 7: {
                    lcr |= 2;
                    break;
                }
                case 8: {
                    lcr |= 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data bits: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    break;
                }
                case 1: {
                    lcr |= 8;
                    break;
                }
                case 2: {
                    lcr |= 0x18;
                    break;
                }
                case 3: {
                    lcr |= 0x28;
                    break;
                }
                case 4: {
                    lcr |= 0x38;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported stop bits: 1.5");
                }
                case 2: {
                    lcr |= 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            int ret = this.controlOut(154, 9496, lcr);
            if (ret < 0) {
                throw new IOException("Error setting control byte");
            }
        }

        @Override
        public boolean getCD() throws IOException {
            return (this.getStatus() & 8) == 0;
        }

        @Override
        public boolean getCTS() throws IOException {
            return (this.getStatus() & 1) == 0;
        }

        @Override
        public boolean getDSR() throws IOException {
            return (this.getStatus() & 2) == 0;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.dtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.dtr = value;
            this.setControlLines();
        }

        @Override
        public boolean getRI() throws IOException {
            return (this.getStatus() & 4) == 0;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.rts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.rts = value;
            this.setControlLines();
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
            byte status = this.getStatus();
            EnumSet<UsbSerialPort.ControlLine> set = EnumSet.noneOf(UsbSerialPort.ControlLine.class);
            if (this.rts) {
                set.add(UsbSerialPort.ControlLine.RTS);
            }
            if ((status & 1) == 0) {
                set.add(UsbSerialPort.ControlLine.CTS);
            }
            if (this.dtr) {
                set.add(UsbSerialPort.ControlLine.DTR);
            }
            if ((status & 2) == 0) {
                set.add(UsbSerialPort.ControlLine.DSR);
            }
            if ((status & 8) == 0) {
                set.add(UsbSerialPort.ControlLine.CD);
            }
            if ((status & 4) == 0) {
                set.add(UsbSerialPort.ControlLine.RI);
            }
            return set;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.allOf(UsbSerialPort.ControlLine.class);
        }

        @Override
        public void setBreak(boolean value) throws IOException {
            byte[] req = new byte[2];
            if (this.controlIn(149, 6149, 0, req) < 0) {
                throw new IOException("Error getting BREAK condition");
            }
            if (value) {
                req[0] = (byte)(req[0] & 0xFFFFFFFE);
                req[1] = (byte)(req[1] & 0xFFFFFFBF);
            } else {
                req[0] = (byte)(req[0] | 1);
                req[1] = (byte)(req[1] | 0x40);
            }
            int val = (req[1] & 0xFF) << 8 | req[0] & 0xFF;
            if (this.controlOut(154, 6149, val) < 0) {
                throw new IOException("Error setting BREAK condition");
            }
        }
    }
}

