/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import com.hoho.android.usbserial.util.MonotonicClock;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProlificSerialDriver
implements UsbSerialDriver {
    private final String TAG = ProlificSerialDriver.class.getSimpleName();
    private static final int[] standardBaudRates = new int[]{75, 150, 300, 600, 1200, 1800, 2400, 3600, 4800, 7200, 9600, 14400, 19200, 28800, 38400, 57600, 115200, 128000, 134400, 161280, 201600, 230400, 268800, 403200, 460800, 614400, 806400, 921600, 1228800, 2457600, 3000000, 6000000};
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;

    public ProlificSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new ProlificSerialPort(this.mDevice, 0);
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1659, new int[]{8963, 9123, 9139, 9165, 9187, 9187, 9203});
        return supportedDevices;
    }

    class ProlificSerialPort
    extends CommonUsbSerialPort {
        private static final int USB_READ_TIMEOUT_MILLIS = 1000;
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int VENDOR_READ_REQUEST = 1;
        private static final int VENDOR_WRITE_REQUEST = 1;
        private static final int VENDOR_READ_HXN_REQUEST = 129;
        private static final int VENDOR_WRITE_HXN_REQUEST = 128;
        private static final int VENDOR_OUT_REQTYPE = 64;
        private static final int VENDOR_IN_REQTYPE = 192;
        private static final int CTRL_OUT_REQTYPE = 33;
        private static final int WRITE_ENDPOINT = 2;
        private static final int READ_ENDPOINT = 131;
        private static final int INTERRUPT_ENDPOINT = 129;
        private static final int RESET_HXN_REQUEST = 7;
        private static final int FLUSH_RX_REQUEST = 8;
        private static final int FLUSH_TX_REQUEST = 9;
        private static final int SET_LINE_REQUEST = 32;
        private static final int SET_CONTROL_REQUEST = 34;
        private static final int SEND_BREAK_REQUEST = 35;
        private static final int GET_CONTROL_HXN_REQUEST = 128;
        private static final int GET_CONTROL_REQUEST = 135;
        private static final int STATUS_NOTIFICATION = 161;
        private static final int RESET_HXN_RX_PIPE = 1;
        private static final int RESET_HXN_TX_PIPE = 2;
        private static final int CONTROL_DTR = 1;
        private static final int CONTROL_RTS = 2;
        private static final int GET_CONTROL_FLAG_CD = 2;
        private static final int GET_CONTROL_FLAG_DSR = 4;
        private static final int GET_CONTROL_FLAG_RI = 1;
        private static final int GET_CONTROL_FLAG_CTS = 8;
        private static final int GET_CONTROL_HXN_FLAG_CD = 64;
        private static final int GET_CONTROL_HXN_FLAG_DSR = 32;
        private static final int GET_CONTROL_HXN_FLAG_RI = 128;
        private static final int GET_CONTROL_HXN_FLAG_CTS = 8;
        private static final int STATUS_FLAG_CD = 1;
        private static final int STATUS_FLAG_DSR = 2;
        private static final int STATUS_FLAG_RI = 8;
        private static final int STATUS_FLAG_CTS = 128;
        private static final int STATUS_BUFFER_SIZE = 10;
        private static final int STATUS_BYTE_IDX = 8;
        protected DeviceType mDeviceType;
        private UsbEndpoint mInterruptEndpoint;
        private int mControlLinesValue;
        private int mBaudRate;
        private int mDataBits;
        private int mStopBits;
        private int mParity;
        private int mStatus;
        private volatile Thread mReadStatusThread;
        private final Object mReadStatusThreadLock;
        private boolean mStopReadStatusThread;
        private IOException mReadStatusException;

        public ProlificSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.mDeviceType = DeviceType.DEVICE_TYPE_HX;
            this.mControlLinesValue = 0;
            this.mBaudRate = -1;
            this.mDataBits = -1;
            this.mStopBits = -1;
            this.mParity = -1;
            this.mStatus = 0;
            this.mReadStatusThread = null;
            this.mReadStatusThreadLock = new Object();
            this.mStopReadStatusThread = false;
            this.mReadStatusException = null;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return ProlificSerialDriver.this;
        }

        private byte[] inControlTransfer(int requestType, int request, int value, int index, int length) throws IOException {
            byte[] buffer = new byte[length];
            int result = this.mConnection.controlTransfer(requestType, request, value, index, buffer, length, 1000);
            if (result != length) {
                throw new IOException(String.format("ControlTransfer 0x%x failed: %d", value, result));
            }
            return buffer;
        }

        private void outControlTransfer(int requestType, int request, int value, int index, byte[] data) throws IOException {
            int length = data == null ? 0 : data.length;
            int result = this.mConnection.controlTransfer(requestType, request, value, index, data, length, 5000);
            if (result != length) {
                throw new IOException(String.format("ControlTransfer 0x%x failed: %d", value, result));
            }
        }

        private byte[] vendorIn(int value, int index, int length) throws IOException {
            int request = this.mDeviceType == DeviceType.DEVICE_TYPE_HXN ? 129 : 1;
            return this.inControlTransfer(192, request, value, index, length);
        }

        private void vendorOut(int value, int index, byte[] data) throws IOException {
            int request = this.mDeviceType == DeviceType.DEVICE_TYPE_HXN ? 128 : 1;
            this.outControlTransfer(64, request, value, index, data);
        }

        private void resetDevice() throws IOException {
            this.purgeHwBuffers(true, true);
        }

        private void ctrlOut(int request, int value, int index, byte[] data) throws IOException {
            this.outControlTransfer(33, request, value, index, data);
        }

        private boolean testHxStatus() {
            try {
                this.inControlTransfer(192, 1, 32896, 0, 1);
                return true;
            }
            catch (IOException ignored) {
                return false;
            }
        }

        private void doBlackMagic() throws IOException {
            if (this.mDeviceType == DeviceType.DEVICE_TYPE_HXN) {
                return;
            }
            this.vendorIn(33924, 0, 1);
            this.vendorOut(1028, 0, null);
            this.vendorIn(33924, 0, 1);
            this.vendorIn(33667, 0, 1);
            this.vendorIn(33924, 0, 1);
            this.vendorOut(1028, 1, null);
            this.vendorIn(33924, 0, 1);
            this.vendorIn(33667, 0, 1);
            this.vendorOut(0, 1, null);
            this.vendorOut(1, 0, null);
            this.vendorOut(2, this.mDeviceType == DeviceType.DEVICE_TYPE_01 ? 36 : 68, null);
        }

        private void setControlLines(int newControlLinesValue) throws IOException {
            this.ctrlOut(34, newControlLinesValue, 0, null);
            this.mControlLinesValue = newControlLinesValue;
        }

        private void readStatusThreadFunction() {
            try {
                while (!this.mStopReadStatusThread) {
                    byte[] buffer = new byte[10];
                    long endTime = MonotonicClock.millis() + 500L;
                    int readBytesCount = this.mConnection.bulkTransfer(this.mInterruptEndpoint, buffer, 10, 500);
                    if (readBytesCount == -1 && MonotonicClock.millis() < endTime) {
                        this.testConnection();
                    }
                    if (readBytesCount <= 0) continue;
                    if (readBytesCount != 10) {
                        throw new IOException("Invalid status notification, expected 10 bytes, got " + readBytesCount);
                    }
                    if (buffer[0] != -95) {
                        throw new IOException("Invalid status notification, expected 161 request, got " + buffer[0]);
                    }
                    this.mStatus = buffer[8] & 0xFF;
                }
            }
            catch (IOException e) {
                this.mReadStatusException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getStatus() throws IOException {
            if (this.mReadStatusThread == null && this.mReadStatusException == null) {
                Object object = this.mReadStatusThreadLock;
                synchronized (object) {
                    if (this.mReadStatusThread == null) {
                        this.mStatus = 0;
                        if (this.mDeviceType == DeviceType.DEVICE_TYPE_HXN) {
                            byte[] data = this.vendorIn(128, 0, 1);
                            if ((data[0] & 8) == 0) {
                                this.mStatus |= 0x80;
                            }
                            if ((data[0] & 0x20) == 0) {
                                this.mStatus |= 2;
                            }
                            if ((data[0] & 0x40) == 0) {
                                this.mStatus |= 1;
                            }
                            if ((data[0] & 0x80) == 0) {
                                this.mStatus |= 8;
                            }
                        } else {
                            byte[] data = this.vendorIn(135, 0, 1);
                            if ((data[0] & 8) == 0) {
                                this.mStatus |= 0x80;
                            }
                            if ((data[0] & 4) == 0) {
                                this.mStatus |= 2;
                            }
                            if ((data[0] & 2) == 0) {
                                this.mStatus |= 1;
                            }
                            if ((data[0] & 1) == 0) {
                                this.mStatus |= 8;
                            }
                        }
                        this.mReadStatusThread = new Thread(this::readStatusThreadFunction);
                        this.mReadStatusThread.setDaemon(true);
                        this.mReadStatusThread.start();
                    }
                }
            }
            IOException readStatusException = this.mReadStatusException;
            if (this.mReadStatusException != null) {
                this.mReadStatusException = null;
                throw new IOException(readStatusException);
            }
            return this.mStatus;
        }

        private boolean testStatusFlag(int flag) throws IOException {
            return (this.getStatus() & flag) == flag;
        }

        @Override
        public void openInt(UsbDeviceConnection connection) throws IOException {
            UsbInterface usbInterface = this.mDevice.getInterface(0);
            if (!connection.claimInterface(usbInterface, true)) {
                throw new IOException("Error claiming Prolific interface 0");
            }
            block5: for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
                UsbEndpoint currentEndpoint = usbInterface.getEndpoint(i);
                switch (currentEndpoint.getAddress()) {
                    case 131: {
                        this.mReadEndpoint = currentEndpoint;
                        continue block5;
                    }
                    case 2: {
                        this.mWriteEndpoint = currentEndpoint;
                        continue block5;
                    }
                    case 129: {
                        this.mInterruptEndpoint = currentEndpoint;
                    }
                }
            }
            byte[] rawDescriptors = connection.getRawDescriptors();
            if (rawDescriptors == null || rawDescriptors.length < 14) {
                throw new IOException("Could not get device descriptors");
            }
            int usbVersion = (rawDescriptors[3] << 8) + rawDescriptors[2];
            int deviceVersion = (rawDescriptors[13] << 8) + rawDescriptors[12];
            byte maxPacketSize0 = rawDescriptors[7];
            this.mDeviceType = this.mDevice.getDeviceClass() == 2 || maxPacketSize0 != 64 ? DeviceType.DEVICE_TYPE_01 : (deviceVersion == 768 && usbVersion == 512 ? DeviceType.DEVICE_TYPE_T : (deviceVersion == 1280 ? DeviceType.DEVICE_TYPE_T : (usbVersion == 512 && !this.testHxStatus() ? DeviceType.DEVICE_TYPE_HXN : DeviceType.DEVICE_TYPE_HX)));
            this.resetDevice();
            this.doBlackMagic();
            this.setControlLines(this.mControlLinesValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeInt() {
            try {
                Object object = this.mReadStatusThreadLock;
                synchronized (object) {
                    if (this.mReadStatusThread != null) {
                        try {
                            this.mStopReadStatusThread = true;
                            this.mReadStatusThread.join();
                        }
                        catch (Exception e) {
                            Log.w((String)ProlificSerialDriver.this.TAG, (String)"An error occured while waiting for status read thread", (Throwable)e);
                        }
                        this.mStopReadStatusThread = false;
                        this.mReadStatusThread = null;
                        this.mReadStatusException = null;
                    }
                }
                this.resetDevice();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mConnection.releaseInterface(this.mDevice.getInterface(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int filterBaudRate(int baudRate) {
            int effectiveBaudRate;
            int buf;
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            if (this.mDeviceType == DeviceType.DEVICE_TYPE_HXN) {
                return baudRate;
            }
            for (int br : standardBaudRates) {
                if (br != baudRate) continue;
                return baudRate;
            }
            int baseline = 384000000;
            int mantissa = baseline / baudRate;
            if (mantissa == 0) {
                throw new UnsupportedOperationException("Baud rate to high");
            }
            int exponent = 0;
            if (this.mDeviceType == DeviceType.DEVICE_TYPE_T) {
                while (mantissa >= 2048) {
                    if (exponent < 15) {
                        mantissa >>= 1;
                        ++exponent;
                        continue;
                    }
                    throw new UnsupportedOperationException("Baud rate to low");
                }
                buf = mantissa + ((exponent & 0xFFFFFFFE) << 12) + ((exponent & 1) << 16) + Integer.MIN_VALUE;
                effectiveBaudRate = baseline / mantissa >> exponent;
            } else {
                while (mantissa >= 512) {
                    if (exponent < 7) {
                        mantissa >>= 2;
                        ++exponent;
                        continue;
                    }
                    throw new UnsupportedOperationException("Baud rate to low");
                }
                buf = mantissa + (exponent << 9) + Integer.MIN_VALUE;
                effectiveBaudRate = baseline / mantissa >> (exponent << 1);
            }
            double baudRateError = Math.abs(1.0 - (double)effectiveBaudRate / (double)baudRate);
            if (baudRateError >= 0.031) {
                throw new UnsupportedOperationException(String.format("Baud rate deviation %.1f%% is higher than allowed 3%%", baudRateError * 100.0));
            }
            Log.d((String)ProlificSerialDriver.this.TAG, (String)String.format("baud rate=%d, effective=%d, error=%.1f%%, value=0x%08x, mantissa=%d, exponent=%d", baudRate, effectiveBaudRate, baudRateError * 100.0, buf, mantissa, exponent));
            return buf;
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (this.mBaudRate == (baudRate = this.filterBaudRate(baudRate)) && this.mDataBits == dataBits && this.mStopBits == stopBits && this.mParity == parity) {
                return;
            }
            byte[] lineRequestData = new byte[7];
            lineRequestData[0] = (byte)(baudRate & 0xFF);
            lineRequestData[1] = (byte)(baudRate >> 8 & 0xFF);
            lineRequestData[2] = (byte)(baudRate >> 16 & 0xFF);
            lineRequestData[3] = (byte)(baudRate >> 24 & 0xFF);
            switch (stopBits) {
                case 1: {
                    lineRequestData[4] = 0;
                    break;
                }
                case 3: {
                    lineRequestData[4] = 1;
                    break;
                }
                case 2: {
                    lineRequestData[4] = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            switch (parity) {
                case 0: {
                    lineRequestData[5] = 0;
                    break;
                }
                case 1: {
                    lineRequestData[5] = 1;
                    break;
                }
                case 2: {
                    lineRequestData[5] = 2;
                    break;
                }
                case 3: {
                    lineRequestData[5] = 3;
                    break;
                }
                case 4: {
                    lineRequestData[5] = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            if (dataBits < 5 || dataBits > 8) {
                throw new IllegalArgumentException("Invalid data bits: " + dataBits);
            }
            lineRequestData[6] = (byte)dataBits;
            this.ctrlOut(32, 0, 0, lineRequestData);
            this.resetDevice();
            this.mBaudRate = baudRate;
            this.mDataBits = dataBits;
            this.mStopBits = stopBits;
            this.mParity = parity;
        }

        @Override
        public boolean getCD() throws IOException {
            return this.testStatusFlag(1);
        }

        @Override
        public boolean getCTS() throws IOException {
            return this.testStatusFlag(128);
        }

        @Override
        public boolean getDSR() throws IOException {
            return this.testStatusFlag(2);
        }

        @Override
        public boolean getDTR() throws IOException {
            return (this.mControlLinesValue & 1) != 0;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            int newControlLinesValue = value ? this.mControlLinesValue | 1 : this.mControlLinesValue & 0xFFFFFFFE;
            this.setControlLines(newControlLinesValue);
        }

        @Override
        public boolean getRI() throws IOException {
            return this.testStatusFlag(8);
        }

        @Override
        public boolean getRTS() throws IOException {
            return (this.mControlLinesValue & 2) != 0;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            int newControlLinesValue = value ? this.mControlLinesValue | 2 : this.mControlLinesValue & 0xFFFFFFFD;
            this.setControlLines(newControlLinesValue);
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
            int status = this.getStatus();
            EnumSet<UsbSerialPort.ControlLine> set = EnumSet.noneOf(UsbSerialPort.ControlLine.class);
            if ((this.mControlLinesValue & 2) != 0) {
                set.add(UsbSerialPort.ControlLine.RTS);
            }
            if ((status & 0x80) != 0) {
                set.add(UsbSerialPort.ControlLine.CTS);
            }
            if ((this.mControlLinesValue & 1) != 0) {
                set.add(UsbSerialPort.ControlLine.DTR);
            }
            if ((status & 2) != 0) {
                set.add(UsbSerialPort.ControlLine.DSR);
            }
            if ((status & 1) != 0) {
                set.add(UsbSerialPort.ControlLine.CD);
            }
            if ((status & 8) != 0) {
                set.add(UsbSerialPort.ControlLine.RI);
            }
            return set;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.allOf(UsbSerialPort.ControlLine.class);
        }

        @Override
        public void purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
            if (this.mDeviceType == DeviceType.DEVICE_TYPE_HXN) {
                int index = 0;
                if (purgeWriteBuffers) {
                    index |= 1;
                }
                if (purgeReadBuffers) {
                    index |= 2;
                }
                if (index != 0) {
                    this.vendorOut(7, index, null);
                }
            } else {
                if (purgeWriteBuffers) {
                    this.vendorOut(8, 0, null);
                }
                if (purgeReadBuffers) {
                    this.vendorOut(9, 0, null);
                }
            }
        }

        @Override
        public void setBreak(boolean value) throws IOException {
            this.ctrlOut(35, value ? 65535 : 0, 0, null);
        }
    }

    protected static enum DeviceType {
        DEVICE_TYPE_01,
        DEVICE_TYPE_T,
        DEVICE_TYPE_HX,
        DEVICE_TYPE_HXN;

    }
}

