/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Cp21xxSerialDriver
implements UsbSerialDriver {
    private static final String TAG = Cp21xxSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    public Cp21xxSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPorts = new ArrayList<UsbSerialPort>();
        for (int port = 0; port < device.getInterfaceCount(); ++port) {
            this.mPorts.add(new Cp21xxSerialPort(this.mDevice, port));
        }
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(4292, new int[]{60000, 60016, 60017, 60032});
        return supportedDevices;
    }

    public class Cp21xxSerialPort
    extends CommonUsbSerialPort {
        private static final int DEFAULT_BAUD_RATE = 9600;
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int REQTYPE_HOST_TO_DEVICE = 65;
        private static final int SILABSER_IFC_ENABLE_REQUEST_CODE = 0;
        private static final int SILABSER_SET_BAUDDIV_REQUEST_CODE = 1;
        private static final int SILABSER_SET_LINE_CTL_REQUEST_CODE = 3;
        private static final int SILABSER_SET_MHS_REQUEST_CODE = 7;
        private static final int SILABSER_SET_BAUDRATE = 30;
        private static final int SILABSER_FLUSH_REQUEST_CODE = 18;
        private static final int SILABSER_SET_DTR_RTS_REQUEST_CODE = 7;
        private static final int FLUSH_READ_CODE = 10;
        private static final int FLUSH_WRITE_CODE = 5;
        private static final int UART_ENABLE = 1;
        private static final int UART_DISABLE = 0;
        private static final int BAUD_RATE_GEN_FREQ = 3686400;
        private static final int MCR_DTR = 1;
        private static final int MCR_RTS = 2;
        private static final int MCR_ALL = 3;
        private static final int CONTROL_WRITE_DTR = 256;
        private static final int CONTROL_WRITE_RTS = 512;
        private static final int DTR_ENABLE = 257;
        private static final int DTR_DISABLE = 256;
        private static final int RTS_ENABLE = 514;
        private static final int RTS_DISABLE = 512;
        private boolean dtr;
        private boolean rts;
        private boolean mIsRestrictedPort;

        public Cp21xxSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.dtr = false;
            this.rts = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return Cp21xxSerialDriver.this;
        }

        private int setConfigSingle(int request, int value) throws IOException {
            int result = this.mConnection.controlTransfer(65, request, value, this.mPortNumber, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Setting baudrate failed: result=" + result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(UsbDeviceConnection connection) throws IOException {
            if (this.mConnection != null) {
                throw new IOException("Already open");
            }
            this.mConnection = connection;
            boolean opened = false;
            this.mIsRestrictedPort = this.mDevice.getInterfaceCount() == 2 && this.mPortNumber == 1;
            try {
                if (this.mPortNumber >= this.mDevice.getInterfaceCount()) {
                    throw new IOException("Unknown port number");
                }
                UsbInterface dataIface = this.mDevice.getInterface(this.mPortNumber);
                if (!this.mConnection.claimInterface(dataIface, true)) {
                    throw new IOException("Could not claim interface " + this.mPortNumber);
                }
                for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                    UsbEndpoint ep = dataIface.getEndpoint(i);
                    if (ep.getType() != 2) continue;
                    if (ep.getDirection() == 128) {
                        this.mReadEndpoint = ep;
                        continue;
                    }
                    this.mWriteEndpoint = ep;
                }
                this.setConfigSingle(0, 1);
                this.setConfigSingle(7, 771);
                this.setConfigSingle(1, 384);
                opened = true;
            }
            finally {
                if (!opened) {
                    this.close();
                }
            }
        }

        @Override
        public void closeInt() {
            try {
                this.setConfigSingle(0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mConnection.releaseInterface(this.mDevice.getInterface(this.mPortNumber));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setBaudRate(int baudRate) throws IOException {
            byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
            int ret = this.mConnection.controlTransfer(65, 30, 0, this.mPortNumber, data, 4, 5000);
            if (ret < 0) {
                throw new IOException("Error setting baud rate");
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            this.setBaudRate(baudRate);
            int configDataBits = 0;
            switch (dataBits) {
                case 5: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported data bits: " + dataBits);
                    }
                    configDataBits |= 0x500;
                    break;
                }
                case 6: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported data bits: " + dataBits);
                    }
                    configDataBits |= 0x600;
                    break;
                }
                case 7: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported data bits: " + dataBits);
                    }
                    configDataBits |= 0x700;
                    break;
                }
                case 8: {
                    configDataBits |= 0x800;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data bits: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    break;
                }
                case 1: {
                    configDataBits |= 0x10;
                    break;
                }
                case 2: {
                    configDataBits |= 0x20;
                    break;
                }
                case 3: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported parity: mark");
                    }
                    configDataBits |= 0x30;
                    break;
                }
                case 4: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported parity: space");
                    }
                    configDataBits |= 0x40;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported stop bits: 1.5");
                }
                case 2: {
                    if (this.mIsRestrictedPort) {
                        throw new UnsupportedOperationException("Unsupported stop bits: 2");
                    }
                    configDataBits |= 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            this.setConfigSingle(3, configDataBits);
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.dtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.dtr = value;
            this.setConfigSingle(7, this.dtr ? 257 : 256);
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.rts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.rts = value;
            this.setConfigSingle(7, this.rts ? 514 : 512);
        }

        @Override
        public boolean purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
            int value = (purgeReadBuffers ? 10 : 0) | (purgeWriteBuffers ? 5 : 0);
            if (value != 0) {
                this.setConfigSingle(18, value);
            }
            return true;
        }
    }
}

