/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.support.media.ExifInterface;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.OriginalSize;
import com.miguelbcr.ui.rx_paparazzo2.interactors.Dimensions;
import io.reactivex.exceptions.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class ImageUtils {
    private static final String TAG = ImageUtils.class.getSimpleName();
    private static final String DEFAULT_EXTENSION = "";
    public static final String JPG_FILE_EXTENSION = "jpg";
    private static final String PNG_FILE_EXTENSION = "png";
    public static final String MIME_TYPE_IMAGE_WILDCARD = "image/*";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final String MIME_TYPE_PNG = "image/png";
    private static final String DATE_FORMAT = "yyyyMMdd_HHmm_ssSSS";
    private static final String LOCALE_EN = "en";
    private final TargetUi targetUi;
    private final Config config;

    public ImageUtils(TargetUi targetUi, Config config) {
        this.targetUi = targetUi;
        this.config = config;
    }

    public File getOutputFile(String prefix, String extension) {
        String fileProviderDirectory = this.config.getFileProviderDirectory();
        File dir = this.getDir(null, fileProviderDirectory);
        return this.createTimestampedFile(dir, prefix, extension);
    }

    private File createTimestampedFile(File dir, String prefix, String extension) {
        File file = new File(dir.getAbsolutePath(), this.createTimestampedFilename(prefix, extension));
        while (file.exists()) {
            String filename = this.createTimestampedFilename(prefix, extension);
            file = new File(dir.getAbsolutePath(), filename);
        }
        return file;
    }

    public String createTimestampedFilename(String prefix, String extension) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT, new Locale(LOCALE_EN));
        String datetime = simpleDateFormat.format(new Date());
        if (!TextUtils.isEmpty((CharSequence)extension) && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        return prefix + datetime + extension;
    }

    public File getPrivateFile(String directory, String filename) {
        File dir = new File(this.targetUi.getContext().getFilesDir(), directory);
        dir.mkdirs();
        return new File(dir, filename);
    }

    private String getApplicationName(Context context) {
        int stringId = context.getApplicationInfo().labelRes;
        return context.getString(stringId);
    }

    private File getDir(String dirRoot, String dirname) {
        File storageDir = null;
        if (!this.config.isUseInternalStorage()) {
            storageDir = this.getPublicDir(dirRoot, dirname);
        }
        if (storageDir == null) {
            storageDir = this.getPrivateDir(dirname);
        }
        return storageDir;
    }

    private File getPublicDir(String dirRoot, String dirname) {
        File dir;
        File storageDir = null;
        if (Environment.getExternalStorageState().equals("mounted") && !(storageDir = new File(dir = dirRoot == null ? Environment.getExternalStorageDirectory() : Environment.getExternalStoragePublicDirectory((String)dirRoot), dirname)).exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        return storageDir;
    }

    private File getPrivateDir(String dirname) {
        File storageDir;
        File dir = this.targetUi.getContext().getFilesDir();
        File file = storageDir = TextUtils.isEmpty((CharSequence)dirname) ? dir : new File(dir, dirname);
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        return storageDir;
    }

    public static String getFileName(String filepath) {
        File file = new File(filepath);
        return file.getName();
    }

    public static String stripPathFromFilename(String fileName) {
        int lastSlash = fileName.lastIndexOf("/");
        if (lastSlash == -1) {
            return fileName;
        }
        return fileName.substring(lastSlash + 1);
    }

    public String getFileExtension(String filepath) {
        return this.getFileExtension(filepath, DEFAULT_EXTENSION);
    }

    public String getFileExtension(String filepath, String defaultExtension) {
        String extension = DEFAULT_EXTENSION;
        if (filepath != null) {
            int i = filepath.lastIndexOf(46);
            extension = i > 0 ? filepath.substring(i + 1) : DEFAULT_EXTENSION;
        }
        if (TextUtils.isEmpty((CharSequence)extension) && !TextUtils.isEmpty((CharSequence)defaultExtension)) {
            extension = defaultExtension;
        }
        return extension;
    }

    String getFileExtension(Uri uri) {
        String mimeType = ImageUtils.getMimeType(this.targetUi.getContext(), uri);
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return this.getFileExtension(uri.getLastPathSegment());
        }
        return mimeType.split("/")[1];
    }

    public static String getMimeType(Context context, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            mimeType = context.getContentResolver().getType(uri);
        } else {
            String path = uri.toString();
            mimeType = ImageUtils.getMimeType(path);
        }
        return mimeType;
    }

    public static String getMimeType(String path) {
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)path);
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
    }

    public static Dimensions getImageDimensions(File file) {
        String filePath = file.getAbsolutePath();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return new Dimensions(options.outWidth, options.outHeight);
    }

    FileData scaleImage(FileData inputData, File destination, Dimensions dimens) {
        String mimeType;
        File input = inputData.getFile();
        if (this.config.getSize() instanceof OriginalSize) {
            this.copyFileAndExifTags(input, destination, dimens);
            mimeType = inputData.getMimeType();
        } else {
            Bitmap bitmap = this.sampleBitmap(input, dimens.getWidth(), dimens.getHeight());
            if (bitmap == null) {
                this.copyFileAndExifTags(input, destination, dimens);
                mimeType = inputData.getMimeType();
            } else {
                Bitmap.CompressFormat compressFormat = this.getCompressFormat(destination.getName());
                if (Bitmap.CompressFormat.JPEG == compressFormat) {
                    mimeType = MIME_TYPE_JPEG;
                } else if (Bitmap.CompressFormat.PNG == compressFormat) {
                    mimeType = MIME_TYPE_PNG;
                } else {
                    throw new IllegalStateException(String.format("Received unexpected compression format '%s'", compressFormat));
                }
                this.bitmap2file(bitmap, destination, compressFormat);
                this.copyExifTags(input, destination, dimens);
            }
        }
        return new FileData(inputData, destination, true, mimeType);
    }

    private Bitmap.CompressFormat getCompressFormat(String filePath) {
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
        String extension = this.getFileExtension(filePath);
        if (extension.toLowerCase().contains(PNG_FILE_EXTENSION)) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return compressFormat;
    }

    private void copyFileAndExifTags(File input, File fileOutput, Dimensions dimens) {
        this.copy(input, fileOutput);
        this.copyExifTags(input, fileOutput, dimens);
    }

    public void copy(InputStream in, File destination) {
        FileOutputStream out = null;
        try {
            int length;
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            String message = String.format("Could not copy file to '%s'", destination.getAbsolutePath());
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void copy(File source, File destination) {
        try {
            FileInputStream in = new FileInputStream(source);
            this.copy(in, destination);
        }
        catch (IOException e) {
            String message = String.format("Could not copy file to '%s'", destination.getAbsolutePath());
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void bitmap2file(Bitmap bitmap, File destination, Bitmap.CompressFormat compressFormat) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(destination);
            bitmap.compress(compressFormat, 90, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            String message = String.format("Could not save bitmap file to '%s'", destination.getAbsolutePath());
            Log.e((String)TAG, (String)message, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copyExifTags(File source, File destination, Dimensions dimens) {
        try {
            String destinationPath = destination.getAbsolutePath();
            String sourcePath = source.getAbsolutePath();
            if (this.getCompressFormat(destinationPath) == Bitmap.CompressFormat.JPEG) {
                ExifInterface exifSource = new ExifInterface(sourcePath);
                ExifInterface exifDest = new ExifInterface(destinationPath);
                for (String attribute : this.getExifTags()) {
                    String tagValue = exifSource.getAttribute(attribute);
                    if (TextUtils.isEmpty((CharSequence)tagValue)) continue;
                    exifDest.setAttribute(attribute, tagValue);
                }
                exifDest.setAttribute("ImageWidth", String.valueOf(dimens.getWidth()));
                exifDest.setAttribute("ImageLength", String.valueOf(dimens.getHeight()));
                exifDest.saveAttributes();
            }
        }
        catch (IOException e) {
            String message = String.format("Could not copy exif tags from '%s'", source.getAbsolutePath());
            Log.d((String)TAG, (String)message, (Throwable)e);
        }
    }

    private String[] getExifTags() {
        return new String[]{"DateTime", "ExposureTime", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSProcessingMethod", "WhiteBalance", "Orientation", "Make", "GPSTimeStamp", "Model", "ISOSpeedRatings", "SubSecTime", "DateTimeDigitized", "SubSecTimeDigitized", "SubSecTimeOriginal", "MeteringMode", "FNumber"};
    }

    private Bitmap sampleBitmap(File input, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = this.sampleSize(input, maxWidth, maxHeight);
        if (options.inSampleSize == 1) {
            return null;
        }
        options.inJustDecodeBounds = false;
        String filePath = input.getAbsolutePath();
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public boolean isImage(File input) {
        BitmapFactory.Options options = this.sampleSize(input, 0, 0);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    private BitmapFactory.Options sampleSize(File input, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        String filePath = input.getAbsolutePath();
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = maxWidth <= 0 || maxHeight <= 0 ? 1 : this.calculateInSampleSize(options, maxWidth, maxHeight);
        return options;
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int inSampleSize = 1;
        Dimensions dimensPortrait = this.getDimensionsPortrait(options.outWidth, options.outHeight);
        Dimensions maxDimensPortrait = this.getDimensionsPortrait(maxWidth, maxHeight);
        float width = dimensPortrait.getWidth();
        float height = dimensPortrait.getHeight();
        float newMaxWidth = maxDimensPortrait.getWidth();
        float newMaxHeight = maxDimensPortrait.getHeight();
        if (height > newMaxHeight || width > newMaxWidth) {
            int widthRatio;
            int heightRatio = Math.round(height / newMaxHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round(width / newMaxWidth)) ? heightRatio : widthRatio;
            float totalPixels = width * height;
            float totalReqPixels = newMaxWidth * newMaxHeight * 2.0f;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixels) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    private Dimensions getDimensionsPortrait(int width, int height) {
        if (width < height) {
            return new Dimensions(width, height);
        }
        return new Dimensions(height, width);
    }
}

