/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.entities;

import android.util.Log;
import com.miguelbcr.ui.rx_paparazzo2.interactors.Dimensions;
import java.io.File;
import java.io.Serializable;

public class FileData
implements Serializable {
    private static final String FILENAME_MIMETYPE = "%s (%s)";
    private static final String FILENAME_MIMETYPE_TITLE = "%s (%s) - %s";
    private static final String FILENAME_TRANSIENT_MIMETYPE_TITLE = "%s %s (%s) - %s";
    private File file;
    private String filename;
    private String mimeType;
    private String title;
    private boolean transientFile;
    private boolean exceededMaximumFileSize;
    private Dimensions originalDimensions;

    public static FileData toFileDataDeleteSourceFileIfTransient(FileData source, File file, boolean transientFile, String mimeType) {
        FileData.deleteSourceFile(source);
        return new FileData(source, file, transientFile, mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteSourceFile(FileData fileData) {
        File file;
        if (!fileData.isTransientFile() || (file = fileData.getFile()) == null || !file.exists()) return;
        try {
            Log.i((String)FileData.class.getSimpleName(), (String)String.format("Removing source file '%s'", file.getAbsolutePath()));
            if (file.delete()) return;
        }
        catch (Exception e) {
            Log.i((String)FileData.class.getSimpleName(), (String)String.format("Could not remove source file '%s'", file.getAbsolutePath()), (Throwable)e);
        }
    }

    public static FileData exceededMaximumFileSize(FileData source) {
        return new FileData(null, true, source.getFilename(), source.getMimeType(), source.getTitle(), source.getOriginalDimensions(), true);
    }

    public FileData(FileData source, Dimensions dimensions) {
        this(source.getFile(), source.isTransientFile(), source.getFilename(), source.getMimeType(), source.getTitle(), dimensions, source.isExceededMaximumFileSize());
    }

    public FileData(FileData source, File file, boolean transientFile, String mimeType) {
        this(file, transientFile, source.getFilename(), mimeType, source.getTitle(), source.getOriginalDimensions(), source.isExceededMaximumFileSize());
    }

    public FileData(File file, boolean transientFile, String filename, String mimeType) {
        this(file, transientFile, filename, mimeType, null, null, false);
    }

    public FileData(File file, boolean transientFile, String filename, String mimeType, String title) {
        this(file, transientFile, filename, mimeType, title, null, false);
    }

    public FileData(File file, boolean transientFile, String filename, String mimeType, String title, Dimensions originalDimensions, boolean exceededMaximumFileSize) {
        this.filename = filename;
        this.transientFile = transientFile;
        this.mimeType = mimeType;
        this.file = file;
        this.title = title;
        this.exceededMaximumFileSize = exceededMaximumFileSize;
        this.originalDimensions = originalDimensions;
    }

    public Dimensions getOriginalDimensions() {
        return this.originalDimensions;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTransientFile() {
        return this.transientFile;
    }

    public boolean isExceededMaximumFileSize() {
        return this.exceededMaximumFileSize;
    }

    public String describe() {
        if (this.title == null) {
            return String.format(FILENAME_MIMETYPE, this.filename, this.mimeType);
        }
        return String.format(FILENAME_MIMETYPE_TITLE, this.filename, this.mimeType, this.title);
    }

    public String toString() {
        String transientDescription = this.transientFile ? "Transient" : "Not transient";
        return String.format(FILENAME_TRANSIENT_MIMETYPE_TITLE, transientDescription, this.filename, this.mimeType, this.title);
    }
}

