/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.workers;

import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.Ignore;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PermissionUtil;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickFile;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PickFiles;
import com.miguelbcr.ui.rx_paparazzo2.interactors.SaveFile;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.workers.Worker;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.List;

public final class Files
extends Worker {
    private final GrantPermissions grantPermissions;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private final CropImage cropImage;
    private final SaveFile saveFile;
    private final TargetUi targetUi;
    private final Config config;

    public Files(GrantPermissions grantPermissions, StartIntent startIntent, GetPath getPath, CropImage cropImage, SaveFile saveFile, TargetUi targetUi, Config config) {
        super(targetUi);
        this.grantPermissions = grantPermissions;
        this.startIntent = startIntent;
        this.getPath = getPath;
        this.cropImage = cropImage;
        this.saveFile = saveFile;
        this.targetUi = targetUi;
        this.config = config;
    }

    public <T> Observable<Response<T, FileData>> pickFile() {
        PickFile pickFile = new PickFile(this.targetUi, this.config, this.startIntent);
        return this.pickFile(pickFile);
    }

    public <T> Observable<Response<T, List<FileData>>> pickFiles() {
        PickFiles pickFiles = new PickFiles(this.targetUi, this.config, this.startIntent);
        return this.pickFiles(pickFiles);
    }

    public <T> Observable<Response<T, FileData>> pickFile(final PickFile pickFile) {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(Ignore ignore) throws Exception {
                return pickFile.react();
            }
        }).flatMap((Function)new Function<Uri, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(Uri uri) throws Exception {
                return Files.this.getPath.with(uri).react();
            }
        }).flatMap((Function)new Function<FileData, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(FileData fileData) throws Exception {
                return Files.this.handleSavingFile(fileData);
            }
        }).map(new Function<FileData, Response<T, FileData>>(){

            public Response<T, FileData> apply(FileData file) throws Exception {
                return new Response<Object, FileData>(Files.this.targetUi.ui(), file, -1);
            }
        }).compose(this.applyOnError());
    }

    private Observable<FileData> handleSavingFile(FileData sourceFileData) {
        return this.cropImage.with(sourceFileData).react().flatMap((Function)new Function<FileData, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(FileData cropped) throws Exception {
                return Files.this.saveFile.with(cropped).react();
            }
        });
    }

    public <T> Observable<Response<T, List<FileData>>> pickFiles(final PickFiles pickFiles) {
        return this.grantPermissions.with(this.permissions()).react().flatMap((Function)new Function<Ignore, ObservableSource<List<Uri>>>(){

            public ObservableSource<List<Uri>> apply(Ignore ignore) throws Exception {
                return pickFiles.react();
            }
        }).flatMapIterable((Function)new Function<List<Uri>, Iterable<Uri>>(){

            public Iterable<Uri> apply(List<Uri> uris) throws Exception {
                return uris;
            }
        }).concatMap((Function)new Function<Uri, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(Uri uri) throws Exception {
                return Files.this.getPath.with(uri).react();
            }
        }).concatMap((Function)new Function<FileData, ObservableSource<FileData>>(){

            public ObservableSource<FileData> apply(FileData fileData) throws Exception {
                return Files.this.handleSavingFile(fileData);
            }
        }).toList().toObservable().map(new Function<List<FileData>, Response<T, List<FileData>>>(){

            public Response<T, List<FileData>> apply(List<FileData> paths) throws Exception {
                return new Response<Object, List<FileData>>(Files.this.targetUi.ui(), paths, -1);
            }
        }).compose(this.applyOnError());
    }

    private String[] permissions() {
        return PermissionUtil.getReadAndWriteStoragePermissions(this.config.isUseInternalStorage());
    }
}

