/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.util.Log;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.DownloadFile;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import java.io.File;

public final class GetPath
extends UseCase<FileData> {
    private static final String TAG = GetPath.class.getSimpleName();
    private static final String URI_SCHEME_CONTENT = "content";
    private static final String URI_SCHEME_FILE = "file";
    private static final String PUBLIC_DOWNLOADS_URI = "content://downloads/public_downloads";
    private static final String DOCUMENT_AUTHORITY_EXTERNAL_STORAGE = "com.android.externalstorage.documents";
    private static final String DOCUMENT_AUTHORITY_DOWNLOADS = "com.android.providers.downloads.documents";
    private static final String DOCUMENT_AUTHORITY_MEDIA = "com.android.providers.media.documents";
    private static final String DOCUMENT_TYPE_PRIMARY = "primary";
    private static final String DOCUMENT_TYPE_IMAGE = "image";
    private static final String DOCUMENT_TYPE_VIDEO = "video";
    private static final String DOCUMENT_TYPE_AUDIO = "audio";
    private final Config config;
    private final TargetUi targetUi;
    private final DownloadFile downloadFile;
    private Uri uri;

    public GetPath(Config config, TargetUi targetUi, DownloadFile downloadFile) {
        this.config = config;
        this.targetUi = targetUi;
        this.downloadFile = downloadFile;
    }

    public GetPath with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<FileData> react() {
        return this.getFileData();
    }

    @SuppressLint(value={"NewApi"})
    private Observable<FileData> getFileData() {
        Context context = this.targetUi.getContext();
        if (this.uri == null || context == null) {
            return null;
        }
        FileData fileData = this.getFileData(context);
        if (fileData != null && fileData.getFile() != null) {
            return Observable.just((Object)fileData);
        }
        return this.downloadFile.with(this.uri, fileData).react();
    }

    @Nullable
    private FileData getFileData(Context context) {
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)this.uri)) {
            if (this.isExternalStorageDocument(this.uri)) {
                Document document = this.getDocument(this.uri);
                if (DOCUMENT_TYPE_PRIMARY.equalsIgnoreCase(document.type)) {
                    return this.getPrimaryExternalDocument(document);
                }
            } else {
                if (this.isDownloadsDocument(this.uri)) {
                    return this.getDownloadsDocument(context);
                }
                if (this.isMediaDocument(this.uri)) {
                    return this.getMediaDocument(context);
                }
            }
        } else if (URI_SCHEME_CONTENT.equalsIgnoreCase(this.uri.getScheme())) {
            if (!this.isFileProvider(context)) {
                return this.getDataColumn(context, this.uri, null, null);
            }
        } else if (URI_SCHEME_FILE.equalsIgnoreCase(this.uri.getScheme())) {
            return this.getFile(context);
        }
        return null;
    }

    private FileData getFile(Context context) {
        File file = new File(this.uri.getPath());
        String fileName = ImageUtils.getFileName(this.uri.getPath());
        String mimeType = ImageUtils.getMimeType(context, this.uri);
        return new FileData(file, false, fileName, mimeType);
    }

    private boolean isFileProvider(Context context) {
        String authority = this.config.getFileProviderAuthority(context);
        return this.uri.getPath().startsWith(authority);
    }

    private FileData getPrimaryExternalDocument(Document document) {
        String mimeType = ImageUtils.getMimeType(document.id);
        String fileName = ImageUtils.stripPathFromFilename(document.id);
        String filePath = Environment.getExternalStorageDirectory() + "/" + document.id;
        File file = new File(filePath);
        return new FileData(file, false, fileName, mimeType);
    }

    private FileData getDownloadsDocument(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            Uri contentUri;
            String id = DocumentsContract.getDocumentId((Uri)this.uri);
            try {
                contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)PUBLIC_DOWNLOADS_URI), (long)Long.valueOf(id));
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)e.getMessage());
                e.printStackTrace();
                contentUri = this.uri;
            }
            return this.getDataColumn(context, contentUri, null, null);
        }
        throw new IllegalStateException("Minimum Android API version must be be KitKat to use DocumentsContract API");
    }

    private FileData getMediaDocument(Context context) {
        Document document = this.getDocument(this.uri);
        Uri contentUri = null;
        if (DOCUMENT_TYPE_IMAGE.equals(document.type)) {
            contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        } else if (DOCUMENT_TYPE_VIDEO.equals(document.type)) {
            contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        } else if (DOCUMENT_TYPE_AUDIO.equals(document.type)) {
            contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        return this.getDataColumn(context, contentUri, "_id=?", new String[]{document.id});
    }

    @SuppressLint(value={"NewApi"})
    private Document getDocument(Uri uri) {
        Document document = new Document();
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        String[] docArray = docId.split(":");
        document.type = docArray[0];
        document.id = docArray[1];
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileData getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String dataColumn = "_data";
        String nameColumn = "_display_name";
        String mimeTypeColumn = "mime_type";
        String titleColumn = "title";
        String[] projection = new String[]{dataColumn, nameColumn, mimeTypeColumn, titleColumn};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                String filePath = cursor.getString(cursor.getColumnIndexOrThrow(dataColumn));
                String fileName = cursor.getString(cursor.getColumnIndexOrThrow(nameColumn));
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow(mimeTypeColumn));
                String title = cursor.getString(cursor.getColumnIndexOrThrow(titleColumn));
                File file = filePath != null ? new File(filePath) : null;
                FileData fileData = new FileData(file, false, fileName, mimeType, title);
                return fileData;
            }
            FileData filePath = null;
            return filePath;
        }
        catch (Exception e) {
            FileData fileData = null;
            return fileData;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private boolean isExternalStorageDocument(Uri uri) {
        return DOCUMENT_AUTHORITY_EXTERNAL_STORAGE.equals(uri.getAuthority());
    }

    private boolean isDownloadsDocument(Uri uri) {
        return DOCUMENT_AUTHORITY_DOWNLOADS.equals(uri.getAuthority());
    }

    private boolean isMediaDocument(Uri uri) {
        return DOCUMENT_AUTHORITY_MEDIA.equals(uri.getAuthority());
    }

    private static class Document {
        String type;
        String id;

        private Document() {
        }
    }
}

