/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.provider.DocumentFile;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public final class DownloadFile
extends UseCase<FileData> {
    private static final String DOWNLOADED_FILENAME_PREFIX = "DOWNLOAD-";
    private static final String MATCH_ANYTHING_NOT_A_LETTER_OR_NUMBER = "[^A-Za-z0-9 ]";
    private final TargetUi targetUi;
    private final Config config;
    private final ImageUtils imageUtils;
    private Uri uri;
    private FileData fileData;

    public DownloadFile(TargetUi targetUi, Config config, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.config = config;
        this.imageUtils = imageUtils;
    }

    @Override
    Observable<FileData> react() {
        return this.getObservableDownloadFile();
    }

    public DownloadFile with(Uri uri, FileData fileData) {
        this.uri = uri;
        this.fileData = fileData;
        return this;
    }

    private Observable<FileData> getObservableDownloadFile() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<FileData>(){

            public void subscribe(ObservableEmitter<FileData> subscriber) throws Exception {
                if (!subscriber.isDisposed()) {
                    try {
                        if ("content".equalsIgnoreCase(DownloadFile.this.uri.getScheme())) {
                            subscriber.onNext((Object)DownloadFile.this.getUsingContentResolver());
                        } else {
                            subscriber.onNext((Object)DownloadFile.this.downloadFile());
                        }
                        subscriber.onComplete();
                    }
                    catch (FileNotFoundException e) {
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        }).subscribeOn(Schedulers.io());
    }

    private FileData downloadFile() throws Exception {
        String mimeType = ImageUtils.getMimeType(this.targetUi.getContext(), this.uri);
        String filename = this.getFilename(this.uri);
        String fileExtension = this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getOutputFile(DOWNLOADED_FILENAME_PREFIX, fileExtension);
        URL url = new URL(this.uri.toString());
        URLConnection connection = url.openConnection();
        connection.connect();
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
        this.imageUtils.copy(inputStream, file);
        return this.toFileData(mimeType, filename, file);
    }

    private FileData toFileData(String mimeType, String filename, File destination) {
        if (this.fileData == null || this.fileData.getFilename() == null) {
            return new FileData(destination, true, filename, mimeType);
        }
        String fileMimeType = this.fileData.getMimeType();
        if (fileMimeType == null) {
            fileMimeType = mimeType;
        }
        return FileData.toFileDataDeleteSourceFileIfTransient(this.fileData, destination, true, fileMimeType);
    }

    private FileData getUsingContentResolver() throws FileNotFoundException {
        String mimeType = ImageUtils.getMimeType(this.targetUi.getContext(), this.uri);
        String uriFilename = this.getFilename(this.uri);
        String fileExtension = this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getOutputFile(DOWNLOADED_FILENAME_PREFIX, fileExtension);
        InputStream inputStream = this.targetUi.getContext().getContentResolver().openInputStream(this.uri);
        this.imageUtils.copy(inputStream, file);
        return this.toFileData(mimeType, uriFilename, file);
    }

    private String getFilename(Uri uri) {
        String fileName;
        DocumentFile file;
        if (Build.VERSION.SDK_INT >= 19 && (file = DocumentFile.fromSingleUri((Context)this.targetUi.getContext(), (Uri)uri)) != null && (fileName = file.getName()) != null) {
            return ImageUtils.stripPathFromFilename(fileName);
        }
        String fileName2 = uri.getLastPathSegment();
        String safeFilename = fileName2.replaceAll(MATCH_ANYTHING_NOT_A_LETTER_OR_NUMBER, "");
        return safeFilename + "." + this.imageUtils.getFileExtension(uri);
    }
}

