/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.PermissionUtil;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PickFiles
extends UseCase<List<Uri>> {
    public static final String DEFAULT_MIME_TYPE = "*/*";
    private final TargetUi targetUi;
    private final Config config;
    private final StartIntent startIntent;

    public PickFiles(TargetUi targetUi, Config config, StartIntent startIntent) {
        this.targetUi = targetUi;
        this.config = config;
        this.startIntent = startIntent;
    }

    public String getDefaultMimeType() {
        return DEFAULT_MIME_TYPE;
    }

    @Override
    public Observable<List<Uri>> react() {
        return this.startIntent.with(this.getFileChooserIntent()).react().map((Function)new Function<Intent, List<Uri>>(){

            public List<Uri> apply(Intent intent) throws Exception {
                if (intent == null) {
                    return new ArrayList<Uri>();
                }
                intent.addFlags(3);
                Uri pickedUri = intent.getData();
                if (pickedUri != null) {
                    PermissionUtil.grantReadPermissionToUri(PickFiles.this.targetUi, pickedUri);
                    return Arrays.asList(pickedUri);
                }
                return PickFiles.this.getUris(intent);
            }
        });
    }

    private List<Uri> getUris(Intent intent) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        ClipData clipData = intent.getClipData();
        if (clipData != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                ClipData.Item item = clipData.getItemAt(i);
                Uri uri = item.getUri();
                PermissionUtil.grantReadPermissionToUri(this.targetUi, uri);
                uris.add(uri);
            }
        }
        return uris;
    }

    private Intent getFileChooserIntent() {
        String mimeType = this.config.getMimeType(this.getDefaultMimeType());
        Intent intent = new Intent();
        intent.setType(mimeType);
        if (this.config.isUseDocumentPicker() && Build.VERSION.SDK_INT >= 19) {
            intent.setAction("android.intent.action.OPEN_DOCUMENT");
        } else {
            intent.setAction("android.intent.action.GET_CONTENT");
        }
        if (this.config.isPickOpenableOnly()) {
            intent.addCategory("android.intent.category.OPENABLE");
        }
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        return intent;
    }
}

