/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.util.DisplayMetrics;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.FileData;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.CustomMaxSize;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.OriginalSize;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.ScreenSize;
import com.miguelbcr.ui.rx_paparazzo2.interactors.Dimensions;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import java.io.File;

public final class ScaledImageDimensions
extends UseCase<Dimensions> {
    private final TargetUi targetUi;
    private final Config config;
    private FileData fileData;

    public ScaledImageDimensions(TargetUi targetUi, Config config) {
        this.targetUi = targetUi;
        this.config = config;
    }

    public ScaledImageDimensions with(FileData fileData) {
        this.fileData = fileData;
        return this;
    }

    @Override
    public Observable<Dimensions> react() {
        return Observable.just((Object)this.getDimensions());
    }

    private Dimensions getDimensions() {
        File file = this.fileData.getFile();
        if (this.config.getSize() instanceof OriginalSize) {
            return ImageUtils.getImageDimensions(file);
        }
        if (this.config.getSize() instanceof CustomMaxSize) {
            return this.getCustomDimens((CustomMaxSize)this.config.getSize(), file);
        }
        if (this.config.getSize() instanceof ScreenSize) {
            return this.getScreenDimens();
        }
        Dimensions dimens = this.getScreenDimens();
        return new Dimensions(dimens.getWidth() / 8, dimens.getHeight() / 8);
    }

    private Dimensions getScreenDimens() {
        DisplayMetrics metrics = this.targetUi.getContext().getResources().getDisplayMetrics();
        return new Dimensions(metrics.widthPixels, metrics.heightPixels);
    }

    private Dimensions getCustomDimens(CustomMaxSize customMaxSize, File file) {
        int maxSize = customMaxSize.getMaxImageSize();
        Dimensions dimensions = ImageUtils.getImageDimensions(file);
        int maxFileSize = Math.max(dimensions.getWidth(), dimensions.getHeight());
        if (maxFileSize < maxSize) {
            return dimensions;
        }
        float scaleFactor = (float)maxSize / (float)maxFileSize;
        float scaledWidth = (float)dimensions.getWidth() * scaleFactor;
        float scaledHeight = (float)dimensions.getHeight() * scaleFactor;
        return new Dimensions((int)scaledWidth, (int)scaledHeight);
    }
}

