/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import java.util.List;

public class PermissionUtil {
    public static final int READ_WRITE_PERMISSIONS = 3;

    public static Intent requestReadWritePermission(TargetUi targetUi, Intent intent, Uri uri) {
        intent.addFlags(3);
        PermissionUtil.grantFileReadWritePermissions(targetUi, intent, uri);
        return intent;
    }

    public static void grantReadPermissionToUri(TargetUi targetUi, Uri uri) {
        String uiPackageName = targetUi.getContext().getPackageName();
        targetUi.getContext().grantUriPermission(uiPackageName, uri, 1);
    }

    private static void grantFileReadWritePermissions(TargetUi targetUi, Intent intent, Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            List resInfoList = targetUi.getContext().getPackageManager().queryIntentActivities(intent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                targetUi.getContext().grantUriPermission(packageName, uri, 3);
            }
        }
    }

    public static void revokeFileReadWritePermissions(TargetUi targetUi, Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            targetUi.getContext().revokeUriPermission(uri, 3);
        }
    }

    public static String[] getReadAndWriteStoragePermissions(boolean internal) {
        if (internal) {
            return new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    }
}

