/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import com.miguelbcr.ui.rx_paparazzo2.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetDimens;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo2.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import java.io.File;

public final class SaveImage
extends UseCase<String> {
    private final TargetUi targetUi;
    private final GetPath getPath;
    private final GetDimens getDimens;
    private final ImageUtils imageUtils;
    private Uri uri;

    public SaveImage(TargetUi targetUi, GetPath getPath, GetDimens getDimens, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.getPath = getPath;
        this.getDimens = getDimens;
        this.imageUtils = imageUtils;
    }

    public SaveImage with(Uri uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public Observable<String> react() {
        return this.getOutputUri().flatMap((Function)new Function<Uri, ObservableSource<String>>(){

            public ObservableSource<String> apply(Uri outputUri) throws Exception {
                return Observable.zip(SaveImage.this.getPath.with(SaveImage.this.uri).react(), SaveImage.this.getPath.with(outputUri).react(), SaveImage.this.getDimens.with(SaveImage.this.uri).react(), (Function3)new Function3<String, String, int[], String>(){

                    public String apply(String filePath, String filePathOutput, int[] dimens) throws Exception {
                        String filePathScaled = SaveImage.this.imageUtils.scaleImage(filePath, filePathOutput, dimens);
                        new File(filePath).delete();
                        MediaScannerConnection.scanFile((Context)SaveImage.this.targetUi.getContext(), (String[])new String[]{filePathScaled}, (String[])new String[]{"image/*"}, null);
                        return filePathScaled;
                    }
                });
            }
        });
    }

    private Observable<Uri> getOutputUri() {
        return this.getPath.with(this.uri).react().flatMap((Function)new Function<String, ObservableSource<Uri>>(){

            public ObservableSource<Uri> apply(String filepath) throws Exception {
                String extension = SaveImage.this.imageUtils.getFileExtension(filepath);
                return Observable.just((Object)Uri.fromFile((File)SaveImage.this.imageUtils.getOutputFile(extension)));
            }
        });
    }
}

