/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PickImages
extends UseCase<List<Uri>> {
    private final StartIntent startIntent;

    public PickImages(StartIntent startIntent) {
        this.startIntent = startIntent;
    }

    @Override
    public Observable<List<Uri>> react() {
        return this.startIntent.with(this.getFileChooserIntent()).react().map((Function)new Function<Intent, List<Uri>>(){

            public List<Uri> apply(Intent intent) throws Exception {
                if (intent.getData() != null) {
                    return Arrays.asList(intent.getData());
                }
                return PickImages.this.getUris(intent);
            }
        });
    }

    private List<Uri> getUris(Intent intent) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        ClipData clipData = intent.getClipData();
        if (clipData != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                ClipData.Item item = clipData.getItemAt(i);
                Uri uri = item.getUri();
                uris.add(uri);
            }
        }
        return uris;
    }

    private Intent getFileChooserIntent() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        return intent;
    }
}

