/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2.interactors;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.miguelbcr.ui.rx_paparazzo2.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo2.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo2.interactors.UseCase;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import rx_activity_result2.OnPreResult;

public final class PickImage
extends UseCase<Uri> {
    private final StartIntent startIntent;
    private final GetPath getPath;

    public PickImage(StartIntent startIntent, GetPath getPath) {
        this.startIntent = startIntent;
        this.getPath = getPath;
    }

    @Override
    public Observable<Uri> react() {
        return this.startIntent.with(this.getFileChooserIntent(), this.getOnPreResultProcessing()).react().map((Function)new Function<Intent, Uri>(){

            public Uri apply(Intent intent) throws Exception {
                return intent.getData();
            }
        });
    }

    private Intent getFileChooserIntent() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        return intent;
    }

    private OnPreResult getOnPreResultProcessing() {
        return new OnPreResult(){

            public Observable<String> response(int responseCode, final @Nullable Intent intent) {
                if (responseCode == -1) {
                    return PickImage.this.getPath.with(intent.getData()).react().subscribeOn(Schedulers.io()).map((Function)new Function<String, String>(){

                        public String apply(String filePath) throws Exception {
                            intent.setData(Uri.fromFile((File)new File(filePath)));
                            return filePath;
                        }
                    });
                }
                return Observable.just((Object)"");
            }
        };
    }
}

