/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo2;

import android.app.Activity;
import android.app.Application;
import android.support.v4.app.Fragment;
import com.miguelbcr.ui.rx_paparazzo2.entities.Config;
import com.miguelbcr.ui.rx_paparazzo2.entities.Response;
import com.miguelbcr.ui.rx_paparazzo2.entities.size.Size;
import com.miguelbcr.ui.rx_paparazzo2.internal.di.ApplicationComponent;
import com.miguelbcr.ui.rx_paparazzo2.internal.di.ApplicationModule;
import com.yalantis.ucrop.UCrop;
import io.reactivex.Observable;
import java.util.List;
import rx_activity_result2.RxActivityResult;

public final class RxPaparazzo {
    public static final int RESULT_DENIED_PERMISSION = 2;
    public static final int RESULT_DENIED_PERMISSION_NEVER_ASK = 3;

    public static void register(Application application) {
        RxActivityResult.register((Application)application);
    }

    public static <T extends Activity> BuilderImage<T> takeImage(T activity) {
        return new BuilderImage<T>(activity);
    }

    public static <T extends Activity> BuilderImages<T> takeImages(T activity) {
        return new BuilderImages<T>(activity);
    }

    public static <T extends Fragment> BuilderImage<T> takeImage(T fragment) {
        return new BuilderImage<T>(fragment);
    }

    public static <T extends Fragment> BuilderImages<T> takeImages(T fragment) {
        return new BuilderImages<T>(fragment);
    }

    public static class BuilderImages<T>
    extends Builder<T> {
        public BuilderImages(T ui) {
            super(ui);
        }

        public BuilderImages<T> useInternalStorage() {
            this.config.setUseInternalStorage();
            return this;
        }

        public BuilderImages<T> size(Size size) {
            this.config.setSize(size);
            return this;
        }

        public BuilderImages<T> crop() {
            this.config.setCrop();
            return this;
        }

        public <O extends UCrop.Options> BuilderImages<T> crop(O options) {
            this.config.setCrop(options);
            return this;
        }

        public Observable<Response<T, List<String>>> usingGallery() {
            return this.applicationComponent.gallery().pickImages();
        }
    }

    public static class BuilderImage<T>
    extends Builder<T> {
        public BuilderImage(T ui) {
            super(ui);
        }

        public BuilderImage<T> useInternalStorage() {
            this.config.setUseInternalStorage();
            return this;
        }

        public BuilderImage<T> size(Size size) {
            this.config.setSize(size);
            return this;
        }

        public BuilderImage<T> crop() {
            this.config.setCrop();
            return this;
        }

        public <O extends UCrop.Options> BuilderImage<T> crop(O options) {
            this.config.setCrop(options);
            return this;
        }

        public Observable<Response<T, String>> usingGallery() {
            return this.applicationComponent.gallery().pickImage();
        }

        public Observable<Response<T, String>> usingCamera() {
            return this.applicationComponent.camera().takePhoto();
        }
    }

    private static abstract class Builder<T> {
        protected final Config config = new Config();
        protected final ApplicationComponent applicationComponent;

        public Builder(T ui) {
            this.applicationComponent = ApplicationComponent.create(new ApplicationModule(this.config, ui));
        }
    }
}

