/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.net.Uri;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.ImageUtils;
import com.fuck_boilerplate.rx_paparazzo.interactors.UseCase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public final class DownloadImage
extends UseCase<String> {
    private final TargetUi targetUi;
    private final ImageUtils imageUtils;
    private Uri uri;

    public DownloadImage(TargetUi targetUi, ImageUtils imageUtils) {
        this.targetUi = targetUi;
        this.imageUtils = imageUtils;
    }

    @Override
    Observable<String> react() {
        return this.getObservableDownloadFile();
    }

    public DownloadImage with(Uri uri) {
        this.uri = uri;
        return this;
    }

    private Observable<String> getObservableDownloadFile() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(Subscriber<? super String> subscriber) {
                try {
                    if ("content".equalsIgnoreCase(DownloadImage.this.uri.getScheme())) {
                        subscriber.onNext((Object)DownloadImage.this.getContent());
                    } else {
                        subscriber.onNext((Object)DownloadImage.this.downloadFile());
                    }
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    subscriber.onNext(null);
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private String downloadFile() throws Exception {
        URL url = new URL(this.uri.toString());
        URLConnection connection = url.openConnection();
        connection.connect();
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream(), 1024);
        String filename = this.getFilename(this.uri);
        filename = filename + this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getPrivateFile(filename);
        this.imageUtils.copy(inputStream, file);
        return file.getAbsolutePath();
    }

    private String getContent() throws Exception {
        InputStream inputStream = this.targetUi.getContext().getContentResolver().openInputStream(this.uri);
        String filename = this.getFilename(this.uri);
        filename = filename + this.imageUtils.getFileExtension(this.uri);
        File file = this.imageUtils.getPrivateFile(filename);
        this.imageUtils.copy(inputStream, file);
        return file.getAbsolutePath();
    }

    private String getFilename(Uri uri) {
        return uri.getLastPathSegment().replaceAll("[^A-Za-z0-9 ]", "");
    }
}

