/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.StartIntent;
import com.fuck_boilerplate.rx_paparazzo.interactors.UseCase;
import java.io.File;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class TakePhoto
extends UseCase<Uri> {
    private static final int READ_WRITE_PERMISSIONS = 3;
    private static final String SUBDIR = "RxPaparazzo";
    private static final String SHOOT_APPEND = "shoot.jpg";
    private final StartIntent startIntent;
    private final TargetUi targetUi;

    public TakePhoto(StartIntent startIntent, TargetUi targetUi) {
        this.startIntent = startIntent;
        this.targetUi = targetUi;
    }

    @Override
    public Observable<Uri> react() {
        final Uri uri = this.getUri();
        return this.startIntent.with(this.getIntentCamera(uri)).react().map((Func1)new Func1<Intent, Uri>(){

            public Uri call(Intent data) {
                TakePhoto.this.revokeFileReadWritePermissions(uri);
                return uri;
            }
        });
    }

    private Uri getUri() {
        Context context = this.targetUi.getContext();
        File dir = new File(context.getFilesDir(), SUBDIR);
        File file = new File(dir, SHOOT_APPEND);
        return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".file_provider"), (File)file);
    }

    private Intent getIntentCamera(Uri uri) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.addFlags(3);
        intent.putExtra("output", (Parcelable)uri);
        this.grantFileReadWritePermissions(intent, uri);
        return intent;
    }

    private void grantFileReadWritePermissions(Intent intent, Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            List resInfoList = this.targetUi.getContext().getPackageManager().queryIntentActivities(intent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                this.targetUi.getContext().grantUriPermission(packageName, uri, 3);
            }
        }
    }

    public void revokeFileReadWritePermissions(Uri uri) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.targetUi.getContext().revokeUriPermission(uri, 3);
        }
    }
}

