/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.interactors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Environment;
import android.text.TextUtils;
import com.fuck_boilerplate.rx_paparazzo.entities.Config;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.entities.size.OriginalSize;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import rx.exceptions.Exceptions;

public final class ImageUtils {
    private static final String DATE_FORMAT = "ddMMyyyy_HHmmss_SSS";
    private static final String LOCALE_EN = "en";
    private final TargetUi targetUi;
    private final Config config;

    public ImageUtils(TargetUi targetUi, Config config) {
        this.targetUi = targetUi;
        this.config = config;
    }

    public File getOutputFile() {
        String filename = new SimpleDateFormat(DATE_FORMAT, new Locale(LOCALE_EN)).format(new Date());
        filename = "IMG-" + filename + ".jpg";
        String dirname = this.getApplicationName(this.targetUi.getContext());
        File dir = this.getPublicDir(null, dirname);
        return new File(dir.getAbsolutePath(), filename);
    }

    private String getApplicationName(Context context) {
        int stringId = context.getApplicationInfo().labelRes;
        return context.getString(stringId);
    }

    private File getPublicDir(String dirRoot, String dirname) {
        File dir;
        File storageDir = null;
        if (!this.config.useInternalStorage() && Environment.getExternalStorageState().equals("mounted") && !(storageDir = new File(dir = dirRoot != null ? Environment.getExternalStoragePublicDirectory((String)dirRoot) : Environment.getExternalStorageDirectory(), dirname)).exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        if (storageDir == null) {
            storageDir = this.getPrivateDir(dirname);
        }
        return storageDir;
    }

    private File getPrivateDir(String dirname) {
        File storageDir;
        File dir = this.targetUi.getContext().getFilesDir();
        File file = storageDir = TextUtils.isEmpty((CharSequence)dirname) ? dir : new File(dir, dirname);
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            storageDir = null;
        }
        return storageDir;
    }

    public String scaleImage(String filePath, String filePathOutput, int[] dimens) {
        if (this.config.getSize() instanceof OriginalSize) {
            return this.copyFile(filePath, filePathOutput);
        }
        boolean rotateIfNeeded = false;
        Bitmap bitmap = this.handleSamplingAndRotationBitmap(filePath, dimens[0], dimens[1], rotateIfNeeded);
        if (bitmap == null) {
            return this.copyFile(filePath, filePathOutput);
        }
        File file = new File(filePath);
        File fileScaled = new File(filePathOutput);
        this.bitmap2file(bitmap, fileScaled, Bitmap.CompressFormat.JPEG);
        this.copyExifRotation(file, fileScaled, rotateIfNeeded);
        return filePathOutput;
    }

    private String copyFile(String filePath, String newfilePath) {
        File file = new File(filePath);
        File fileOutput = new File(newfilePath);
        this.copy(file, fileOutput);
        return newfilePath;
    }

    public void copy(InputStream in, File dst) {
        FileOutputStream out = null;
        try {
            int length;
            out = new FileOutputStream(dst);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copy(File src, File dst) {
        try {
            FileInputStream in = new FileInputStream(src);
            this.copy(in, dst);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private boolean bitmap2file(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(compressFormat, 90, (OutputStream)fileOutputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean copyExifRotation(File sourceFile, File destFile, boolean rotateIfNeeded) {
        if (sourceFile == null || destFile == null) {
            return false;
        }
        try {
            ExifInterface exifSource = new ExifInterface(sourceFile.getAbsolutePath());
            ExifInterface exifDest = new ExifInterface(destFile.getAbsolutePath());
            String value = rotateIfNeeded ? String.valueOf(1) : exifSource.getAttribute("Orientation");
            exifDest.setAttribute("Orientation", value);
            exifDest.saveAttributes();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Bitmap handleSamplingAndRotationBitmap(String filePath, int maxWidth, int maxHeight, boolean rotateIfNeeded) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int n = options.inSampleSize = maxWidth <= 0 || maxHeight <= 0 ? 1 : this.calculateInSampleSize(options, maxWidth, maxHeight);
        if (options.inSampleSize == 1) {
            return null;
        }
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (rotateIfNeeded) {
            bitmap = this.rotateImageIfRequired(bitmap, filePath);
        }
        return bitmap;
    }

    private int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int inSampleSize = 1;
        int[] dimensPortrait = this.getDimensionsPortrait(options.outWidth, options.outHeight);
        int[] maxDimensPortrait = this.getDimensionsPortrait(maxWidth, maxHeight);
        float width = dimensPortrait[0];
        float height = dimensPortrait[1];
        float newMaxWidth = maxDimensPortrait[0];
        float newMaxHeight = maxDimensPortrait[1];
        if (height > newMaxHeight || width > newMaxWidth) {
            int widthRatio;
            int heightRatio = Math.round(height / newMaxHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round(width / newMaxWidth)) ? heightRatio : widthRatio;
            float totalPixels = width * height;
            float totalReqPixels = newMaxWidth * newMaxHeight * 2.0f;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixels) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    private int[] getDimensionsPortrait(int width, int height) {
        if (width < height) {
            return new int[]{width, height};
        }
        return new int[]{height, width};
    }

    private Bitmap rotateImageIfRequired(Bitmap img, String filePath) {
        try {
            ExifInterface ei = new ExifInterface(filePath);
            int orientation = ei.getAttributeInt("Orientation", 0);
            Bitmap processedImage = img;
            switch (orientation) {
                case 6: {
                    processedImage = this.rotateImage(img, 90);
                    break;
                }
                case 3: {
                    processedImage = this.rotateImage(img, 180);
                    break;
                }
                case 8: {
                    processedImage = this.rotateImage(img, 270);
                    break;
                }
            }
            return processedImage;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Bitmap rotateImage(Bitmap img, int degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        Bitmap rotatedImg = Bitmap.createBitmap((Bitmap)img, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (Matrix)matrix, (boolean)true);
        img.recycle();
        return rotatedImg;
    }
}

