/*
 * Decompiled with CFR 0.152.
 */
package com.fuck_boilerplate.rx_paparazzo.internal.di;

import com.fuck_boilerplate.rx_paparazzo.entities.Config;
import com.fuck_boilerplate.rx_paparazzo.entities.TargetUi;
import com.fuck_boilerplate.rx_paparazzo.interactors.CropImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.DownloadImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.GetDimens;
import com.fuck_boilerplate.rx_paparazzo.interactors.GetPath;
import com.fuck_boilerplate.rx_paparazzo.interactors.GrantPermissions;
import com.fuck_boilerplate.rx_paparazzo.interactors.ImageUtils;
import com.fuck_boilerplate.rx_paparazzo.interactors.PickImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.PickImages;
import com.fuck_boilerplate.rx_paparazzo.interactors.SaveImage;
import com.fuck_boilerplate.rx_paparazzo.interactors.StartIntent;
import com.fuck_boilerplate.rx_paparazzo.interactors.TakePhoto;
import com.fuck_boilerplate.rx_paparazzo.internal.di.ApplicationComponent;
import com.fuck_boilerplate.rx_paparazzo.workers.Camera;
import com.fuck_boilerplate.rx_paparazzo.workers.Gallery;

class ApplicationComponentImpl
extends ApplicationComponent {
    private final ImageUtils imageUtils;
    private final DownloadImage downloadImage;
    private final StartIntent startIntent;
    private final GetPath getPath;
    private final GetDimens getDimens;
    private final TakePhoto takePhoto;
    private final CropImage cropImage;
    private final SaveImage saveImage;
    private final GrantPermissions grantPermissions;
    private final PickImages pickImages;
    private final PickImage pickImage;
    private final Camera camera;
    private final Gallery gallery;

    public ApplicationComponentImpl(TargetUi ui, Config config) {
        this.startIntent = new StartIntent(ui);
        this.imageUtils = new ImageUtils(ui, config);
        this.downloadImage = new DownloadImage(ui, this.imageUtils);
        this.getPath = new GetPath(ui, this.downloadImage);
        this.takePhoto = new TakePhoto(this.startIntent, ui);
        this.getDimens = new GetDimens(ui, config, this.getPath);
        this.cropImage = new CropImage(ui, config, this.startIntent, this.getPath, this.getDimens);
        this.saveImage = new SaveImage(ui, config, this.getPath, this.getDimens, this.imageUtils);
        this.grantPermissions = new GrantPermissions(ui);
        this.pickImages = new PickImages(this.startIntent);
        this.pickImage = new PickImage(this.startIntent, ui);
        this.camera = new Camera(this.takePhoto, this.cropImage, this.saveImage, this.grantPermissions, ui, config);
        this.gallery = new Gallery(this.grantPermissions, this.pickImages, this.pickImage, this.cropImage, this.saveImage, ui, config);
    }

    @Override
    public Camera camera() {
        return this.camera;
    }

    @Override
    public Gallery gallery() {
        return this.gallery;
    }

    @Override
    public GetPath getPath() {
        return this.getPath;
    }
}

