/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.operation;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.jedis.Protocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HyperLogLog
extends AbstractOperation {
    private Map<Bytes, Set<Bytes>> data = new HashMap<Bytes, Set<Bytes>>();

    public void pfadd(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(2);
        Bytes key = request.getParams()[0].toBytes();
        if (!this.data.containsKey(key)) {
            this.data.put(key, new HashSet());
        }
        Set<Bytes> s = this.data.get(key);
        RequestParams[] req = request.getParams();
        for (int i = 1; i < req.length; ++i) {
            s.add(req[i].toBytes());
        }
        request.getOutputProtocol().writer(1);
    }

    public void pfcount(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(1);
        HashSet<Bytes> set = new HashSet<Bytes>();
        RequestParams[] req = request.getParams();
        for (int i = 0; i < req.length; ++i) {
            Set<Bytes> v = this.data.get(req[i].toBytes());
            if (v == null) continue;
            set.addAll(v);
        }
        request.getOutputProtocol().writer(set.size());
    }

    public void pfmerge(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(2);
        Bytes key = request.getParams()[0].toBytes();
        Set<Bytes> set = this.data.get(key);
        if (set == null) {
            set = new HashSet<Bytes>();
            this.data.put(key, set);
        }
        RequestParams[] req = request.getParams();
        for (int i = 1; i < req.length; ++i) {
            Set<Bytes> v = this.data.get(req[i].toBytes());
            if (v == null) continue;
            set.addAll(v);
        }
        request.getOutputProtocol().writer(Protocol.Keyword.OK.name());
    }
}

