/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.util.Assert;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;

public class Member {
    private final byte[] member;
    private final BigDecimal score;
    private HashKey key;
    public static final Comparator<Member> COMPARATOR = (e1, e2) -> {
        int c = e1.getScore().compareTo(e2.getScore());
        if (c == 0) {
            byte[] m1 = e1.getMember();
            byte[] m2 = e2.getMember();
            if (m1 == null) {
                if (m2 == null) {
                    return 0;
                }
                return 1;
            }
            if (m2 == null) {
                return -1;
            }
            int l1 = m1.length;
            int l2 = m2.length;
            for (int i = 0; i < l1 && i < l2; ++i) {
                c = m1[i] - m2[i];
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(l1, l2);
        }
        return c;
    };

    public Member(byte[] member, BigDecimal score) {
        Assert.allNotNull("All not null", member, score);
        this.member = member;
        this.score = score;
    }

    private Member(BigDecimal score) {
        this.member = null;
        this.key = null;
        this.score = score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashKey getKey() {
        if (this.member == null) {
            throw new IllegalArgumentException("Not invoke in this object !");
        }
        if (this.key == null) {
            Member member = this;
            synchronized (member) {
                if (this.key == null) {
                    this.key = new HashKey(this.member);
                }
            }
        }
        return this.key;
    }

    public byte[] getMember() {
        if (this.member == null) {
            return null;
        }
        return Arrays.copyOf(this.member, this.member.length);
    }

    public BigDecimal getScore() {
        return this.score;
    }

    public boolean scoreEQ(BigDecimal decimal) {
        return this.score.compareTo(decimal) == 0;
    }

    public boolean scoreGT(BigDecimal decimal) {
        return this.score.compareTo(decimal) > 0;
    }

    public boolean scoreLT(BigDecimal decimal) {
        return this.score.compareTo(decimal) < 0;
    }

    public boolean scoreNE(BigDecimal decimal) {
        return !this.scoreEQ(decimal);
    }

    public boolean scoreGE(BigDecimal decimal) {
        return this.score.compareTo(decimal) >= 0;
    }

    public boolean scoreLE(BigDecimal decimal) {
        return this.score.compareTo(decimal) <= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member m = (Member)o;
        return Arrays.equals(this.member, m.member);
    }

    public int hashCode() {
        return Arrays.hashCode(this.member);
    }

    public static Member MAX(BigDecimal score) {
        return new Member(score);
    }

    public static Member MIN(BigDecimal score) {
        return new Member(new byte[0], score);
    }
}

