/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;

public class ScaleTextureView
extends TextureView {
    private float translationX;
    private float translationY;
    private float scale = 1.0f;
    private float rotation;
    private float actionX;
    private float actionY;
    private float spacing;
    private float degree;
    private int moveType;
    private boolean enabledTouch = true;
    private boolean enabledRotation = true;
    private boolean enabledTranslation = true;

    public ScaleTextureView(Context context) {
        this(context, null);
    }

    public ScaleTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaleTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClickable(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.enabledTouch) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.moveType = 1;
                    this.actionX = event.getRawX();
                    this.actionY = event.getRawY();
                    break;
                }
                case 5: {
                    this.moveType = 2;
                    this.spacing = this.getSpacing(event);
                    this.degree = this.getDegree(event);
                    break;
                }
                case 2: {
                    if (this.moveType == 1) {
                        if (!this.enabledTranslation) break;
                        this.translationX = this.translationX + event.getRawX() - this.actionX;
                        this.translationY = this.translationY + event.getRawY() - this.actionY;
                        this.setTranslationX(this.translationX);
                        this.setTranslationY(this.translationY);
                        this.actionX = event.getRawX();
                        this.actionY = event.getRawY();
                        break;
                    }
                    if (this.moveType != 2) break;
                    this.scale = this.scale * this.getSpacing(event) / this.spacing;
                    this.setScaleX(this.scale);
                    this.setScaleY(this.scale);
                    if (!this.enabledRotation) break;
                    this.rotation = this.rotation + this.getDegree(event) - this.degree;
                    if (this.rotation > 360.0f) {
                        this.rotation -= 360.0f;
                    }
                    if (this.rotation < -360.0f) {
                        this.rotation += 360.0f;
                    }
                    this.setRotation(this.rotation);
                    break;
                }
                case 1: 
                case 6: {
                    this.moveType = 0;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private float getSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private float getDegree(MotionEvent event) {
        double delta_x = event.getX(0) - event.getX(1);
        double delta_y = event.getY(0) - event.getY(1);
        double radians = Math.atan2(delta_y, delta_x);
        return (float)Math.toDegrees(radians);
    }

    public void setEnabledTouch(boolean enabled) {
        this.enabledTouch = enabled;
    }

    public void setEnabledRotation(boolean enabled) {
        this.enabledRotation = enabled;
    }

    public void setEnabledTranslation(boolean enabled) {
        this.enabledTranslation = enabled;
    }

    public void reset(boolean saveEnabled) {
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scale = 1.0f;
        this.rotation = 0.0f;
        this.actionX = 0.0f;
        this.actionY = 0.0f;
        this.spacing = 0.0f;
        this.degree = 0.0f;
        this.moveType = 0;
        if (!saveEnabled) {
            this.enabledTouch = true;
            this.enabledRotation = true;
            this.enabledTranslation = true;
        }
        this.setScaleX(1.0f);
        this.setScaleY(1.0f);
        this.setRotation(0.0f);
        this.setTranslationX(0.0f);
        this.setTranslationY(0.0f);
    }
}

