/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.ViewGroup;

public class Helper {
    private static long lastClickTime;

    public static int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return Helper.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static ViewGroup getDecorView(Context mContext) {
        Activity activity = Helper.scanForActivity(mContext);
        if (activity == null) {
            return null;
        }
        return (ViewGroup)activity.getWindow().getDecorView();
    }

    public static ViewGroup getDecorView(Activity _activity) {
        Activity activity = _activity;
        if (activity == null) {
            return null;
        }
        return (ViewGroup)activity.getWindow().getDecorView();
    }

    public static void showSysBar(Activity activity, ViewGroup decorView) {
        int uiOptions = decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 16) {
            uiOptions &= 0xFFFFFFFD;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            uiOptions &= 0xFFFFEFFF;
        }
        decorView.setSystemUiVisibility(uiOptions);
        activity.getWindow().clearFlags(1024);
    }

    public static void hideSysBar(Activity activity, ViewGroup decorView) {
        int uiOptions = decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 16) {
            uiOptions |= 2;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            uiOptions |= 0x1000;
        }
        decorView.setSystemUiVisibility(uiOptions);
        activity.getWindow().setFlags(1024, 1024);
    }

    public static ViewGroup setFullScreen(Context context, boolean isFullScreen) {
        Activity activity = Helper.scanForActivity(context);
        ViewGroup decorView = Helper.getDecorView(activity);
        if (decorView == null) {
            return null;
        }
        if (isFullScreen) {
            Helper.hideSysBar(activity, decorView);
            activity.setRequestedOrientation(0);
        } else {
            Helper.showSysBar(activity, decorView);
            activity.setRequestedOrientation(1);
        }
        return decorView;
    }

    public static String secdsToDateFormat(int secds, int totalsecds) {
        long hours = secds / 3600;
        long minutes = secds % 3600 / 60;
        long seconds = secds % 60;
        String sh = "00";
        if (hours > 0L) {
            sh = hours < 10L ? "0" + hours : hours + "";
        }
        String sm = "00";
        if (minutes > 0L) {
            sm = minutes < 10L ? "0" + minutes : minutes + "";
        }
        String ss = "00";
        if (seconds > 0L) {
            ss = seconds < 10L ? "0" + seconds : seconds + "";
        }
        if (totalsecds >= 3600) {
            return sh + ":" + sm + ":" + ss;
        }
        return sm + ":" + ss;
    }

    public static synchronized boolean isFastClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 1000L) {
            return true;
        }
        lastClickTime = time;
        return false;
    }
}

