/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.microshow.rxffmpeg.player.Helper;
import io.microshow.rxffmpeg.player.IMediaPlayer;
import io.microshow.rxffmpeg.player.MeasureHelper;
import io.microshow.rxffmpeg.player.RxFFmpegPlayer;
import io.microshow.rxffmpeg.player.RxFFmpegPlayerController;
import io.microshow.rxffmpeg.player.RxFFmpegPlayerImpl;
import io.microshow.rxffmpeg.player.ScaleTextureView;
import java.lang.ref.WeakReference;

public class RxFFmpegPlayerView
extends FrameLayout {
    private Context mContext;
    private MeasureHelper mMeasureHelper;
    private FrameLayout mContainer;
    private RxFFmpegPlayerController mPlayerController;
    private TextureView mTextureView;
    public RxFFmpegPlayer mPlayer;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_FULL_SCREEN = 1;
    private int mCurrentMode = 0;

    public RxFFmpegPlayerView(Context context) {
        this(context, null);
    }

    public RxFFmpegPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mMeasureHelper = new MeasureHelper((View)this){

            @Override
            public boolean isFullScreen() {
                return RxFFmpegPlayerView.this.mCurrentMode == 1;
            }
        };
        this.initContainer();
        this.initPlayer();
        this.setKeepScreenOn(true);
    }

    private void initPlayer() {
        if (this.mTextureView == null) {
            this.mTextureView = new ScaleTextureView(this.mContext);
        }
        this.mPlayer = new RxFFmpegPlayerImpl();
        this.mPlayer.setTextureView(this.mTextureView);
        this.mPlayer.setOnVideoSizeChangedListener(new VideoSizeChangedListener(this));
    }

    private void updateVideoLayoutParams(final int width, final int height, final float dar) {
        this.post(new Runnable(){

            @Override
            public void run() {
                RxFFmpegPlayerView.this.mMeasureHelper.setVideoSizeInfo(new MeasureHelper.VideoSizeInfo(width, height, dar));
                RxFFmpegPlayerView.this.mMeasureHelper.setVideoLayoutParams(RxFFmpegPlayerView.this.mTextureView, RxFFmpegPlayerView.this.mContainer);
            }
        });
    }

    private void initContainer() {
        this.mContainer = new FrameLayout(this.mContext);
        this.mContainer.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    public void setPlayerBackgroundColor(int color) {
        if (this.mContainer != null) {
            this.mContainer.setBackgroundColor(color);
        }
    }

    public void setController(RxFFmpegPlayerController playerController, MeasureHelper.FitModel fitModel) {
        this.setFitModel(fitModel);
        this.mContainer.removeView((View)this.mPlayerController);
        this.mPlayerController = playerController;
        this.mPlayerController.setPlayerView(this);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mContainer.addView((View)this.mPlayerController, (ViewGroup.LayoutParams)params);
        this.addTextureView();
    }

    private void addTextureView() {
        this.mContainer.removeView((View)this.mTextureView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mContainer.addView((View)this.mTextureView, 0, (ViewGroup.LayoutParams)params);
    }

    public TextureView getTextureView() {
        return this.mTextureView;
    }

    public void setFitModel(MeasureHelper.FitModel fitModel) {
        if (this.mMeasureHelper != null && fitModel != null) {
            this.mMeasureHelper.setFitModel(fitModel);
        }
    }

    public void play(String videoPath, boolean isLooping) {
        if (this.mPlayer != null) {
            this.mPlayer.play(videoPath, isLooping);
        }
    }

    public void repeatPlay() {
        if (this.mPlayer != null) {
            this.mPlayer.repeatPlay();
        }
    }

    public void pause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
            if (this.mPlayerController != null) {
                this.mPlayerController.onPause();
            }
        }
    }

    public void resume() {
        if (this.mPlayer != null) {
            this.mPlayer.resume();
            if (this.mPlayerController != null) {
                this.mPlayerController.onResume();
            }
        }
    }

    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    public boolean isLooping() {
        return this.mPlayer != null && this.mPlayer.isLooping();
    }

    public void setVolume(int percent) {
        if (this.mPlayer != null) {
            this.mPlayer.setVolume(percent);
        }
    }

    public int getVolume() {
        if (this.mPlayer != null) {
            return this.mPlayer.getVolume() != -1 ? this.mPlayer.getVolume() : 100;
        }
        return 100;
    }

    public void setMuteSolo(int mute) {
        if (this.mPlayer != null) {
            this.mPlayer.setMuteSolo(mute);
        }
    }

    public int getMuteSolo() {
        if (this.mPlayer != null) {
            return this.mPlayer.getMuteSolo() != -1 ? this.mPlayer.getMuteSolo() : 0;
        }
        return 0;
    }

    public void release() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
            this.mPlayer = null;
        }
        this.setKeepScreenOn(false);
    }

    public boolean isFullScreenModel() {
        return this.mCurrentMode == 1;
    }

    public boolean switchScreen() {
        if (this.isFullScreenModel()) {
            return this.exitFullScreen();
        }
        return this.enterFullScreen();
    }

    public boolean enterFullScreen() {
        if (this.mCurrentMode == 1) {
            return false;
        }
        ViewGroup decorView = Helper.setFullScreen(this.mContext, true);
        if (decorView == null) {
            return false;
        }
        this.removeView((View)this.mContainer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        decorView.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mCurrentMode = 1;
        return true;
    }

    public boolean exitFullScreen() {
        if (this.mCurrentMode == 1) {
            ViewGroup decorView = Helper.setFullScreen(this.mContext, false);
            if (decorView == null) {
                return false;
            }
            decorView.removeView((View)this.mContainer);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
            this.mCurrentMode = 0;
        }
        return false;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mMeasureHelper != null) {
            this.mMeasureHelper.setVideoLayoutParams(this.mTextureView, this.mContainer);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int[] size = this.mMeasureHelper.doMeasure(this.getMeasuredWidth(), this.getMeasuredHeight());
        this.setMeasuredDimension(size[0], size[1]);
    }

    public static class VideoSizeChangedListener
    implements IMediaPlayer.OnVideoSizeChangedListener {
        private WeakReference<RxFFmpegPlayerView> mWeakReference;

        VideoSizeChangedListener(RxFFmpegPlayerView mRxFFmpegPlayerView) {
            this.mWeakReference = new WeakReference<RxFFmpegPlayerView>(mRxFFmpegPlayerView);
        }

        @Override
        public void onVideoSizeChanged(IMediaPlayer mediaPlayer, int width, int height, float dar) {
            RxFFmpegPlayerView mRxFFmpegPlayerView = (RxFFmpegPlayerView)((Object)this.mWeakReference.get());
            if (mRxFFmpegPlayerView != null) {
                mRxFFmpegPlayerView.updateVideoLayoutParams(width, height, dar);
            }
        }
    }
}

