/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import io.microshow.rxffmpeg.R;
import io.microshow.rxffmpeg.player.Helper;
import io.microshow.rxffmpeg.player.IMediaPlayer;
import io.microshow.rxffmpeg.player.RxFFmpegPlayerController;
import java.lang.ref.WeakReference;

public class RxFFmpegPlayerControllerImpl
extends RxFFmpegPlayerController {
    private TextView mTimeView;
    private SeekBar mProgressView;
    private ProgressBar mProgressBar;
    private View mBottomPanel;
    private ImageView playBtn;
    private View repeatPlay;
    private boolean isSeeking = false;
    public int mPosition;

    public RxFFmpegPlayerControllerImpl(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.rxffmpeg_player_controller;
    }

    @Override
    public void initView() {
        this.mBottomPanel = this.findViewById(R.id.bottomPanel);
        this.mProgressView = (SeekBar)this.findViewById(R.id.progress_view);
        this.mTimeView = (TextView)this.findViewById(R.id.time_view);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.playBtn = (ImageView)this.findViewById(R.id.iv_play);
        this.repeatPlay = this.findViewById(R.id.repeatPlay);
        this.repeatPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RxFFmpegPlayerControllerImpl.this.mPlayerView.repeatPlay();
                RxFFmpegPlayerControllerImpl.this.repeatPlay.setVisibility(8);
            }
        });
        View mFullScreenIv = this.findViewById(R.id.iv_fullscreen);
        mFullScreenIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (RxFFmpegPlayerControllerImpl.this.mPlayerView != null) {
                    RxFFmpegPlayerControllerImpl.this.mPlayerView.switchScreen();
                }
            }
        });
        this.playBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (RxFFmpegPlayerControllerImpl.this.mPlayerView != null) {
                    if (RxFFmpegPlayerControllerImpl.this.mPlayerView.isPlaying()) {
                        RxFFmpegPlayerControllerImpl.this.mPlayerView.pause();
                    } else {
                        RxFFmpegPlayerControllerImpl.this.mPlayerView.resume();
                    }
                }
            }
        });
    }

    @Override
    public void initListener() {
        PlayerListener mPlayerListener = new PlayerListener(this);
        this.mPlayer.setOnLoadingListener(mPlayerListener);
        this.mPlayer.setOnTimeUpdateListener(mPlayerListener);
        this.mPlayer.setOnErrorListener(mPlayerListener);
        this.mPlayer.setOnCompleteListener(mPlayerListener);
        this.mProgressView.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                RxFFmpegPlayerControllerImpl.this.mPosition = progress * RxFFmpegPlayerControllerImpl.this.mPlayer.getDuration() / 100;
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                RxFFmpegPlayerControllerImpl.this.isSeeking = true;
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                RxFFmpegPlayerControllerImpl.this.mPlayer.seekTo(RxFFmpegPlayerControllerImpl.this.mPosition);
                RxFFmpegPlayerControllerImpl.this.isSeeking = false;
            }
        });
    }

    public void onCompletion(IMediaPlayer mediaPlayer) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (RxFFmpegPlayerControllerImpl.this.mPlayerView != null && !RxFFmpegPlayerControllerImpl.this.mPlayerView.isLooping()) {
                    RxFFmpegPlayerControllerImpl.this.repeatPlay.setVisibility(0);
                } else {
                    RxFFmpegPlayerControllerImpl.this.repeatPlay.setVisibility(8);
                }
            }
        });
    }

    public void onError(IMediaPlayer mediaPlayer, final int code, final String msg) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)RxFFmpegPlayerControllerImpl.this.getContext(), (CharSequence)("\u51fa\u9519\u4e86\uff1acode=" + code + ", msg=" + msg), (int)0).show();
            }
        });
    }

    public void onTimeUpdate(IMediaPlayer mediaPlayer, final int currentTime, final int totalTime) {
        this.post(new Runnable(){

            @Override
            @SuppressLint(value={"SetTextI18n"})
            public void run() {
                if (totalTime <= 0) {
                    RxFFmpegPlayerControllerImpl.this.mBottomPanel.setVisibility(8);
                    return;
                }
                RxFFmpegPlayerControllerImpl.this.mBottomPanel.setVisibility(0);
                RxFFmpegPlayerControllerImpl.this.mTimeView.setText((CharSequence)(Helper.secdsToDateFormat(currentTime, totalTime) + " / " + Helper.secdsToDateFormat(totalTime, totalTime)));
                if (!RxFFmpegPlayerControllerImpl.this.isSeeking && totalTime > 0) {
                    RxFFmpegPlayerControllerImpl.this.mProgressView.setProgress(currentTime * 100 / totalTime);
                }
            }
        });
    }

    public void onLoading(IMediaPlayer mediaPlayer, final boolean isLoading) {
        this.post(new Runnable(){

            @Override
            public void run() {
                RxFFmpegPlayerControllerImpl.this.mProgressBar.setVisibility(isLoading ? 0 : 8);
            }
        });
    }

    @Override
    public void onPause() {
        this.playBtn.setImageResource(R.mipmap.rxffmpeg_player_start);
        this.playBtn.animate().alpha(1.0f).start();
    }

    @Override
    public void onResume() {
        this.playBtn.setImageResource(R.mipmap.rxffmpeg_player_pause);
        this.playBtn.animate().alpha(1.0f).start();
    }

    public static class PlayerListener
    implements IMediaPlayer.OnCompletionListener,
    IMediaPlayer.OnErrorListener,
    IMediaPlayer.OnLoadingListener,
    IMediaPlayer.OnTimeUpdateListener {
        private WeakReference<RxFFmpegPlayerControllerImpl> mWeakReference;

        PlayerListener(RxFFmpegPlayerControllerImpl playerControllerImpl) {
            this.mWeakReference = new WeakReference<RxFFmpegPlayerControllerImpl>(playerControllerImpl);
        }

        @Override
        public void onCompletion(IMediaPlayer mediaPlayer) {
            RxFFmpegPlayerControllerImpl playerControllerImpl = (RxFFmpegPlayerControllerImpl)((Object)this.mWeakReference.get());
            if (playerControllerImpl != null) {
                playerControllerImpl.onCompletion(mediaPlayer);
            }
        }

        @Override
        public void onError(IMediaPlayer mediaPlayer, int err, String msg) {
            RxFFmpegPlayerControllerImpl playerControllerImpl = (RxFFmpegPlayerControllerImpl)((Object)this.mWeakReference.get());
            if (playerControllerImpl != null) {
                playerControllerImpl.onError(mediaPlayer, err, msg);
            }
        }

        @Override
        public void onLoading(IMediaPlayer mediaPlayer, boolean isLoading) {
            RxFFmpegPlayerControllerImpl playerControllerImpl = (RxFFmpegPlayerControllerImpl)((Object)this.mWeakReference.get());
            if (playerControllerImpl != null) {
                playerControllerImpl.onLoading(mediaPlayer, isLoading);
            }
        }

        @Override
        public void onTimeUpdate(IMediaPlayer mediaPlayer, int currentTime, int totalTime) {
            RxFFmpegPlayerControllerImpl playerControllerImpl = (RxFFmpegPlayerControllerImpl)((Object)this.mWeakReference.get());
            if (playerControllerImpl != null) {
                playerControllerImpl.onTimeUpdate(mediaPlayer, currentTime, totalTime);
            }
        }
    }
}

