/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ExternalLiveData<T>
extends MutableLiveData<T> {
    public static final int START_VERSION = -1;

    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<? super T> observer) {
        if (owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        try {
            ExternalLifecycleBoundObserver wrapper = new ExternalLifecycleBoundObserver(owner, observer);
            LiveData.LifecycleBoundObserver existing = (LiveData.LifecycleBoundObserver)this.callMethodPutIfAbsent(observer, (Object)wrapper);
            if (existing != null && !existing.isAttachedTo(owner)) {
                throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
            }
            if (existing != null) {
                return;
            }
            owner.getLifecycle().addObserver((LifecycleObserver)wrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getVersion() {
        return super.getVersion();
    }

    protected Lifecycle.State observerActiveLevel() {
        return Lifecycle.State.CREATED;
    }

    private Object getFieldObservers() throws Exception {
        Field fieldObservers = LiveData.class.getDeclaredField("mObservers");
        fieldObservers.setAccessible(true);
        return fieldObservers.get((Object)this);
    }

    private Object callMethodPutIfAbsent(Object observer, Object wrapper) throws Exception {
        Object mObservers = this.getFieldObservers();
        Class<?> classOfSafeIterableMap = mObservers.getClass();
        Method putIfAbsent = classOfSafeIterableMap.getDeclaredMethod("putIfAbsent", Object.class, Object.class);
        putIfAbsent.setAccessible(true);
        return putIfAbsent.invoke(mObservers, observer, wrapper);
    }

    class ExternalLifecycleBoundObserver
    extends LiveData.LifecycleBoundObserver {
        ExternalLifecycleBoundObserver(LifecycleOwner owner, Observer<? super T> observer) {
            super((LiveData)ExternalLiveData.this, owner, observer);
        }

        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(ExternalLiveData.this.observerActiveLevel());
        }
    }
}

