/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import com.egain.bindings.chat.EgainParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.BOSHClient;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.BOSHClientConnEvent;
import org.igniterealtime.jbosh.BOSHClientConnListener;
import org.igniterealtime.jbosh.BOSHClientRequestListener;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ComposableBody;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.bosh.BOSHConfiguration;
import org.jivesoftware.smack.bosh.EceEventDispatcher;
import org.jivesoftware.smack.bosh.EceEventListener;
import org.jivesoftware.smack.bosh.EceStatusEvent;
import org.jivesoftware.smack.bosh.EceToXmppIncomingMessageConverter;
import org.jivesoftware.smack.bosh.MessageBodyDecoder;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jxmpp.jid.parts.Resourcepart;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class EceBoshConnection
extends AbstractXMPPConnection {
    public static final String XMPP_BOSH_NS = "urn:xmpp:xbosh";
    public static final String BOSH_URI = "http://jabber.org/protocol/httpbind";
    public static final String EGAIN_FROM = "from";
    public static final String EGAIN_AUTHID = "authid";
    public static final String AGENT_JOIN_MSG = "agent_join_msg";
    public static final String AGENT_LEFT_SESSION = "agent_left_session";
    public static final String AGENT_CLOSE_SESSION = "agent_close_session";
    private static final Logger LOGGER = Logger.getLogger(EceBoshConnection.class.getName());
    private final BOSHConfiguration config;
    protected String sessionID = null;
    private EgainParams params;
    private BOSHClient client;
    private boolean isFirstInitialization = true;
    private boolean done = false;
    private PipedWriter readerPipe;
    private Thread readerConsumer;
    private boolean notified;
    private EceEventDispatcher eceEventDispatcher = new EceEventDispatcher(this);
    private XmlMapper mapper = new XmlMapper();
    private EceToXmppIncomingMessageConverter eceConverter = new EceToXmppIncomingMessageConverter(new MessageBodyDecoder());

    public EceBoshConnection(BOSHConfiguration config, EgainParams params) {
        super((ConnectionConfiguration)config);
        this.config = config;
        this.params = params;
        if (null == params.getMessagingData()) {
            params.setMessagingData(this.getDefaultMessages());
        }
        this.applyEventTokensToMessages(params);
    }

    private void applyEventTokensToMessages(EgainParams params) {
        String msgs = params.getMessagingData();
        msgs = msgs.replaceFirst("agent_join_msg\\s*=", "agent_join_msg=" + EceStatusEvent.CHAT_STARTED.getToken());
        msgs = msgs.replaceFirst("agent_left_session\\s*=", "agent_left_session=" + EceStatusEvent.CHAT_CLOSED.getToken());
        msgs = msgs.replaceFirst("agent_close_session\\s*=", "agent_close_session=" + EceStatusEvent.CHAT_CLOSED.getToken());
        params.setMessagingData(msgs);
    }

    private String getDefaultMessages() {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/default_messages.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectInternal(BOSHClient client) throws SmackException, InterruptedException {
        this.done = false;
        this.notified = false;
        client.addBOSHClientConnListener(new BOSHConnectionListener());
        client.addBOSHClientResponseListener(new BOSHPacketReader());
        if (this.config.isDebuggerEnabled()) {
            this.initDebugger();
            if (this.isFirstInitialization) {
                if (this.debugger.getReaderListener() != null) {
                    this.addAsyncStanzaListener(this.debugger.getReaderListener(), null);
                }
                if (this.debugger.getWriterListener() != null) {
                    this.addStanzaSendingListener(this.debugger.getWriterListener(), null);
                }
            }
        }
        try {
            client.send(ComposableBody.builder().setNamespaceDefinition("xmpp", XMPP_BOSH_NS).setAttribute(BodyQName.createWithPrefix(XMPP_BOSH_NS, "version", "xmpp"), "1.0").setAttribute(BodyQName.create("http://bindings.egain.com/chat", EGAIN_FROM), "anonymous@egain.com").setAttribute(BodyQName.create("http://bindings.egain.com/chat", EGAIN_AUTHID), "0").setAttribute(BodyQName.create("http://bindings.egain.com/chat", "content"), "text/xml; charset=utf-8").setPayloadXML(this.mapper.writeValueAsString((Object)this.params)).build());
            this.authenticated = true;
        }
        catch (BOSHException e) {
            throw new SmackException.ConnectionException((Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        EceBoshConnection e = this;
        synchronized (e) {
            if (!this.connected) {
                long now;
                long deadline = System.currentTimeMillis() + this.getReplyTimeout();
                while (!this.notified && (now = System.currentTimeMillis()) < deadline) {
                    ((Object)((Object)this)).wait(deadline - now);
                }
            }
        }
        if (!this.connected && !this.done) {
            this.done = true;
            String errorMessage = "Timeout reached for the connection to " + this.getHost() + ":" + this.getPort() + ".";
            throw new SmackException(errorMessage);
        }
    }

    protected void connectInternal() throws SmackException, InterruptedException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.sessionID = null;
        BOSHClientConfig.Builder cfgBuilder = null;
        try {
            cfgBuilder = BOSHClientConfig.Builder.create(this.config.getURI(), this.config.getXMPPServiceDomain().toString());
            if (this.config.isProxyEnabled()) {
                cfgBuilder.setProxy(this.config.getProxyAddress(), this.config.getProxyPort());
            }
            if (null != this.config.getCustomSSLContext()) {
                cfgBuilder.setSSLContext(this.config.getCustomSSLContext());
            }
            for (Header h : this.config.getHttpHeaders()) {
                cfgBuilder.addHttpHeader(h);
            }
            cfgBuilder.setXMLLang("en-US");
            this.client = BOSHClient.create(cfgBuilder.build());
            this.connectInternal(this.client);
        }
        catch (URISyntaxException e) {
            throw new SmackException.ConnectionException((Throwable)e);
        }
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    protected void loginInternal(String username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        this.saslAuthentication.authenticate(username, password, this.config.getAuthzid(), null);
        this.bindResourceAndEstablishSession(resource);
        this.afterSuccessfulLogin(false);
    }

    public void sendNonza(Nonza element) throws SmackException.NotConnectedException {
        if (this.done) {
            throw new SmackException.NotConnectedException();
        }
        this.sendElement((Element)element);
    }

    protected void sendStanzaInternal(Stanza packet) throws SmackException.NotConnectedException {
        this.sendElement((Element)packet);
    }

    private void sendElement(Element element) {
        try {
            String x = element.toXML().toString();
            x = x.replaceFirst("<message ", "<message xmlns='jabber:client' ");
            x = x.replaceFirst("<presence id='[^']+' ", "<presence xmlns='jabber:client' ");
            this.send(ComposableBody.builder().setPayloadXML(x).build());
            if (element instanceof Stanza) {
                this.firePacketSendingListeners((Stanza)element);
            }
        }
        catch (BOSHException e) {
            LOGGER.log(Level.SEVERE, "BOSHException in sendStanzaInternal", e);
        }
    }

    protected void shutdown() {
        this.setWasAuthenticated();
        this.sessionID = null;
        this.done = true;
        this.authenticated = false;
        this.connected = false;
        this.isFirstInitialization = false;
        if (this.readerPipe != null) {
            try {
                this.readerPipe.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        this.readerConsumer = null;
    }

    protected void send(ComposableBody body) throws BOSHException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected to a server!");
        }
        if (body == null) {
            throw new NullPointerException("Body mustn't be null!");
        }
        if (this.sessionID != null) {
            body = body.rebuild().setAttribute(BodyQName.create(BOSH_URI, "sid"), this.sessionID).build();
        }
        LOGGER.log(Level.FINE, "Sending message:" + body.toXML());
        this.client.send(body);
    }

    protected void initDebugger() {
        this.writer = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }
        };
        try {
            this.readerPipe = new PipedWriter();
            this.reader = new PipedReader(this.readerPipe);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.initDebugger();
        this.client.addBOSHClientResponseListener(new BOSHClientResponseListener(){

            @Override
            public void responseReceived(BOSHMessageEvent event) {
                if (event.getBody() != null) {
                    try {
                        EceBoshConnection.this.readerPipe.write(event.getBody().toXML());
                        EceBoshConnection.this.readerPipe.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.client.addBOSHClientRequestListener(new BOSHClientRequestListener(){

            @Override
            public void requestSent(BOSHMessageEvent event) {
                if (event.getBody() != null) {
                    try {
                        EceBoshConnection.this.writer.write(event.getBody().toXML());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.readerConsumer = new Thread(){
            private Thread thread = this;
            private int bufferLength = 1024;

            @Override
            public void run() {
                try {
                    char[] cbuf = new char[this.bufferLength];
                    while (EceBoshConnection.this.readerConsumer == this.thread && !EceBoshConnection.this.done) {
                        EceBoshConnection.this.reader.read(cbuf, 0, this.bufferLength);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.readerConsumer.setDaemon(true);
        this.readerConsumer.start();
    }

    protected void notifyConnectionError(Exception e) {
        this.shutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    protected void invokeStanzaCollectorsAndNotifyRecvListeners(Stanza packet) {
        this.eceConverter.process(packet);
        super.invokeStanzaCollectorsAndNotifyRecvListeners(packet);
    }

    public void addEceEventListener(EceEventListener listener) {
        this.eceEventDispatcher.addListener(listener);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    private class BOSHPacketReader
    implements BOSHClientResponseListener {
        private BOSHPacketReader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void responseReceived(BOSHMessageEvent event) {
            AbstractBody body = event.getBody();
            LOGGER.log(Level.FINE, "Received message:" + body.toXML());
            if (body == null) return;
            try {
                if (EceBoshConnection.this.sessionID == null) {
                    EceBoshConnection.this.sessionID = body.getAttribute(BodyQName.create(EceBoshConnection.BOSH_URI, "sid"));
                }
                if (EceBoshConnection.this.streamId == null) {
                    EceBoshConnection.this.streamId = body.getAttribute(BodyQName.create(EceBoshConnection.BOSH_URI, EceBoshConnection.EGAIN_AUTHID));
                }
                XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)new StringReader(body.toXML()));
                int eventType = parser.getEventType();
                do {
                    eventType = parser.next();
                    switch (eventType) {
                        case 2: {
                            String name;
                            switch (name = parser.getName()) {
                                case "message": 
                                case "iq": 
                                case "presence": {
                                    EceBoshConnection.this.parseAndProcessStanza(parser);
                                    break;
                                }
                                case "challenge": {
                                    String challengeData = parser.nextText();
                                    EceBoshConnection.this.getSASLAuthentication().challengeReceived(challengeData);
                                    break;
                                }
                                case "success": {
                                    EceBoshConnection.this.send(ComposableBody.builder().setNamespaceDefinition("xmpp", EceBoshConnection.XMPP_BOSH_NS).setAttribute(BodyQName.createWithPrefix(EceBoshConnection.XMPP_BOSH_NS, "restart", "xmpp"), "true").setAttribute(BodyQName.create(EceBoshConnection.BOSH_URI, "to"), EceBoshConnection.this.getXMPPServiceDomain().toString()).build());
                                    SaslStreamElements.Success success = new SaslStreamElements.Success(parser.nextText());
                                    EceBoshConnection.this.getSASLAuthentication().authenticated(success);
                                    break;
                                }
                                case "features": {
                                    EceBoshConnection.this.parseFeatures(parser);
                                    break;
                                }
                                case "failure": {
                                    if (!"urn:ietf:params:xml:ns:xmpp-sasl".equals(parser.getNamespace(null))) break;
                                    SaslStreamElements.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)parser);
                                    EceBoshConnection.this.getSASLAuthentication().authenticationFailed(failure);
                                    break;
                                }
                                case "error": {
                                    if ("urn:ietf:params:xml:ns:xmpp-streams".equals(parser.getNamespace(null))) {
                                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)parser));
                                    }
                                    XMPPError.Builder builder = PacketParserUtils.parseError((XmlPullParser)parser);
                                    throw new XMPPException.XMPPErrorException(null, builder.build());
                                }
                                case "body": {
                                    String type = parser.getAttributeValue(null, "type");
                                    if (!"terminate".equals(type)) break;
                                    EceBoshConnection.this.eceEventDispatcher.emitEvent(EceStatusEvent.CHAT_CLOSED);
                                }
                            }
                            break;
                        }
                    }
                } while (eventType != 1);
                return;
            }
            catch (Exception e) {
                if (!EceBoshConnection.this.isConnected()) return;
                EceBoshConnection.this.notifyConnectionError(e);
            }
        }
    }

    public class BOSHConnectionListener
    implements BOSHClientConnListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionEvent(BOSHClientConnEvent connEvent) {
            block14: {
                try {
                    if (connEvent.isConnected()) {
                        EceBoshConnection.this.connected = true;
                        if (EceBoshConnection.this.isFirstInitialization) {
                            EceBoshConnection.this.isFirstInitialization = false;
                            break block14;
                        }
                        if (!EceBoshConnection.this.wasAuthenticated) break block14;
                        try {
                            EceBoshConnection.this.login();
                            break block14;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (connEvent.isError()) {
                        Throwable cause = connEvent.getCause();
                        Exception e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
                        EceBoshConnection.this.notifyConnectionError(e);
                    }
                    EceBoshConnection.this.connected = false;
                }
                finally {
                    EceBoshConnection.this.notified = true;
                    EceBoshConnection eceBoshConnection = EceBoshConnection.this;
                    synchronized (eceBoshConnection) {
                        ((Object)((Object)EceBoshConnection.this)).notifyAll();
                    }
                }
            }
        }
    }
}

