/*
 * Decompiled with CFR 0.152.
 */
package com.github.mfathi91.time;

import com.github.mfathi91.time.PersianChronology;
import com.github.mfathi91.time.PersianDate;
import com.github.mfathi91.time.PersianMonth;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class PersianDateTime
implements ChronoLocalDateTime<PersianDate> {
    private static final PersianDateTime MIN = new PersianDateTime(PersianDate.MIN, LocalTime.MIN);
    private static final PersianDateTime MAX = new PersianDateTime(PersianDate.MAX, LocalTime.MAX);
    private final PersianDate date;
    private final LocalTime time;

    public static PersianDateTime now() {
        return new PersianDateTime(PersianDate.now(), LocalTime.now());
    }

    public static PersianDateTime of(PersianDate date, LocalTime time) {
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, PersianMonth month, int dayOfMonth, int hour, int minute) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, PersianMonth month, int dayOfMonth, int hour, int minute, int second) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, PersianMonth month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second, nanoOfSecond);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, int month, int dayOfMonth, int hour, int minute) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        PersianDate date = PersianDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second, nanoOfSecond);
        return new PersianDateTime(date, time);
    }

    public static PersianDateTime fromGregorian(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        return new PersianDateTime(PersianDate.fromGregorian(localDateTime.toLocalDate()), localDateTime.toLocalTime());
    }

    public static PersianDateTime parse(CharSequence text) {
        return PersianDateTime.parse(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static PersianDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.withChronology(PersianChronology.INSTANCE).parse(text, PersianDateTime::from);
    }

    public static PersianDateTime from(TemporalAccessor temporal) {
        Objects.requireNonNull(temporal, "temporal");
        if (temporal instanceof PersianDateTime) {
            return (PersianDateTime)temporal;
        }
        try {
            PersianDate date = PersianDate.from(temporal);
            LocalTime time = LocalTime.from(temporal);
            return new PersianDateTime(date, time);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException(String.format("Unable to parse PersianDateTime from TemporalAccessor: %s", temporal), ex);
        }
    }

    private PersianDateTime(PersianDate date, LocalTime time) {
        this.date = Objects.requireNonNull(date, "date");
        this.time = Objects.requireNonNull(time, "time");
    }

    @Override
    public PersianDate toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    public LocalDateTime toGregorian() {
        return LocalDateTime.of(this.date.toGregorian(), this.time);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return false;
    }

    @Override
    public long getLong(TemporalField field) {
        Objects.requireNonNull(field, "field");
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            return chronoField.isTimeBased() ? this.time.getLong(field) : this.date.getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ChronoLocalDateTime<PersianDate> with(TemporalField field, long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChronoLocalDateTime<PersianDate> plus(long amountToAdd, TemporalUnit temporalUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChronoZonedDateTime<PersianDate> atZone(ZoneId zoneId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> other) {
        int result = 0;
        if (other instanceof PersianDateTime) {
            PersianDateTime otherPersianDateTime = (PersianDateTime)other;
            result = this.date.compareTo(otherPersianDateTime.date);
            if (result == 0) {
                result = this.time.compareTo(otherPersianDateTime.time);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PersianDateTime) {
            return this.compareTo((PersianDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.date, this.time);
    }

    @Override
    public String toString() {
        return String.format("%sT%s", this.date, this.time);
    }
}

