/*
 * Decompiled with CFR 0.152.
 */
package mehdi.sakout.fancybuttons;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static Map<String, Typeface> cachedFontMap = new HashMap<String, Typeface>();

    public static int pxToSp(Context context, float px) {
        return Math.round(px / context.getResources().getDisplayMetrics().scaledDensity);
    }

    public static int spToPx(Context context, float sp) {
        return Math.round(sp * context.getResources().getDisplayMetrics().scaledDensity);
    }

    public static Typeface findFont(Context context, String fonPath, String defaultFontPath) {
        String fontName = new File(fonPath).getName();
        String defaultFontName = "";
        if (!TextUtils.isEmpty((CharSequence)defaultFontPath)) {
            defaultFontName = new File(defaultFontPath).getName();
        }
        if (cachedFontMap.containsKey(fontName)) {
            return cachedFontMap.get(fontName);
        }
        try {
            AssetManager assets = context.getResources().getAssets();
            if (Arrays.asList(assets.list("")).contains(fonPath)) {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName);
                cachedFontMap.put(fontName, typeface);
                return typeface;
            }
            if (Arrays.asList(assets.list("fonts")).contains(fontName)) {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)String.format("fonts/%s", fontName));
                cachedFontMap.put(fontName, typeface);
                return typeface;
            }
            if (Arrays.asList(assets.list("iconfonts")).contains(fontName)) {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)String.format("iconfonts/%s", fontName));
                cachedFontMap.put(fontName, typeface);
                return typeface;
            }
            if (!TextUtils.isEmpty((CharSequence)defaultFontPath) && Arrays.asList(assets.list("")).contains(defaultFontPath)) {
                Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)defaultFontPath);
                cachedFontMap.put(defaultFontName, typeface);
                return typeface;
            }
            throw new Exception("Font not Found");
        }
        catch (Exception e) {
            return Typeface.DEFAULT;
        }
    }
}

