/*
 * Decompiled with CFR 0.152.
 */
package com.labters.documentscanner.base;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import com.labters.documentscanner.R;
import com.labters.documentscanner.base.CropperErrorType;
import com.labters.documentscanner.libraries.NativeClass;
import com.labters.documentscanner.libraries.PolygonView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;

public abstract class DocumentScanActivity
extends AppCompatActivity {
    protected CompositeDisposable disposable = new CompositeDisposable();
    private Bitmap selectedImage;
    private NativeClass nativeClass = new NativeClass();

    protected abstract FrameLayout getHolderImageCrop();

    protected abstract ImageView getImageView();

    protected abstract PolygonView getPolygonView();

    protected abstract void showProgressBar();

    protected abstract void hideProgressBar();

    protected abstract void showError(CropperErrorType var1);

    protected abstract Bitmap getBitmapImage();

    private void setImageRotation() {
        Bitmap tempBitmap = this.selectedImage.copy(this.selectedImage.getConfig(), true);
        for (int i = 1; i <= 4; ++i) {
            MatOfPoint2f point2f = this.nativeClass.getPoint(tempBitmap);
            if (point2f != null) {
                this.selectedImage = tempBitmap.copy(this.selectedImage.getConfig(), true);
                break;
            }
            tempBitmap = this.rotateBitmap(tempBitmap, 90 * i);
        }
    }

    protected Bitmap rotateBitmap(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private void setProgressBar(boolean isShow) {
        if (isShow) {
            this.showProgressBar();
        } else {
            this.hideProgressBar();
        }
    }

    protected void startCropping() {
        this.selectedImage = this.getBitmapImage();
        this.setProgressBar(true);
        this.disposable.add(Observable.fromCallable(() -> {
            this.setImageRotation();
            return false;
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(result -> {
            this.initializeCropping();
            this.setProgressBar(false);
        }));
    }

    private void initializeCropping() {
        Bitmap scaledBitmap = this.scaledBitmap(this.selectedImage, this.getHolderImageCrop().getWidth(), this.getHolderImageCrop().getHeight());
        this.getImageView().setImageBitmap(scaledBitmap);
        Bitmap tempBitmap = ((BitmapDrawable)this.getImageView().getDrawable()).getBitmap();
        Map<Integer, PointF> pointFs = null;
        try {
            pointFs = this.getEdgePoints(tempBitmap);
            this.getPolygonView().setPoints(pointFs);
            this.getPolygonView().setVisibility(0);
            int padding = (int)this.getResources().getDimension(R.dimen.scanPadding);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(tempBitmap.getWidth() + 2 * padding, tempBitmap.getHeight() + 2 * padding);
            layoutParams.gravity = 17;
            this.getPolygonView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.getPolygonView().setPointColor(this.getResources().getColor(R.color.blue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Bitmap getCroppedImage() {
        try {
            Map<Integer, PointF> points = this.getPolygonView().getPoints();
            float xRatio = (float)this.selectedImage.getWidth() / (float)this.getImageView().getWidth();
            float yRatio = (float)this.selectedImage.getHeight() / (float)this.getImageView().getHeight();
            float x1 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)0))).x * xRatio;
            float x2 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)1))).x * xRatio;
            float x3 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)2))).x * xRatio;
            float x4 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)3))).x * xRatio;
            float y1 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)0))).y * yRatio;
            float y2 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)1))).y * yRatio;
            float y3 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)2))).y * yRatio;
            float y4 = Objects.requireNonNull(points.get((Object)Integer.valueOf((int)3))).y * yRatio;
            return this.nativeClass.getScannedBitmap(this.selectedImage, x1, y1, x2, y2, x3, y3, x4, y4);
        }
        catch (Exception e) {
            this.showError(CropperErrorType.CROP_ERROR);
            return null;
        }
    }

    protected Bitmap scaledBitmap(Bitmap bitmap, int width, int height) {
        Matrix m = new Matrix();
        m.setRectToRect(new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight()), new RectF(0.0f, 0.0f, (float)width, (float)height), Matrix.ScaleToFit.CENTER);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
    }

    private Map<Integer, PointF> getEdgePoints(Bitmap tempBitmap) throws Exception {
        List<PointF> pointFs = this.getContourEdgePoints(tempBitmap);
        Map<Integer, PointF> orderedPoints = this.orderedValidEdgePoints(tempBitmap, pointFs);
        return orderedPoints;
    }

    private List<PointF> getContourEdgePoints(Bitmap tempBitmap) {
        MatOfPoint2f point2f = this.nativeClass.getPoint(tempBitmap);
        if (point2f == null) {
            point2f = new MatOfPoint2f();
        }
        List<Point> points = Arrays.asList(point2f.toArray());
        ArrayList<PointF> result = new ArrayList<PointF>();
        for (int i = 0; i < points.size(); ++i) {
            result.add(new PointF((float)points.get((int)i).x, (float)points.get((int)i).y));
        }
        return result;
    }

    private Map<Integer, PointF> getOutlinePoints(Bitmap tempBitmap) {
        HashMap<Integer, PointF> outlinePoints = new HashMap<Integer, PointF>();
        outlinePoints.put(0, new PointF(0.0f, 0.0f));
        outlinePoints.put(1, new PointF((float)tempBitmap.getWidth(), 0.0f));
        outlinePoints.put(2, new PointF(0.0f, (float)tempBitmap.getHeight()));
        outlinePoints.put(3, new PointF((float)tempBitmap.getWidth(), (float)tempBitmap.getHeight()));
        return outlinePoints;
    }

    private Map<Integer, PointF> orderedValidEdgePoints(Bitmap tempBitmap, List<PointF> pointFs) {
        Map<Integer, PointF> orderedPoints = this.getPolygonView().getOrderedPoints(pointFs);
        if (!this.getPolygonView().isValidShape(orderedPoints)) {
            orderedPoints = this.getOutlinePoints(tempBitmap);
        }
        return orderedPoints;
    }

    protected void onStop() {
        super.onStop();
        this.disposable.clear();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.disposable.dispose();
    }
}

