/*
 * Decompiled with CFR 0.152.
 */
package com.labters.documentscanner;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.labters.documentscanner.R;
import com.labters.documentscanner.base.CropperErrorType;
import com.labters.documentscanner.base.DocumentScanActivity;
import com.labters.documentscanner.helpers.ScannerConstants;
import com.labters.documentscanner.libraries.PolygonView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ImageCropActivity
extends DocumentScanActivity {
    private FrameLayout holderImageCrop;
    private ImageView imageView;
    private PolygonView polygonView;
    private boolean isInverted;
    private ProgressBar progressBar;
    private Bitmap cropImage;
    private View.OnClickListener btnImageEnhanceClick = new View.OnClickListener(){

        public void onClick(View v) {
            ImageCropActivity.this.showProgressBar();
            ImageCropActivity.this.disposable.add(Observable.fromCallable(() -> {
                ImageCropActivity.this.cropImage = ImageCropActivity.this.getCroppedImage();
                if (ImageCropActivity.this.cropImage == null) {
                    return false;
                }
                if (ScannerConstants.saveStorage) {
                    ImageCropActivity.this.saveToInternalStorage(ImageCropActivity.this.cropImage);
                }
                return false;
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(result -> {
                ImageCropActivity.this.hideProgressBar();
                if (ImageCropActivity.this.cropImage != null) {
                    ScannerConstants.selectedImageBitmap = ImageCropActivity.this.cropImage;
                    ImageCropActivity.this.setResult(-1);
                    ImageCropActivity.this.finish();
                }
            }));
        }
    };
    private View.OnClickListener btnRebase = v -> {
        this.cropImage = ScannerConstants.selectedImageBitmap.copy(ScannerConstants.selectedImageBitmap.getConfig(), true);
        this.isInverted = false;
        this.startCropping();
    };
    private View.OnClickListener btnCloseClick = v -> this.finish();
    private View.OnClickListener btnInvertColor = new View.OnClickListener(){

        public void onClick(View v) {
            ImageCropActivity.this.showProgressBar();
            ImageCropActivity.this.disposable.add(Observable.fromCallable(() -> {
                ImageCropActivity.this.invertColor();
                return false;
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(result -> {
                ImageCropActivity.this.hideProgressBar();
                Bitmap scaledBitmap = ImageCropActivity.this.scaledBitmap(ImageCropActivity.this.cropImage, ImageCropActivity.this.holderImageCrop.getWidth(), ImageCropActivity.this.holderImageCrop.getHeight());
                ImageCropActivity.this.imageView.setImageBitmap(scaledBitmap);
            }));
        }
    };
    private View.OnClickListener onRotateClick = new View.OnClickListener(){

        public void onClick(View v) {
            ImageCropActivity.this.showProgressBar();
            ImageCropActivity.this.disposable.add(Observable.fromCallable(() -> {
                if (ImageCropActivity.this.isInverted) {
                    ImageCropActivity.this.invertColor();
                }
                ImageCropActivity.this.cropImage = ImageCropActivity.this.rotateBitmap(ImageCropActivity.this.cropImage, 90.0f);
                return false;
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(result -> {
                ImageCropActivity.this.hideProgressBar();
                ImageCropActivity.this.startCropping();
            }));
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_crop);
        this.cropImage = ScannerConstants.selectedImageBitmap;
        this.isInverted = false;
        if (ScannerConstants.selectedImageBitmap != null) {
            this.initView();
        } else {
            Toast.makeText((Context)this, (CharSequence)ScannerConstants.imageError, (int)1).show();
            this.finish();
        }
    }

    @Override
    protected FrameLayout getHolderImageCrop() {
        return this.holderImageCrop;
    }

    @Override
    protected ImageView getImageView() {
        return this.imageView;
    }

    @Override
    protected PolygonView getPolygonView() {
        return this.polygonView;
    }

    @Override
    protected void showProgressBar() {
        RelativeLayout rlContainer = (RelativeLayout)this.findViewById(R.id.rlContainer);
        this.setViewInteract((View)rlContainer, false);
        this.progressBar.setVisibility(0);
    }

    @Override
    protected void hideProgressBar() {
        RelativeLayout rlContainer = (RelativeLayout)this.findViewById(R.id.rlContainer);
        this.setViewInteract((View)rlContainer, true);
        this.progressBar.setVisibility(8);
    }

    @Override
    protected void showError(CropperErrorType errorType) {
        switch (errorType) {
            case CROP_ERROR: {
                Toast.makeText((Context)this, (CharSequence)ScannerConstants.cropError, (int)1).show();
            }
        }
    }

    @Override
    protected Bitmap getBitmapImage() {
        return this.cropImage;
    }

    private void setViewInteract(View view, boolean canDo) {
        view.setEnabled(canDo);
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.setViewInteract(((ViewGroup)view).getChildAt(i), canDo);
            }
        }
    }

    private void initView() {
        Button btnImageCrop = (Button)this.findViewById(R.id.btnImageCrop);
        Button btnClose = (Button)this.findViewById(R.id.btnClose);
        this.holderImageCrop = (FrameLayout)this.findViewById(R.id.holderImageCrop);
        this.imageView = (ImageView)this.findViewById(R.id.imageView);
        ImageView ivRotate = (ImageView)this.findViewById(R.id.ivRotate);
        ImageView ivInvert = (ImageView)this.findViewById(R.id.ivInvert);
        ImageView ivRebase = (ImageView)this.findViewById(R.id.ivRebase);
        btnImageCrop.setText((CharSequence)ScannerConstants.cropText);
        btnClose.setText((CharSequence)ScannerConstants.backText);
        this.polygonView = (PolygonView)this.findViewById(R.id.polygonView);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        if (this.progressBar.getIndeterminateDrawable() != null && ScannerConstants.progressColor != null) {
            this.progressBar.getIndeterminateDrawable().setColorFilter(Color.parseColor((String)ScannerConstants.progressColor), PorterDuff.Mode.MULTIPLY);
        } else if (this.progressBar.getProgressDrawable() != null && ScannerConstants.progressColor != null) {
            this.progressBar.getProgressDrawable().setColorFilter(Color.parseColor((String)ScannerConstants.progressColor), PorterDuff.Mode.MULTIPLY);
        }
        btnImageCrop.setBackgroundColor(Color.parseColor((String)ScannerConstants.cropColor));
        btnClose.setBackgroundColor(Color.parseColor((String)ScannerConstants.backColor));
        btnImageCrop.setOnClickListener(this.btnImageEnhanceClick);
        btnClose.setOnClickListener(this.btnCloseClick);
        ivRotate.setOnClickListener(this.onRotateClick);
        ivInvert.setOnClickListener(this.btnInvertColor);
        ivRebase.setOnClickListener(this.btnRebase);
        this.startCropping();
    }

    private void invertColor() {
        if (!this.isInverted) {
            Bitmap bmpMonochrome = Bitmap.createBitmap((int)this.cropImage.getWidth(), (int)this.cropImage.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bmpMonochrome);
            ColorMatrix ma = new ColorMatrix();
            ma.setSaturation(0.0f);
            Paint paint = new Paint();
            paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(ma));
            canvas.drawBitmap(this.cropImage, 0.0f, 0.0f, paint);
            this.cropImage = bmpMonochrome.copy(bmpMonochrome.getConfig(), true);
        } else {
            this.cropImage = this.cropImage.copy(this.cropImage.getConfig(), true);
        }
        this.isInverted = !this.isInverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveToInternalStorage(Bitmap bitmapImage) {
        File directory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        String imageFileName = "cropped_" + timeStamp + ".png";
        File mypath = new File(directory, imageFileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(mypath);
            bitmapImage.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return directory.getAbsolutePath();
    }
}

