/*
 * Decompiled with CFR 0.152.
 */
package top.maybesix.xhlibrary.util;

public class HexStringUtils {
    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static int hexString2Int(String hexString) {
        return Integer.parseInt(hexString, 16);
    }

    public static byte hexString2Byte(String hexString) {
        return (byte)Integer.parseInt(hexString, 16);
    }

    public static String byte2HexString(Byte hexByte) {
        return String.format("%02x", hexByte).toUpperCase();
    }

    public static String byteArray2HexString(byte[] hexbytearray) {
        return HexStringUtils.byteArray2HexString(hexbytearray, 0, hexbytearray.length);
    }

    public static String byteArray2HexString(byte[] hexbytearray, int beginIndex, int endIndex) {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            strBuilder.append(HexStringUtils.byte2HexString(hexbytearray[i]));
        }
        return strBuilder.toString();
    }

    public static byte[] hexString2ByteArray(String hexString) {
        byte[] result;
        int len = hexString.length();
        if (HexStringUtils.isOdd(len)) {
            result = new byte[++len / 2];
            hexString = "0" + hexString;
        } else {
            result = new byte[len / 2];
        }
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            result[j] = HexStringUtils.hexString2Byte(hexString.substring(i, i + 2));
            ++j;
        }
        return result;
    }
}

