/*
 * Decompiled with CFR 0.152.
 */
package top.maybesix.xhlibrary.util;

public class CrcUtils {
    private static final String TAG = "CrcUtils";

    public static boolean isPassCRC(byte[] bytes) {
        int length = bytes.length;
        byte[] head = new byte[2];
        byte[] end = new byte[1];
        byte[] body = new byte[length - 5];
        byte valueHead1 = 90;
        byte valueHead2 = -91;
        byte valueEnd = -106;
        byte crcLow = bytes[length - 2];
        byte crcHigh = bytes[length - 3];
        System.arraycopy(bytes, 0, head, 0, 2);
        System.arraycopy(bytes, length - 1, end, 0, 1);
        System.arraycopy(bytes, 2, body, 0, length - 5);
        byte[] bodyAndCrcOne = new byte[body.length + 2];
        System.arraycopy(body, 0, bodyAndCrcOne, 0, body.length);
        bodyAndCrcOne[body.length] = crcHigh;
        bodyAndCrcOne[body.length + 1] = crcLow;
        byte[] bodyAndCrcTwo = new byte[body.length + 2];
        System.arraycopy(body, 0, bodyAndCrcTwo, 0, body.length);
        bodyAndCrcOne[body.length] = crcLow;
        bodyAndCrcOne[body.length + 1] = crcHigh;
        if (head[0] == valueHead1 && head[1] == valueHead2) {
            if (end[0] == valueEnd) {
                return CrcUtils.getCrc(bodyAndCrcOne) == 0 || CrcUtils.getCrc(bodyAndCrcTwo) == 0;
            }
            System.out.println("end\u6821\u9a8c\u5931\u8d25 ");
        } else {
            System.out.println("head\u6821\u9a8c\u5931\u8d25 ");
        }
        return false;
    }

    public static boolean isPassCRC(String hexString) {
        try {
            hexString = hexString.replace(" ", "");
            int length = hexString.length();
            String head = hexString.substring(0, 4);
            String end = hexString.substring(length - 2, length);
            String body = hexString.substring(4, length - 6);
            String crcHigh = hexString.substring(length - 6, length - 4);
            String crcLow = hexString.substring(length - 4, length - 2);
            String bodyAndCrcOne = body + crcHigh + crcLow;
            String bodyAndCrcTwo = body + crcLow + crcHigh;
            String valueHead = "5AA5";
            String valueEnd = "96";
            if (head.equals(valueHead)) {
                if (end.equals(valueEnd)) {
                    return CrcUtils.getCrc(bodyAndCrcOne) == 0 || CrcUtils.getCrc(bodyAndCrcTwo) == 0;
                }
                System.out.println("end\u6821\u9a8c\u5931\u8d25 ");
            } else {
                System.out.println("head\u6821\u9a8c\u5931\u8d25 ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static String getCrcString(String hexString) {
        return CrcUtils.toHexString(CrcUtils.getCrc(hexString));
    }

    public static String getCrcString(byte[] bytes) {
        return CrcUtils.toHexString(CrcUtils.getCrc(bytes));
    }

    private static String toHexString(int crc) {
        int fixedLength;
        String result = Integer.toHexString(crc).toUpperCase();
        int length = result.length();
        if (length != (fixedLength = 4)) {
            for (int i = fixedLength - length; i > 0; --i) {
                result = "0" + result;
            }
        }
        return result;
    }

    private static int getCrc(byte[] bytes) {
        int crc = 65535;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return crc &= 0xFFFF;
    }

    private static int getCrc(String hexString) {
        return CrcUtils.getCrc(CrcUtils.hexToByte(hexString));
    }

    private static byte[] hexToByte(String hex) {
        hex = hex.replace(" ", "");
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }
}

