/*
 * Decompiled with CFR 0.152.
 */
package top.maybesix.xhlibrary.serialport;

import android.util.Log;
import android_serialport_api.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import top.maybesix.xhlibrary.serialport.ComPortData;
import top.maybesix.xhlibrary.util.HexStringUtils;

public class SerialPortHelper {
    private static final String TAG = "SerialPortHelper";
    private OnSerialPortReceivedListener onSerialPortReceivedListener;
    private SerialPort serialPort;
    private OutputStream outputStream;
    private InputStream inputStream;
    private ReadThread readThread;
    private SendThread sendThread;
    private String port;
    private int baudRate;
    private boolean openState = false;
    private byte[] loopData = new byte[]{48};
    private int delay = 500;

    public SerialPortHelper() {
        this("/dev/ttyHSL1", 9600);
    }

    public SerialPortHelper(String port) {
        this(port, 9600);
    }

    public SerialPortHelper(String port, int baudRate) {
        this.port = port;
        this.baudRate = baudRate;
        this.onSerialPortReceivedListener = new OnSerialPortReceivedListener(){

            @Override
            public void onSerialPortDataReceived(ComPortData comPortData) {
                Log.d((String)SerialPortHelper.TAG, (String)"onSerialPortDataReceived: \u672a\u8bbe\u7f6e\u76d1\u542c\uff0c\u91c7\u7528\u9ed8\u8ba4Listener");
            }
        };
    }

    public SerialPortHelper(String port, String sBaudRate) {
        this(port, Integer.parseInt(sBaudRate));
    }

    public void setSerialPortReceivedListener(OnSerialPortReceivedListener onSerialPortReceivedListener) {
        this.onSerialPortReceivedListener = onSerialPortReceivedListener;
    }

    public boolean isOpen() {
        return this.openState;
    }

    public void open() {
        try {
            this.baseOpen();
            Log.i((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u6210\u529f\uff01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u5931\u8d25:\u6ca1\u6709\u4e32\u53e3\u8bfb/\u5199\u6743\u9650!");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u5931\u8d25:\u672a\u77e5\u9519\u8bef!");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u5931\u8d25:\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"openComPort: \u5176\u4ed6\u9519\u8bef");
            e.printStackTrace();
        }
    }

    private void baseOpen() throws SecurityException, IOException, InvalidParameterException {
        this.serialPort = new SerialPort(new File(this.port), this.baudRate, 0);
        this.outputStream = this.serialPort.getOutputStream();
        this.inputStream = this.serialPort.getInputStream();
        this.readThread = new ReadThread();
        this.readThread.start();
        this.sendThread = new SendThread();
        this.sendThread.setSuspendFlag();
        this.sendThread.start();
        this.openState = true;
    }

    public void close() {
        if (this.readThread != null) {
            this.readThread.interrupt();
        }
        if (this.serialPort != null) {
            this.serialPort.close();
            this.serialPort = null;
        }
        this.openState = false;
    }

    private void send(byte[] bOutArray) {
        try {
            if (this.openState) {
                this.outputStream.write(bOutArray);
            } else {
                this.open();
                this.outputStream.write(bOutArray);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendHex(String hexString) {
        byte[] bOutArray = HexStringUtils.hexString2ByteArray(hexString);
        this.send(bOutArray);
    }

    public void sendTxtString(String txtString) {
        byte[] bOutArray = txtString.getBytes();
        this.send(bOutArray);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public boolean setBaudRate(int iBaud) {
        if (this.openState) {
            return false;
        }
        this.baudRate = iBaud;
        return true;
    }

    public boolean setBaudRate(String sBaud) {
        int iBaud = Integer.parseInt(sBaud);
        return this.setBaudRate(iBaud);
    }

    public String getPort() {
        return this.port;
    }

    public boolean setPort(String sPort) {
        if (this.openState) {
            return false;
        }
        this.port = sPort;
        return true;
    }

    public byte[] getLoopData() {
        return this.loopData;
    }

    public void setLoopData(byte[] loopData) {
        this.loopData = loopData;
    }

    public void setLoopData(String str, boolean isHexString) {
        this.loopData = isHexString ? str.getBytes() : HexStringUtils.hexString2ByteArray(str);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void startSend() {
        if (this.sendThread != null) {
            this.sendThread.setResume();
        }
    }

    public void stopSend() {
        if (this.sendThread != null) {
            this.sendThread.setSuspendFlag();
        }
    }

    public static interface OnSerialPortReceivedListener {
        public void onSerialPortDataReceived(ComPortData var1);
    }

    private class SendThread
    extends Thread {
        boolean runFlag = true;

        private SendThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                SendThread sendThread = this;
                synchronized (sendThread) {
                    while (this.runFlag) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                SerialPortHelper.this.send(SerialPortHelper.this.getLoopData());
                try {
                    Thread.sleep(SerialPortHelper.this.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void setSuspendFlag() {
            this.runFlag = true;
        }

        private synchronized void setResume() {
            this.runFlag = false;
            this.notify();
        }
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    if (SerialPortHelper.this.inputStream == null) {
                        return;
                    }
                    byte[] buffer = new byte[512];
                    int size = SerialPortHelper.this.inputStream.read(buffer);
                    if (size <= 0) continue;
                    ComPortData comPortData = new ComPortData(SerialPortHelper.this.port, buffer, size);
                    SerialPortHelper.this.onSerialPortReceivedListener.onSerialPortDataReceived(comPortData);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }
}

