/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.sun;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.GccCompatibleCCompiler;
import com.github.maven_nar.cpptasks.sun.ForteCCLinker;
import java.io.File;
import java.util.Vector;

public final class ForteCCCompiler
extends GccCompatibleCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cxx", ".cpp", ".c++", ".i", ".s"};
    private static final ForteCCCompiler instance = new ForteCCCompiler("CC", sourceExtensions, headerExtensions);
    private String identifier;
    private File[] includePath;

    public static ForteCCCompiler getInstance() {
        return instance;
    }

    private ForteCCCompiler(String command, String[] sourceExtensions, String[] headerExtensions) {
        super(command, "-V", sourceExtensions, headerExtensions, false, null, false, null);
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (optimization != null && optimization.isSpeed()) {
            args.addElement("-xO2");
        }
        if (rtti != null) {
            if (rtti.booleanValue()) {
                args.addElement("-features=rtti");
            } else {
                args.addElement("-features=no%rtti");
            }
        }
        if (multithreaded) {
            args.addElement("-mt");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-KPIC");
        }
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                args.addElement("+w");
                break;
            }
            case 4: {
                args.addElement("+w2");
                break;
            }
            case 5: {
                args.addElement("+w2");
                args.addElement("-xwe");
            }
        }
    }

    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            File compilerIncludeDir;
            File ccLoc = CUtil.getExecutableLocation("CC");
            if (ccLoc != null && (compilerIncludeDir = new File(new File(ccLoc, "../include").getAbsolutePath())).exists()) {
                this.includePath = new File[2];
                this.includePath[0] = compilerIncludeDir;
            }
            if (this.includePath == null) {
                this.includePath = new File[1];
            }
            this.includePath[this.includePath.length - 1] = new File("/usr/include");
        }
        return this.includePath;
    }

    public Linker getLinker(LinkType linkType) {
        return ForteCCLinker.getInstance().getLinker(linkType);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }
}

