/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.SoftwareApplication;
import com.google.schemaorg.core.SoftwareSourceCode;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class SoftwareSourceCodeImpl
extends CreativeWorkImpl
implements SoftwareSourceCode {
    private static final ImmutableSet<String> PROPERTY_SET = SoftwareSourceCodeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/codeRepository");
        builder.add((Object)"http://schema.org/codeSampleType");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/programmingLanguage");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/runtime");
        builder.add((Object)"http://schema.org/runtimePlatform");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/sampleType");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/targetProduct");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public SoftwareSourceCodeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/SoftwareSourceCode";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodeRepositoryList() {
        return this.getProperty("http://schema.org/codeRepository");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodeSampleTypeList() {
        return this.getProperty("http://schema.org/codeSampleType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getProgrammingLanguageList() {
        return this.getProperty("http://schema.org/programmingLanguage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRuntimeList() {
        return this.getProperty("http://schema.org/runtime");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRuntimePlatformList() {
        return this.getProperty("http://schema.org/runtimePlatform");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSampleTypeList() {
        return this.getProperty("http://schema.org/sampleType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetProductList() {
        return this.getProperty("http://schema.org/targetProduct");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<SoftwareSourceCode.Builder>
    implements SoftwareSourceCode.Builder {
        BuilderImpl() {
        }

        @Override
        public SoftwareSourceCode.Builder addAbout(Thing value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAbout(Thing.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAbout(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityAPI(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityAPI(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityControl(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityControl(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityFeature(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityFeature(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityHazard(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAccessibilityHazard(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAccountablePerson(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAccountablePerson(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAccountablePerson(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAdditionalType(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAdditionalType(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAggregateRating(AggregateRating value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAggregateRating(AggregateRating.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAggregateRating(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAlternateName(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAlternateName(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAlternativeHeadline(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAlternativeHeadline(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAssociatedMedia(MediaObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAssociatedMedia(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAudience(Audience value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAudience(Audience.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAudience(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAudio(AudioObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAudio(AudioObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAudio(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAuthor(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAuthor(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAuthor(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAuthor(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addAuthor(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAward(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAward(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addAwards(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public SoftwareSourceCode.Builder addAwards(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCharacter(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCharacter(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCharacter(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCitation(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCitation(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCitation(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCitation(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCodeRepository(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/codeRepository", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCodeRepository(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/codeRepository", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCodeSampleType(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/codeSampleType", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCodeSampleType(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/codeSampleType", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addComment(Comment value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public SoftwareSourceCode.Builder addComment(Comment.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addComment(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCommentCount(Integer value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCommentCount(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addContentLocation(Place value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public SoftwareSourceCode.Builder addContentLocation(Place.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addContentLocation(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addContentRating(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public SoftwareSourceCode.Builder addContentRating(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addContributor(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public SoftwareSourceCode.Builder addContributor(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addContributor(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public SoftwareSourceCode.Builder addContributor(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addContributor(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightHolder(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightHolder(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightHolder(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightHolder(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightHolder(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightYear(Number value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCopyrightYear(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addCreator(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCreator(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCreator(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public SoftwareSourceCode.Builder addCreator(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addCreator(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDateCreated(Date value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDateCreated(DateTime value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDateCreated(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDateModified(Date value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDateModified(DateTime value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDateModified(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDatePublished(Date value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDatePublished(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDescription(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDescription(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDiscussionUrl(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDiscussionUrl(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addEditor(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public SoftwareSourceCode.Builder addEditor(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addEditor(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addEducationalAlignment(AlignmentObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public SoftwareSourceCode.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addEducationalAlignment(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addEducationalUse(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public SoftwareSourceCode.Builder addEducationalUse(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addEncoding(MediaObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public SoftwareSourceCode.Builder addEncoding(MediaObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addEncoding(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addEncodings(MediaObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public SoftwareSourceCode.Builder addEncodings(MediaObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addEncodings(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addExampleOfWork(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public SoftwareSourceCode.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addExampleOfWork(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addFileFormat(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public SoftwareSourceCode.Builder addFileFormat(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addGenre(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public SoftwareSourceCode.Builder addGenre(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public SoftwareSourceCode.Builder addGenre(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addHasPart(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public SoftwareSourceCode.Builder addHasPart(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addHasPart(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addHeadline(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public SoftwareSourceCode.Builder addHeadline(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addImage(ImageObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public SoftwareSourceCode.Builder addImage(ImageObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addImage(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public SoftwareSourceCode.Builder addImage(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addInLanguage(Language value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public SoftwareSourceCode.Builder addInLanguage(Language.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addInLanguage(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public SoftwareSourceCode.Builder addInLanguage(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addInteractionStatistic(InteractionCounter value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public SoftwareSourceCode.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addInteractionStatistic(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addInteractivityType(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public SoftwareSourceCode.Builder addInteractivityType(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addIsBasedOnUrl(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public SoftwareSourceCode.Builder addIsBasedOnUrl(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addIsFamilyFriendly(Boolean value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public SoftwareSourceCode.Builder addIsFamilyFriendly(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addIsPartOf(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public SoftwareSourceCode.Builder addIsPartOf(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addIsPartOf(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addKeywords(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public SoftwareSourceCode.Builder addKeywords(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addLearningResourceType(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public SoftwareSourceCode.Builder addLearningResourceType(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addLicense(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public SoftwareSourceCode.Builder addLicense(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addLicense(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public SoftwareSourceCode.Builder addLicense(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addLocationCreated(Place value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public SoftwareSourceCode.Builder addLocationCreated(Place.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addLocationCreated(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntity(Thing value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntity(Thing.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntity(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntityOfPage(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntityOfPage(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public SoftwareSourceCode.Builder addMainEntityOfPage(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addMentions(Thing value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public SoftwareSourceCode.Builder addMentions(Thing.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addMentions(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addName(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public SoftwareSourceCode.Builder addName(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addOffers(Offer value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public SoftwareSourceCode.Builder addOffers(Offer.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addOffers(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPosition(Integer value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPosition(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPosition(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPotentialAction(Action value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPotentialAction(Action.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addPotentialAction(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addProducer(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public SoftwareSourceCode.Builder addProducer(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addProducer(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public SoftwareSourceCode.Builder addProducer(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addProducer(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addProgrammingLanguage(Language value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/programmingLanguage", value);
        }

        @Override
        public SoftwareSourceCode.Builder addProgrammingLanguage(Language.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/programmingLanguage", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addProgrammingLanguage(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/programmingLanguage", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addProvider(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public SoftwareSourceCode.Builder addProvider(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addProvider(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public SoftwareSourceCode.Builder addProvider(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addProvider(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPublication(PublicationEvent value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPublication(PublicationEvent.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addPublication(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPublisher(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPublisher(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addPublisher(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPublisher(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addPublisher(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPublishingPrinciples(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPublishingPrinciples(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addRecordedAt(Event value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public SoftwareSourceCode.Builder addRecordedAt(Event.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addRecordedAt(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addReleasedEvent(PublicationEvent value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public SoftwareSourceCode.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addReleasedEvent(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addReview(Review value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public SoftwareSourceCode.Builder addReview(Review.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addReview(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addReviews(Review value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public SoftwareSourceCode.Builder addReviews(Review.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addReviews(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addRuntime(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/runtime", value);
        }

        @Override
        public SoftwareSourceCode.Builder addRuntime(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/runtime", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addRuntimePlatform(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/runtimePlatform", value);
        }

        @Override
        public SoftwareSourceCode.Builder addRuntimePlatform(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/runtimePlatform", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addSameAs(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public SoftwareSourceCode.Builder addSameAs(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addSampleType(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sampleType", value);
        }

        @Override
        public SoftwareSourceCode.Builder addSampleType(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sampleType", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addSchemaVersion(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public SoftwareSourceCode.Builder addSchemaVersion(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public SoftwareSourceCode.Builder addSchemaVersion(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addSourceOrganization(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public SoftwareSourceCode.Builder addSourceOrganization(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addSourceOrganization(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addTargetProduct(SoftwareApplication value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/targetProduct", value);
        }

        @Override
        public SoftwareSourceCode.Builder addTargetProduct(SoftwareApplication.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/targetProduct", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addTargetProduct(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/targetProduct", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addText(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public SoftwareSourceCode.Builder addText(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addThumbnailUrl(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public SoftwareSourceCode.Builder addThumbnailUrl(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addTimeRequired(Duration value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public SoftwareSourceCode.Builder addTimeRequired(Duration.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addTimeRequired(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addTranslator(Organization value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public SoftwareSourceCode.Builder addTranslator(Organization.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addTranslator(Person value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public SoftwareSourceCode.Builder addTranslator(Person.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addTranslator(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addTypicalAgeRange(Text value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public SoftwareSourceCode.Builder addTypicalAgeRange(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addUrl(URL value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public SoftwareSourceCode.Builder addUrl(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addVersion(Number value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public SoftwareSourceCode.Builder addVersion(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addVideo(VideoObject value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public SoftwareSourceCode.Builder addVideo(VideoObject.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addVideo(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addWorkExample(CreativeWork value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public SoftwareSourceCode.Builder addWorkExample(CreativeWork.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addWorkExample(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addDetailedDescription(Article value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public SoftwareSourceCode.Builder addDetailedDescription(Article.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addDetailedDescription(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public SoftwareSourceCode.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public SoftwareSourceCode.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public SoftwareSourceCode.Builder addPopularityScore(String value) {
            return (SoftwareSourceCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public SoftwareSourceCode build() {
            return new SoftwareSourceCodeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

