/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.ContactPointImpl;
import com.google.schemaorg.core.ContactPointOption;
import com.google.schemaorg.core.Country;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.GeoShape;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.OpeningHoursSpecification;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PostalAddress;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PostalAddressImpl
extends ContactPointImpl
implements PostalAddress {
    private static final ImmutableSet<String> PROPERTY_SET = PostalAddressImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/addressCountry");
        builder.add((Object)"http://schema.org/addressLocality");
        builder.add((Object)"http://schema.org/addressRegion");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/areaServed");
        builder.add((Object)"http://schema.org/availableLanguage");
        builder.add((Object)"http://schema.org/contactOption");
        builder.add((Object)"http://schema.org/contactType");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/email");
        builder.add((Object)"http://schema.org/faxNumber");
        builder.add((Object)"http://schema.org/hoursAvailable");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/postalCode");
        builder.add((Object)"http://schema.org/postOfficeBoxNumber");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/productSupported");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/serviceArea");
        builder.add((Object)"http://schema.org/streetAddress");
        builder.add((Object)"http://schema.org/telephone");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PostalAddressImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PostalAddress";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressCountryList() {
        return this.getProperty("http://schema.org/addressCountry");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressLocalityList() {
        return this.getProperty("http://schema.org/addressLocality");
    }

    @Override
    public ImmutableList<SchemaOrgType> getAddressRegionList() {
        return this.getProperty("http://schema.org/addressRegion");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPostalCodeList() {
        return this.getProperty("http://schema.org/postalCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPostOfficeBoxNumberList() {
        return this.getProperty("http://schema.org/postOfficeBoxNumber");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStreetAddressList() {
        return this.getProperty("http://schema.org/streetAddress");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PostalAddress.Builder>
    implements PostalAddress.Builder {
        BuilderImpl() {
        }

        @Override
        public PostalAddress.Builder addAdditionalType(URL value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PostalAddress.Builder addAdditionalType(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAddressCountry(Country value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public PostalAddress.Builder addAddressCountry(Country.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressCountry", value.build());
        }

        @Override
        public PostalAddress.Builder addAddressCountry(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressCountry", value);
        }

        @Override
        public PostalAddress.Builder addAddressCountry(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressCountry", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAddressLocality(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressLocality", value);
        }

        @Override
        public PostalAddress.Builder addAddressLocality(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressLocality", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAddressRegion(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressRegion", value);
        }

        @Override
        public PostalAddress.Builder addAddressRegion(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/addressRegion", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAlternateName(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PostalAddress.Builder addAlternateName(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAreaServed(AdministrativeArea value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public PostalAddress.Builder addAreaServed(AdministrativeArea.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public PostalAddress.Builder addAreaServed(GeoShape value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public PostalAddress.Builder addAreaServed(GeoShape.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public PostalAddress.Builder addAreaServed(Place value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public PostalAddress.Builder addAreaServed(Place.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value.build());
        }

        @Override
        public PostalAddress.Builder addAreaServed(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", value);
        }

        @Override
        public PostalAddress.Builder addAreaServed(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/areaServed", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addAvailableLanguage(Language value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/availableLanguage", value);
        }

        @Override
        public PostalAddress.Builder addAvailableLanguage(Language.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/availableLanguage", value.build());
        }

        @Override
        public PostalAddress.Builder addAvailableLanguage(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/availableLanguage", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addContactOption(ContactPointOption value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/contactOption", value);
        }

        @Override
        public PostalAddress.Builder addContactOption(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/contactOption", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addContactType(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/contactType", value);
        }

        @Override
        public PostalAddress.Builder addContactType(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/contactType", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addDescription(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PostalAddress.Builder addDescription(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addEmail(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/email", value);
        }

        @Override
        public PostalAddress.Builder addEmail(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/email", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addFaxNumber(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/faxNumber", value);
        }

        @Override
        public PostalAddress.Builder addFaxNumber(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/faxNumber", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addHoursAvailable(OpeningHoursSpecification value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/hoursAvailable", value);
        }

        @Override
        public PostalAddress.Builder addHoursAvailable(OpeningHoursSpecification.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/hoursAvailable", value.build());
        }

        @Override
        public PostalAddress.Builder addHoursAvailable(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/hoursAvailable", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addImage(ImageObject value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PostalAddress.Builder addImage(ImageObject.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PostalAddress.Builder addImage(URL value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PostalAddress.Builder addImage(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addMainEntityOfPage(CreativeWork value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PostalAddress.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PostalAddress.Builder addMainEntityOfPage(URL value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PostalAddress.Builder addMainEntityOfPage(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addName(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PostalAddress.Builder addName(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addPostalCode(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/postalCode", value);
        }

        @Override
        public PostalAddress.Builder addPostalCode(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/postalCode", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addPostOfficeBoxNumber(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/postOfficeBoxNumber", value);
        }

        @Override
        public PostalAddress.Builder addPostOfficeBoxNumber(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/postOfficeBoxNumber", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addPotentialAction(Action value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PostalAddress.Builder addPotentialAction(Action.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PostalAddress.Builder addPotentialAction(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addProductSupported(Product value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/productSupported", value);
        }

        @Override
        public PostalAddress.Builder addProductSupported(Product.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/productSupported", value.build());
        }

        @Override
        public PostalAddress.Builder addProductSupported(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/productSupported", value);
        }

        @Override
        public PostalAddress.Builder addProductSupported(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/productSupported", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addSameAs(URL value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PostalAddress.Builder addSameAs(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addServiceArea(AdministrativeArea value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public PostalAddress.Builder addServiceArea(AdministrativeArea.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public PostalAddress.Builder addServiceArea(GeoShape value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public PostalAddress.Builder addServiceArea(GeoShape.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public PostalAddress.Builder addServiceArea(Place value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value);
        }

        @Override
        public PostalAddress.Builder addServiceArea(Place.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", value.build());
        }

        @Override
        public PostalAddress.Builder addServiceArea(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/serviceArea", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addStreetAddress(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/streetAddress", value);
        }

        @Override
        public PostalAddress.Builder addStreetAddress(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/streetAddress", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addTelephone(Text value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/telephone", value);
        }

        @Override
        public PostalAddress.Builder addTelephone(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/telephone", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addUrl(URL value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PostalAddress.Builder addUrl(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addDetailedDescription(Article value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PostalAddress.Builder addDetailedDescription(Article.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PostalAddress.Builder addDetailedDescription(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PostalAddress.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PostalAddress.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PostalAddress.Builder addPopularityScore(String value) {
            return (PostalAddress.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PostalAddress build() {
            return new PostalAddressImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

