/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.ArticleImpl;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.NewsArticle;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class NewsArticleImpl
extends ArticleImpl
implements NewsArticle {
    private static final ImmutableSet<String> PROPERTY_SET = NewsArticleImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/articleBody");
        builder.add((Object)"http://schema.org/articleSection");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateline");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/pageEnd");
        builder.add((Object)"http://schema.org/pageStart");
        builder.add((Object)"http://schema.org/pagination");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/printColumn");
        builder.add((Object)"http://schema.org/printEdition");
        builder.add((Object)"http://schema.org/printPage");
        builder.add((Object)"http://schema.org/printSection");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/wordCount");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public NewsArticleImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/NewsArticle";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDatelineList() {
        return this.getProperty("http://schema.org/dateline");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrintColumnList() {
        return this.getProperty("http://schema.org/printColumn");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrintEditionList() {
        return this.getProperty("http://schema.org/printEdition");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrintPageList() {
        return this.getProperty("http://schema.org/printPage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrintSectionList() {
        return this.getProperty("http://schema.org/printSection");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<NewsArticle.Builder>
    implements NewsArticle.Builder {
        BuilderImpl() {
        }

        @Override
        public NewsArticle.Builder addAbout(Thing value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public NewsArticle.Builder addAbout(Thing.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public NewsArticle.Builder addAbout(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAccessibilityAPI(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public NewsArticle.Builder addAccessibilityAPI(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAccessibilityControl(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public NewsArticle.Builder addAccessibilityControl(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAccessibilityFeature(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public NewsArticle.Builder addAccessibilityFeature(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAccessibilityHazard(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public NewsArticle.Builder addAccessibilityHazard(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAccountablePerson(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public NewsArticle.Builder addAccountablePerson(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public NewsArticle.Builder addAccountablePerson(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAdditionalType(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public NewsArticle.Builder addAdditionalType(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAggregateRating(AggregateRating value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public NewsArticle.Builder addAggregateRating(AggregateRating.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public NewsArticle.Builder addAggregateRating(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAlternateName(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public NewsArticle.Builder addAlternateName(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAlternativeHeadline(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public NewsArticle.Builder addAlternativeHeadline(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addArticleBody(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/articleBody", value);
        }

        @Override
        public NewsArticle.Builder addArticleBody(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/articleBody", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addArticleSection(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/articleSection", value);
        }

        @Override
        public NewsArticle.Builder addArticleSection(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/articleSection", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAssociatedMedia(MediaObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public NewsArticle.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public NewsArticle.Builder addAssociatedMedia(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAudience(Audience value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public NewsArticle.Builder addAudience(Audience.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public NewsArticle.Builder addAudience(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAudio(AudioObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public NewsArticle.Builder addAudio(AudioObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public NewsArticle.Builder addAudio(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAuthor(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public NewsArticle.Builder addAuthor(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public NewsArticle.Builder addAuthor(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public NewsArticle.Builder addAuthor(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public NewsArticle.Builder addAuthor(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAward(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public NewsArticle.Builder addAward(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addAwards(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public NewsArticle.Builder addAwards(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCharacter(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public NewsArticle.Builder addCharacter(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public NewsArticle.Builder addCharacter(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCitation(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public NewsArticle.Builder addCitation(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public NewsArticle.Builder addCitation(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public NewsArticle.Builder addCitation(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addComment(Comment value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public NewsArticle.Builder addComment(Comment.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public NewsArticle.Builder addComment(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCommentCount(Integer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public NewsArticle.Builder addCommentCount(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addContentLocation(Place value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public NewsArticle.Builder addContentLocation(Place.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public NewsArticle.Builder addContentLocation(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addContentRating(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public NewsArticle.Builder addContentRating(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addContributor(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public NewsArticle.Builder addContributor(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public NewsArticle.Builder addContributor(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public NewsArticle.Builder addContributor(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public NewsArticle.Builder addContributor(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCopyrightHolder(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public NewsArticle.Builder addCopyrightHolder(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public NewsArticle.Builder addCopyrightHolder(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public NewsArticle.Builder addCopyrightHolder(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public NewsArticle.Builder addCopyrightHolder(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCopyrightYear(Number value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public NewsArticle.Builder addCopyrightYear(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addCreator(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public NewsArticle.Builder addCreator(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public NewsArticle.Builder addCreator(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public NewsArticle.Builder addCreator(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public NewsArticle.Builder addCreator(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDateCreated(Date value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public NewsArticle.Builder addDateCreated(DateTime value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public NewsArticle.Builder addDateCreated(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDateline(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateline", value);
        }

        @Override
        public NewsArticle.Builder addDateline(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateline", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDateModified(Date value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public NewsArticle.Builder addDateModified(DateTime value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public NewsArticle.Builder addDateModified(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDatePublished(Date value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public NewsArticle.Builder addDatePublished(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDescription(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public NewsArticle.Builder addDescription(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDiscussionUrl(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public NewsArticle.Builder addDiscussionUrl(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addEditor(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public NewsArticle.Builder addEditor(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public NewsArticle.Builder addEditor(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addEducationalAlignment(AlignmentObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public NewsArticle.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public NewsArticle.Builder addEducationalAlignment(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addEducationalUse(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public NewsArticle.Builder addEducationalUse(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addEncoding(MediaObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public NewsArticle.Builder addEncoding(MediaObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public NewsArticle.Builder addEncoding(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addEncodings(MediaObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public NewsArticle.Builder addEncodings(MediaObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public NewsArticle.Builder addEncodings(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addExampleOfWork(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public NewsArticle.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public NewsArticle.Builder addExampleOfWork(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addFileFormat(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public NewsArticle.Builder addFileFormat(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addGenre(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public NewsArticle.Builder addGenre(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public NewsArticle.Builder addGenre(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addHasPart(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public NewsArticle.Builder addHasPart(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public NewsArticle.Builder addHasPart(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addHeadline(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public NewsArticle.Builder addHeadline(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addImage(ImageObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public NewsArticle.Builder addImage(ImageObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public NewsArticle.Builder addImage(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public NewsArticle.Builder addImage(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addInLanguage(Language value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public NewsArticle.Builder addInLanguage(Language.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public NewsArticle.Builder addInLanguage(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public NewsArticle.Builder addInLanguage(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addInteractionStatistic(InteractionCounter value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public NewsArticle.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public NewsArticle.Builder addInteractionStatistic(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addInteractivityType(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public NewsArticle.Builder addInteractivityType(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addIsBasedOnUrl(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public NewsArticle.Builder addIsBasedOnUrl(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addIsFamilyFriendly(Boolean value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public NewsArticle.Builder addIsFamilyFriendly(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addIsPartOf(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public NewsArticle.Builder addIsPartOf(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public NewsArticle.Builder addIsPartOf(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addKeywords(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public NewsArticle.Builder addKeywords(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addLearningResourceType(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public NewsArticle.Builder addLearningResourceType(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addLicense(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public NewsArticle.Builder addLicense(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public NewsArticle.Builder addLicense(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public NewsArticle.Builder addLicense(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addLocationCreated(Place value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public NewsArticle.Builder addLocationCreated(Place.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public NewsArticle.Builder addLocationCreated(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addMainEntity(Thing value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public NewsArticle.Builder addMainEntity(Thing.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public NewsArticle.Builder addMainEntity(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addMainEntityOfPage(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public NewsArticle.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public NewsArticle.Builder addMainEntityOfPage(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public NewsArticle.Builder addMainEntityOfPage(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addMentions(Thing value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public NewsArticle.Builder addMentions(Thing.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public NewsArticle.Builder addMentions(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addName(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public NewsArticle.Builder addName(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addOffers(Offer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public NewsArticle.Builder addOffers(Offer.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public NewsArticle.Builder addOffers(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPageEnd(Integer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public NewsArticle.Builder addPageEnd(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageEnd", value);
        }

        @Override
        public NewsArticle.Builder addPageEnd(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageEnd", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPageStart(Integer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public NewsArticle.Builder addPageStart(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageStart", value);
        }

        @Override
        public NewsArticle.Builder addPageStart(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pageStart", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPagination(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pagination", value);
        }

        @Override
        public NewsArticle.Builder addPagination(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/pagination", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPosition(Integer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public NewsArticle.Builder addPosition(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public NewsArticle.Builder addPosition(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPotentialAction(Action value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public NewsArticle.Builder addPotentialAction(Action.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public NewsArticle.Builder addPotentialAction(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPrintColumn(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printColumn", value);
        }

        @Override
        public NewsArticle.Builder addPrintColumn(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printColumn", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPrintEdition(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printEdition", value);
        }

        @Override
        public NewsArticle.Builder addPrintEdition(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printEdition", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPrintPage(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printPage", value);
        }

        @Override
        public NewsArticle.Builder addPrintPage(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printPage", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPrintSection(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printSection", value);
        }

        @Override
        public NewsArticle.Builder addPrintSection(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/printSection", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addProducer(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public NewsArticle.Builder addProducer(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public NewsArticle.Builder addProducer(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public NewsArticle.Builder addProducer(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public NewsArticle.Builder addProducer(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addProvider(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public NewsArticle.Builder addProvider(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public NewsArticle.Builder addProvider(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public NewsArticle.Builder addProvider(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public NewsArticle.Builder addProvider(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPublication(PublicationEvent value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public NewsArticle.Builder addPublication(PublicationEvent.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public NewsArticle.Builder addPublication(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPublisher(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public NewsArticle.Builder addPublisher(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public NewsArticle.Builder addPublisher(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public NewsArticle.Builder addPublisher(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public NewsArticle.Builder addPublisher(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPublishingPrinciples(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public NewsArticle.Builder addPublishingPrinciples(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addRecordedAt(Event value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public NewsArticle.Builder addRecordedAt(Event.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public NewsArticle.Builder addRecordedAt(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addReleasedEvent(PublicationEvent value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public NewsArticle.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public NewsArticle.Builder addReleasedEvent(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addReview(Review value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public NewsArticle.Builder addReview(Review.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public NewsArticle.Builder addReview(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addReviews(Review value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public NewsArticle.Builder addReviews(Review.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public NewsArticle.Builder addReviews(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addSameAs(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public NewsArticle.Builder addSameAs(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addSchemaVersion(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public NewsArticle.Builder addSchemaVersion(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public NewsArticle.Builder addSchemaVersion(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addSourceOrganization(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public NewsArticle.Builder addSourceOrganization(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public NewsArticle.Builder addSourceOrganization(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addText(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public NewsArticle.Builder addText(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addThumbnailUrl(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public NewsArticle.Builder addThumbnailUrl(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addTimeRequired(Duration value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public NewsArticle.Builder addTimeRequired(Duration.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public NewsArticle.Builder addTimeRequired(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addTranslator(Organization value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public NewsArticle.Builder addTranslator(Organization.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public NewsArticle.Builder addTranslator(Person value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public NewsArticle.Builder addTranslator(Person.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public NewsArticle.Builder addTranslator(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addTypicalAgeRange(Text value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public NewsArticle.Builder addTypicalAgeRange(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addUrl(URL value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public NewsArticle.Builder addUrl(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addVersion(Number value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public NewsArticle.Builder addVersion(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addVideo(VideoObject value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public NewsArticle.Builder addVideo(VideoObject.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public NewsArticle.Builder addVideo(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addWordCount(Integer value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/wordCount", value);
        }

        @Override
        public NewsArticle.Builder addWordCount(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/wordCount", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addWorkExample(CreativeWork value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public NewsArticle.Builder addWorkExample(CreativeWork.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public NewsArticle.Builder addWorkExample(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addDetailedDescription(Article value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public NewsArticle.Builder addDetailedDescription(Article.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public NewsArticle.Builder addDetailedDescription(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public NewsArticle.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public NewsArticle.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public NewsArticle.Builder addPopularityScore(String value) {
            return (NewsArticle.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public NewsArticle build() {
            return new NewsArticleImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

