/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AdministrativeArea;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalStudyImpl;
import com.google.schemaorg.core.MedicalStudyStatus;
import com.google.schemaorg.core.MedicalTrial;
import com.google.schemaorg.core.MedicalTrialDesign;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalTrialImpl
extends MedicalStudyImpl
implements MedicalTrial {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalTrialImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/outcome");
        builder.add((Object)"http://schema.org/phase");
        builder.add((Object)"http://schema.org/population");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/sponsor");
        builder.add((Object)"http://schema.org/status");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/studyLocation");
        builder.add((Object)"http://schema.org/studySubject");
        builder.add((Object)"http://schema.org/trialDesign");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalTrialImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalTrial";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getPhaseList() {
        return this.getProperty("http://schema.org/phase");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTrialDesignList() {
        return this.getProperty("http://schema.org/trialDesign");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalTrial.Builder>
    implements MedicalTrial.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalTrial.Builder addAdditionalType(URL value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalTrial.Builder addAdditionalType(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addAlternateName(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalTrial.Builder addAlternateName(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addCode(MedicalCode value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalTrial.Builder addCode(MedicalCode.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalTrial.Builder addCode(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addDescription(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalTrial.Builder addDescription(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addGuideline(MedicalGuideline value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalTrial.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalTrial.Builder addGuideline(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addImage(ImageObject value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTrial.Builder addImage(ImageObject.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalTrial.Builder addImage(URL value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalTrial.Builder addImage(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTrial.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalTrial.Builder addMainEntityOfPage(URL value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalTrial.Builder addMainEntityOfPage(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalTrial.Builder addMedicineSystem(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addName(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalTrial.Builder addName(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addOutcome(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/outcome", value);
        }

        @Override
        public MedicalTrial.Builder addOutcome(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/outcome", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addPhase(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/phase", value);
        }

        @Override
        public MedicalTrial.Builder addPhase(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/phase", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addPopulation(Text value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/population", value);
        }

        @Override
        public MedicalTrial.Builder addPopulation(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/population", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addPotentialAction(Action value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalTrial.Builder addPotentialAction(Action.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalTrial.Builder addPotentialAction(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addRecognizingAuthority(Organization value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalTrial.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalTrial.Builder addRecognizingAuthority(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalTrial.Builder addRelevantSpecialty(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addSameAs(URL value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalTrial.Builder addSameAs(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addSponsor(Organization value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/sponsor", value);
        }

        @Override
        public MedicalTrial.Builder addSponsor(Organization.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/sponsor", value.build());
        }

        @Override
        public MedicalTrial.Builder addSponsor(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/sponsor", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addStatus(MedicalStudyStatus value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/status", value);
        }

        @Override
        public MedicalTrial.Builder addStatus(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/status", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addStudy(MedicalStudy value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalTrial.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalTrial.Builder addStudy(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addStudyLocation(AdministrativeArea value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studyLocation", value);
        }

        @Override
        public MedicalTrial.Builder addStudyLocation(AdministrativeArea.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studyLocation", value.build());
        }

        @Override
        public MedicalTrial.Builder addStudyLocation(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studyLocation", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addStudySubject(MedicalEntity value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studySubject", value);
        }

        @Override
        public MedicalTrial.Builder addStudySubject(MedicalEntity.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studySubject", value.build());
        }

        @Override
        public MedicalTrial.Builder addStudySubject(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/studySubject", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addTrialDesign(MedicalTrialDesign value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/trialDesign", value);
        }

        @Override
        public MedicalTrial.Builder addTrialDesign(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/trialDesign", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addUrl(URL value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalTrial.Builder addUrl(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addDetailedDescription(Article value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalTrial.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalTrial.Builder addDetailedDescription(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalTrial.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalTrial.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalTrial.Builder addPopularityScore(String value) {
            return (MedicalTrial.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalTrial build() {
            return new MedicalTrialImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

