/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalRiskFactor;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalRiskFactorImpl
extends MedicalEntityImpl
implements MedicalRiskFactor {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalRiskFactorImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/increasesRiskOf");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalRiskFactorImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalRiskFactor";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getIncreasesRiskOfList() {
        return this.getProperty("http://schema.org/increasesRiskOf");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalRiskFactor.Builder>
    implements MedicalRiskFactor.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalRiskFactor.Builder addAdditionalType(URL value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalRiskFactor.Builder addAdditionalType(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addAlternateName(Text value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalRiskFactor.Builder addAlternateName(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addCode(MedicalCode value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalRiskFactor.Builder addCode(MedicalCode.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addCode(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addDescription(Text value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalRiskFactor.Builder addDescription(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addGuideline(MedicalGuideline value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalRiskFactor.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addGuideline(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addImage(ImageObject value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskFactor.Builder addImage(ImageObject.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addImage(URL value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskFactor.Builder addImage(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addIncreasesRiskOf(MedicalEntity value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/increasesRiskOf", value);
        }

        @Override
        public MedicalRiskFactor.Builder addIncreasesRiskOf(MedicalEntity.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/increasesRiskOf", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addIncreasesRiskOf(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/increasesRiskOf", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskFactor.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addMainEntityOfPage(URL value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskFactor.Builder addMainEntityOfPage(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalRiskFactor.Builder addMedicineSystem(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addName(Text value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalRiskFactor.Builder addName(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addPotentialAction(Action value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalRiskFactor.Builder addPotentialAction(Action.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addPotentialAction(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addRecognizingAuthority(Organization value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalRiskFactor.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addRecognizingAuthority(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalRiskFactor.Builder addRelevantSpecialty(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addSameAs(URL value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalRiskFactor.Builder addSameAs(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addStudy(MedicalStudy value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalRiskFactor.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addStudy(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addUrl(URL value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalRiskFactor.Builder addUrl(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addDetailedDescription(Article value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalRiskFactor.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addDetailedDescription(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalRiskFactor.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalRiskFactor.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalRiskFactor.Builder addPopularityScore(String value) {
            return (MedicalRiskFactor.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalRiskFactor build() {
            return new MedicalRiskFactorImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

