/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalEvidenceLevel;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalGuidelineImpl;
import com.google.schemaorg.core.MedicalGuidelineRecommendation;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalGuidelineRecommendationImpl
extends MedicalGuidelineImpl
implements MedicalGuidelineRecommendation {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalGuidelineRecommendationImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/evidenceLevel");
        builder.add((Object)"http://schema.org/evidenceOrigin");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/guidelineDate");
        builder.add((Object)"http://schema.org/guidelineSubject");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/recommendationStrength");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalGuidelineRecommendationImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalGuidelineRecommendation";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecommendationStrengthList() {
        return this.getProperty("http://schema.org/recommendationStrength");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalGuidelineRecommendation.Builder>
    implements MedicalGuidelineRecommendation.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addAdditionalType(URL value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addAdditionalType(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addAlternateName(Text value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addAlternateName(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addCode(MedicalCode value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addCode(MedicalCode.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addCode(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addDescription(Text value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addDescription(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addEvidenceLevel(MedicalEvidenceLevel value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/evidenceLevel", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addEvidenceLevel(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/evidenceLevel", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addEvidenceOrigin(Text value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/evidenceOrigin", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addEvidenceOrigin(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/evidenceOrigin", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuideline(MedicalGuideline value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuideline(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuidelineDate(Date value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guidelineDate", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuidelineDate(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guidelineDate", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuidelineSubject(MedicalEntity value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guidelineSubject", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuidelineSubject(MedicalEntity.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guidelineSubject", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addGuidelineSubject(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/guidelineSubject", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addImage(ImageObject value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addImage(ImageObject.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addImage(URL value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addImage(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMainEntityOfPage(URL value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMainEntityOfPage(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addMedicineSystem(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addName(Text value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addName(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPotentialAction(Action value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPotentialAction(Action.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPotentialAction(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRecognizingAuthority(Organization value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRecognizingAuthority(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRecommendationStrength(Text value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/recommendationStrength", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRecommendationStrength(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/recommendationStrength", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addRelevantSpecialty(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addSameAs(URL value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addSameAs(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addStudy(MedicalStudy value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addStudy(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addUrl(URL value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addUrl(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addDetailedDescription(Article value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addDetailedDescription(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalGuidelineRecommendation.Builder addPopularityScore(String value) {
            return (MedicalGuidelineRecommendation.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalGuidelineRecommendation build() {
            return new MedicalGuidelineRecommendationImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

