/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIntangibleImpl;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalCodeImpl
extends MedicalIntangibleImpl
implements MedicalCode {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalCodeImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/codeValue");
        builder.add((Object)"http://schema.org/codingSystem");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalCodeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalCode";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodeValueList() {
        return this.getProperty("http://schema.org/codeValue");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCodingSystemList() {
        return this.getProperty("http://schema.org/codingSystem");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalCode.Builder>
    implements MedicalCode.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalCode.Builder addAdditionalType(URL value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalCode.Builder addAdditionalType(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addAlternateName(Text value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalCode.Builder addAlternateName(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addCode(MedicalCode value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalCode.Builder addCode(MedicalCode.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalCode.Builder addCode(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addCodeValue(Text value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/codeValue", value);
        }

        @Override
        public MedicalCode.Builder addCodeValue(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/codeValue", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addCodingSystem(Text value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/codingSystem", value);
        }

        @Override
        public MedicalCode.Builder addCodingSystem(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/codingSystem", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addDescription(Text value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalCode.Builder addDescription(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addGuideline(MedicalGuideline value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalCode.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalCode.Builder addGuideline(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addImage(ImageObject value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCode.Builder addImage(ImageObject.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalCode.Builder addImage(URL value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCode.Builder addImage(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCode.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalCode.Builder addMainEntityOfPage(URL value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCode.Builder addMainEntityOfPage(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalCode.Builder addMedicineSystem(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addName(Text value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalCode.Builder addName(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addPotentialAction(Action value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalCode.Builder addPotentialAction(Action.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalCode.Builder addPotentialAction(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addRecognizingAuthority(Organization value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalCode.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalCode.Builder addRecognizingAuthority(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalCode.Builder addRelevantSpecialty(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addSameAs(URL value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalCode.Builder addSameAs(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addStudy(MedicalStudy value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalCode.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalCode.Builder addStudy(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addUrl(URL value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalCode.Builder addUrl(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addDetailedDescription(Article value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalCode.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalCode.Builder addDetailedDescription(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalCode.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalCode.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalCode.Builder addPopularityScore(String value) {
            return (MedicalCode.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalCode build() {
            return new MedicalCodeImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

