/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.ListItem;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class ListItemImpl
extends IntangibleImpl
implements ListItem {
    private static final ImmutableSet<String> PROPERTY_SET = ListItemImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/item");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nextItem");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/previousItem");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public ListItemImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/ListItem";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemList() {
        return this.getProperty("http://schema.org/item");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNextItemList() {
        return this.getProperty("http://schema.org/nextItem");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPositionList() {
        return this.getProperty("http://schema.org/position");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPreviousItemList() {
        return this.getProperty("http://schema.org/previousItem");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<ListItem.Builder>
    implements ListItem.Builder {
        BuilderImpl() {
        }

        @Override
        public ListItem.Builder addAdditionalType(URL value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public ListItem.Builder addAdditionalType(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public ListItem.Builder addAlternateName(Text value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public ListItem.Builder addAlternateName(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public ListItem.Builder addDescription(Text value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public ListItem.Builder addDescription(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public ListItem.Builder addImage(ImageObject value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ListItem.Builder addImage(ImageObject.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public ListItem.Builder addImage(URL value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public ListItem.Builder addImage(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public ListItem.Builder addItem(Thing value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/item", value);
        }

        @Override
        public ListItem.Builder addItem(Thing.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/item", value.build());
        }

        @Override
        public ListItem.Builder addItem(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/item", Text.of(value));
        }

        @Override
        public ListItem.Builder addMainEntityOfPage(CreativeWork value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ListItem.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public ListItem.Builder addMainEntityOfPage(URL value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public ListItem.Builder addMainEntityOfPage(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public ListItem.Builder addName(Text value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public ListItem.Builder addName(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public ListItem.Builder addNextItem(ListItem value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/nextItem", value);
        }

        @Override
        public ListItem.Builder addNextItem(ListItem.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/nextItem", value.build());
        }

        @Override
        public ListItem.Builder addNextItem(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/nextItem", Text.of(value));
        }

        @Override
        public ListItem.Builder addPosition(Integer value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public ListItem.Builder addPosition(Text value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public ListItem.Builder addPosition(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public ListItem.Builder addPotentialAction(Action value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public ListItem.Builder addPotentialAction(Action.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public ListItem.Builder addPotentialAction(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public ListItem.Builder addPreviousItem(ListItem value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/previousItem", value);
        }

        @Override
        public ListItem.Builder addPreviousItem(ListItem.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/previousItem", value.build());
        }

        @Override
        public ListItem.Builder addPreviousItem(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/previousItem", Text.of(value));
        }

        @Override
        public ListItem.Builder addSameAs(URL value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public ListItem.Builder addSameAs(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public ListItem.Builder addUrl(URL value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public ListItem.Builder addUrl(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public ListItem.Builder addDetailedDescription(Article value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public ListItem.Builder addDetailedDescription(Article.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public ListItem.Builder addDetailedDescription(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public ListItem.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public ListItem.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public ListItem.Builder addPopularityScore(String value) {
            return (ListItem.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public ListItem build() {
            return new ListItemImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

