/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DietarySupplement;
import com.google.schemaorg.core.DrugLegalStatus;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MaximumDoseSchedule;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicalTherapyImpl;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.RecommendedDoseSchedule;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DietarySupplementImpl
extends MedicalTherapyImpl
implements DietarySupplement {
    private static final ImmutableSet<String> PROPERTY_SET = DietarySupplementImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/activeIngredient");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/background");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/dosageForm");
        builder.add((Object)"http://schema.org/duplicateTherapy");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/isProprietary");
        builder.add((Object)"http://schema.org/legalStatus");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/manufacturer");
        builder.add((Object)"http://schema.org/maximumIntake");
        builder.add((Object)"http://schema.org/mechanismOfAction");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/nonProprietaryName");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/recommendedIntake");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/safetyConsideration");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/targetPopulation");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DietarySupplementImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DietarySupplement";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getActiveIngredientList() {
        return this.getProperty("http://schema.org/activeIngredient");
    }

    @Override
    public ImmutableList<SchemaOrgType> getBackgroundList() {
        return this.getProperty("http://schema.org/background");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDosageFormList() {
        return this.getProperty("http://schema.org/dosageForm");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsProprietaryList() {
        return this.getProperty("http://schema.org/isProprietary");
    }

    @Override
    public ImmutableList<SchemaOrgType> getLegalStatusList() {
        return this.getProperty("http://schema.org/legalStatus");
    }

    @Override
    public ImmutableList<SchemaOrgType> getManufacturerList() {
        return this.getProperty("http://schema.org/manufacturer");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMaximumIntakeList() {
        return this.getProperty("http://schema.org/maximumIntake");
    }

    @Override
    public ImmutableList<SchemaOrgType> getMechanismOfActionList() {
        return this.getProperty("http://schema.org/mechanismOfAction");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNonProprietaryNameList() {
        return this.getProperty("http://schema.org/nonProprietaryName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecommendedIntakeList() {
        return this.getProperty("http://schema.org/recommendedIntake");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSafetyConsiderationList() {
        return this.getProperty("http://schema.org/safetyConsideration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetPopulationList() {
        return this.getProperty("http://schema.org/targetPopulation");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DietarySupplement.Builder>
    implements DietarySupplement.Builder {
        BuilderImpl() {
        }

        @Override
        public DietarySupplement.Builder addActiveIngredient(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/activeIngredient", value);
        }

        @Override
        public DietarySupplement.Builder addActiveIngredient(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/activeIngredient", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addAdditionalType(URL value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DietarySupplement.Builder addAdditionalType(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addAdverseOutcome(MedicalEntity value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public DietarySupplement.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public DietarySupplement.Builder addAdverseOutcome(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addAlternateName(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DietarySupplement.Builder addAlternateName(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addBackground(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/background", value);
        }

        @Override
        public DietarySupplement.Builder addBackground(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/background", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addCode(MedicalCode value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public DietarySupplement.Builder addCode(MedicalCode.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public DietarySupplement.Builder addCode(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addContraindication(MedicalContraindication value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public DietarySupplement.Builder addContraindication(MedicalContraindication.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public DietarySupplement.Builder addContraindication(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addDescription(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DietarySupplement.Builder addDescription(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addDosageForm(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/dosageForm", value);
        }

        @Override
        public DietarySupplement.Builder addDosageForm(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/dosageForm", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addDuplicateTherapy(MedicalTherapy value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/duplicateTherapy", value);
        }

        @Override
        public DietarySupplement.Builder addDuplicateTherapy(MedicalTherapy.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/duplicateTherapy", value.build());
        }

        @Override
        public DietarySupplement.Builder addDuplicateTherapy(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/duplicateTherapy", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addGuideline(MedicalGuideline value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public DietarySupplement.Builder addGuideline(MedicalGuideline.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public DietarySupplement.Builder addGuideline(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addImage(ImageObject value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DietarySupplement.Builder addImage(ImageObject.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DietarySupplement.Builder addImage(URL value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DietarySupplement.Builder addImage(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addIndication(MedicalIndication value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public DietarySupplement.Builder addIndication(MedicalIndication.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public DietarySupplement.Builder addIndication(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addIsProprietary(Boolean value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/isProprietary", value);
        }

        @Override
        public DietarySupplement.Builder addIsProprietary(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/isProprietary", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addLegalStatus(DrugLegalStatus value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/legalStatus", value);
        }

        @Override
        public DietarySupplement.Builder addLegalStatus(DrugLegalStatus.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/legalStatus", value.build());
        }

        @Override
        public DietarySupplement.Builder addLegalStatus(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/legalStatus", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addMainEntityOfPage(CreativeWork value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DietarySupplement.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DietarySupplement.Builder addMainEntityOfPage(URL value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DietarySupplement.Builder addMainEntityOfPage(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addManufacturer(Organization value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/manufacturer", value);
        }

        @Override
        public DietarySupplement.Builder addManufacturer(Organization.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/manufacturer", value.build());
        }

        @Override
        public DietarySupplement.Builder addManufacturer(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/manufacturer", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addMaximumIntake(MaximumDoseSchedule value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/maximumIntake", value);
        }

        @Override
        public DietarySupplement.Builder addMaximumIntake(MaximumDoseSchedule.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/maximumIntake", value.build());
        }

        @Override
        public DietarySupplement.Builder addMaximumIntake(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/maximumIntake", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addMechanismOfAction(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mechanismOfAction", value);
        }

        @Override
        public DietarySupplement.Builder addMechanismOfAction(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/mechanismOfAction", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addMedicineSystem(MedicineSystem value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public DietarySupplement.Builder addMedicineSystem(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addName(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DietarySupplement.Builder addName(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addNonProprietaryName(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/nonProprietaryName", value);
        }

        @Override
        public DietarySupplement.Builder addNonProprietaryName(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/nonProprietaryName", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addPotentialAction(Action value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DietarySupplement.Builder addPotentialAction(Action.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DietarySupplement.Builder addPotentialAction(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addRecognizingAuthority(Organization value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public DietarySupplement.Builder addRecognizingAuthority(Organization.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public DietarySupplement.Builder addRecognizingAuthority(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addRecommendedIntake(RecommendedDoseSchedule value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recommendedIntake", value);
        }

        @Override
        public DietarySupplement.Builder addRecommendedIntake(RecommendedDoseSchedule.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recommendedIntake", value.build());
        }

        @Override
        public DietarySupplement.Builder addRecommendedIntake(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/recommendedIntake", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public DietarySupplement.Builder addRelevantSpecialty(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addSafetyConsideration(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/safetyConsideration", value);
        }

        @Override
        public DietarySupplement.Builder addSafetyConsideration(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/safetyConsideration", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addSameAs(URL value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DietarySupplement.Builder addSameAs(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public DietarySupplement.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public DietarySupplement.Builder addSeriousAdverseOutcome(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addStudy(MedicalStudy value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public DietarySupplement.Builder addStudy(MedicalStudy.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public DietarySupplement.Builder addStudy(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addTargetPopulation(Text value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/targetPopulation", value);
        }

        @Override
        public DietarySupplement.Builder addTargetPopulation(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/targetPopulation", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addUrl(URL value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DietarySupplement.Builder addUrl(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addDetailedDescription(Article value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DietarySupplement.Builder addDetailedDescription(Article.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DietarySupplement.Builder addDetailedDescription(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DietarySupplement.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DietarySupplement.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DietarySupplement.Builder addPopularityScore(String value) {
            return (DietarySupplement.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DietarySupplement build() {
            return new DietarySupplementImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

