/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AlignmentObjectImpl
extends IntangibleImpl
implements AlignmentObject {
    private static final ImmutableSet<String> PROPERTY_SET = AlignmentObjectImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alignmentType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/educationalFramework");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/targetDescription");
        builder.add((Object)"http://schema.org/targetName");
        builder.add((Object)"http://schema.org/targetUrl");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AlignmentObjectImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/AlignmentObject";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAlignmentTypeList() {
        return this.getProperty("http://schema.org/alignmentType");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEducationalFrameworkList() {
        return this.getProperty("http://schema.org/educationalFramework");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetDescriptionList() {
        return this.getProperty("http://schema.org/targetDescription");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetNameList() {
        return this.getProperty("http://schema.org/targetName");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTargetUrlList() {
        return this.getProperty("http://schema.org/targetUrl");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<AlignmentObject.Builder>
    implements AlignmentObject.Builder {
        BuilderImpl() {
        }

        @Override
        public AlignmentObject.Builder addAdditionalType(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public AlignmentObject.Builder addAdditionalType(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addAlignmentType(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/alignmentType", value);
        }

        @Override
        public AlignmentObject.Builder addAlignmentType(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/alignmentType", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addAlternateName(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public AlignmentObject.Builder addAlternateName(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addDescription(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public AlignmentObject.Builder addDescription(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addEducationalFramework(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/educationalFramework", value);
        }

        @Override
        public AlignmentObject.Builder addEducationalFramework(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/educationalFramework", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addImage(ImageObject value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AlignmentObject.Builder addImage(ImageObject.Builder value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public AlignmentObject.Builder addImage(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AlignmentObject.Builder addImage(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addMainEntityOfPage(CreativeWork value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AlignmentObject.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public AlignmentObject.Builder addMainEntityOfPage(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AlignmentObject.Builder addMainEntityOfPage(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addName(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public AlignmentObject.Builder addName(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addPotentialAction(Action value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public AlignmentObject.Builder addPotentialAction(Action.Builder value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public AlignmentObject.Builder addPotentialAction(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addSameAs(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public AlignmentObject.Builder addSameAs(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addTargetDescription(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetDescription", value);
        }

        @Override
        public AlignmentObject.Builder addTargetDescription(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetDescription", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addTargetName(Text value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetName", value);
        }

        @Override
        public AlignmentObject.Builder addTargetName(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetName", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addTargetUrl(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetUrl", value);
        }

        @Override
        public AlignmentObject.Builder addTargetUrl(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/targetUrl", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addUrl(URL value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public AlignmentObject.Builder addUrl(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addDetailedDescription(Article value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public AlignmentObject.Builder addDetailedDescription(Article.Builder value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public AlignmentObject.Builder addDetailedDescription(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public AlignmentObject.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public AlignmentObject.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public AlignmentObject.Builder addPopularityScore(String value) {
            return (AlignmentObject.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public AlignmentObject build() {
            return new AlignmentObjectImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

