/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.schemaorg.core;

/** Factory to create builder object in the namespace http://schema.org/. */
public final class CoreFactory {

  public static APIReference.Builder newAPIReferenceBuilder() {
    return new APIReferenceImpl.BuilderImpl();
  }

  public static AboutPage.Builder newAboutPageBuilder() {
    return new AboutPageImpl.BuilderImpl();
  }

  public static AcceptAction.Builder newAcceptActionBuilder() {
    return new AcceptActionImpl.BuilderImpl();
  }

  public static AccountingService.Builder newAccountingServiceBuilder() {
    return new AccountingServiceImpl.BuilderImpl();
  }

  public static AchieveAction.Builder newAchieveActionBuilder() {
    return new AchieveActionImpl.BuilderImpl();
  }

  public static Action.Builder newActionBuilder() {
    return new ActionImpl.BuilderImpl();
  }

  public static ActivateAction.Builder newActivateActionBuilder() {
    return new ActivateActionImpl.BuilderImpl();
  }

  public static AddAction.Builder newAddActionBuilder() {
    return new AddActionImpl.BuilderImpl();
  }

  public static AdministrativeArea.Builder newAdministrativeAreaBuilder() {
    return new AdministrativeAreaImpl.BuilderImpl();
  }

  public static AdultEntertainment.Builder newAdultEntertainmentBuilder() {
    return new AdultEntertainmentImpl.BuilderImpl();
  }

  public static AggregateOffer.Builder newAggregateOfferBuilder() {
    return new AggregateOfferImpl.BuilderImpl();
  }

  public static AggregateRating.Builder newAggregateRatingBuilder() {
    return new AggregateRatingImpl.BuilderImpl();
  }

  public static AgreeAction.Builder newAgreeActionBuilder() {
    return new AgreeActionImpl.BuilderImpl();
  }

  public static Airline.Builder newAirlineBuilder() {
    return new AirlineImpl.BuilderImpl();
  }

  public static Airport.Builder newAirportBuilder() {
    return new AirportImpl.BuilderImpl();
  }

  public static AlignmentObject.Builder newAlignmentObjectBuilder() {
    return new AlignmentObjectImpl.BuilderImpl();
  }

  public static AllocateAction.Builder newAllocateActionBuilder() {
    return new AllocateActionImpl.BuilderImpl();
  }

  public static AmusementPark.Builder newAmusementParkBuilder() {
    return new AmusementParkImpl.BuilderImpl();
  }

  public static AnatomicalStructure.Builder newAnatomicalStructureBuilder() {
    return new AnatomicalStructureImpl.BuilderImpl();
  }

  public static AnatomicalSystem.Builder newAnatomicalSystemBuilder() {
    return new AnatomicalSystemImpl.BuilderImpl();
  }

  public static AnimalShelter.Builder newAnimalShelterBuilder() {
    return new AnimalShelterImpl.BuilderImpl();
  }

  public static Answer.Builder newAnswerBuilder() {
    return new AnswerImpl.BuilderImpl();
  }

  public static ApartmentComplex.Builder newApartmentComplexBuilder() {
    return new ApartmentComplexImpl.BuilderImpl();
  }

  public static AppendAction.Builder newAppendActionBuilder() {
    return new AppendActionImpl.BuilderImpl();
  }

  public static ApplyAction.Builder newApplyActionBuilder() {
    return new ApplyActionImpl.BuilderImpl();
  }

  public static ApprovedIndication.Builder newApprovedIndicationBuilder() {
    return new ApprovedIndicationImpl.BuilderImpl();
  }

  public static Aquarium.Builder newAquariumBuilder() {
    return new AquariumImpl.BuilderImpl();
  }

  public static ArriveAction.Builder newArriveActionBuilder() {
    return new ArriveActionImpl.BuilderImpl();
  }

  public static ArtGallery.Builder newArtGalleryBuilder() {
    return new ArtGalleryImpl.BuilderImpl();
  }

  public static Artery.Builder newArteryBuilder() {
    return new ArteryImpl.BuilderImpl();
  }

  public static Article.Builder newArticleBuilder() {
    return new ArticleImpl.BuilderImpl();
  }

  public static AskAction.Builder newAskActionBuilder() {
    return new AskActionImpl.BuilderImpl();
  }

  public static AssessAction.Builder newAssessActionBuilder() {
    return new AssessActionImpl.BuilderImpl();
  }

  public static AssignAction.Builder newAssignActionBuilder() {
    return new AssignActionImpl.BuilderImpl();
  }

  public static Attorney.Builder newAttorneyBuilder() {
    return new AttorneyImpl.BuilderImpl();
  }

  public static Audience.Builder newAudienceBuilder() {
    return new AudienceImpl.BuilderImpl();
  }

  public static AudioObject.Builder newAudioObjectBuilder() {
    return new AudioObjectImpl.BuilderImpl();
  }

  public static AuthorizeAction.Builder newAuthorizeActionBuilder() {
    return new AuthorizeActionImpl.BuilderImpl();
  }

  public static AutoBodyShop.Builder newAutoBodyShopBuilder() {
    return new AutoBodyShopImpl.BuilderImpl();
  }

  public static AutoDealer.Builder newAutoDealerBuilder() {
    return new AutoDealerImpl.BuilderImpl();
  }

  public static AutoPartsStore.Builder newAutoPartsStoreBuilder() {
    return new AutoPartsStoreImpl.BuilderImpl();
  }

  public static AutoRental.Builder newAutoRentalBuilder() {
    return new AutoRentalImpl.BuilderImpl();
  }

  public static AutoRepair.Builder newAutoRepairBuilder() {
    return new AutoRepairImpl.BuilderImpl();
  }

  public static AutoWash.Builder newAutoWashBuilder() {
    return new AutoWashImpl.BuilderImpl();
  }

  public static AutomatedTeller.Builder newAutomatedTellerBuilder() {
    return new AutomatedTellerImpl.BuilderImpl();
  }

  public static AutomotiveBusiness.Builder newAutomotiveBusinessBuilder() {
    return new AutomotiveBusinessImpl.BuilderImpl();
  }

  public static Bakery.Builder newBakeryBuilder() {
    return new BakeryImpl.BuilderImpl();
  }

  public static BankOrCreditUnion.Builder newBankOrCreditUnionBuilder() {
    return new BankOrCreditUnionImpl.BuilderImpl();
  }

  public static BarOrPub.Builder newBarOrPubBuilder() {
    return new BarOrPubImpl.BuilderImpl();
  }

  public static Barcode.Builder newBarcodeBuilder() {
    return new BarcodeImpl.BuilderImpl();
  }

  public static Beach.Builder newBeachBuilder() {
    return new BeachImpl.BuilderImpl();
  }

  public static BeautySalon.Builder newBeautySalonBuilder() {
    return new BeautySalonImpl.BuilderImpl();
  }

  public static BedAndBreakfast.Builder newBedAndBreakfastBuilder() {
    return new BedAndBreakfastImpl.BuilderImpl();
  }

  public static BefriendAction.Builder newBefriendActionBuilder() {
    return new BefriendActionImpl.BuilderImpl();
  }

  public static BikeStore.Builder newBikeStoreBuilder() {
    return new BikeStoreImpl.BuilderImpl();
  }

  public static Blog.Builder newBlogBuilder() {
    return new BlogImpl.BuilderImpl();
  }

  public static BlogPosting.Builder newBlogPostingBuilder() {
    return new BlogPostingImpl.BuilderImpl();
  }

  public static BloodTest.Builder newBloodTestBuilder() {
    return new BloodTestImpl.BuilderImpl();
  }

  public static BodyOfWater.Builder newBodyOfWaterBuilder() {
    return new BodyOfWaterImpl.BuilderImpl();
  }

  public static Bone.Builder newBoneBuilder() {
    return new BoneImpl.BuilderImpl();
  }

  public static Book.Builder newBookBuilder() {
    return new BookImpl.BuilderImpl();
  }

  public static BookSeries.Builder newBookSeriesBuilder() {
    return new BookSeriesImpl.BuilderImpl();
  }

  public static BookStore.Builder newBookStoreBuilder() {
    return new BookStoreImpl.BuilderImpl();
  }

  public static BookmarkAction.Builder newBookmarkActionBuilder() {
    return new BookmarkActionImpl.BuilderImpl();
  }

  public static BorrowAction.Builder newBorrowActionBuilder() {
    return new BorrowActionImpl.BuilderImpl();
  }

  public static BowlingAlley.Builder newBowlingAlleyBuilder() {
    return new BowlingAlleyImpl.BuilderImpl();
  }

  public static BrainStructure.Builder newBrainStructureBuilder() {
    return new BrainStructureImpl.BuilderImpl();
  }

  public static Brand.Builder newBrandBuilder() {
    return new BrandImpl.BuilderImpl();
  }

  public static BreadcrumbList.Builder newBreadcrumbListBuilder() {
    return new BreadcrumbListImpl.BuilderImpl();
  }

  public static Brewery.Builder newBreweryBuilder() {
    return new BreweryImpl.BuilderImpl();
  }

  public static Bridge.Builder newBridgeBuilder() {
    return new BridgeImpl.BuilderImpl();
  }

  public static BroadcastChannel.Builder newBroadcastChannelBuilder() {
    return new BroadcastChannelImpl.BuilderImpl();
  }

  public static BroadcastEvent.Builder newBroadcastEventBuilder() {
    return new BroadcastEventImpl.BuilderImpl();
  }

  public static BroadcastFrequencySpecification.Builder
      newBroadcastFrequencySpecificationBuilder() {
    return new BroadcastFrequencySpecificationImpl.BuilderImpl();
  }

  public static BroadcastService.Builder newBroadcastServiceBuilder() {
    return new BroadcastServiceImpl.BuilderImpl();
  }

  public static BuddhistTemple.Builder newBuddhistTempleBuilder() {
    return new BuddhistTempleImpl.BuilderImpl();
  }

  public static BusReservation.Builder newBusReservationBuilder() {
    return new BusReservationImpl.BuilderImpl();
  }

  public static BusStation.Builder newBusStationBuilder() {
    return new BusStationImpl.BuilderImpl();
  }

  public static BusStop.Builder newBusStopBuilder() {
    return new BusStopImpl.BuilderImpl();
  }

  public static BusTrip.Builder newBusTripBuilder() {
    return new BusTripImpl.BuilderImpl();
  }

  public static BusinessAudience.Builder newBusinessAudienceBuilder() {
    return new BusinessAudienceImpl.BuilderImpl();
  }

  public static BusinessEvent.Builder newBusinessEventBuilder() {
    return new BusinessEventImpl.BuilderImpl();
  }

  public static BuyAction.Builder newBuyActionBuilder() {
    return new BuyActionImpl.BuilderImpl();
  }

  public static CableOrSatelliteService.Builder newCableOrSatelliteServiceBuilder() {
    return new CableOrSatelliteServiceImpl.BuilderImpl();
  }

  public static CafeOrCoffeeShop.Builder newCafeOrCoffeeShopBuilder() {
    return new CafeOrCoffeeShopImpl.BuilderImpl();
  }

  public static Campground.Builder newCampgroundBuilder() {
    return new CampgroundImpl.BuilderImpl();
  }

  public static Canal.Builder newCanalBuilder() {
    return new CanalImpl.BuilderImpl();
  }

  public static CancelAction.Builder newCancelActionBuilder() {
    return new CancelActionImpl.BuilderImpl();
  }

  public static Car.Builder newCarBuilder() {
    return new CarImpl.BuilderImpl();
  }

  public static Casino.Builder newCasinoBuilder() {
    return new CasinoImpl.BuilderImpl();
  }

  public static CatholicChurch.Builder newCatholicChurchBuilder() {
    return new CatholicChurchImpl.BuilderImpl();
  }

  public static Cemetery.Builder newCemeteryBuilder() {
    return new CemeteryImpl.BuilderImpl();
  }

  public static CheckAction.Builder newCheckActionBuilder() {
    return new CheckActionImpl.BuilderImpl();
  }

  public static CheckInAction.Builder newCheckInActionBuilder() {
    return new CheckInActionImpl.BuilderImpl();
  }

  public static CheckOutAction.Builder newCheckOutActionBuilder() {
    return new CheckOutActionImpl.BuilderImpl();
  }

  public static CheckoutPage.Builder newCheckoutPageBuilder() {
    return new CheckoutPageImpl.BuilderImpl();
  }

  public static ChildCare.Builder newChildCareBuilder() {
    return new ChildCareImpl.BuilderImpl();
  }

  public static ChildrensEvent.Builder newChildrensEventBuilder() {
    return new ChildrensEventImpl.BuilderImpl();
  }

  public static ChooseAction.Builder newChooseActionBuilder() {
    return new ChooseActionImpl.BuilderImpl();
  }

  public static Church.Builder newChurchBuilder() {
    return new ChurchImpl.BuilderImpl();
  }

  public static City.Builder newCityBuilder() {
    return new CityImpl.BuilderImpl();
  }

  public static CityHall.Builder newCityHallBuilder() {
    return new CityHallImpl.BuilderImpl();
  }

  public static CivicStructure.Builder newCivicStructureBuilder() {
    return new CivicStructureImpl.BuilderImpl();
  }

  public static Class.Builder newClassBuilder() {
    return new ClassImpl.BuilderImpl();
  }

  public static Clip.Builder newClipBuilder() {
    return new ClipImpl.BuilderImpl();
  }

  public static ClothingStore.Builder newClothingStoreBuilder() {
    return new ClothingStoreImpl.BuilderImpl();
  }

  public static Code.Builder newCodeBuilder() {
    return new CodeImpl.BuilderImpl();
  }

  public static CollectionPage.Builder newCollectionPageBuilder() {
    return new CollectionPageImpl.BuilderImpl();
  }

  public static CollegeOrUniversity.Builder newCollegeOrUniversityBuilder() {
    return new CollegeOrUniversityImpl.BuilderImpl();
  }

  public static ComedyClub.Builder newComedyClubBuilder() {
    return new ComedyClubImpl.BuilderImpl();
  }

  public static ComedyEvent.Builder newComedyEventBuilder() {
    return new ComedyEventImpl.BuilderImpl();
  }

  public static Comment.Builder newCommentBuilder() {
    return new CommentImpl.BuilderImpl();
  }

  public static CommentAction.Builder newCommentActionBuilder() {
    return new CommentActionImpl.BuilderImpl();
  }

  public static CommunicateAction.Builder newCommunicateActionBuilder() {
    return new CommunicateActionImpl.BuilderImpl();
  }

  public static ComputerStore.Builder newComputerStoreBuilder() {
    return new ComputerStoreImpl.BuilderImpl();
  }

  public static ConfirmAction.Builder newConfirmActionBuilder() {
    return new ConfirmActionImpl.BuilderImpl();
  }

  public static ConsumeAction.Builder newConsumeActionBuilder() {
    return new ConsumeActionImpl.BuilderImpl();
  }

  public static ContactPage.Builder newContactPageBuilder() {
    return new ContactPageImpl.BuilderImpl();
  }

  public static ContactPoint.Builder newContactPointBuilder() {
    return new ContactPointImpl.BuilderImpl();
  }

  public static Continent.Builder newContinentBuilder() {
    return new ContinentImpl.BuilderImpl();
  }

  public static ControlAction.Builder newControlActionBuilder() {
    return new ControlActionImpl.BuilderImpl();
  }

  public static ConvenienceStore.Builder newConvenienceStoreBuilder() {
    return new ConvenienceStoreImpl.BuilderImpl();
  }

  public static CookAction.Builder newCookActionBuilder() {
    return new CookActionImpl.BuilderImpl();
  }

  public static Corporation.Builder newCorporationBuilder() {
    return new CorporationImpl.BuilderImpl();
  }

  public static Country.Builder newCountryBuilder() {
    return new CountryImpl.BuilderImpl();
  }

  public static Courthouse.Builder newCourthouseBuilder() {
    return new CourthouseImpl.BuilderImpl();
  }

  public static CreateAction.Builder newCreateActionBuilder() {
    return new CreateActionImpl.BuilderImpl();
  }

  public static CreativeWork.Builder newCreativeWorkBuilder() {
    return new CreativeWorkImpl.BuilderImpl();
  }

  public static CreativeWorkSeason.Builder newCreativeWorkSeasonBuilder() {
    return new CreativeWorkSeasonImpl.BuilderImpl();
  }

  public static CreativeWorkSeries.Builder newCreativeWorkSeriesBuilder() {
    return new CreativeWorkSeriesImpl.BuilderImpl();
  }

  public static Crematorium.Builder newCrematoriumBuilder() {
    return new CrematoriumImpl.BuilderImpl();
  }

  public static DDxElement.Builder newDDxElementBuilder() {
    return new DDxElementImpl.BuilderImpl();
  }

  public static DanceEvent.Builder newDanceEventBuilder() {
    return new DanceEventImpl.BuilderImpl();
  }

  public static DanceGroup.Builder newDanceGroupBuilder() {
    return new DanceGroupImpl.BuilderImpl();
  }

  public static DataCatalog.Builder newDataCatalogBuilder() {
    return new DataCatalogImpl.BuilderImpl();
  }

  public static DataDownload.Builder newDataDownloadBuilder() {
    return new DataDownloadImpl.BuilderImpl();
  }

  public static DataFeed.Builder newDataFeedBuilder() {
    return new DataFeedImpl.BuilderImpl();
  }

  public static DataFeedItem.Builder newDataFeedItemBuilder() {
    return new DataFeedItemImpl.BuilderImpl();
  }

  public static Dataset.Builder newDatasetBuilder() {
    return new DatasetImpl.BuilderImpl();
  }

  public static DatedMoneySpecification.Builder newDatedMoneySpecificationBuilder() {
    return new DatedMoneySpecificationImpl.BuilderImpl();
  }

  public static DaySpa.Builder newDaySpaBuilder() {
    return new DaySpaImpl.BuilderImpl();
  }

  public static DeactivateAction.Builder newDeactivateActionBuilder() {
    return new DeactivateActionImpl.BuilderImpl();
  }

  public static DefenceEstablishment.Builder newDefenceEstablishmentBuilder() {
    return new DefenceEstablishmentImpl.BuilderImpl();
  }

  public static DeleteAction.Builder newDeleteActionBuilder() {
    return new DeleteActionImpl.BuilderImpl();
  }

  public static DeliveryChargeSpecification.Builder newDeliveryChargeSpecificationBuilder() {
    return new DeliveryChargeSpecificationImpl.BuilderImpl();
  }

  public static DeliveryEvent.Builder newDeliveryEventBuilder() {
    return new DeliveryEventImpl.BuilderImpl();
  }

  public static Demand.Builder newDemandBuilder() {
    return new DemandImpl.BuilderImpl();
  }

  public static Dentist.Builder newDentistBuilder() {
    return new DentistImpl.BuilderImpl();
  }

  public static DepartAction.Builder newDepartActionBuilder() {
    return new DepartActionImpl.BuilderImpl();
  }

  public static DepartmentStore.Builder newDepartmentStoreBuilder() {
    return new DepartmentStoreImpl.BuilderImpl();
  }

  public static DiagnosticLab.Builder newDiagnosticLabBuilder() {
    return new DiagnosticLabImpl.BuilderImpl();
  }

  public static DiagnosticProcedure.Builder newDiagnosticProcedureBuilder() {
    return new DiagnosticProcedureImpl.BuilderImpl();
  }

  public static Diet.Builder newDietBuilder() {
    return new DietImpl.BuilderImpl();
  }

  public static DietarySupplement.Builder newDietarySupplementBuilder() {
    return new DietarySupplementImpl.BuilderImpl();
  }

  public static DisagreeAction.Builder newDisagreeActionBuilder() {
    return new DisagreeActionImpl.BuilderImpl();
  }

  public static DiscoverAction.Builder newDiscoverActionBuilder() {
    return new DiscoverActionImpl.BuilderImpl();
  }

  public static DiscussionForumPosting.Builder newDiscussionForumPostingBuilder() {
    return new DiscussionForumPostingImpl.BuilderImpl();
  }

  public static DislikeAction.Builder newDislikeActionBuilder() {
    return new DislikeActionImpl.BuilderImpl();
  }

  public static Distance.Builder newDistanceBuilder() {
    return new DistanceImpl.BuilderImpl();
  }

  public static DonateAction.Builder newDonateActionBuilder() {
    return new DonateActionImpl.BuilderImpl();
  }

  public static DoseSchedule.Builder newDoseScheduleBuilder() {
    return new DoseScheduleImpl.BuilderImpl();
  }

  public static DownloadAction.Builder newDownloadActionBuilder() {
    return new DownloadActionImpl.BuilderImpl();
  }

  public static DrawAction.Builder newDrawActionBuilder() {
    return new DrawActionImpl.BuilderImpl();
  }

  public static DrinkAction.Builder newDrinkActionBuilder() {
    return new DrinkActionImpl.BuilderImpl();
  }

  public static Drug.Builder newDrugBuilder() {
    return new DrugImpl.BuilderImpl();
  }

  public static DrugClass.Builder newDrugClassBuilder() {
    return new DrugClassImpl.BuilderImpl();
  }

  public static DrugCost.Builder newDrugCostBuilder() {
    return new DrugCostImpl.BuilderImpl();
  }

  public static DrugLegalStatus.Builder newDrugLegalStatusBuilder() {
    return new DrugLegalStatusImpl.BuilderImpl();
  }

  public static DrugStrength.Builder newDrugStrengthBuilder() {
    return new DrugStrengthImpl.BuilderImpl();
  }

  public static DryCleaningOrLaundry.Builder newDryCleaningOrLaundryBuilder() {
    return new DryCleaningOrLaundryImpl.BuilderImpl();
  }

  public static Duration.Builder newDurationBuilder() {
    return new DurationImpl.BuilderImpl();
  }

  public static EatAction.Builder newEatActionBuilder() {
    return new EatActionImpl.BuilderImpl();
  }

  public static EducationEvent.Builder newEducationEventBuilder() {
    return new EducationEventImpl.BuilderImpl();
  }

  public static EducationalAudience.Builder newEducationalAudienceBuilder() {
    return new EducationalAudienceImpl.BuilderImpl();
  }

  public static EducationalOrganization.Builder newEducationalOrganizationBuilder() {
    return new EducationalOrganizationImpl.BuilderImpl();
  }

  public static Electrician.Builder newElectricianBuilder() {
    return new ElectricianImpl.BuilderImpl();
  }

  public static ElectronicsStore.Builder newElectronicsStoreBuilder() {
    return new ElectronicsStoreImpl.BuilderImpl();
  }

  public static ElementarySchool.Builder newElementarySchoolBuilder() {
    return new ElementarySchoolImpl.BuilderImpl();
  }

  public static EmailMessage.Builder newEmailMessageBuilder() {
    return new EmailMessageImpl.BuilderImpl();
  }

  public static Embassy.Builder newEmbassyBuilder() {
    return new EmbassyImpl.BuilderImpl();
  }

  public static EmergencyService.Builder newEmergencyServiceBuilder() {
    return new EmergencyServiceImpl.BuilderImpl();
  }

  public static EmployeeRole.Builder newEmployeeRoleBuilder() {
    return new EmployeeRoleImpl.BuilderImpl();
  }

  public static EmploymentAgency.Builder newEmploymentAgencyBuilder() {
    return new EmploymentAgencyImpl.BuilderImpl();
  }

  public static EndorseAction.Builder newEndorseActionBuilder() {
    return new EndorseActionImpl.BuilderImpl();
  }

  public static Energy.Builder newEnergyBuilder() {
    return new EnergyImpl.BuilderImpl();
  }

  public static EngineSpecification.Builder newEngineSpecificationBuilder() {
    return new EngineSpecificationImpl.BuilderImpl();
  }

  public static EntertainmentBusiness.Builder newEntertainmentBusinessBuilder() {
    return new EntertainmentBusinessImpl.BuilderImpl();
  }

  public static EntryPoint.Builder newEntryPointBuilder() {
    return new EntryPointImpl.BuilderImpl();
  }

  public static Episode.Builder newEpisodeBuilder() {
    return new EpisodeImpl.BuilderImpl();
  }

  public static Event.Builder newEventBuilder() {
    return new EventImpl.BuilderImpl();
  }

  public static EventReservation.Builder newEventReservationBuilder() {
    return new EventReservationImpl.BuilderImpl();
  }

  public static EventVenue.Builder newEventVenueBuilder() {
    return new EventVenueImpl.BuilderImpl();
  }

  public static ExerciseAction.Builder newExerciseActionBuilder() {
    return new ExerciseActionImpl.BuilderImpl();
  }

  public static ExerciseGym.Builder newExerciseGymBuilder() {
    return new ExerciseGymImpl.BuilderImpl();
  }

  public static ExercisePlan.Builder newExercisePlanBuilder() {
    return new ExercisePlanImpl.BuilderImpl();
  }

  public static ExhibitionEvent.Builder newExhibitionEventBuilder() {
    return new ExhibitionEventImpl.BuilderImpl();
  }

  public static FastFoodRestaurant.Builder newFastFoodRestaurantBuilder() {
    return new FastFoodRestaurantImpl.BuilderImpl();
  }

  public static Festival.Builder newFestivalBuilder() {
    return new FestivalImpl.BuilderImpl();
  }

  public static FilmAction.Builder newFilmActionBuilder() {
    return new FilmActionImpl.BuilderImpl();
  }

  public static FinancialService.Builder newFinancialServiceBuilder() {
    return new FinancialServiceImpl.BuilderImpl();
  }

  public static FindAction.Builder newFindActionBuilder() {
    return new FindActionImpl.BuilderImpl();
  }

  public static FireStation.Builder newFireStationBuilder() {
    return new FireStationImpl.BuilderImpl();
  }

  public static Flight.Builder newFlightBuilder() {
    return new FlightImpl.BuilderImpl();
  }

  public static FlightReservation.Builder newFlightReservationBuilder() {
    return new FlightReservationImpl.BuilderImpl();
  }

  public static Florist.Builder newFloristBuilder() {
    return new FloristImpl.BuilderImpl();
  }

  public static FollowAction.Builder newFollowActionBuilder() {
    return new FollowActionImpl.BuilderImpl();
  }

  public static FoodEstablishment.Builder newFoodEstablishmentBuilder() {
    return new FoodEstablishmentImpl.BuilderImpl();
  }

  public static FoodEstablishmentReservation.Builder newFoodEstablishmentReservationBuilder() {
    return new FoodEstablishmentReservationImpl.BuilderImpl();
  }

  public static FoodEvent.Builder newFoodEventBuilder() {
    return new FoodEventImpl.BuilderImpl();
  }

  public static FurnitureStore.Builder newFurnitureStoreBuilder() {
    return new FurnitureStoreImpl.BuilderImpl();
  }

  public static Game.Builder newGameBuilder() {
    return new GameImpl.BuilderImpl();
  }

  public static GameServer.Builder newGameServerBuilder() {
    return new GameServerImpl.BuilderImpl();
  }

  public static GardenStore.Builder newGardenStoreBuilder() {
    return new GardenStoreImpl.BuilderImpl();
  }

  public static GasStation.Builder newGasStationBuilder() {
    return new GasStationImpl.BuilderImpl();
  }

  public static GatedResidenceCommunity.Builder newGatedResidenceCommunityBuilder() {
    return new GatedResidenceCommunityImpl.BuilderImpl();
  }

  public static GeneralContractor.Builder newGeneralContractorBuilder() {
    return new GeneralContractorImpl.BuilderImpl();
  }

  public static GeoCircle.Builder newGeoCircleBuilder() {
    return new GeoCircleImpl.BuilderImpl();
  }

  public static GeoCoordinates.Builder newGeoCoordinatesBuilder() {
    return new GeoCoordinatesImpl.BuilderImpl();
  }

  public static GeoShape.Builder newGeoShapeBuilder() {
    return new GeoShapeImpl.BuilderImpl();
  }

  public static GiveAction.Builder newGiveActionBuilder() {
    return new GiveActionImpl.BuilderImpl();
  }

  public static GolfCourse.Builder newGolfCourseBuilder() {
    return new GolfCourseImpl.BuilderImpl();
  }

  public static GovernmentBuilding.Builder newGovernmentBuildingBuilder() {
    return new GovernmentBuildingImpl.BuilderImpl();
  }

  public static GovernmentOffice.Builder newGovernmentOfficeBuilder() {
    return new GovernmentOfficeImpl.BuilderImpl();
  }

  public static GovernmentOrganization.Builder newGovernmentOrganizationBuilder() {
    return new GovernmentOrganizationImpl.BuilderImpl();
  }

  public static GovernmentPermit.Builder newGovernmentPermitBuilder() {
    return new GovernmentPermitImpl.BuilderImpl();
  }

  public static GovernmentService.Builder newGovernmentServiceBuilder() {
    return new GovernmentServiceImpl.BuilderImpl();
  }

  public static GroceryStore.Builder newGroceryStoreBuilder() {
    return new GroceryStoreImpl.BuilderImpl();
  }

  public static HVACBusiness.Builder newHVACBusinessBuilder() {
    return new HVACBusinessImpl.BuilderImpl();
  }

  public static HairSalon.Builder newHairSalonBuilder() {
    return new HairSalonImpl.BuilderImpl();
  }

  public static HardwareStore.Builder newHardwareStoreBuilder() {
    return new HardwareStoreImpl.BuilderImpl();
  }

  public static HealthAndBeautyBusiness.Builder newHealthAndBeautyBusinessBuilder() {
    return new HealthAndBeautyBusinessImpl.BuilderImpl();
  }

  public static HealthClub.Builder newHealthClubBuilder() {
    return new HealthClubImpl.BuilderImpl();
  }

  public static HighSchool.Builder newHighSchoolBuilder() {
    return new HighSchoolImpl.BuilderImpl();
  }

  public static HinduTemple.Builder newHinduTempleBuilder() {
    return new HinduTempleImpl.BuilderImpl();
  }

  public static HobbyShop.Builder newHobbyShopBuilder() {
    return new HobbyShopImpl.BuilderImpl();
  }

  public static HomeAndConstructionBusiness.Builder newHomeAndConstructionBusinessBuilder() {
    return new HomeAndConstructionBusinessImpl.BuilderImpl();
  }

  public static HomeGoodsStore.Builder newHomeGoodsStoreBuilder() {
    return new HomeGoodsStoreImpl.BuilderImpl();
  }

  public static Hospital.Builder newHospitalBuilder() {
    return new HospitalImpl.BuilderImpl();
  }

  public static Hostel.Builder newHostelBuilder() {
    return new HostelImpl.BuilderImpl();
  }

  public static Hotel.Builder newHotelBuilder() {
    return new HotelImpl.BuilderImpl();
  }

  public static HousePainter.Builder newHousePainterBuilder() {
    return new HousePainterImpl.BuilderImpl();
  }

  public static IceCreamShop.Builder newIceCreamShopBuilder() {
    return new IceCreamShopImpl.BuilderImpl();
  }

  public static IgnoreAction.Builder newIgnoreActionBuilder() {
    return new IgnoreActionImpl.BuilderImpl();
  }

  public static ImageGallery.Builder newImageGalleryBuilder() {
    return new ImageGalleryImpl.BuilderImpl();
  }

  public static ImageObject.Builder newImageObjectBuilder() {
    return new ImageObjectImpl.BuilderImpl();
  }

  public static ImagingTest.Builder newImagingTestBuilder() {
    return new ImagingTestImpl.BuilderImpl();
  }

  public static IndividualProduct.Builder newIndividualProductBuilder() {
    return new IndividualProductImpl.BuilderImpl();
  }

  public static InfectiousDisease.Builder newInfectiousDiseaseBuilder() {
    return new InfectiousDiseaseImpl.BuilderImpl();
  }

  public static InformAction.Builder newInformActionBuilder() {
    return new InformActionImpl.BuilderImpl();
  }

  public static InsertAction.Builder newInsertActionBuilder() {
    return new InsertActionImpl.BuilderImpl();
  }

  public static InstallAction.Builder newInstallActionBuilder() {
    return new InstallActionImpl.BuilderImpl();
  }

  public static InsuranceAgency.Builder newInsuranceAgencyBuilder() {
    return new InsuranceAgencyImpl.BuilderImpl();
  }

  public static Intangible.Builder newIntangibleBuilder() {
    return new IntangibleImpl.BuilderImpl();
  }

  public static InteractAction.Builder newInteractActionBuilder() {
    return new InteractActionImpl.BuilderImpl();
  }

  public static InteractionCounter.Builder newInteractionCounterBuilder() {
    return new InteractionCounterImpl.BuilderImpl();
  }

  public static InternetCafe.Builder newInternetCafeBuilder() {
    return new InternetCafeImpl.BuilderImpl();
  }

  public static InviteAction.Builder newInviteActionBuilder() {
    return new InviteActionImpl.BuilderImpl();
  }

  public static Invoice.Builder newInvoiceBuilder() {
    return new InvoiceImpl.BuilderImpl();
  }

  public static ItemList.Builder newItemListBuilder() {
    return new ItemListImpl.BuilderImpl();
  }

  public static ItemPage.Builder newItemPageBuilder() {
    return new ItemPageImpl.BuilderImpl();
  }

  public static JewelryStore.Builder newJewelryStoreBuilder() {
    return new JewelryStoreImpl.BuilderImpl();
  }

  public static JobPosting.Builder newJobPostingBuilder() {
    return new JobPostingImpl.BuilderImpl();
  }

  public static JoinAction.Builder newJoinActionBuilder() {
    return new JoinActionImpl.BuilderImpl();
  }

  public static Joint.Builder newJointBuilder() {
    return new JointImpl.BuilderImpl();
  }

  public static LakeBodyOfWater.Builder newLakeBodyOfWaterBuilder() {
    return new LakeBodyOfWaterImpl.BuilderImpl();
  }

  public static Landform.Builder newLandformBuilder() {
    return new LandformImpl.BuilderImpl();
  }

  public static LandmarksOrHistoricalBuildings.Builder newLandmarksOrHistoricalBuildingsBuilder() {
    return new LandmarksOrHistoricalBuildingsImpl.BuilderImpl();
  }

  public static Language.Builder newLanguageBuilder() {
    return new LanguageImpl.BuilderImpl();
  }

  public static LeaveAction.Builder newLeaveActionBuilder() {
    return new LeaveActionImpl.BuilderImpl();
  }

  public static LegalService.Builder newLegalServiceBuilder() {
    return new LegalServiceImpl.BuilderImpl();
  }

  public static LegislativeBuilding.Builder newLegislativeBuildingBuilder() {
    return new LegislativeBuildingImpl.BuilderImpl();
  }

  public static LendAction.Builder newLendActionBuilder() {
    return new LendActionImpl.BuilderImpl();
  }

  public static Library.Builder newLibraryBuilder() {
    return new LibraryImpl.BuilderImpl();
  }

  public static LifestyleModification.Builder newLifestyleModificationBuilder() {
    return new LifestyleModificationImpl.BuilderImpl();
  }

  public static Ligament.Builder newLigamentBuilder() {
    return new LigamentImpl.BuilderImpl();
  }

  public static LikeAction.Builder newLikeActionBuilder() {
    return new LikeActionImpl.BuilderImpl();
  }

  public static LiquorStore.Builder newLiquorStoreBuilder() {
    return new LiquorStoreImpl.BuilderImpl();
  }

  public static ListItem.Builder newListItemBuilder() {
    return new ListItemImpl.BuilderImpl();
  }

  public static ListenAction.Builder newListenActionBuilder() {
    return new ListenActionImpl.BuilderImpl();
  }

  public static LiteraryEvent.Builder newLiteraryEventBuilder() {
    return new LiteraryEventImpl.BuilderImpl();
  }

  public static LiveBlogPosting.Builder newLiveBlogPostingBuilder() {
    return new LiveBlogPostingImpl.BuilderImpl();
  }

  public static LocalBusiness.Builder newLocalBusinessBuilder() {
    return new LocalBusinessImpl.BuilderImpl();
  }

  public static LocalBusinessCivicStructureCommon.Builder
      newLocalBusinessCivicStructureCommonBuilder() {
    return new LocalBusinessCivicStructureCommonImpl.BuilderImpl();
  }

  public static Locksmith.Builder newLocksmithBuilder() {
    return new LocksmithImpl.BuilderImpl();
  }

  public static LodgingBusiness.Builder newLodgingBusinessBuilder() {
    return new LodgingBusinessImpl.BuilderImpl();
  }

  public static LodgingReservation.Builder newLodgingReservationBuilder() {
    return new LodgingReservationImpl.BuilderImpl();
  }

  public static LoseAction.Builder newLoseActionBuilder() {
    return new LoseActionImpl.BuilderImpl();
  }

  public static LymphaticVessel.Builder newLymphaticVesselBuilder() {
    return new LymphaticVesselImpl.BuilderImpl();
  }

  public static Map.Builder newMapBuilder() {
    return new MapImpl.BuilderImpl();
  }

  public static MarryAction.Builder newMarryActionBuilder() {
    return new MarryActionImpl.BuilderImpl();
  }

  public static Mass.Builder newMassBuilder() {
    return new MassImpl.BuilderImpl();
  }

  public static MaximumDoseSchedule.Builder newMaximumDoseScheduleBuilder() {
    return new MaximumDoseScheduleImpl.BuilderImpl();
  }

  public static MediaObject.Builder newMediaObjectBuilder() {
    return new MediaObjectImpl.BuilderImpl();
  }

  public static MedicalCause.Builder newMedicalCauseBuilder() {
    return new MedicalCauseImpl.BuilderImpl();
  }

  public static MedicalClinic.Builder newMedicalClinicBuilder() {
    return new MedicalClinicImpl.BuilderImpl();
  }

  public static MedicalCode.Builder newMedicalCodeBuilder() {
    return new MedicalCodeImpl.BuilderImpl();
  }

  public static MedicalCondition.Builder newMedicalConditionBuilder() {
    return new MedicalConditionImpl.BuilderImpl();
  }

  public static MedicalConditionStage.Builder newMedicalConditionStageBuilder() {
    return new MedicalConditionStageImpl.BuilderImpl();
  }

  public static MedicalContraindication.Builder newMedicalContraindicationBuilder() {
    return new MedicalContraindicationImpl.BuilderImpl();
  }

  public static MedicalDevice.Builder newMedicalDeviceBuilder() {
    return new MedicalDeviceImpl.BuilderImpl();
  }

  public static MedicalEntity.Builder newMedicalEntityBuilder() {
    return new MedicalEntityImpl.BuilderImpl();
  }

  public static MedicalGuideline.Builder newMedicalGuidelineBuilder() {
    return new MedicalGuidelineImpl.BuilderImpl();
  }

  public static MedicalGuidelineContraindication.Builder
      newMedicalGuidelineContraindicationBuilder() {
    return new MedicalGuidelineContraindicationImpl.BuilderImpl();
  }

  public static MedicalGuidelineRecommendation.Builder newMedicalGuidelineRecommendationBuilder() {
    return new MedicalGuidelineRecommendationImpl.BuilderImpl();
  }

  public static MedicalIndication.Builder newMedicalIndicationBuilder() {
    return new MedicalIndicationImpl.BuilderImpl();
  }

  public static MedicalIntangible.Builder newMedicalIntangibleBuilder() {
    return new MedicalIntangibleImpl.BuilderImpl();
  }

  public static MedicalObservationalStudy.Builder newMedicalObservationalStudyBuilder() {
    return new MedicalObservationalStudyImpl.BuilderImpl();
  }

  public static MedicalOrganization.Builder newMedicalOrganizationBuilder() {
    return new MedicalOrganizationImpl.BuilderImpl();
  }

  public static MedicalProcedure.Builder newMedicalProcedureBuilder() {
    return new MedicalProcedureImpl.BuilderImpl();
  }

  public static MedicalRiskCalculator.Builder newMedicalRiskCalculatorBuilder() {
    return new MedicalRiskCalculatorImpl.BuilderImpl();
  }

  public static MedicalRiskEstimator.Builder newMedicalRiskEstimatorBuilder() {
    return new MedicalRiskEstimatorImpl.BuilderImpl();
  }

  public static MedicalRiskFactor.Builder newMedicalRiskFactorBuilder() {
    return new MedicalRiskFactorImpl.BuilderImpl();
  }

  public static MedicalRiskScore.Builder newMedicalRiskScoreBuilder() {
    return new MedicalRiskScoreImpl.BuilderImpl();
  }

  public static MedicalScholarlyArticle.Builder newMedicalScholarlyArticleBuilder() {
    return new MedicalScholarlyArticleImpl.BuilderImpl();
  }

  public static MedicalSign.Builder newMedicalSignBuilder() {
    return new MedicalSignImpl.BuilderImpl();
  }

  public static MedicalSignOrSymptom.Builder newMedicalSignOrSymptomBuilder() {
    return new MedicalSignOrSymptomImpl.BuilderImpl();
  }

  public static MedicalStudy.Builder newMedicalStudyBuilder() {
    return new MedicalStudyImpl.BuilderImpl();
  }

  public static MedicalSymptom.Builder newMedicalSymptomBuilder() {
    return new MedicalSymptomImpl.BuilderImpl();
  }

  public static MedicalTest.Builder newMedicalTestBuilder() {
    return new MedicalTestImpl.BuilderImpl();
  }

  public static MedicalTestPanel.Builder newMedicalTestPanelBuilder() {
    return new MedicalTestPanelImpl.BuilderImpl();
  }

  public static MedicalTherapy.Builder newMedicalTherapyBuilder() {
    return new MedicalTherapyImpl.BuilderImpl();
  }

  public static MedicalTrial.Builder newMedicalTrialBuilder() {
    return new MedicalTrialImpl.BuilderImpl();
  }

  public static MedicalWebPage.Builder newMedicalWebPageBuilder() {
    return new MedicalWebPageImpl.BuilderImpl();
  }

  public static MensClothingStore.Builder newMensClothingStoreBuilder() {
    return new MensClothingStoreImpl.BuilderImpl();
  }

  public static MiddleSchool.Builder newMiddleSchoolBuilder() {
    return new MiddleSchoolImpl.BuilderImpl();
  }

  public static MobileApplication.Builder newMobileApplicationBuilder() {
    return new MobileApplicationImpl.BuilderImpl();
  }

  public static MobilePhoneStore.Builder newMobilePhoneStoreBuilder() {
    return new MobilePhoneStoreImpl.BuilderImpl();
  }

  public static Mosque.Builder newMosqueBuilder() {
    return new MosqueImpl.BuilderImpl();
  }

  public static Motel.Builder newMotelBuilder() {
    return new MotelImpl.BuilderImpl();
  }

  public static MotorcycleDealer.Builder newMotorcycleDealerBuilder() {
    return new MotorcycleDealerImpl.BuilderImpl();
  }

  public static MotorcycleRepair.Builder newMotorcycleRepairBuilder() {
    return new MotorcycleRepairImpl.BuilderImpl();
  }

  public static Mountain.Builder newMountainBuilder() {
    return new MountainImpl.BuilderImpl();
  }

  public static MoveAction.Builder newMoveActionBuilder() {
    return new MoveActionImpl.BuilderImpl();
  }

  public static Movie.Builder newMovieBuilder() {
    return new MovieImpl.BuilderImpl();
  }

  public static MovieClip.Builder newMovieClipBuilder() {
    return new MovieClipImpl.BuilderImpl();
  }

  public static MovieRentalStore.Builder newMovieRentalStoreBuilder() {
    return new MovieRentalStoreImpl.BuilderImpl();
  }

  public static MovieSeries.Builder newMovieSeriesBuilder() {
    return new MovieSeriesImpl.BuilderImpl();
  }

  public static MovieTheater.Builder newMovieTheaterBuilder() {
    return new MovieTheaterImpl.BuilderImpl();
  }

  public static MovingCompany.Builder newMovingCompanyBuilder() {
    return new MovingCompanyImpl.BuilderImpl();
  }

  public static Muscle.Builder newMuscleBuilder() {
    return new MuscleImpl.BuilderImpl();
  }

  public static Museum.Builder newMuseumBuilder() {
    return new MuseumImpl.BuilderImpl();
  }

  public static MusicAlbum.Builder newMusicAlbumBuilder() {
    return new MusicAlbumImpl.BuilderImpl();
  }

  public static MusicComposition.Builder newMusicCompositionBuilder() {
    return new MusicCompositionImpl.BuilderImpl();
  }

  public static MusicEvent.Builder newMusicEventBuilder() {
    return new MusicEventImpl.BuilderImpl();
  }

  public static MusicGroup.Builder newMusicGroupBuilder() {
    return new MusicGroupImpl.BuilderImpl();
  }

  public static MusicPlaylist.Builder newMusicPlaylistBuilder() {
    return new MusicPlaylistImpl.BuilderImpl();
  }

  public static MusicRecording.Builder newMusicRecordingBuilder() {
    return new MusicRecordingImpl.BuilderImpl();
  }

  public static MusicRelease.Builder newMusicReleaseBuilder() {
    return new MusicReleaseImpl.BuilderImpl();
  }

  public static MusicStore.Builder newMusicStoreBuilder() {
    return new MusicStoreImpl.BuilderImpl();
  }

  public static MusicVenue.Builder newMusicVenueBuilder() {
    return new MusicVenueImpl.BuilderImpl();
  }

  public static MusicVideoObject.Builder newMusicVideoObjectBuilder() {
    return new MusicVideoObjectImpl.BuilderImpl();
  }

  public static NGO.Builder newNGOBuilder() {
    return new NGOImpl.BuilderImpl();
  }

  public static NailSalon.Builder newNailSalonBuilder() {
    return new NailSalonImpl.BuilderImpl();
  }

  public static Nerve.Builder newNerveBuilder() {
    return new NerveImpl.BuilderImpl();
  }

  public static NewsArticle.Builder newNewsArticleBuilder() {
    return new NewsArticleImpl.BuilderImpl();
  }

  public static NightClub.Builder newNightClubBuilder() {
    return new NightClubImpl.BuilderImpl();
  }

  public static Notary.Builder newNotaryBuilder() {
    return new NotaryImpl.BuilderImpl();
  }

  public static NutritionInformation.Builder newNutritionInformationBuilder() {
    return new NutritionInformationImpl.BuilderImpl();
  }

  public static OceanBodyOfWater.Builder newOceanBodyOfWaterBuilder() {
    return new OceanBodyOfWaterImpl.BuilderImpl();
  }

  public static Offer.Builder newOfferBuilder() {
    return new OfferImpl.BuilderImpl();
  }

  public static OfferCatalog.Builder newOfferCatalogBuilder() {
    return new OfferCatalogImpl.BuilderImpl();
  }

  public static OfficeEquipmentStore.Builder newOfficeEquipmentStoreBuilder() {
    return new OfficeEquipmentStoreImpl.BuilderImpl();
  }

  public static OnDemandEvent.Builder newOnDemandEventBuilder() {
    return new OnDemandEventImpl.BuilderImpl();
  }

  public static OpeningHoursSpecification.Builder newOpeningHoursSpecificationBuilder() {
    return new OpeningHoursSpecificationImpl.BuilderImpl();
  }

  public static Optician.Builder newOpticianBuilder() {
    return new OpticianImpl.BuilderImpl();
  }

  public static Order.Builder newOrderBuilder() {
    return new OrderImpl.BuilderImpl();
  }

  public static OrderAction.Builder newOrderActionBuilder() {
    return new OrderActionImpl.BuilderImpl();
  }

  public static OrderItem.Builder newOrderItemBuilder() {
    return new OrderItemImpl.BuilderImpl();
  }

  public static Organization.Builder newOrganizationBuilder() {
    return new OrganizationImpl.BuilderImpl();
  }

  public static OrganizationRole.Builder newOrganizationRoleBuilder() {
    return new OrganizationRoleImpl.BuilderImpl();
  }

  public static OrganizeAction.Builder newOrganizeActionBuilder() {
    return new OrganizeActionImpl.BuilderImpl();
  }

  public static OutletStore.Builder newOutletStoreBuilder() {
    return new OutletStoreImpl.BuilderImpl();
  }

  public static OwnershipInfo.Builder newOwnershipInfoBuilder() {
    return new OwnershipInfoImpl.BuilderImpl();
  }

  public static PaintAction.Builder newPaintActionBuilder() {
    return new PaintActionImpl.BuilderImpl();
  }

  public static Painting.Builder newPaintingBuilder() {
    return new PaintingImpl.BuilderImpl();
  }

  public static PalliativeProcedure.Builder newPalliativeProcedureBuilder() {
    return new PalliativeProcedureImpl.BuilderImpl();
  }

  public static ParcelDelivery.Builder newParcelDeliveryBuilder() {
    return new ParcelDeliveryImpl.BuilderImpl();
  }

  public static ParentAudience.Builder newParentAudienceBuilder() {
    return new ParentAudienceImpl.BuilderImpl();
  }

  public static Park.Builder newParkBuilder() {
    return new ParkImpl.BuilderImpl();
  }

  public static ParkingFacility.Builder newParkingFacilityBuilder() {
    return new ParkingFacilityImpl.BuilderImpl();
  }

  public static PathologyTest.Builder newPathologyTestBuilder() {
    return new PathologyTestImpl.BuilderImpl();
  }

  public static PawnShop.Builder newPawnShopBuilder() {
    return new PawnShopImpl.BuilderImpl();
  }

  public static PayAction.Builder newPayActionBuilder() {
    return new PayActionImpl.BuilderImpl();
  }

  public static PaymentChargeSpecification.Builder newPaymentChargeSpecificationBuilder() {
    return new PaymentChargeSpecificationImpl.BuilderImpl();
  }

  public static PeopleAudience.Builder newPeopleAudienceBuilder() {
    return new PeopleAudienceImpl.BuilderImpl();
  }

  public static PerformAction.Builder newPerformActionBuilder() {
    return new PerformActionImpl.BuilderImpl();
  }

  public static PerformanceRole.Builder newPerformanceRoleBuilder() {
    return new PerformanceRoleImpl.BuilderImpl();
  }

  public static PerformingArtsTheater.Builder newPerformingArtsTheaterBuilder() {
    return new PerformingArtsTheaterImpl.BuilderImpl();
  }

  public static PerformingGroup.Builder newPerformingGroupBuilder() {
    return new PerformingGroupImpl.BuilderImpl();
  }

  public static Periodical.Builder newPeriodicalBuilder() {
    return new PeriodicalImpl.BuilderImpl();
  }

  public static Permit.Builder newPermitBuilder() {
    return new PermitImpl.BuilderImpl();
  }

  public static Person.Builder newPersonBuilder() {
    return new PersonImpl.BuilderImpl();
  }

  public static PetStore.Builder newPetStoreBuilder() {
    return new PetStoreImpl.BuilderImpl();
  }

  public static Pharmacy.Builder newPharmacyBuilder() {
    return new PharmacyImpl.BuilderImpl();
  }

  public static Photograph.Builder newPhotographBuilder() {
    return new PhotographImpl.BuilderImpl();
  }

  public static PhotographAction.Builder newPhotographActionBuilder() {
    return new PhotographActionImpl.BuilderImpl();
  }

  public static PhysicalActivity.Builder newPhysicalActivityBuilder() {
    return new PhysicalActivityImpl.BuilderImpl();
  }

  public static PhysicalTherapy.Builder newPhysicalTherapyBuilder() {
    return new PhysicalTherapyImpl.BuilderImpl();
  }

  public static Physician.Builder newPhysicianBuilder() {
    return new PhysicianImpl.BuilderImpl();
  }

  public static Place.Builder newPlaceBuilder() {
    return new PlaceImpl.BuilderImpl();
  }

  public static PlaceOfWorship.Builder newPlaceOfWorshipBuilder() {
    return new PlaceOfWorshipImpl.BuilderImpl();
  }

  public static PlaceOrganizationCommon.Builder newPlaceOrganizationCommonBuilder() {
    return new PlaceOrganizationCommonImpl.BuilderImpl();
  }

  public static PlanAction.Builder newPlanActionBuilder() {
    return new PlanActionImpl.BuilderImpl();
  }

  public static PlayAction.Builder newPlayActionBuilder() {
    return new PlayActionImpl.BuilderImpl();
  }

  public static Playground.Builder newPlaygroundBuilder() {
    return new PlaygroundImpl.BuilderImpl();
  }

  public static Plumber.Builder newPlumberBuilder() {
    return new PlumberImpl.BuilderImpl();
  }

  public static PoliceStation.Builder newPoliceStationBuilder() {
    return new PoliceStationImpl.BuilderImpl();
  }

  public static Pond.Builder newPondBuilder() {
    return new PondImpl.BuilderImpl();
  }

  public static PostOffice.Builder newPostOfficeBuilder() {
    return new PostOfficeImpl.BuilderImpl();
  }

  public static PostalAddress.Builder newPostalAddressBuilder() {
    return new PostalAddressImpl.BuilderImpl();
  }

  public static PrependAction.Builder newPrependActionBuilder() {
    return new PrependActionImpl.BuilderImpl();
  }

  public static Preschool.Builder newPreschoolBuilder() {
    return new PreschoolImpl.BuilderImpl();
  }

  public static PreventionIndication.Builder newPreventionIndicationBuilder() {
    return new PreventionIndicationImpl.BuilderImpl();
  }

  public static PriceSpecification.Builder newPriceSpecificationBuilder() {
    return new PriceSpecificationImpl.BuilderImpl();
  }

  public static Product.Builder newProductBuilder() {
    return new ProductImpl.BuilderImpl();
  }

  public static ProductModel.Builder newProductModelBuilder() {
    return new ProductModelImpl.BuilderImpl();
  }

  public static ProfessionalService.Builder newProfessionalServiceBuilder() {
    return new ProfessionalServiceImpl.BuilderImpl();
  }

  public static ProfilePage.Builder newProfilePageBuilder() {
    return new ProfilePageImpl.BuilderImpl();
  }

  public static ProgramMembership.Builder newProgramMembershipBuilder() {
    return new ProgramMembershipImpl.BuilderImpl();
  }

  public static Property.Builder newPropertyBuilder() {
    return new PropertyImpl.BuilderImpl();
  }

  public static PropertyValue.Builder newPropertyValueBuilder() {
    return new PropertyValueImpl.BuilderImpl();
  }

  public static PropertyValueSpecification.Builder newPropertyValueSpecificationBuilder() {
    return new PropertyValueSpecificationImpl.BuilderImpl();
  }

  public static PsychologicalTreatment.Builder newPsychologicalTreatmentBuilder() {
    return new PsychologicalTreatmentImpl.BuilderImpl();
  }

  public static PublicSwimmingPool.Builder newPublicSwimmingPoolBuilder() {
    return new PublicSwimmingPoolImpl.BuilderImpl();
  }

  public static PublicationEvent.Builder newPublicationEventBuilder() {
    return new PublicationEventImpl.BuilderImpl();
  }

  public static PublicationIssue.Builder newPublicationIssueBuilder() {
    return new PublicationIssueImpl.BuilderImpl();
  }

  public static PublicationVolume.Builder newPublicationVolumeBuilder() {
    return new PublicationVolumeImpl.BuilderImpl();
  }

  public static QAPage.Builder newQAPageBuilder() {
    return new QAPageImpl.BuilderImpl();
  }

  public static QuantitativeValue.Builder newQuantitativeValueBuilder() {
    return new QuantitativeValueImpl.BuilderImpl();
  }

  public static Quantity.Builder newQuantityBuilder() {
    return new QuantityImpl.BuilderImpl();
  }

  public static Question.Builder newQuestionBuilder() {
    return new QuestionImpl.BuilderImpl();
  }

  public static QuoteAction.Builder newQuoteActionBuilder() {
    return new QuoteActionImpl.BuilderImpl();
  }

  public static RVPark.Builder newRVParkBuilder() {
    return new RVParkImpl.BuilderImpl();
  }

  public static RadiationTherapy.Builder newRadiationTherapyBuilder() {
    return new RadiationTherapyImpl.BuilderImpl();
  }

  public static RadioChannel.Builder newRadioChannelBuilder() {
    return new RadioChannelImpl.BuilderImpl();
  }

  public static RadioClip.Builder newRadioClipBuilder() {
    return new RadioClipImpl.BuilderImpl();
  }

  public static RadioEpisode.Builder newRadioEpisodeBuilder() {
    return new RadioEpisodeImpl.BuilderImpl();
  }

  public static RadioSeason.Builder newRadioSeasonBuilder() {
    return new RadioSeasonImpl.BuilderImpl();
  }

  public static RadioSeries.Builder newRadioSeriesBuilder() {
    return new RadioSeriesImpl.BuilderImpl();
  }

  public static RadioStation.Builder newRadioStationBuilder() {
    return new RadioStationImpl.BuilderImpl();
  }

  public static Rating.Builder newRatingBuilder() {
    return new RatingImpl.BuilderImpl();
  }

  public static ReactAction.Builder newReactActionBuilder() {
    return new ReactActionImpl.BuilderImpl();
  }

  public static ReadAction.Builder newReadActionBuilder() {
    return new ReadActionImpl.BuilderImpl();
  }

  public static RealEstateAgent.Builder newRealEstateAgentBuilder() {
    return new RealEstateAgentImpl.BuilderImpl();
  }

  public static ReceiveAction.Builder newReceiveActionBuilder() {
    return new ReceiveActionImpl.BuilderImpl();
  }

  public static Recipe.Builder newRecipeBuilder() {
    return new RecipeImpl.BuilderImpl();
  }

  public static RecommendedDoseSchedule.Builder newRecommendedDoseScheduleBuilder() {
    return new RecommendedDoseScheduleImpl.BuilderImpl();
  }

  public static RecyclingCenter.Builder newRecyclingCenterBuilder() {
    return new RecyclingCenterImpl.BuilderImpl();
  }

  public static RegisterAction.Builder newRegisterActionBuilder() {
    return new RegisterActionImpl.BuilderImpl();
  }

  public static RejectAction.Builder newRejectActionBuilder() {
    return new RejectActionImpl.BuilderImpl();
  }

  public static RentAction.Builder newRentActionBuilder() {
    return new RentActionImpl.BuilderImpl();
  }

  public static RentalCarReservation.Builder newRentalCarReservationBuilder() {
    return new RentalCarReservationImpl.BuilderImpl();
  }

  public static ReplaceAction.Builder newReplaceActionBuilder() {
    return new ReplaceActionImpl.BuilderImpl();
  }

  public static ReplyAction.Builder newReplyActionBuilder() {
    return new ReplyActionImpl.BuilderImpl();
  }

  public static Report.Builder newReportBuilder() {
    return new ReportImpl.BuilderImpl();
  }

  public static ReportedDoseSchedule.Builder newReportedDoseScheduleBuilder() {
    return new ReportedDoseScheduleImpl.BuilderImpl();
  }

  public static Reservation.Builder newReservationBuilder() {
    return new ReservationImpl.BuilderImpl();
  }

  public static ReservationPackage.Builder newReservationPackageBuilder() {
    return new ReservationPackageImpl.BuilderImpl();
  }

  public static ReserveAction.Builder newReserveActionBuilder() {
    return new ReserveActionImpl.BuilderImpl();
  }

  public static Reservoir.Builder newReservoirBuilder() {
    return new ReservoirImpl.BuilderImpl();
  }

  public static Residence.Builder newResidenceBuilder() {
    return new ResidenceImpl.BuilderImpl();
  }

  public static Restaurant.Builder newRestaurantBuilder() {
    return new RestaurantImpl.BuilderImpl();
  }

  public static ResumeAction.Builder newResumeActionBuilder() {
    return new ResumeActionImpl.BuilderImpl();
  }

  public static ReturnAction.Builder newReturnActionBuilder() {
    return new ReturnActionImpl.BuilderImpl();
  }

  public static Review.Builder newReviewBuilder() {
    return new ReviewImpl.BuilderImpl();
  }

  public static ReviewAction.Builder newReviewActionBuilder() {
    return new ReviewActionImpl.BuilderImpl();
  }

  public static RiverBodyOfWater.Builder newRiverBodyOfWaterBuilder() {
    return new RiverBodyOfWaterImpl.BuilderImpl();
  }

  public static Role.Builder newRoleBuilder() {
    return new RoleImpl.BuilderImpl();
  }

  public static RoofingContractor.Builder newRoofingContractorBuilder() {
    return new RoofingContractorImpl.BuilderImpl();
  }

  public static RsvpAction.Builder newRsvpActionBuilder() {
    return new RsvpActionImpl.BuilderImpl();
  }

  public static SaleEvent.Builder newSaleEventBuilder() {
    return new SaleEventImpl.BuilderImpl();
  }

  public static ScheduleAction.Builder newScheduleActionBuilder() {
    return new ScheduleActionImpl.BuilderImpl();
  }

  public static ScholarlyArticle.Builder newScholarlyArticleBuilder() {
    return new ScholarlyArticleImpl.BuilderImpl();
  }

  public static School.Builder newSchoolBuilder() {
    return new SchoolImpl.BuilderImpl();
  }

  public static ScreeningEvent.Builder newScreeningEventBuilder() {
    return new ScreeningEventImpl.BuilderImpl();
  }

  public static Sculpture.Builder newSculptureBuilder() {
    return new SculptureImpl.BuilderImpl();
  }

  public static SeaBodyOfWater.Builder newSeaBodyOfWaterBuilder() {
    return new SeaBodyOfWaterImpl.BuilderImpl();
  }

  public static SearchAction.Builder newSearchActionBuilder() {
    return new SearchActionImpl.BuilderImpl();
  }

  public static SearchResultsPage.Builder newSearchResultsPageBuilder() {
    return new SearchResultsPageImpl.BuilderImpl();
  }

  public static Season.Builder newSeasonBuilder() {
    return new SeasonImpl.BuilderImpl();
  }

  public static Seat.Builder newSeatBuilder() {
    return new SeatImpl.BuilderImpl();
  }

  public static SelfStorage.Builder newSelfStorageBuilder() {
    return new SelfStorageImpl.BuilderImpl();
  }

  public static SellAction.Builder newSellActionBuilder() {
    return new SellActionImpl.BuilderImpl();
  }

  public static SendAction.Builder newSendActionBuilder() {
    return new SendActionImpl.BuilderImpl();
  }

  public static Series.Builder newSeriesBuilder() {
    return new SeriesImpl.BuilderImpl();
  }

  public static Service.Builder newServiceBuilder() {
    return new ServiceImpl.BuilderImpl();
  }

  public static ServiceChannel.Builder newServiceChannelBuilder() {
    return new ServiceChannelImpl.BuilderImpl();
  }

  public static ShareAction.Builder newShareActionBuilder() {
    return new ShareActionImpl.BuilderImpl();
  }

  public static ShoeStore.Builder newShoeStoreBuilder() {
    return new ShoeStoreImpl.BuilderImpl();
  }

  public static ShoppingCenter.Builder newShoppingCenterBuilder() {
    return new ShoppingCenterImpl.BuilderImpl();
  }

  public static SingleFamilyResidence.Builder newSingleFamilyResidenceBuilder() {
    return new SingleFamilyResidenceImpl.BuilderImpl();
  }

  public static SiteNavigationElement.Builder newSiteNavigationElementBuilder() {
    return new SiteNavigationElementImpl.BuilderImpl();
  }

  public static SkiResort.Builder newSkiResortBuilder() {
    return new SkiResortImpl.BuilderImpl();
  }

  public static SocialEvent.Builder newSocialEventBuilder() {
    return new SocialEventImpl.BuilderImpl();
  }

  public static SocialMediaPosting.Builder newSocialMediaPostingBuilder() {
    return new SocialMediaPostingImpl.BuilderImpl();
  }

  public static SoftwareApplication.Builder newSoftwareApplicationBuilder() {
    return new SoftwareApplicationImpl.BuilderImpl();
  }

  public static SoftwareSourceCode.Builder newSoftwareSourceCodeBuilder() {
    return new SoftwareSourceCodeImpl.BuilderImpl();
  }

  public static SomeProducts.Builder newSomeProductsBuilder() {
    return new SomeProductsImpl.BuilderImpl();
  }

  public static SportingGoodsStore.Builder newSportingGoodsStoreBuilder() {
    return new SportingGoodsStoreImpl.BuilderImpl();
  }

  public static SportsActivityLocation.Builder newSportsActivityLocationBuilder() {
    return new SportsActivityLocationImpl.BuilderImpl();
  }

  public static SportsClub.Builder newSportsClubBuilder() {
    return new SportsClubImpl.BuilderImpl();
  }

  public static SportsEvent.Builder newSportsEventBuilder() {
    return new SportsEventImpl.BuilderImpl();
  }

  public static SportsOrganization.Builder newSportsOrganizationBuilder() {
    return new SportsOrganizationImpl.BuilderImpl();
  }

  public static SportsTeam.Builder newSportsTeamBuilder() {
    return new SportsTeamImpl.BuilderImpl();
  }

  public static StadiumOrArena.Builder newStadiumOrArenaBuilder() {
    return new StadiumOrArenaImpl.BuilderImpl();
  }

  public static State.Builder newStateBuilder() {
    return new StateImpl.BuilderImpl();
  }

  public static Store.Builder newStoreBuilder() {
    return new StoreImpl.BuilderImpl();
  }

  public static StructuredValue.Builder newStructuredValueBuilder() {
    return new StructuredValueImpl.BuilderImpl();
  }

  public static SubscribeAction.Builder newSubscribeActionBuilder() {
    return new SubscribeActionImpl.BuilderImpl();
  }

  public static SubwayStation.Builder newSubwayStationBuilder() {
    return new SubwayStationImpl.BuilderImpl();
  }

  public static SuperficialAnatomy.Builder newSuperficialAnatomyBuilder() {
    return new SuperficialAnatomyImpl.BuilderImpl();
  }

  public static SuspendAction.Builder newSuspendActionBuilder() {
    return new SuspendActionImpl.BuilderImpl();
  }

  public static Synagogue.Builder newSynagogueBuilder() {
    return new SynagogueImpl.BuilderImpl();
  }

  public static TVClip.Builder newTVClipBuilder() {
    return new TVClipImpl.BuilderImpl();
  }

  public static TVEpisode.Builder newTVEpisodeBuilder() {
    return new TVEpisodeImpl.BuilderImpl();
  }

  public static TVSeason.Builder newTVSeasonBuilder() {
    return new TVSeasonImpl.BuilderImpl();
  }

  public static TVSeries.Builder newTVSeriesBuilder() {
    return new TVSeriesImpl.BuilderImpl();
  }

  public static Table.Builder newTableBuilder() {
    return new TableImpl.BuilderImpl();
  }

  public static TakeAction.Builder newTakeActionBuilder() {
    return new TakeActionImpl.BuilderImpl();
  }

  public static TattooParlor.Builder newTattooParlorBuilder() {
    return new TattooParlorImpl.BuilderImpl();
  }

  public static Taxi.Builder newTaxiBuilder() {
    return new TaxiImpl.BuilderImpl();
  }

  public static TaxiReservation.Builder newTaxiReservationBuilder() {
    return new TaxiReservationImpl.BuilderImpl();
  }

  public static TaxiService.Builder newTaxiServiceBuilder() {
    return new TaxiServiceImpl.BuilderImpl();
  }

  public static TaxiStand.Builder newTaxiStandBuilder() {
    return new TaxiStandImpl.BuilderImpl();
  }

  public static TechArticle.Builder newTechArticleBuilder() {
    return new TechArticleImpl.BuilderImpl();
  }

  public static TelevisionChannel.Builder newTelevisionChannelBuilder() {
    return new TelevisionChannelImpl.BuilderImpl();
  }

  public static TelevisionStation.Builder newTelevisionStationBuilder() {
    return new TelevisionStationImpl.BuilderImpl();
  }

  public static TennisComplex.Builder newTennisComplexBuilder() {
    return new TennisComplexImpl.BuilderImpl();
  }

  public static TheaterEvent.Builder newTheaterEventBuilder() {
    return new TheaterEventImpl.BuilderImpl();
  }

  public static TheaterGroup.Builder newTheaterGroupBuilder() {
    return new TheaterGroupImpl.BuilderImpl();
  }

  public static TherapeuticProcedure.Builder newTherapeuticProcedureBuilder() {
    return new TherapeuticProcedureImpl.BuilderImpl();
  }

  public static Thing.Builder newThingBuilder() {
    return new ThingImpl.BuilderImpl();
  }

  public static Ticket.Builder newTicketBuilder() {
    return new TicketImpl.BuilderImpl();
  }

  public static TieAction.Builder newTieActionBuilder() {
    return new TieActionImpl.BuilderImpl();
  }

  public static TipAction.Builder newTipActionBuilder() {
    return new TipActionImpl.BuilderImpl();
  }

  public static TireShop.Builder newTireShopBuilder() {
    return new TireShopImpl.BuilderImpl();
  }

  public static TouristAttraction.Builder newTouristAttractionBuilder() {
    return new TouristAttractionImpl.BuilderImpl();
  }

  public static TouristInformationCenter.Builder newTouristInformationCenterBuilder() {
    return new TouristInformationCenterImpl.BuilderImpl();
  }

  public static ToyStore.Builder newToyStoreBuilder() {
    return new ToyStoreImpl.BuilderImpl();
  }

  public static TrackAction.Builder newTrackActionBuilder() {
    return new TrackActionImpl.BuilderImpl();
  }

  public static TradeAction.Builder newTradeActionBuilder() {
    return new TradeActionImpl.BuilderImpl();
  }

  public static TrainReservation.Builder newTrainReservationBuilder() {
    return new TrainReservationImpl.BuilderImpl();
  }

  public static TrainStation.Builder newTrainStationBuilder() {
    return new TrainStationImpl.BuilderImpl();
  }

  public static TrainTrip.Builder newTrainTripBuilder() {
    return new TrainTripImpl.BuilderImpl();
  }

  public static TransferAction.Builder newTransferActionBuilder() {
    return new TransferActionImpl.BuilderImpl();
  }

  public static TravelAction.Builder newTravelActionBuilder() {
    return new TravelActionImpl.BuilderImpl();
  }

  public static TravelAgency.Builder newTravelAgencyBuilder() {
    return new TravelAgencyImpl.BuilderImpl();
  }

  public static TreatmentIndication.Builder newTreatmentIndicationBuilder() {
    return new TreatmentIndicationImpl.BuilderImpl();
  }

  public static TypeAndQuantityNode.Builder newTypeAndQuantityNodeBuilder() {
    return new TypeAndQuantityNodeImpl.BuilderImpl();
  }

  public static UnRegisterAction.Builder newUnRegisterActionBuilder() {
    return new UnRegisterActionImpl.BuilderImpl();
  }

  public static UnitPriceSpecification.Builder newUnitPriceSpecificationBuilder() {
    return new UnitPriceSpecificationImpl.BuilderImpl();
  }

  public static UpdateAction.Builder newUpdateActionBuilder() {
    return new UpdateActionImpl.BuilderImpl();
  }

  public static UseAction.Builder newUseActionBuilder() {
    return new UseActionImpl.BuilderImpl();
  }

  public static UserBlocks.Builder newUserBlocksBuilder() {
    return new UserBlocksImpl.BuilderImpl();
  }

  public static UserCheckins.Builder newUserCheckinsBuilder() {
    return new UserCheckinsImpl.BuilderImpl();
  }

  public static UserComments.Builder newUserCommentsBuilder() {
    return new UserCommentsImpl.BuilderImpl();
  }

  public static UserDownloads.Builder newUserDownloadsBuilder() {
    return new UserDownloadsImpl.BuilderImpl();
  }

  public static UserInteraction.Builder newUserInteractionBuilder() {
    return new UserInteractionImpl.BuilderImpl();
  }

  public static UserLikes.Builder newUserLikesBuilder() {
    return new UserLikesImpl.BuilderImpl();
  }

  public static UserPageVisits.Builder newUserPageVisitsBuilder() {
    return new UserPageVisitsImpl.BuilderImpl();
  }

  public static UserPlays.Builder newUserPlaysBuilder() {
    return new UserPlaysImpl.BuilderImpl();
  }

  public static UserPlusOnes.Builder newUserPlusOnesBuilder() {
    return new UserPlusOnesImpl.BuilderImpl();
  }

  public static UserTweets.Builder newUserTweetsBuilder() {
    return new UserTweetsImpl.BuilderImpl();
  }

  public static Vehicle.Builder newVehicleBuilder() {
    return new VehicleImpl.BuilderImpl();
  }

  public static Vein.Builder newVeinBuilder() {
    return new VeinImpl.BuilderImpl();
  }

  public static Vessel.Builder newVesselBuilder() {
    return new VesselImpl.BuilderImpl();
  }

  public static VeterinaryCare.Builder newVeterinaryCareBuilder() {
    return new VeterinaryCareImpl.BuilderImpl();
  }

  public static VideoGallery.Builder newVideoGalleryBuilder() {
    return new VideoGalleryImpl.BuilderImpl();
  }

  public static VideoGame.Builder newVideoGameBuilder() {
    return new VideoGameImpl.BuilderImpl();
  }

  public static VideoGameClip.Builder newVideoGameClipBuilder() {
    return new VideoGameClipImpl.BuilderImpl();
  }

  public static VideoGameSeries.Builder newVideoGameSeriesBuilder() {
    return new VideoGameSeriesImpl.BuilderImpl();
  }

  public static VideoObject.Builder newVideoObjectBuilder() {
    return new VideoObjectImpl.BuilderImpl();
  }

  public static ViewAction.Builder newViewActionBuilder() {
    return new ViewActionImpl.BuilderImpl();
  }

  public static VisualArtsEvent.Builder newVisualArtsEventBuilder() {
    return new VisualArtsEventImpl.BuilderImpl();
  }

  public static VisualArtwork.Builder newVisualArtworkBuilder() {
    return new VisualArtworkImpl.BuilderImpl();
  }

  public static Volcano.Builder newVolcanoBuilder() {
    return new VolcanoImpl.BuilderImpl();
  }

  public static VoteAction.Builder newVoteActionBuilder() {
    return new VoteActionImpl.BuilderImpl();
  }

  public static WPAdBlock.Builder newWPAdBlockBuilder() {
    return new WPAdBlockImpl.BuilderImpl();
  }

  public static WPFooter.Builder newWPFooterBuilder() {
    return new WPFooterImpl.BuilderImpl();
  }

  public static WPHeader.Builder newWPHeaderBuilder() {
    return new WPHeaderImpl.BuilderImpl();
  }

  public static WPSideBar.Builder newWPSideBarBuilder() {
    return new WPSideBarImpl.BuilderImpl();
  }

  public static WantAction.Builder newWantActionBuilder() {
    return new WantActionImpl.BuilderImpl();
  }

  public static WarrantyPromise.Builder newWarrantyPromiseBuilder() {
    return new WarrantyPromiseImpl.BuilderImpl();
  }

  public static WatchAction.Builder newWatchActionBuilder() {
    return new WatchActionImpl.BuilderImpl();
  }

  public static Waterfall.Builder newWaterfallBuilder() {
    return new WaterfallImpl.BuilderImpl();
  }

  public static WearAction.Builder newWearActionBuilder() {
    return new WearActionImpl.BuilderImpl();
  }

  public static WebApplication.Builder newWebApplicationBuilder() {
    return new WebApplicationImpl.BuilderImpl();
  }

  public static WebPage.Builder newWebPageBuilder() {
    return new WebPageImpl.BuilderImpl();
  }

  public static WebPageElement.Builder newWebPageElementBuilder() {
    return new WebPageElementImpl.BuilderImpl();
  }

  public static WebSite.Builder newWebSiteBuilder() {
    return new WebSiteImpl.BuilderImpl();
  }

  public static WholesaleStore.Builder newWholesaleStoreBuilder() {
    return new WholesaleStoreImpl.BuilderImpl();
  }

  public static WinAction.Builder newWinActionBuilder() {
    return new WinActionImpl.BuilderImpl();
  }

  public static Winery.Builder newWineryBuilder() {
    return new WineryImpl.BuilderImpl();
  }

  public static WriteAction.Builder newWriteActionBuilder() {
    return new WriteActionImpl.BuilderImpl();
  }

  public static Zoo.Builder newZooBuilder() {
    return new ZooImpl.BuilderImpl();
  }
}
