/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.schemaorg.core;

/** Constants of type and property names in http://schema.org/. */
public final class CoreConstants {
  public static final String NAMESPACE = "http://schema.org/";

  public static final String PROPERTY_ABOUT = NAMESPACE + "about";

  public static final String PROPERTY_ACCEPTED_ANSWER = NAMESPACE + "acceptedAnswer";

  public static final String PROPERTY_ACCEPTED_OFFER = NAMESPACE + "acceptedOffer";

  public static final String PROPERTY_ACCEPTED_PAYMENT_METHOD = NAMESPACE + "acceptedPaymentMethod";

  public static final String PROPERTY_ACCEPTS_RESERVATIONS = NAMESPACE + "acceptsReservations";

  public static final String PROPERTY_ACCESS_CODE = NAMESPACE + "accessCode";

  public static final String PROPERTY_ACCESSIBILITY_API = NAMESPACE + "accessibilityAPI";

  public static final String PROPERTY_ACCESSIBILITY_CONTROL = NAMESPACE + "accessibilityControl";

  public static final String PROPERTY_ACCESSIBILITY_FEATURE = NAMESPACE + "accessibilityFeature";

  public static final String PROPERTY_ACCESSIBILITY_HAZARD = NAMESPACE + "accessibilityHazard";

  public static final String PROPERTY_ACCOUNT_ID = NAMESPACE + "accountId";

  public static final String PROPERTY_ACCOUNTABLE_PERSON = NAMESPACE + "accountablePerson";

  public static final String PROPERTY_ACQUIRED_FROM = NAMESPACE + "acquiredFrom";

  public static final String PROPERTY_ACTION = NAMESPACE + "action";

  public static final String PROPERTY_ACTION_APPLICATION = NAMESPACE + "actionApplication";

  public static final String PROPERTY_ACTION_OPTION = NAMESPACE + "actionOption";

  public static final String PROPERTY_ACTION_PLATFORM = NAMESPACE + "actionPlatform";

  public static final String PROPERTY_ACTION_STATUS = NAMESPACE + "actionStatus";

  public static final String PROPERTY_ACTIVE_INGREDIENT = NAMESPACE + "activeIngredient";

  public static final String PROPERTY_ACTIVITY_DURATION = NAMESPACE + "activityDuration";

  public static final String PROPERTY_ACTIVITY_FREQUENCY = NAMESPACE + "activityFrequency";

  public static final String PROPERTY_ACTOR = NAMESPACE + "actor";

  public static final String PROPERTY_ACTORS = NAMESPACE + "actors";

  public static final String PROPERTY_ADD_ON = NAMESPACE + "addOn";

  public static final String PROPERTY_ADDITIONAL_NAME = NAMESPACE + "additionalName";

  public static final String PROPERTY_ADDITIONAL_NUMBER_OF_GUESTS =
      NAMESPACE + "additionalNumberOfGuests";

  public static final String PROPERTY_ADDITIONAL_PROPERTY = NAMESPACE + "additionalProperty";

  public static final String PROPERTY_ADDITIONAL_TYPE = NAMESPACE + "additionalType";

  public static final String PROPERTY_ADDITIONAL_VARIABLE = NAMESPACE + "additionalVariable";

  public static final String PROPERTY_ADDRESS = NAMESPACE + "address";

  public static final String PROPERTY_ADDRESS_COUNTRY = NAMESPACE + "addressCountry";

  public static final String PROPERTY_ADDRESS_LOCALITY = NAMESPACE + "addressLocality";

  public static final String PROPERTY_ADDRESS_REGION = NAMESPACE + "addressRegion";

  public static final String PROPERTY_ADMINISTRATION_ROUTE = NAMESPACE + "administrationRoute";

  public static final String PROPERTY_ADVANCE_BOOKING_REQUIREMENT =
      NAMESPACE + "advanceBookingRequirement";

  public static final String PROPERTY_ADVERSE_OUTCOME = NAMESPACE + "adverseOutcome";

  public static final String PROPERTY_AFFECTED_BY = NAMESPACE + "affectedBy";

  public static final String PROPERTY_AFFILIATION = NAMESPACE + "affiliation";

  public static final String PROPERTY_AGENT = NAMESPACE + "agent";

  public static final String PROPERTY_AGGREGATE_RATING = NAMESPACE + "aggregateRating";

  public static final String PROPERTY_AIRCRAFT = NAMESPACE + "aircraft";

  public static final String PROPERTY_ALBUM = NAMESPACE + "album";

  public static final String PROPERTY_ALBUM_PRODUCTION_TYPE = NAMESPACE + "albumProductionType";

  public static final String PROPERTY_ALBUM_RELEASE = NAMESPACE + "albumRelease";

  public static final String PROPERTY_ALBUM_RELEASE_TYPE = NAMESPACE + "albumReleaseType";

  public static final String PROPERTY_ALBUMS = NAMESPACE + "albums";

  public static final String PROPERTY_ALCOHOL_WARNING = NAMESPACE + "alcoholWarning";

  public static final String PROPERTY_ALGORITHM = NAMESPACE + "algorithm";

  public static final String PROPERTY_ALIGNMENT_TYPE = NAMESPACE + "alignmentType";

  public static final String PROPERTY_ALTERNATE_NAME = NAMESPACE + "alternateName";

  public static final String PROPERTY_ALTERNATIVE_HEADLINE = NAMESPACE + "alternativeHeadline";

  public static final String PROPERTY_ALUMNI = NAMESPACE + "alumni";

  public static final String PROPERTY_ALUMNI_OF = NAMESPACE + "alumniOf";

  public static final String PROPERTY_AMOUNT = NAMESPACE + "amount";

  public static final String PROPERTY_AMOUNT_OF_THIS_GOOD = NAMESPACE + "amountOfThisGood";

  public static final String PROPERTY_ANSWER_COUNT = NAMESPACE + "answerCount";

  public static final String PROPERTY_ANTAGONIST = NAMESPACE + "antagonist";

  public static final String PROPERTY_APPLICABLE_LOCATION = NAMESPACE + "applicableLocation";

  public static final String PROPERTY_APPLICATION = NAMESPACE + "application";

  public static final String PROPERTY_APPLICATION_CATEGORY = NAMESPACE + "applicationCategory";

  public static final String PROPERTY_APPLICATION_SUB_CATEGORY =
      NAMESPACE + "applicationSubCategory";

  public static final String PROPERTY_APPLICATION_SUITE = NAMESPACE + "applicationSuite";

  public static final String PROPERTY_APPLIES_TO_DELIVERY_METHOD =
      NAMESPACE + "appliesToDeliveryMethod";

  public static final String PROPERTY_APPLIES_TO_PAYMENT_METHOD =
      NAMESPACE + "appliesToPaymentMethod";

  public static final String PROPERTY_AREA = NAMESPACE + "area";

  public static final String PROPERTY_AREA_SERVED = NAMESPACE + "areaServed";

  public static final String PROPERTY_ARRIVAL_AIRPORT = NAMESPACE + "arrivalAirport";

  public static final String PROPERTY_ARRIVAL_BUS_STOP = NAMESPACE + "arrivalBusStop";

  public static final String PROPERTY_ARRIVAL_GATE = NAMESPACE + "arrivalGate";

  public static final String PROPERTY_ARRIVAL_PLATFORM = NAMESPACE + "arrivalPlatform";

  public static final String PROPERTY_ARRIVAL_STATION = NAMESPACE + "arrivalStation";

  public static final String PROPERTY_ARRIVAL_TERMINAL = NAMESPACE + "arrivalTerminal";

  public static final String PROPERTY_ARRIVAL_TIME = NAMESPACE + "arrivalTime";

  public static final String PROPERTY_ART_EDITION = NAMESPACE + "artEdition";

  public static final String PROPERTY_ART_MEDIUM = NAMESPACE + "artMedium";

  public static final String PROPERTY_ARTERIAL_BRANCH = NAMESPACE + "arterialBranch";

  public static final String PROPERTY_ARTFORM = NAMESPACE + "artform";

  public static final String PROPERTY_ARTICLE_BODY = NAMESPACE + "articleBody";

  public static final String PROPERTY_ARTICLE_SECTION = NAMESPACE + "articleSection";

  public static final String PROPERTY_ARTWORK_SURFACE = NAMESPACE + "artworkSurface";

  public static final String PROPERTY_ASPECT = NAMESPACE + "aspect";

  public static final String PROPERTY_ASSEMBLY = NAMESPACE + "assembly";

  public static final String PROPERTY_ASSEMBLY_VERSION = NAMESPACE + "assemblyVersion";

  public static final String PROPERTY_ASSOCIATED_ANATOMY = NAMESPACE + "associatedAnatomy";

  public static final String PROPERTY_ASSOCIATED_ARTICLE = NAMESPACE + "associatedArticle";

  public static final String PROPERTY_ASSOCIATED_MEDIA = NAMESPACE + "associatedMedia";

  public static final String PROPERTY_ASSOCIATED_PATHOPHYSIOLOGY =
      NAMESPACE + "associatedPathophysiology";

  public static final String PROPERTY_ATHLETE = NAMESPACE + "athlete";

  public static final String PROPERTY_ATTENDEE = NAMESPACE + "attendee";

  public static final String PROPERTY_ATTENDEES = NAMESPACE + "attendees";

  public static final String PROPERTY_AUDIENCE = NAMESPACE + "audience";

  public static final String PROPERTY_AUDIENCE_TYPE = NAMESPACE + "audienceType";

  public static final String PROPERTY_AUDIO = NAMESPACE + "audio";

  public static final String PROPERTY_AUTHOR = NAMESPACE + "author";

  public static final String PROPERTY_AVAILABILITY = NAMESPACE + "availability";

  public static final String PROPERTY_AVAILABILITY_ENDS = NAMESPACE + "availabilityEnds";

  public static final String PROPERTY_AVAILABILITY_STARTS = NAMESPACE + "availabilityStarts";

  public static final String PROPERTY_AVAILABLE_AT_OR_FROM = NAMESPACE + "availableAtOrFrom";

  public static final String PROPERTY_AVAILABLE_CHANNEL = NAMESPACE + "availableChannel";

  public static final String PROPERTY_AVAILABLE_DELIVERY_METHOD =
      NAMESPACE + "availableDeliveryMethod";

  public static final String PROPERTY_AVAILABLE_FROM = NAMESPACE + "availableFrom";

  public static final String PROPERTY_AVAILABLE_IN = NAMESPACE + "availableIn";

  public static final String PROPERTY_AVAILABLE_LANGUAGE = NAMESPACE + "availableLanguage";

  public static final String PROPERTY_AVAILABLE_ON_DEVICE = NAMESPACE + "availableOnDevice";

  public static final String PROPERTY_AVAILABLE_SERVICE = NAMESPACE + "availableService";

  public static final String PROPERTY_AVAILABLE_STRENGTH = NAMESPACE + "availableStrength";

  public static final String PROPERTY_AVAILABLE_TEST = NAMESPACE + "availableTest";

  public static final String PROPERTY_AVAILABLE_THROUGH = NAMESPACE + "availableThrough";

  public static final String PROPERTY_AWARD = NAMESPACE + "award";

  public static final String PROPERTY_AWARDS = NAMESPACE + "awards";

  public static final String PROPERTY_AWAY_TEAM = NAMESPACE + "awayTeam";

  public static final String PROPERTY_BACKGROUND = NAMESPACE + "background";

  public static final String PROPERTY_BASE_SALARY = NAMESPACE + "baseSalary";

  public static final String PROPERTY_BENEFITS = NAMESPACE + "benefits";

  public static final String PROPERTY_BEST_RATING = NAMESPACE + "bestRating";

  public static final String PROPERTY_BILLING_ADDRESS = NAMESPACE + "billingAddress";

  public static final String PROPERTY_BILLING_INCREMENT = NAMESPACE + "billingIncrement";

  public static final String PROPERTY_BILLING_PERIOD = NAMESPACE + "billingPeriod";

  public static final String PROPERTY_BIOMECHNICAL_CLASS = NAMESPACE + "biomechnicalClass";

  public static final String PROPERTY_BIRTH_DATE = NAMESPACE + "birthDate";

  public static final String PROPERTY_BIRTH_PLACE = NAMESPACE + "birthPlace";

  public static final String PROPERTY_BITRATE = NAMESPACE + "bitrate";

  public static final String PROPERTY_BLOG_POST = NAMESPACE + "blogPost";

  public static final String PROPERTY_BLOG_POSTS = NAMESPACE + "blogPosts";

  public static final String PROPERTY_BLOOD_SUPPLY = NAMESPACE + "bloodSupply";

  public static final String PROPERTY_BOARDING_GROUP = NAMESPACE + "boardingGroup";

  public static final String PROPERTY_BOARDING_POLICY = NAMESPACE + "boardingPolicy";

  public static final String PROPERTY_BODY_LOCATION = NAMESPACE + "bodyLocation";

  public static final String PROPERTY_BOOK_EDITION = NAMESPACE + "bookEdition";

  public static final String PROPERTY_BOOK_FORMAT = NAMESPACE + "bookFormat";

  public static final String PROPERTY_BOOKING_AGENT = NAMESPACE + "bookingAgent";

  public static final String PROPERTY_BOOKING_TIME = NAMESPACE + "bookingTime";

  public static final String PROPERTY_BORROWER = NAMESPACE + "borrower";

  public static final String PROPERTY_BOX = NAMESPACE + "box";

  public static final String PROPERTY_BRANCH = NAMESPACE + "branch";

  public static final String PROPERTY_BRANCH_CODE = NAMESPACE + "branchCode";

  public static final String PROPERTY_BRANCH_OF = NAMESPACE + "branchOf";

  public static final String PROPERTY_BRAND = NAMESPACE + "brand";

  public static final String PROPERTY_BREADCRUMB = NAMESPACE + "breadcrumb";

  public static final String PROPERTY_BREASTFEEDING_WARNING = NAMESPACE + "breastfeedingWarning";

  public static final String PROPERTY_BROADCAST_AFFILIATE_OF = NAMESPACE + "broadcastAffiliateOf";

  public static final String PROPERTY_BROADCAST_CHANNEL_ID = NAMESPACE + "broadcastChannelId";

  public static final String PROPERTY_BROADCAST_DISPLAY_NAME = NAMESPACE + "broadcastDisplayName";

  public static final String PROPERTY_BROADCAST_FREQUENCY = NAMESPACE + "broadcastFrequency";

  public static final String PROPERTY_BROADCAST_FREQUENCY_VALUE =
      NAMESPACE + "broadcastFrequencyValue";

  public static final String PROPERTY_BROADCAST_OF_EVENT = NAMESPACE + "broadcastOfEvent";

  public static final String PROPERTY_BROADCAST_SERVICE_TIER = NAMESPACE + "broadcastServiceTier";

  public static final String PROPERTY_BROADCAST_SIGNAL_MODULATION =
      NAMESPACE + "broadcastSignalModulation";

  public static final String PROPERTY_BROADCAST_TIMEZONE = NAMESPACE + "broadcastTimezone";

  public static final String PROPERTY_BROADCASTER = NAMESPACE + "broadcaster";

  public static final String PROPERTY_BROKER = NAMESPACE + "broker";

  public static final String PROPERTY_BROWSER_REQUIREMENTS = NAMESPACE + "browserRequirements";

  public static final String PROPERTY_BUS_NAME = NAMESPACE + "busName";

  public static final String PROPERTY_BUS_NUMBER = NAMESPACE + "busNumber";

  public static final String PROPERTY_BUSINESS_FUNCTION = NAMESPACE + "businessFunction";

  public static final String PROPERTY_BUYER = NAMESPACE + "buyer";

  public static final String PROPERTY_BY_ARTIST = NAMESPACE + "byArtist";

  public static final String PROPERTY_CALORIES = NAMESPACE + "calories";

  public static final String PROPERTY_CANDIDATE = NAMESPACE + "candidate";

  public static final String PROPERTY_CAPTION = NAMESPACE + "caption";

  public static final String PROPERTY_CARBOHYDRATE_CONTENT = NAMESPACE + "carbohydrateContent";

  public static final String PROPERTY_CARGO_VOLUME = NAMESPACE + "cargoVolume";

  public static final String PROPERTY_CARRIER = NAMESPACE + "carrier";

  public static final String PROPERTY_CARRIER_REQUIREMENTS = NAMESPACE + "carrierRequirements";

  public static final String PROPERTY_CATALOG = NAMESPACE + "catalog";

  public static final String PROPERTY_CATALOG_NUMBER = NAMESPACE + "catalogNumber";

  public static final String PROPERTY_CATEGORY = NAMESPACE + "category";

  public static final String PROPERTY_CAUSE = NAMESPACE + "cause";

  public static final String PROPERTY_CAUSE_OF = NAMESPACE + "causeOf";

  public static final String PROPERTY_CHARACTER = NAMESPACE + "character";

  public static final String PROPERTY_CHARACTER_ATTRIBUTE = NAMESPACE + "characterAttribute";

  public static final String PROPERTY_CHARACTER_NAME = NAMESPACE + "characterName";

  public static final String PROPERTY_CHEAT_CODE = NAMESPACE + "cheatCode";

  public static final String PROPERTY_CHECKIN_TIME = NAMESPACE + "checkinTime";

  public static final String PROPERTY_CHECKOUT_TIME = NAMESPACE + "checkoutTime";

  public static final String PROPERTY_CHILD_MAX_AGE = NAMESPACE + "childMaxAge";

  public static final String PROPERTY_CHILD_MIN_AGE = NAMESPACE + "childMinAge";

  public static final String PROPERTY_CHILDREN = NAMESPACE + "children";

  public static final String PROPERTY_CHOLESTEROL_CONTENT = NAMESPACE + "cholesterolContent";

  public static final String PROPERTY_CIRCLE = NAMESPACE + "circle";

  public static final String PROPERTY_CITATION = NAMESPACE + "citation";

  public static final String PROPERTY_CLINCAL_PHARMACOLOGY = NAMESPACE + "clincalPharmacology";

  public static final String PROPERTY_CLINICAL_PHARMACOLOGY = NAMESPACE + "clinicalPharmacology";

  public static final String PROPERTY_CLIP_NUMBER = NAMESPACE + "clipNumber";

  public static final String PROPERTY_CLOSES = NAMESPACE + "closes";

  public static final String PROPERTY_COACH = NAMESPACE + "coach";

  public static final String PROPERTY_CODE = NAMESPACE + "code";

  public static final String PROPERTY_CODE_REPOSITORY = NAMESPACE + "codeRepository";

  public static final String PROPERTY_CODE_SAMPLE_TYPE = NAMESPACE + "codeSampleType";

  public static final String PROPERTY_CODE_VALUE = NAMESPACE + "codeValue";

  public static final String PROPERTY_CODING_SYSTEM = NAMESPACE + "codingSystem";

  public static final String PROPERTY_COLLEAGUE = NAMESPACE + "colleague";

  public static final String PROPERTY_COLLEAGUES = NAMESPACE + "colleagues";

  public static final String PROPERTY_COLLECTION = NAMESPACE + "collection";

  public static final String PROPERTY_COLOR = NAMESPACE + "color";

  public static final String PROPERTY_COMMENT = NAMESPACE + "comment";

  public static final String PROPERTY_COMMENT_COUNT = NAMESPACE + "commentCount";

  public static final String PROPERTY_COMMENT_TEXT = NAMESPACE + "commentText";

  public static final String PROPERTY_COMMENT_TIME = NAMESPACE + "commentTime";

  public static final String PROPERTY_COMPETITOR = NAMESPACE + "competitor";

  public static final String PROPERTY_COMPOSER = NAMESPACE + "composer";

  public static final String PROPERTY_COMPRISED_OF = NAMESPACE + "comprisedOf";

  public static final String PROPERTY_CONFIRMATION_NUMBER = NAMESPACE + "confirmationNumber";

  public static final String PROPERTY_CONNECTED_TO = NAMESPACE + "connectedTo";

  public static final String PROPERTY_CONTACT_OPTION = NAMESPACE + "contactOption";

  public static final String PROPERTY_CONTACT_POINT = NAMESPACE + "contactPoint";

  public static final String PROPERTY_CONTACT_POINTS = NAMESPACE + "contactPoints";

  public static final String PROPERTY_CONTACT_TYPE = NAMESPACE + "contactType";

  public static final String PROPERTY_CONTAINED_IN = NAMESPACE + "containedIn";

  public static final String PROPERTY_CONTAINED_IN_PLACE = NAMESPACE + "containedInPlace";

  public static final String PROPERTY_CONTAINS_PLACE = NAMESPACE + "containsPlace";

  public static final String PROPERTY_CONTAINS_SEASON = NAMESPACE + "containsSeason";

  public static final String PROPERTY_CONTENT_LOCATION = NAMESPACE + "contentLocation";

  public static final String PROPERTY_CONTENT_RATING = NAMESPACE + "contentRating";

  public static final String PROPERTY_CONTENT_SIZE = NAMESPACE + "contentSize";

  public static final String PROPERTY_CONTENT_TYPE = NAMESPACE + "contentType";

  public static final String PROPERTY_CONTENT_URL = NAMESPACE + "contentUrl";

  public static final String PROPERTY_CONTRAINDICATION = NAMESPACE + "contraindication";

  public static final String PROPERTY_CONTRIBUTOR = NAMESPACE + "contributor";

  public static final String PROPERTY_COOK_TIME = NAMESPACE + "cookTime";

  public static final String PROPERTY_COOKING_METHOD = NAMESPACE + "cookingMethod";

  public static final String PROPERTY_COPYRIGHT_HOLDER = NAMESPACE + "copyrightHolder";

  public static final String PROPERTY_COPYRIGHT_YEAR = NAMESPACE + "copyrightYear";

  public static final String PROPERTY_COST = NAMESPACE + "cost";

  public static final String PROPERTY_COST_CATEGORY = NAMESPACE + "costCategory";

  public static final String PROPERTY_COST_CURRENCY = NAMESPACE + "costCurrency";

  public static final String PROPERTY_COST_ORIGIN = NAMESPACE + "costOrigin";

  public static final String PROPERTY_COST_PER_UNIT = NAMESPACE + "costPerUnit";

  public static final String PROPERTY_COUNTRIES_NOT_SUPPORTED = NAMESPACE + "countriesNotSupported";

  public static final String PROPERTY_COUNTRIES_SUPPORTED = NAMESPACE + "countriesSupported";

  public static final String PROPERTY_COUNTRY_OF_ORIGIN = NAMESPACE + "countryOfOrigin";

  public static final String PROPERTY_COURSE = NAMESPACE + "course";

  public static final String PROPERTY_COVERAGE_END_TIME = NAMESPACE + "coverageEndTime";

  public static final String PROPERTY_COVERAGE_START_TIME = NAMESPACE + "coverageStartTime";

  public static final String PROPERTY_CREATOR = NAMESPACE + "creator";

  public static final String PROPERTY_CREDITED_TO = NAMESPACE + "creditedTo";

  public static final String PROPERTY_CURRENCIES_ACCEPTED = NAMESPACE + "currenciesAccepted";

  public static final String PROPERTY_CURRENCY = NAMESPACE + "currency";

  public static final String PROPERTY_CUSTOMER = NAMESPACE + "customer";

  public static final String PROPERTY_DATA_FEED_ELEMENT = NAMESPACE + "dataFeedElement";

  public static final String PROPERTY_DATASET = NAMESPACE + "dataset";

  public static final String PROPERTY_DATASET_TIME_INTERVAL = NAMESPACE + "datasetTimeInterval";

  public static final String PROPERTY_DATE_CREATED = NAMESPACE + "dateCreated";

  public static final String PROPERTY_DATE_DELETED = NAMESPACE + "dateDeleted";

  public static final String PROPERTY_DATE_ISSUED = NAMESPACE + "dateIssued";

  public static final String PROPERTY_DATE_MODIFIED = NAMESPACE + "dateModified";

  public static final String PROPERTY_DATE_POSTED = NAMESPACE + "datePosted";

  public static final String PROPERTY_DATE_PUBLISHED = NAMESPACE + "datePublished";

  public static final String PROPERTY_DATE_VEHICLE_FIRST_REGISTERED =
      NAMESPACE + "dateVehicleFirstRegistered";

  public static final String PROPERTY_DATELINE = NAMESPACE + "dateline";

  public static final String PROPERTY_DAY_OF_WEEK = NAMESPACE + "dayOfWeek";

  public static final String PROPERTY_DEATH_DATE = NAMESPACE + "deathDate";

  public static final String PROPERTY_DEATH_PLACE = NAMESPACE + "deathPlace";

  public static final String PROPERTY_DEFAULT_VALUE = NAMESPACE + "defaultValue";

  public static final String PROPERTY_DELIVERY_ADDRESS = NAMESPACE + "deliveryAddress";

  public static final String PROPERTY_DELIVERY_LEAD_TIME = NAMESPACE + "deliveryLeadTime";

  public static final String PROPERTY_DELIVERY_METHOD = NAMESPACE + "deliveryMethod";

  public static final String PROPERTY_DELIVERY_STATUS = NAMESPACE + "deliveryStatus";

  public static final String PROPERTY_DEPARTMENT = NAMESPACE + "department";

  public static final String PROPERTY_DEPARTURE_AIRPORT = NAMESPACE + "departureAirport";

  public static final String PROPERTY_DEPARTURE_BUS_STOP = NAMESPACE + "departureBusStop";

  public static final String PROPERTY_DEPARTURE_GATE = NAMESPACE + "departureGate";

  public static final String PROPERTY_DEPARTURE_PLATFORM = NAMESPACE + "departurePlatform";

  public static final String PROPERTY_DEPARTURE_STATION = NAMESPACE + "departureStation";

  public static final String PROPERTY_DEPARTURE_TERMINAL = NAMESPACE + "departureTerminal";

  public static final String PROPERTY_DEPARTURE_TIME = NAMESPACE + "departureTime";

  public static final String PROPERTY_DEPENDENCIES = NAMESPACE + "dependencies";

  public static final String PROPERTY_DEPTH = NAMESPACE + "depth";

  public static final String PROPERTY_DESCRIPTION = NAMESPACE + "description";

  public static final String PROPERTY_DEVICE = NAMESPACE + "device";

  public static final String PROPERTY_DIAGNOSIS = NAMESPACE + "diagnosis";

  public static final String PROPERTY_DIAGRAM = NAMESPACE + "diagram";

  public static final String PROPERTY_DIET = NAMESPACE + "diet";

  public static final String PROPERTY_DIET_FEATURES = NAMESPACE + "dietFeatures";

  public static final String PROPERTY_DIFFERENTIAL_DIAGNOSIS = NAMESPACE + "differentialDiagnosis";

  public static final String PROPERTY_DIRECTOR = NAMESPACE + "director";

  public static final String PROPERTY_DIRECTORS = NAMESPACE + "directors";

  public static final String PROPERTY_DISCOUNT = NAMESPACE + "discount";

  public static final String PROPERTY_DISCOUNT_CODE = NAMESPACE + "discountCode";

  public static final String PROPERTY_DISCOUNT_CURRENCY = NAMESPACE + "discountCurrency";

  public static final String PROPERTY_DISCUSSES = NAMESPACE + "discusses";

  public static final String PROPERTY_DISCUSSION_URL = NAMESPACE + "discussionUrl";

  public static final String PROPERTY_DISSOLUTION_DATE = NAMESPACE + "dissolutionDate";

  public static final String PROPERTY_DISTANCE = NAMESPACE + "distance";

  public static final String PROPERTY_DISTINGUISHING_SIGN = NAMESPACE + "distinguishingSign";

  public static final String PROPERTY_DISTRIBUTION = NAMESPACE + "distribution";

  public static final String PROPERTY_DOMAIN_INCLUDES = NAMESPACE + "domainIncludes";

  public static final String PROPERTY_DOOR_TIME = NAMESPACE + "doorTime";

  public static final String PROPERTY_DOSAGE_FORM = NAMESPACE + "dosageForm";

  public static final String PROPERTY_DOSE_SCHEDULE = NAMESPACE + "doseSchedule";

  public static final String PROPERTY_DOSE_UNIT = NAMESPACE + "doseUnit";

  public static final String PROPERTY_DOSE_VALUE = NAMESPACE + "doseValue";

  public static final String PROPERTY_DOWNLOAD_URL = NAMESPACE + "downloadUrl";

  public static final String PROPERTY_DOWNVOTE_COUNT = NAMESPACE + "downvoteCount";

  public static final String PROPERTY_DRAINS_TO = NAMESPACE + "drainsTo";

  public static final String PROPERTY_DRIVE_WHEEL_CONFIGURATION =
      NAMESPACE + "driveWheelConfiguration";

  public static final String PROPERTY_DROPOFF_LOCATION = NAMESPACE + "dropoffLocation";

  public static final String PROPERTY_DROPOFF_TIME = NAMESPACE + "dropoffTime";

  public static final String PROPERTY_DRUG = NAMESPACE + "drug";

  public static final String PROPERTY_DRUG_CLASS = NAMESPACE + "drugClass";

  public static final String PROPERTY_DRUG_UNIT = NAMESPACE + "drugUnit";

  public static final String PROPERTY_DUNS = NAMESPACE + "duns";

  public static final String PROPERTY_DUPLICATE_THERAPY = NAMESPACE + "duplicateTherapy";

  public static final String PROPERTY_DURATION = NAMESPACE + "duration";

  public static final String PROPERTY_DURATION_OF_WARRANTY = NAMESPACE + "durationOfWarranty";

  public static final String PROPERTY_EDITOR = NAMESPACE + "editor";

  public static final String PROPERTY_EDUCATION_REQUIREMENTS = NAMESPACE + "educationRequirements";

  public static final String PROPERTY_EDUCATIONAL_ALIGNMENT = NAMESPACE + "educationalAlignment";

  public static final String PROPERTY_EDUCATIONAL_FRAMEWORK = NAMESPACE + "educationalFramework";

  public static final String PROPERTY_EDUCATIONAL_ROLE = NAMESPACE + "educationalRole";

  public static final String PROPERTY_EDUCATIONAL_USE = NAMESPACE + "educationalUse";

  public static final String PROPERTY_ELEVATION = NAMESPACE + "elevation";

  public static final String PROPERTY_ELIGIBLE_CUSTOMER_TYPE = NAMESPACE + "eligibleCustomerType";

  public static final String PROPERTY_ELIGIBLE_DURATION = NAMESPACE + "eligibleDuration";

  public static final String PROPERTY_ELIGIBLE_QUANTITY = NAMESPACE + "eligibleQuantity";

  public static final String PROPERTY_ELIGIBLE_REGION = NAMESPACE + "eligibleRegion";

  public static final String PROPERTY_ELIGIBLE_TRANSACTION_VOLUME =
      NAMESPACE + "eligibleTransactionVolume";

  public static final String PROPERTY_EMAIL = NAMESPACE + "email";

  public static final String PROPERTY_EMBED_URL = NAMESPACE + "embedUrl";

  public static final String PROPERTY_EMPLOYEE = NAMESPACE + "employee";

  public static final String PROPERTY_EMPLOYEES = NAMESPACE + "employees";

  public static final String PROPERTY_EMPLOYMENT_TYPE = NAMESPACE + "employmentType";

  public static final String PROPERTY_ENCODES_CREATIVE_WORK = NAMESPACE + "encodesCreativeWork";

  public static final String PROPERTY_ENCODING = NAMESPACE + "encoding";

  public static final String PROPERTY_ENCODING_FORMAT = NAMESPACE + "encodingFormat";

  public static final String PROPERTY_ENCODING_TYPE = NAMESPACE + "encodingType";

  public static final String PROPERTY_ENCODINGS = NAMESPACE + "encodings";

  public static final String PROPERTY_END_DATE = NAMESPACE + "endDate";

  public static final String PROPERTY_END_TIME = NAMESPACE + "endTime";

  public static final String PROPERTY_ENDORSEE = NAMESPACE + "endorsee";

  public static final String PROPERTY_ENDORSERS = NAMESPACE + "endorsers";

  public static final String PROPERTY_ENTERTAINMENT_BUSINESS = NAMESPACE + "entertainmentBusiness";

  public static final String PROPERTY_EPIDEMIOLOGY = NAMESPACE + "epidemiology";

  public static final String PROPERTY_EPISODE = NAMESPACE + "episode";

  public static final String PROPERTY_EPISODE_NUMBER = NAMESPACE + "episodeNumber";

  public static final String PROPERTY_EPISODES = NAMESPACE + "episodes";

  public static final String PROPERTY_EQUAL = NAMESPACE + "equal";

  public static final String PROPERTY_ERROR = NAMESPACE + "error";

  public static final String PROPERTY_ESTIMATED_FLIGHT_DURATION =
      NAMESPACE + "estimatedFlightDuration";

  public static final String PROPERTY_ESTIMATES_RISK_OF = NAMESPACE + "estimatesRiskOf";

  public static final String PROPERTY_EVENT = NAMESPACE + "event";

  public static final String PROPERTY_EVENT_STATUS = NAMESPACE + "eventStatus";

  public static final String PROPERTY_EVENTS = NAMESPACE + "events";

  public static final String PROPERTY_EVIDENCE_LEVEL = NAMESPACE + "evidenceLevel";

  public static final String PROPERTY_EVIDENCE_ORIGIN = NAMESPACE + "evidenceOrigin";

  public static final String PROPERTY_EXAMPLE_OF_WORK = NAMESPACE + "exampleOfWork";

  public static final String PROPERTY_EXECUTABLE_LIBRARY_NAME = NAMESPACE + "executableLibraryName";

  public static final String PROPERTY_EXERCISE_COURSE = NAMESPACE + "exerciseCourse";

  public static final String PROPERTY_EXERCISE_PLAN = NAMESPACE + "exercisePlan";

  public static final String PROPERTY_EXERCISE_RELATED_DIET = NAMESPACE + "exerciseRelatedDiet";

  public static final String PROPERTY_EXERCISE_TYPE = NAMESPACE + "exerciseType";

  public static final String PROPERTY_EXIF_DATA = NAMESPACE + "exifData";

  public static final String PROPERTY_EXPECTED_ARRIVAL_FROM = NAMESPACE + "expectedArrivalFrom";

  public static final String PROPERTY_EXPECTED_ARRIVAL_UNTIL = NAMESPACE + "expectedArrivalUntil";

  public static final String PROPERTY_EXPECTED_PROGNOSIS = NAMESPACE + "expectedPrognosis";

  public static final String PROPERTY_EXPECTS_ACCEPTANCE_OF = NAMESPACE + "expectsAcceptanceOf";

  public static final String PROPERTY_EXPERIENCE_REQUIREMENTS =
      NAMESPACE + "experienceRequirements";

  public static final String PROPERTY_EXPERT_CONSIDERATIONS = NAMESPACE + "expertConsiderations";

  public static final String PROPERTY_EXPIRES = NAMESPACE + "expires";

  public static final String PROPERTY_FAMILY_NAME = NAMESPACE + "familyName";

  public static final String PROPERTY_FAT_CONTENT = NAMESPACE + "fatContent";

  public static final String PROPERTY_FAX_NUMBER = NAMESPACE + "faxNumber";

  public static final String PROPERTY_FEATURE_LIST = NAMESPACE + "featureList";

  public static final String PROPERTY_FIBER_CONTENT = NAMESPACE + "fiberContent";

  public static final String PROPERTY_FILE_FORMAT = NAMESPACE + "fileFormat";

  public static final String PROPERTY_FILE_SIZE = NAMESPACE + "fileSize";

  public static final String PROPERTY_FIRST_PERFORMANCE = NAMESPACE + "firstPerformance";

  public static final String PROPERTY_FLIGHT_DISTANCE = NAMESPACE + "flightDistance";

  public static final String PROPERTY_FLIGHT_NUMBER = NAMESPACE + "flightNumber";

  public static final String PROPERTY_FOLLOWEE = NAMESPACE + "followee";

  public static final String PROPERTY_FOLLOWS = NAMESPACE + "follows";

  public static final String PROPERTY_FOLLOWUP = NAMESPACE + "followup";

  public static final String PROPERTY_FOOD_ESTABLISHMENT = NAMESPACE + "foodEstablishment";

  public static final String PROPERTY_FOOD_EVENT = NAMESPACE + "foodEvent";

  public static final String PROPERTY_FOOD_WARNING = NAMESPACE + "foodWarning";

  public static final String PROPERTY_FOUNDER = NAMESPACE + "founder";

  public static final String PROPERTY_FOUNDERS = NAMESPACE + "founders";

  public static final String PROPERTY_FOUNDING_DATE = NAMESPACE + "foundingDate";

  public static final String PROPERTY_FOUNDING_LOCATION = NAMESPACE + "foundingLocation";

  public static final String PROPERTY_FREE = NAMESPACE + "free";

  public static final String PROPERTY_FREQUENCY = NAMESPACE + "frequency";

  public static final String PROPERTY_FROM_LOCATION = NAMESPACE + "fromLocation";

  public static final String PROPERTY_FUEL_CONSUMPTION = NAMESPACE + "fuelConsumption";

  public static final String PROPERTY_FUEL_EFFICIENCY = NAMESPACE + "fuelEfficiency";

  public static final String PROPERTY_FUEL_TYPE = NAMESPACE + "fuelType";

  public static final String PROPERTY_FUNCTION = NAMESPACE + "function";

  public static final String PROPERTY_FUNCTIONAL_CLASS = NAMESPACE + "functionalClass";

  public static final String PROPERTY_GAME = NAMESPACE + "game";

  public static final String PROPERTY_GAME_ITEM = NAMESPACE + "gameItem";

  public static final String PROPERTY_GAME_LOCATION = NAMESPACE + "gameLocation";

  public static final String PROPERTY_GAME_PLATFORM = NAMESPACE + "gamePlatform";

  public static final String PROPERTY_GAME_SERVER = NAMESPACE + "gameServer";

  public static final String PROPERTY_GAME_TIP = NAMESPACE + "gameTip";

  public static final String PROPERTY_GENDER = NAMESPACE + "gender";

  public static final String PROPERTY_GENRE = NAMESPACE + "genre";

  public static final String PROPERTY_GEO = NAMESPACE + "geo";

  public static final String PROPERTY_GEO_MIDPOINT = NAMESPACE + "geoMidpoint";

  public static final String PROPERTY_GEO_RADIUS = NAMESPACE + "geoRadius";

  public static final String PROPERTY_GEOGRAPHIC_AREA = NAMESPACE + "geographicArea";

  public static final String PROPERTY_GIVEN_NAME = NAMESPACE + "givenName";

  public static final String PROPERTY_GLOBAL_LOCATION_NUMBER = NAMESPACE + "globalLocationNumber";

  public static final String PROPERTY_GREATER = NAMESPACE + "greater";

  public static final String PROPERTY_GREATER_OR_EQUAL = NAMESPACE + "greaterOrEqual";

  public static final String PROPERTY_GTIN12 = NAMESPACE + "gtin12";

  public static final String PROPERTY_GTIN13 = NAMESPACE + "gtin13";

  public static final String PROPERTY_GTIN14 = NAMESPACE + "gtin14";

  public static final String PROPERTY_GTIN8 = NAMESPACE + "gtin8";

  public static final String PROPERTY_GUIDELINE = NAMESPACE + "guideline";

  public static final String PROPERTY_GUIDELINE_DATE = NAMESPACE + "guidelineDate";

  public static final String PROPERTY_GUIDELINE_SUBJECT = NAMESPACE + "guidelineSubject";

  public static final String PROPERTY_HAS_DELIVERY_METHOD = NAMESPACE + "hasDeliveryMethod";

  public static final String PROPERTY_HAS_MAP = NAMESPACE + "hasMap";

  public static final String PROPERTY_HAS_OFFER_CATALOG = NAMESPACE + "hasOfferCatalog";

  public static final String PROPERTY_HAS_POS = NAMESPACE + "hasPOS";

  public static final String PROPERTY_HAS_PART = NAMESPACE + "hasPart";

  public static final String PROPERTY_HEADLINE = NAMESPACE + "headline";

  public static final String PROPERTY_HEALTH_CONDITION = NAMESPACE + "healthCondition";

  public static final String PROPERTY_HEIGHT = NAMESPACE + "height";

  public static final String PROPERTY_HIGH_PRICE = NAMESPACE + "highPrice";

  public static final String PROPERTY_HIRING_ORGANIZATION = NAMESPACE + "hiringOrganization";

  public static final String PROPERTY_HOME_LOCATION = NAMESPACE + "homeLocation";

  public static final String PROPERTY_HOME_TEAM = NAMESPACE + "homeTeam";

  public static final String PROPERTY_HONORIFIC_PREFIX = NAMESPACE + "honorificPrefix";

  public static final String PROPERTY_HONORIFIC_SUFFIX = NAMESPACE + "honorificSuffix";

  public static final String PROPERTY_HOSPITAL_AFFILIATION = NAMESPACE + "hospitalAffiliation";

  public static final String PROPERTY_HOSTING_ORGANIZATION = NAMESPACE + "hostingOrganization";

  public static final String PROPERTY_HOURS_AVAILABLE = NAMESPACE + "hoursAvailable";

  public static final String PROPERTY_HOW_PERFORMED = NAMESPACE + "howPerformed";

  public static final String PROPERTY_HTTP_METHOD = NAMESPACE + "httpMethod";

  public static final String PROPERTY_IATA_CODE = NAMESPACE + "iataCode";

  public static final String PROPERTY_ICAO_CODE = NAMESPACE + "icaoCode";

  public static final String PROPERTY_IDENTIFYING_EXAM = NAMESPACE + "identifyingExam";

  public static final String PROPERTY_IDENTIFYING_TEST = NAMESPACE + "identifyingTest";

  public static final String PROPERTY_ILLUSTRATOR = NAMESPACE + "illustrator";

  public static final String PROPERTY_IMAGE = NAMESPACE + "image";

  public static final String PROPERTY_IMAGING_TECHNIQUE = NAMESPACE + "imagingTechnique";

  public static final String PROPERTY_IN_ALBUM = NAMESPACE + "inAlbum";

  public static final String PROPERTY_IN_BROADCAST_LINEUP = NAMESPACE + "inBroadcastLineup";

  public static final String PROPERTY_IN_LANGUAGE = NAMESPACE + "inLanguage";

  public static final String PROPERTY_IN_PLAYLIST = NAMESPACE + "inPlaylist";

  public static final String PROPERTY_INCENTIVE_COMPENSATION = NAMESPACE + "incentiveCompensation";

  public static final String PROPERTY_INCENTIVES = NAMESPACE + "incentives";

  public static final String PROPERTY_INCLUDED_COMPOSITION = NAMESPACE + "includedComposition";

  public static final String PROPERTY_INCLUDED_DATA_CATALOG = NAMESPACE + "includedDataCatalog";

  public static final String PROPERTY_INCLUDED_RISK_FACTOR = NAMESPACE + "includedRiskFactor";

  public static final String PROPERTY_INCLUDES_OBJECT = NAMESPACE + "includesObject";

  public static final String PROPERTY_INCREASES_RISK_OF = NAMESPACE + "increasesRiskOf";

  public static final String PROPERTY_INDICATION = NAMESPACE + "indication";

  public static final String PROPERTY_INDUSTRY = NAMESPACE + "industry";

  public static final String PROPERTY_INELIGIBLE_REGION = NAMESPACE + "ineligibleRegion";

  public static final String PROPERTY_INFECTIOUS_AGENT = NAMESPACE + "infectiousAgent";

  public static final String PROPERTY_INFECTIOUS_AGENT_CLASS = NAMESPACE + "infectiousAgentClass";

  public static final String PROPERTY_INGREDIENTS = NAMESPACE + "ingredients";

  public static final String PROPERTY_INSERTION = NAMESPACE + "insertion";

  public static final String PROPERTY_INSTALL_URL = NAMESPACE + "installUrl";

  public static final String PROPERTY_INSTRUMENT = NAMESPACE + "instrument";

  public static final String PROPERTY_INTENSITY = NAMESPACE + "intensity";

  public static final String PROPERTY_INTERACTING_DRUG = NAMESPACE + "interactingDrug";

  public static final String PROPERTY_INTERACTION_COUNT = NAMESPACE + "interactionCount";

  public static final String PROPERTY_INTERACTION_SERVICE = NAMESPACE + "interactionService";

  public static final String PROPERTY_INTERACTION_STATISTIC = NAMESPACE + "interactionStatistic";

  public static final String PROPERTY_INTERACTION_TYPE = NAMESPACE + "interactionType";

  public static final String PROPERTY_INTERACTIVITY_TYPE = NAMESPACE + "interactivityType";

  public static final String PROPERTY_INVENTORY_LEVEL = NAMESPACE + "inventoryLevel";

  public static final String PROPERTY_INVERSE_OF = NAMESPACE + "inverseOf";

  public static final String PROPERTY_IS_ACCESSIBLE_FOR_FREE = NAMESPACE + "isAccessibleForFree";

  public static final String PROPERTY_IS_ACCESSORY_OR_SPARE_PART_FOR =
      NAMESPACE + "isAccessoryOrSparePartFor";

  public static final String PROPERTY_IS_AVAILABLE_GENERICALLY =
      NAMESPACE + "isAvailableGenerically";

  public static final String PROPERTY_IS_BASED_ON_URL = NAMESPACE + "isBasedOnUrl";

  public static final String PROPERTY_IS_CONSUMABLE_FOR = NAMESPACE + "isConsumableFor";

  public static final String PROPERTY_IS_FAMILY_FRIENDLY = NAMESPACE + "isFamilyFriendly";

  public static final String PROPERTY_IS_GIFT = NAMESPACE + "isGift";

  public static final String PROPERTY_IS_LIVE_BROADCAST = NAMESPACE + "isLiveBroadcast";

  public static final String PROPERTY_IS_PART_OF = NAMESPACE + "isPartOf";

  public static final String PROPERTY_IS_PROPRIETARY = NAMESPACE + "isProprietary";

  public static final String PROPERTY_IS_RELATED_TO = NAMESPACE + "isRelatedTo";

  public static final String PROPERTY_IS_SIMILAR_TO = NAMESPACE + "isSimilarTo";

  public static final String PROPERTY_IS_VARIANT_OF = NAMESPACE + "isVariantOf";

  public static final String PROPERTY_ISBN = NAMESPACE + "isbn";

  public static final String PROPERTY_ISIC_V4 = NAMESPACE + "isicV4";

  public static final String PROPERTY_ISRC_CODE = NAMESPACE + "isrcCode";

  public static final String PROPERTY_ISSN = NAMESPACE + "issn";

  public static final String PROPERTY_ISSUE_NUMBER = NAMESPACE + "issueNumber";

  public static final String PROPERTY_ISSUED_BY = NAMESPACE + "issuedBy";

  public static final String PROPERTY_ISSUED_THROUGH = NAMESPACE + "issuedThrough";

  public static final String PROPERTY_ISWC_CODE = NAMESPACE + "iswcCode";

  public static final String PROPERTY_ITEM = NAMESPACE + "item";

  public static final String PROPERTY_ITEM_CONDITION = NAMESPACE + "itemCondition";

  public static final String PROPERTY_ITEM_LIST_ELEMENT = NAMESPACE + "itemListElement";

  public static final String PROPERTY_ITEM_LIST_ORDER = NAMESPACE + "itemListOrder";

  public static final String PROPERTY_ITEM_OFFERED = NAMESPACE + "itemOffered";

  public static final String PROPERTY_ITEM_REVIEWED = NAMESPACE + "itemReviewed";

  public static final String PROPERTY_ITEM_SHIPPED = NAMESPACE + "itemShipped";

  public static final String PROPERTY_JOB_BENEFITS = NAMESPACE + "jobBenefits";

  public static final String PROPERTY_JOB_LOCATION = NAMESPACE + "jobLocation";

  public static final String PROPERTY_JOB_TITLE = NAMESPACE + "jobTitle";

  public static final String PROPERTY_KEYWORDS = NAMESPACE + "keywords";

  public static final String PROPERTY_KNOWN_VEHICLE_DAMAGES = NAMESPACE + "knownVehicleDamages";

  public static final String PROPERTY_KNOWS = NAMESPACE + "knows";

  public static final String PROPERTY_LABEL_DETAILS = NAMESPACE + "labelDetails";

  public static final String PROPERTY_LANDLORD = NAMESPACE + "landlord";

  public static final String PROPERTY_LANGUAGE = NAMESPACE + "language";

  public static final String PROPERTY_LAST_REVIEWED = NAMESPACE + "lastReviewed";

  public static final String PROPERTY_LATITUDE = NAMESPACE + "latitude";

  public static final String PROPERTY_LEARNING_RESOURCE_TYPE = NAMESPACE + "learningResourceType";

  public static final String PROPERTY_LEGAL_NAME = NAMESPACE + "legalName";

  public static final String PROPERTY_LEGAL_STATUS = NAMESPACE + "legalStatus";

  public static final String PROPERTY_LENDER = NAMESPACE + "lender";

  public static final String PROPERTY_LESSER = NAMESPACE + "lesser";

  public static final String PROPERTY_LESSER_OR_EQUAL = NAMESPACE + "lesserOrEqual";

  public static final String PROPERTY_LICENSE = NAMESPACE + "license";

  public static final String PROPERTY_LINE = NAMESPACE + "line";

  public static final String PROPERTY_LIVE_BLOG_UPDATE = NAMESPACE + "liveBlogUpdate";

  public static final String PROPERTY_LOCATION = NAMESPACE + "location";

  public static final String PROPERTY_LOCATION_CREATED = NAMESPACE + "locationCreated";

  public static final String PROPERTY_LODGING_UNIT_DESCRIPTION =
      NAMESPACE + "lodgingUnitDescription";

  public static final String PROPERTY_LODGING_UNIT_TYPE = NAMESPACE + "lodgingUnitType";

  public static final String PROPERTY_LOGO = NAMESPACE + "logo";

  public static final String PROPERTY_LONGITUDE = NAMESPACE + "longitude";

  public static final String PROPERTY_LOSER = NAMESPACE + "loser";

  public static final String PROPERTY_LOW_PRICE = NAMESPACE + "lowPrice";

  public static final String PROPERTY_LYRICIST = NAMESPACE + "lyricist";

  public static final String PROPERTY_LYRICS = NAMESPACE + "lyrics";

  public static final String PROPERTY_MAIN_CONTENT_OF_PAGE = NAMESPACE + "mainContentOfPage";

  public static final String PROPERTY_MAIN_ENTITY = NAMESPACE + "mainEntity";

  public static final String PROPERTY_MAIN_ENTITY_OF_PAGE = NAMESPACE + "mainEntityOfPage";

  public static final String PROPERTY_MAKES_OFFER = NAMESPACE + "makesOffer";

  public static final String PROPERTY_MANUFACTURER = NAMESPACE + "manufacturer";

  public static final String PROPERTY_MAP = NAMESPACE + "map";

  public static final String PROPERTY_MAP_TYPE = NAMESPACE + "mapType";

  public static final String PROPERTY_MAPS = NAMESPACE + "maps";

  public static final String PROPERTY_MATERIAL = NAMESPACE + "material";

  public static final String PROPERTY_MAX_PRICE = NAMESPACE + "maxPrice";

  public static final String PROPERTY_MAX_VALUE = NAMESPACE + "maxValue";

  public static final String PROPERTY_MAXIMUM_INTAKE = NAMESPACE + "maximumIntake";

  public static final String PROPERTY_MEAL_SERVICE = NAMESPACE + "mealService";

  public static final String PROPERTY_MECHANISM_OF_ACTION = NAMESPACE + "mechanismOfAction";

  public static final String PROPERTY_MEDICAL_SPECIALTY = NAMESPACE + "medicalSpecialty";

  public static final String PROPERTY_MEDICINE_SYSTEM = NAMESPACE + "medicineSystem";

  public static final String PROPERTY_MEMBER = NAMESPACE + "member";

  public static final String PROPERTY_MEMBER_OF = NAMESPACE + "memberOf";

  public static final String PROPERTY_MEMBERS = NAMESPACE + "members";

  public static final String PROPERTY_MEMBERSHIP_NUMBER = NAMESPACE + "membershipNumber";

  public static final String PROPERTY_MEMORY_REQUIREMENTS = NAMESPACE + "memoryRequirements";

  public static final String PROPERTY_MENTIONS = NAMESPACE + "mentions";

  public static final String PROPERTY_MENU = NAMESPACE + "menu";

  public static final String PROPERTY_MERCHANT = NAMESPACE + "merchant";

  public static final String PROPERTY_MILEAGE_FROM_ODOMETER = NAMESPACE + "mileageFromOdometer";

  public static final String PROPERTY_MIN_PRICE = NAMESPACE + "minPrice";

  public static final String PROPERTY_MIN_VALUE = NAMESPACE + "minValue";

  public static final String PROPERTY_MINIMUM_PAYMENT_DUE = NAMESPACE + "minimumPaymentDue";

  public static final String PROPERTY_MODEL = NAMESPACE + "model";

  public static final String PROPERTY_MODIFIED_TIME = NAMESPACE + "modifiedTime";

  public static final String PROPERTY_MPN = NAMESPACE + "mpn";

  public static final String PROPERTY_MULTIPLE_VALUES = NAMESPACE + "multipleValues";

  public static final String PROPERTY_MUSCLE_ACTION = NAMESPACE + "muscleAction";

  public static final String PROPERTY_MUSIC_ARRANGEMENT = NAMESPACE + "musicArrangement";

  public static final String PROPERTY_MUSIC_BY = NAMESPACE + "musicBy";

  public static final String PROPERTY_MUSIC_COMPOSITION_FORM = NAMESPACE + "musicCompositionForm";

  public static final String PROPERTY_MUSIC_GROUP_MEMBER = NAMESPACE + "musicGroupMember";

  public static final String PROPERTY_MUSIC_RELEASE_FORMAT = NAMESPACE + "musicReleaseFormat";

  public static final String PROPERTY_MUSICAL_KEY = NAMESPACE + "musicalKey";

  public static final String PROPERTY_NAICS = NAMESPACE + "naics";

  public static final String PROPERTY_NAME = NAMESPACE + "name";

  public static final String PROPERTY_NAMED_POSITION = NAMESPACE + "namedPosition";

  public static final String PROPERTY_NATIONALITY = NAMESPACE + "nationality";

  public static final String PROPERTY_NATURAL_PROGRESSION = NAMESPACE + "naturalProgression";

  public static final String PROPERTY_NERVE = NAMESPACE + "nerve";

  public static final String PROPERTY_NERVE_MOTOR = NAMESPACE + "nerveMotor";

  public static final String PROPERTY_NET_WORTH = NAMESPACE + "netWorth";

  public static final String PROPERTY_NEXT_ITEM = NAMESPACE + "nextItem";

  public static final String PROPERTY_NON_EQUAL = NAMESPACE + "nonEqual";

  public static final String PROPERTY_NON_PROPRIETARY_NAME = NAMESPACE + "nonProprietaryName";

  public static final String PROPERTY_NORMAL_RANGE = NAMESPACE + "normalRange";

  public static final String PROPERTY_NUM_ADULTS = NAMESPACE + "numAdults";

  public static final String PROPERTY_NUM_CHILDREN = NAMESPACE + "numChildren";

  public static final String PROPERTY_NUM_TRACKS = NAMESPACE + "numTracks";

  public static final String PROPERTY_NUMBER_OF_AIRBAGS = NAMESPACE + "numberOfAirbags";

  public static final String PROPERTY_NUMBER_OF_AXLES = NAMESPACE + "numberOfAxles";

  public static final String PROPERTY_NUMBER_OF_DOORS = NAMESPACE + "numberOfDoors";

  public static final String PROPERTY_NUMBER_OF_EMPLOYEES = NAMESPACE + "numberOfEmployees";

  public static final String PROPERTY_NUMBER_OF_EPISODES = NAMESPACE + "numberOfEpisodes";

  public static final String PROPERTY_NUMBER_OF_FORWARD_GEARS = NAMESPACE + "numberOfForwardGears";

  public static final String PROPERTY_NUMBER_OF_ITEMS = NAMESPACE + "numberOfItems";

  public static final String PROPERTY_NUMBER_OF_PAGES = NAMESPACE + "numberOfPages";

  public static final String PROPERTY_NUMBER_OF_PLAYERS = NAMESPACE + "numberOfPlayers";

  public static final String PROPERTY_NUMBER_OF_PREVIOUS_OWNERS =
      NAMESPACE + "numberOfPreviousOwners";

  public static final String PROPERTY_NUMBER_OF_SEASONS = NAMESPACE + "numberOfSeasons";

  public static final String PROPERTY_NUMBERED_POSITION = NAMESPACE + "numberedPosition";

  public static final String PROPERTY_NUTRITION = NAMESPACE + "nutrition";

  public static final String PROPERTY_OBJECT = NAMESPACE + "object";

  public static final String PROPERTY_OCCUPATIONAL_CATEGORY = NAMESPACE + "occupationalCategory";

  public static final String PROPERTY_OFFER_COUNT = NAMESPACE + "offerCount";

  public static final String PROPERTY_OFFERED_BY = NAMESPACE + "offeredBy";

  public static final String PROPERTY_OFFERS = NAMESPACE + "offers";

  public static final String PROPERTY_OPENING_HOURS = NAMESPACE + "openingHours";

  public static final String PROPERTY_OPENING_HOURS_SPECIFICATION =
      NAMESPACE + "openingHoursSpecification";

  public static final String PROPERTY_OPENS = NAMESPACE + "opens";

  public static final String PROPERTY_OPERATING_SYSTEM = NAMESPACE + "operatingSystem";

  public static final String PROPERTY_OPPONENT = NAMESPACE + "opponent";

  public static final String PROPERTY_OPTION = NAMESPACE + "option";

  public static final String PROPERTY_ORDER_DATE = NAMESPACE + "orderDate";

  public static final String PROPERTY_ORDER_DELIVERY = NAMESPACE + "orderDelivery";

  public static final String PROPERTY_ORDER_ITEM_NUMBER = NAMESPACE + "orderItemNumber";

  public static final String PROPERTY_ORDER_ITEM_STATUS = NAMESPACE + "orderItemStatus";

  public static final String PROPERTY_ORDER_NUMBER = NAMESPACE + "orderNumber";

  public static final String PROPERTY_ORDER_QUANTITY = NAMESPACE + "orderQuantity";

  public static final String PROPERTY_ORDER_STATUS = NAMESPACE + "orderStatus";

  public static final String PROPERTY_ORDERED_ITEM = NAMESPACE + "orderedItem";

  public static final String PROPERTY_ORGANIZER = NAMESPACE + "organizer";

  public static final String PROPERTY_ORIGIN = NAMESPACE + "origin";

  public static final String PROPERTY_ORIGIN_ADDRESS = NAMESPACE + "originAddress";

  public static final String PROPERTY_ORIGINATES_FROM = NAMESPACE + "originatesFrom";

  public static final String PROPERTY_OUTCOME = NAMESPACE + "outcome";

  public static final String PROPERTY_OVERDOSAGE = NAMESPACE + "overdosage";

  public static final String PROPERTY_OVERVIEW = NAMESPACE + "overview";

  public static final String PROPERTY_OWNED_FROM = NAMESPACE + "ownedFrom";

  public static final String PROPERTY_OWNED_THROUGH = NAMESPACE + "ownedThrough";

  public static final String PROPERTY_OWNS = NAMESPACE + "owns";

  public static final String PROPERTY_PAGE_END = NAMESPACE + "pageEnd";

  public static final String PROPERTY_PAGE_START = NAMESPACE + "pageStart";

  public static final String PROPERTY_PAGINATION = NAMESPACE + "pagination";

  public static final String PROPERTY_PARENT = NAMESPACE + "parent";

  public static final String PROPERTY_PARENT_ITEM = NAMESPACE + "parentItem";

  public static final String PROPERTY_PARENT_ORGANIZATION = NAMESPACE + "parentOrganization";

  public static final String PROPERTY_PARENT_SERVICE = NAMESPACE + "parentService";

  public static final String PROPERTY_PARENTS = NAMESPACE + "parents";

  public static final String PROPERTY_PART_OF_EPISODE = NAMESPACE + "partOfEpisode";

  public static final String PROPERTY_PART_OF_INVOICE = NAMESPACE + "partOfInvoice";

  public static final String PROPERTY_PART_OF_ORDER = NAMESPACE + "partOfOrder";

  public static final String PROPERTY_PART_OF_SEASON = NAMESPACE + "partOfSeason";

  public static final String PROPERTY_PART_OF_SERIES = NAMESPACE + "partOfSeries";

  public static final String PROPERTY_PART_OF_SYSTEM = NAMESPACE + "partOfSystem";

  public static final String PROPERTY_PART_OF_TV_SERIES = NAMESPACE + "partOfTVSeries";

  public static final String PROPERTY_PARTICIPANT = NAMESPACE + "participant";

  public static final String PROPERTY_PARTY_SIZE = NAMESPACE + "partySize";

  public static final String PROPERTY_PASSENGER_PRIORITY_STATUS =
      NAMESPACE + "passengerPriorityStatus";

  public static final String PROPERTY_PASSENGER_SEQUENCE_NUMBER =
      NAMESPACE + "passengerSequenceNumber";

  public static final String PROPERTY_PATHOPHYSIOLOGY = NAMESPACE + "pathophysiology";

  public static final String PROPERTY_PAYMENT_ACCEPTED = NAMESPACE + "paymentAccepted";

  public static final String PROPERTY_PAYMENT_DUE = NAMESPACE + "paymentDue";

  public static final String PROPERTY_PAYMENT_DUE_DATE = NAMESPACE + "paymentDueDate";

  public static final String PROPERTY_PAYMENT_METHOD = NAMESPACE + "paymentMethod";

  public static final String PROPERTY_PAYMENT_METHOD_ID = NAMESPACE + "paymentMethodId";

  public static final String PROPERTY_PAYMENT_STATUS = NAMESPACE + "paymentStatus";

  public static final String PROPERTY_PAYMENT_URL = NAMESPACE + "paymentUrl";

  public static final String PROPERTY_PERFORMER = NAMESPACE + "performer";

  public static final String PROPERTY_PERFORMER_IN = NAMESPACE + "performerIn";

  public static final String PROPERTY_PERFORMERS = NAMESPACE + "performers";

  public static final String PROPERTY_PERMISSIONS = NAMESPACE + "permissions";

  public static final String PROPERTY_PERMIT_AUDIENCE = NAMESPACE + "permitAudience";

  public static final String PROPERTY_PHASE = NAMESPACE + "phase";

  public static final String PROPERTY_PHOTO = NAMESPACE + "photo";

  public static final String PROPERTY_PHOTOS = NAMESPACE + "photos";

  public static final String PROPERTY_PHYSIOLOGICAL_BENEFITS = NAMESPACE + "physiologicalBenefits";

  public static final String PROPERTY_PICKUP_LOCATION = NAMESPACE + "pickupLocation";

  public static final String PROPERTY_PICKUP_TIME = NAMESPACE + "pickupTime";

  public static final String PROPERTY_PLAY_MODE = NAMESPACE + "playMode";

  public static final String PROPERTY_PLAYER_TYPE = NAMESPACE + "playerType";

  public static final String PROPERTY_PLAYERS_ONLINE = NAMESPACE + "playersOnline";

  public static final String PROPERTY_POLYGON = NAMESPACE + "polygon";

  public static final String PROPERTY_POPULATION = NAMESPACE + "population";

  public static final String PROPERTY_POSITION = NAMESPACE + "position";

  public static final String PROPERTY_POSSIBLE_COMPLICATION = NAMESPACE + "possibleComplication";

  public static final String PROPERTY_POSSIBLE_TREATMENT = NAMESPACE + "possibleTreatment";

  public static final String PROPERTY_POST_OFFICE_BOX_NUMBER = NAMESPACE + "postOfficeBoxNumber";

  public static final String PROPERTY_POST_OP = NAMESPACE + "postOp";

  public static final String PROPERTY_POSTAL_CODE = NAMESPACE + "postalCode";

  public static final String PROPERTY_POTENTIAL_ACTION = NAMESPACE + "potentialAction";

  public static final String PROPERTY_PRE_OP = NAMESPACE + "preOp";

  public static final String PROPERTY_PREDECESSOR_OF = NAMESPACE + "predecessorOf";

  public static final String PROPERTY_PREGNANCY_CATEGORY = NAMESPACE + "pregnancyCategory";

  public static final String PROPERTY_PREGNANCY_WARNING = NAMESPACE + "pregnancyWarning";

  public static final String PROPERTY_PREP_TIME = NAMESPACE + "prepTime";

  public static final String PROPERTY_PREPARATION = NAMESPACE + "preparation";

  public static final String PROPERTY_PRESCRIBING_INFO = NAMESPACE + "prescribingInfo";

  public static final String PROPERTY_PRESCRIPTION_STATUS = NAMESPACE + "prescriptionStatus";

  public static final String PROPERTY_PREVIOUS_ITEM = NAMESPACE + "previousItem";

  public static final String PROPERTY_PREVIOUS_START_DATE = NAMESPACE + "previousStartDate";

  public static final String PROPERTY_PRICE = NAMESPACE + "price";

  public static final String PROPERTY_PRICE_CURRENCY = NAMESPACE + "priceCurrency";

  public static final String PROPERTY_PRICE_RANGE = NAMESPACE + "priceRange";

  public static final String PROPERTY_PRICE_SPECIFICATION = NAMESPACE + "priceSpecification";

  public static final String PROPERTY_PRICE_TYPE = NAMESPACE + "priceType";

  public static final String PROPERTY_PRICE_VALID_UNTIL = NAMESPACE + "priceValidUntil";

  public static final String PROPERTY_PRIMARY_IMAGE_OF_PAGE = NAMESPACE + "primaryImageOfPage";

  public static final String PROPERTY_PRIMARY_PREVENTION = NAMESPACE + "primaryPrevention";

  public static final String PROPERTY_PRINT_COLUMN = NAMESPACE + "printColumn";

  public static final String PROPERTY_PRINT_EDITION = NAMESPACE + "printEdition";

  public static final String PROPERTY_PRINT_PAGE = NAMESPACE + "printPage";

  public static final String PROPERTY_PRINT_SECTION = NAMESPACE + "printSection";

  public static final String PROPERTY_PROCEDURE = NAMESPACE + "procedure";

  public static final String PROPERTY_PROCEDURE_TYPE = NAMESPACE + "procedureType";

  public static final String PROPERTY_PROCESSING_TIME = NAMESPACE + "processingTime";

  public static final String PROPERTY_PROCESSOR_REQUIREMENTS = NAMESPACE + "processorRequirements";

  public static final String PROPERTY_PRODUCER = NAMESPACE + "producer";

  public static final String PROPERTY_PRODUCES = NAMESPACE + "produces";

  public static final String PROPERTY_PRODUCT_ID = NAMESPACE + "productID";

  public static final String PROPERTY_PRODUCT_SUPPORTED = NAMESPACE + "productSupported";

  public static final String PROPERTY_PRODUCTION_COMPANY = NAMESPACE + "productionCompany";

  public static final String PROPERTY_PRODUCTION_DATE = NAMESPACE + "productionDate";

  public static final String PROPERTY_PROFICIENCY_LEVEL = NAMESPACE + "proficiencyLevel";

  public static final String PROPERTY_PROGRAM_MEMBERSHIP_USED = NAMESPACE + "programMembershipUsed";

  public static final String PROPERTY_PROGRAM_NAME = NAMESPACE + "programName";

  public static final String PROPERTY_PROGRAMMING_LANGUAGE = NAMESPACE + "programmingLanguage";

  public static final String PROPERTY_PROGRAMMING_MODEL = NAMESPACE + "programmingModel";

  public static final String PROPERTY_PROPERTY_ID = NAMESPACE + "propertyID";

  public static final String PROPERTY_PROPRIETARY_NAME = NAMESPACE + "proprietaryName";

  public static final String PROPERTY_PROTEIN_CONTENT = NAMESPACE + "proteinContent";

  public static final String PROPERTY_PROVIDER = NAMESPACE + "provider";

  public static final String PROPERTY_PROVIDER_MOBILITY = NAMESPACE + "providerMobility";

  public static final String PROPERTY_PROVIDES_BROADCAST_SERVICE =
      NAMESPACE + "providesBroadcastService";

  public static final String PROPERTY_PROVIDES_SERVICE = NAMESPACE + "providesService";

  public static final String PROPERTY_PUBLICATION = NAMESPACE + "publication";

  public static final String PROPERTY_PUBLICATION_TYPE = NAMESPACE + "publicationType";

  public static final String PROPERTY_PUBLISHED_ON = NAMESPACE + "publishedOn";

  public static final String PROPERTY_PUBLISHER = NAMESPACE + "publisher";

  public static final String PROPERTY_PUBLISHING_PRINCIPLES = NAMESPACE + "publishingPrinciples";

  public static final String PROPERTY_PURCHASE_DATE = NAMESPACE + "purchaseDate";

  public static final String PROPERTY_PURPOSE = NAMESPACE + "purpose";

  public static final String PROPERTY_QUALIFICATIONS = NAMESPACE + "qualifications";

  public static final String PROPERTY_QUERY = NAMESPACE + "query";

  public static final String PROPERTY_QUEST = NAMESPACE + "quest";

  public static final String PROPERTY_QUESTION = NAMESPACE + "question";

  public static final String PROPERTY_RANGE_INCLUDES = NAMESPACE + "rangeIncludes";

  public static final String PROPERTY_RATING_COUNT = NAMESPACE + "ratingCount";

  public static final String PROPERTY_RATING_VALUE = NAMESPACE + "ratingValue";

  public static final String PROPERTY_READONLY_VALUE = NAMESPACE + "readonlyValue";

  public static final String PROPERTY_REAL_ESTATE_AGENT = NAMESPACE + "realEstateAgent";

  public static final String PROPERTY_RECIPE = NAMESPACE + "recipe";

  public static final String PROPERTY_RECIPE_CATEGORY = NAMESPACE + "recipeCategory";

  public static final String PROPERTY_RECIPE_CUISINE = NAMESPACE + "recipeCuisine";

  public static final String PROPERTY_RECIPE_INGREDIENT = NAMESPACE + "recipeIngredient";

  public static final String PROPERTY_RECIPE_INSTRUCTIONS = NAMESPACE + "recipeInstructions";

  public static final String PROPERTY_RECIPE_YIELD = NAMESPACE + "recipeYield";

  public static final String PROPERTY_RECIPIENT = NAMESPACE + "recipient";

  public static final String PROPERTY_RECOGNIZING_AUTHORITY = NAMESPACE + "recognizingAuthority";

  public static final String PROPERTY_RECOMMENDATION_STRENGTH =
      NAMESPACE + "recommendationStrength";

  public static final String PROPERTY_RECOMMENDED_INTAKE = NAMESPACE + "recommendedIntake";

  public static final String PROPERTY_RECORD_LABEL = NAMESPACE + "recordLabel";

  public static final String PROPERTY_RECORDED_AS = NAMESPACE + "recordedAs";

  public static final String PROPERTY_RECORDED_AT = NAMESPACE + "recordedAt";

  public static final String PROPERTY_RECORDED_IN = NAMESPACE + "recordedIn";

  public static final String PROPERTY_RECORDING_OF = NAMESPACE + "recordingOf";

  public static final String PROPERTY_REFERENCES_ORDER = NAMESPACE + "referencesOrder";

  public static final String PROPERTY_REGION_DRAINED = NAMESPACE + "regionDrained";

  public static final String PROPERTY_REGIONS_ALLOWED = NAMESPACE + "regionsAllowed";

  public static final String PROPERTY_RELATED_ANATOMY = NAMESPACE + "relatedAnatomy";

  public static final String PROPERTY_RELATED_CONDITION = NAMESPACE + "relatedCondition";

  public static final String PROPERTY_RELATED_DRUG = NAMESPACE + "relatedDrug";

  public static final String PROPERTY_RELATED_LINK = NAMESPACE + "relatedLink";

  public static final String PROPERTY_RELATED_STRUCTURE = NAMESPACE + "relatedStructure";

  public static final String PROPERTY_RELATED_THERAPY = NAMESPACE + "relatedTherapy";

  public static final String PROPERTY_RELATED_TO = NAMESPACE + "relatedTo";

  public static final String PROPERTY_RELEASE_DATE = NAMESPACE + "releaseDate";

  public static final String PROPERTY_RELEASE_NOTES = NAMESPACE + "releaseNotes";

  public static final String PROPERTY_RELEASE_OF = NAMESPACE + "releaseOf";

  public static final String PROPERTY_RELEASED_EVENT = NAMESPACE + "releasedEvent";

  public static final String PROPERTY_RELEVANT_SPECIALTY = NAMESPACE + "relevantSpecialty";

  public static final String PROPERTY_REPETITIONS = NAMESPACE + "repetitions";

  public static final String PROPERTY_REPLACEE = NAMESPACE + "replacee";

  public static final String PROPERTY_REPLACER = NAMESPACE + "replacer";

  public static final String PROPERTY_REPLY_TO_URL = NAMESPACE + "replyToUrl";

  public static final String PROPERTY_REPORT_NUMBER = NAMESPACE + "reportNumber";

  public static final String PROPERTY_REPRESENTATIVE_OF_PAGE = NAMESPACE + "representativeOfPage";

  public static final String PROPERTY_REQUIRED_GENDER = NAMESPACE + "requiredGender";

  public static final String PROPERTY_REQUIRED_MAX_AGE = NAMESPACE + "requiredMaxAge";

  public static final String PROPERTY_REQUIRED_MIN_AGE = NAMESPACE + "requiredMinAge";

  public static final String PROPERTY_REQUIREMENTS = NAMESPACE + "requirements";

  public static final String PROPERTY_REQUIRES_SUBSCRIPTION = NAMESPACE + "requiresSubscription";

  public static final String PROPERTY_RESERVATION_FOR = NAMESPACE + "reservationFor";

  public static final String PROPERTY_RESERVATION_ID = NAMESPACE + "reservationId";

  public static final String PROPERTY_RESERVATION_STATUS = NAMESPACE + "reservationStatus";

  public static final String PROPERTY_RESERVED_TICKET = NAMESPACE + "reservedTicket";

  public static final String PROPERTY_RESPONSIBILITIES = NAMESPACE + "responsibilities";

  public static final String PROPERTY_REST_PERIODS = NAMESPACE + "restPeriods";

  public static final String PROPERTY_RESULT = NAMESPACE + "result";

  public static final String PROPERTY_RESULT_COMMENT = NAMESPACE + "resultComment";

  public static final String PROPERTY_RESULT_REVIEW = NAMESPACE + "resultReview";

  public static final String PROPERTY_REVIEW = NAMESPACE + "review";

  public static final String PROPERTY_REVIEW_BODY = NAMESPACE + "reviewBody";

  public static final String PROPERTY_REVIEW_COUNT = NAMESPACE + "reviewCount";

  public static final String PROPERTY_REVIEW_RATING = NAMESPACE + "reviewRating";

  public static final String PROPERTY_REVIEWED_BY = NAMESPACE + "reviewedBy";

  public static final String PROPERTY_REVIEWS = NAMESPACE + "reviews";

  public static final String PROPERTY_RISK_FACTOR = NAMESPACE + "riskFactor";

  public static final String PROPERTY_RISKS = NAMESPACE + "risks";

  public static final String PROPERTY_ROLE_NAME = NAMESPACE + "roleName";

  public static final String PROPERTY_RSVP_RESPONSE = NAMESPACE + "rsvpResponse";

  public static final String PROPERTY_RUNS_TO = NAMESPACE + "runsTo";

  public static final String PROPERTY_RUNTIME = NAMESPACE + "runtime";

  public static final String PROPERTY_RUNTIME_PLATFORM = NAMESPACE + "runtimePlatform";

  public static final String PROPERTY_SAFETY_CONSIDERATION = NAMESPACE + "safetyConsideration";

  public static final String PROPERTY_SALARY_CURRENCY = NAMESPACE + "salaryCurrency";

  public static final String PROPERTY_SAME_AS = NAMESPACE + "sameAs";

  public static final String PROPERTY_SAMPLE_TYPE = NAMESPACE + "sampleType";

  public static final String PROPERTY_SATURATED_FAT_CONTENT = NAMESPACE + "saturatedFatContent";

  public static final String PROPERTY_SCHEDULED_PAYMENT_DATE = NAMESPACE + "scheduledPaymentDate";

  public static final String PROPERTY_SCHEDULED_TIME = NAMESPACE + "scheduledTime";

  public static final String PROPERTY_SCHEMA_VERSION = NAMESPACE + "schemaVersion";

  public static final String PROPERTY_SCREEN_COUNT = NAMESPACE + "screenCount";

  public static final String PROPERTY_SCREENSHOT = NAMESPACE + "screenshot";

  public static final String PROPERTY_SEASON = NAMESPACE + "season";

  public static final String PROPERTY_SEASON_NUMBER = NAMESPACE + "seasonNumber";

  public static final String PROPERTY_SEASONS = NAMESPACE + "seasons";

  public static final String PROPERTY_SEAT_NUMBER = NAMESPACE + "seatNumber";

  public static final String PROPERTY_SEAT_ROW = NAMESPACE + "seatRow";

  public static final String PROPERTY_SEAT_SECTION = NAMESPACE + "seatSection";

  public static final String PROPERTY_SEATING_TYPE = NAMESPACE + "seatingType";

  public static final String PROPERTY_SECONDARY_PREVENTION = NAMESPACE + "secondaryPrevention";

  public static final String PROPERTY_SECURITY_SCREENING = NAMESPACE + "securityScreening";

  public static final String PROPERTY_SEEKS = NAMESPACE + "seeks";

  public static final String PROPERTY_SELLER = NAMESPACE + "seller";

  public static final String PROPERTY_SENDER = NAMESPACE + "sender";

  public static final String PROPERTY_SENSORY_UNIT = NAMESPACE + "sensoryUnit";

  public static final String PROPERTY_SERIAL_NUMBER = NAMESPACE + "serialNumber";

  public static final String PROPERTY_SERIOUS_ADVERSE_OUTCOME = NAMESPACE + "seriousAdverseOutcome";

  public static final String PROPERTY_SERVER_STATUS = NAMESPACE + "serverStatus";

  public static final String PROPERTY_SERVES_CUISINE = NAMESPACE + "servesCuisine";

  public static final String PROPERTY_SERVICE_AREA = NAMESPACE + "serviceArea";

  public static final String PROPERTY_SERVICE_AUDIENCE = NAMESPACE + "serviceAudience";

  public static final String PROPERTY_SERVICE_LOCATION = NAMESPACE + "serviceLocation";

  public static final String PROPERTY_SERVICE_OPERATOR = NAMESPACE + "serviceOperator";

  public static final String PROPERTY_SERVICE_OUTPUT = NAMESPACE + "serviceOutput";

  public static final String PROPERTY_SERVICE_PHONE = NAMESPACE + "servicePhone";

  public static final String PROPERTY_SERVICE_POSTAL_ADDRESS = NAMESPACE + "servicePostalAddress";

  public static final String PROPERTY_SERVICE_SMS_NUMBER = NAMESPACE + "serviceSmsNumber";

  public static final String PROPERTY_SERVICE_TYPE = NAMESPACE + "serviceType";

  public static final String PROPERTY_SERVICE_URL = NAMESPACE + "serviceUrl";

  public static final String PROPERTY_SERVING_SIZE = NAMESPACE + "servingSize";

  public static final String PROPERTY_SHARED_CONTENT = NAMESPACE + "sharedContent";

  public static final String PROPERTY_SIBLING = NAMESPACE + "sibling";

  public static final String PROPERTY_SIBLINGS = NAMESPACE + "siblings";

  public static final String PROPERTY_SIGN_DETECTED = NAMESPACE + "signDetected";

  public static final String PROPERTY_SIGN_OR_SYMPTOM = NAMESPACE + "signOrSymptom";

  public static final String PROPERTY_SIGNIFICANCE = NAMESPACE + "significance";

  public static final String PROPERTY_SIGNIFICANT_LINK = NAMESPACE + "significantLink";

  public static final String PROPERTY_SIGNIFICANT_LINKS = NAMESPACE + "significantLinks";

  public static final String PROPERTY_SKILLS = NAMESPACE + "skills";

  public static final String PROPERTY_SKU = NAMESPACE + "sku";

  public static final String PROPERTY_SODIUM_CONTENT = NAMESPACE + "sodiumContent";

  public static final String PROPERTY_SOFTWARE_ADD_ON = NAMESPACE + "softwareAddOn";

  public static final String PROPERTY_SOFTWARE_HELP = NAMESPACE + "softwareHelp";

  public static final String PROPERTY_SOFTWARE_REQUIREMENTS = NAMESPACE + "softwareRequirements";

  public static final String PROPERTY_SOFTWARE_VERSION = NAMESPACE + "softwareVersion";

  public static final String PROPERTY_SOURCE = NAMESPACE + "source";

  public static final String PROPERTY_SOURCE_ORGANIZATION = NAMESPACE + "sourceOrganization";

  public static final String PROPERTY_SOURCED_FROM = NAMESPACE + "sourcedFrom";

  public static final String PROPERTY_SPATIAL = NAMESPACE + "spatial";

  public static final String PROPERTY_SPECIAL_COMMITMENTS = NAMESPACE + "specialCommitments";

  public static final String PROPERTY_SPECIALTY = NAMESPACE + "specialty";

  public static final String PROPERTY_SPONSOR = NAMESPACE + "sponsor";

  public static final String PROPERTY_SPORT = NAMESPACE + "sport";

  public static final String PROPERTY_SPORTS_ACTIVITY_LOCATION =
      NAMESPACE + "sportsActivityLocation";

  public static final String PROPERTY_SPORTS_EVENT = NAMESPACE + "sportsEvent";

  public static final String PROPERTY_SPORTS_TEAM = NAMESPACE + "sportsTeam";

  public static final String PROPERTY_SPOUSE = NAMESPACE + "spouse";

  public static final String PROPERTY_STAGE = NAMESPACE + "stage";

  public static final String PROPERTY_STAGE_AS_NUMBER = NAMESPACE + "stageAsNumber";

  public static final String PROPERTY_START_DATE = NAMESPACE + "startDate";

  public static final String PROPERTY_START_TIME = NAMESPACE + "startTime";

  public static final String PROPERTY_STATUS = NAMESPACE + "status";

  public static final String PROPERTY_STEERING_POSITION = NAMESPACE + "steeringPosition";

  public static final String PROPERTY_STEP_VALUE = NAMESPACE + "stepValue";

  public static final String PROPERTY_STORAGE_REQUIREMENTS = NAMESPACE + "storageRequirements";

  public static final String PROPERTY_STREET_ADDRESS = NAMESPACE + "streetAddress";

  public static final String PROPERTY_STRENGTH_UNIT = NAMESPACE + "strengthUnit";

  public static final String PROPERTY_STRENGTH_VALUE = NAMESPACE + "strengthValue";

  public static final String PROPERTY_STRUCTURAL_CLASS = NAMESPACE + "structuralClass";

  public static final String PROPERTY_STUDY = NAMESPACE + "study";

  public static final String PROPERTY_STUDY_DESIGN = NAMESPACE + "studyDesign";

  public static final String PROPERTY_STUDY_LOCATION = NAMESPACE + "studyLocation";

  public static final String PROPERTY_STUDY_SUBJECT = NAMESPACE + "studySubject";

  public static final String PROPERTY_SUB_EVENT = NAMESPACE + "subEvent";

  public static final String PROPERTY_SUB_EVENTS = NAMESPACE + "subEvents";

  public static final String PROPERTY_SUB_ORGANIZATION = NAMESPACE + "subOrganization";

  public static final String PROPERTY_SUB_RESERVATION = NAMESPACE + "subReservation";

  public static final String PROPERTY_SUB_STAGE_SUFFIX = NAMESPACE + "subStageSuffix";

  public static final String PROPERTY_SUB_STRUCTURE = NAMESPACE + "subStructure";

  public static final String PROPERTY_SUB_TEST = NAMESPACE + "subTest";

  public static final String PROPERTY_SUBTITLE_LANGUAGE = NAMESPACE + "subtitleLanguage";

  public static final String PROPERTY_SUBTYPE = NAMESPACE + "subtype";

  public static final String PROPERTY_SUCCESSOR_OF = NAMESPACE + "successorOf";

  public static final String PROPERTY_SUGAR_CONTENT = NAMESPACE + "sugarContent";

  public static final String PROPERTY_SUGGESTED_ANSWER = NAMESPACE + "suggestedAnswer";

  public static final String PROPERTY_SUGGESTED_GENDER = NAMESPACE + "suggestedGender";

  public static final String PROPERTY_SUGGESTED_MAX_AGE = NAMESPACE + "suggestedMaxAge";

  public static final String PROPERTY_SUGGESTED_MIN_AGE = NAMESPACE + "suggestedMinAge";

  public static final String PROPERTY_SUPER_EVENT = NAMESPACE + "superEvent";

  public static final String PROPERTY_SUPERSEDED_BY = NAMESPACE + "supersededBy";

  public static final String PROPERTY_SUPPLY_TO = NAMESPACE + "supplyTo";

  public static final String PROPERTY_SUPPORTING_DATA = NAMESPACE + "supportingData";

  public static final String PROPERTY_SURFACE = NAMESPACE + "surface";

  public static final String PROPERTY_TARGET = NAMESPACE + "target";

  public static final String PROPERTY_TARGET_COLLECTION = NAMESPACE + "targetCollection";

  public static final String PROPERTY_TARGET_DESCRIPTION = NAMESPACE + "targetDescription";

  public static final String PROPERTY_TARGET_NAME = NAMESPACE + "targetName";

  public static final String PROPERTY_TARGET_PLATFORM = NAMESPACE + "targetPlatform";

  public static final String PROPERTY_TARGET_POPULATION = NAMESPACE + "targetPopulation";

  public static final String PROPERTY_TARGET_PRODUCT = NAMESPACE + "targetProduct";

  public static final String PROPERTY_TARGET_URL = NAMESPACE + "targetUrl";

  public static final String PROPERTY_TAX_ID = NAMESPACE + "taxID";

  public static final String PROPERTY_TELEPHONE = NAMESPACE + "telephone";

  public static final String PROPERTY_TEMPORAL = NAMESPACE + "temporal";

  public static final String PROPERTY_TEXT = NAMESPACE + "text";

  public static final String PROPERTY_THUMBNAIL = NAMESPACE + "thumbnail";

  public static final String PROPERTY_THUMBNAIL_URL = NAMESPACE + "thumbnailUrl";

  public static final String PROPERTY_TICKER_SYMBOL = NAMESPACE + "tickerSymbol";

  public static final String PROPERTY_TICKET_NUMBER = NAMESPACE + "ticketNumber";

  public static final String PROPERTY_TICKET_TOKEN = NAMESPACE + "ticketToken";

  public static final String PROPERTY_TICKETED_SEAT = NAMESPACE + "ticketedSeat";

  public static final String PROPERTY_TIME_REQUIRED = NAMESPACE + "timeRequired";

  public static final String PROPERTY_TISSUE_SAMPLE = NAMESPACE + "tissueSample";

  public static final String PROPERTY_TITLE = NAMESPACE + "title";

  public static final String PROPERTY_TO_LOCATION = NAMESPACE + "toLocation";

  public static final String PROPERTY_TOTAL_PAYMENT_DUE = NAMESPACE + "totalPaymentDue";

  public static final String PROPERTY_TOTAL_PRICE = NAMESPACE + "totalPrice";

  public static final String PROPERTY_TOTAL_TIME = NAMESPACE + "totalTime";

  public static final String PROPERTY_TRACK = NAMESPACE + "track";

  public static final String PROPERTY_TRACKING_NUMBER = NAMESPACE + "trackingNumber";

  public static final String PROPERTY_TRACKING_URL = NAMESPACE + "trackingUrl";

  public static final String PROPERTY_TRACKS = NAMESPACE + "tracks";

  public static final String PROPERTY_TRAILER = NAMESPACE + "trailer";

  public static final String PROPERTY_TRAIN_NAME = NAMESPACE + "trainName";

  public static final String PROPERTY_TRAIN_NUMBER = NAMESPACE + "trainNumber";

  public static final String PROPERTY_TRANS_FAT_CONTENT = NAMESPACE + "transFatContent";

  public static final String PROPERTY_TRANSCRIPT = NAMESPACE + "transcript";

  public static final String PROPERTY_TRANSLATOR = NAMESPACE + "translator";

  public static final String PROPERTY_TRANSMISSION_METHOD = NAMESPACE + "transmissionMethod";

  public static final String PROPERTY_TRIAL_DESIGN = NAMESPACE + "trialDesign";

  public static final String PROPERTY_TRIBUTARY = NAMESPACE + "tributary";

  public static final String PROPERTY_TYPE_OF_GOOD = NAMESPACE + "typeOfGood";

  public static final String PROPERTY_TYPICAL_AGE_RANGE = NAMESPACE + "typicalAgeRange";

  public static final String PROPERTY_TYPICAL_TEST = NAMESPACE + "typicalTest";

  public static final String PROPERTY_UNDER_NAME = NAMESPACE + "underName";

  public static final String PROPERTY_UNIT_CODE = NAMESPACE + "unitCode";

  public static final String PROPERTY_UNIT_TEXT = NAMESPACE + "unitText";

  public static final String PROPERTY_UNSATURATED_FAT_CONTENT = NAMESPACE + "unsaturatedFatContent";

  public static final String PROPERTY_UPLOAD_DATE = NAMESPACE + "uploadDate";

  public static final String PROPERTY_UPVOTE_COUNT = NAMESPACE + "upvoteCount";

  public static final String PROPERTY_URL = NAMESPACE + "url";

  public static final String PROPERTY_URL_TEMPLATE = NAMESPACE + "urlTemplate";

  public static final String PROPERTY_USED_TO_DIAGNOSE = NAMESPACE + "usedToDiagnose";

  public static final String PROPERTY_USER_INTERACTION_COUNT = NAMESPACE + "userInteractionCount";

  public static final String PROPERTY_USES_DEVICE = NAMESPACE + "usesDevice";

  public static final String PROPERTY_VALID_FOR = NAMESPACE + "validFor";

  public static final String PROPERTY_VALID_FROM = NAMESPACE + "validFrom";

  public static final String PROPERTY_VALID_IN = NAMESPACE + "validIn";

  public static final String PROPERTY_VALID_THROUGH = NAMESPACE + "validThrough";

  public static final String PROPERTY_VALID_UNTIL = NAMESPACE + "validUntil";

  public static final String PROPERTY_VALUE = NAMESPACE + "value";

  public static final String PROPERTY_VALUE_ADDED_TAX_INCLUDED =
      NAMESPACE + "valueAddedTaxIncluded";

  public static final String PROPERTY_VALUE_MAX_LENGTH = NAMESPACE + "valueMaxLength";

  public static final String PROPERTY_VALUE_MIN_LENGTH = NAMESPACE + "valueMinLength";

  public static final String PROPERTY_VALUE_NAME = NAMESPACE + "valueName";

  public static final String PROPERTY_VALUE_PATTERN = NAMESPACE + "valuePattern";

  public static final String PROPERTY_VALUE_REFERENCE = NAMESPACE + "valueReference";

  public static final String PROPERTY_VALUE_REQUIRED = NAMESPACE + "valueRequired";

  public static final String PROPERTY_VAT_ID = NAMESPACE + "vatID";

  public static final String PROPERTY_VEHICLE_CONFIGURATION = NAMESPACE + "vehicleConfiguration";

  public static final String PROPERTY_VEHICLE_ENGINE = NAMESPACE + "vehicleEngine";

  public static final String PROPERTY_VEHICLE_IDENTIFICATION_NUMBER =
      NAMESPACE + "vehicleIdentificationNumber";

  public static final String PROPERTY_VEHICLE_INTERIOR_COLOR = NAMESPACE + "vehicleInteriorColor";

  public static final String PROPERTY_VEHICLE_INTERIOR_TYPE = NAMESPACE + "vehicleInteriorType";

  public static final String PROPERTY_VEHICLE_MODEL_DATE = NAMESPACE + "vehicleModelDate";

  public static final String PROPERTY_VEHICLE_SEATING_CAPACITY =
      NAMESPACE + "vehicleSeatingCapacity";

  public static final String PROPERTY_VEHICLE_SPECIAL_USAGE = NAMESPACE + "vehicleSpecialUsage";

  public static final String PROPERTY_VEHICLE_TRANSMISSION = NAMESPACE + "vehicleTransmission";

  public static final String PROPERTY_VENDOR = NAMESPACE + "vendor";

  public static final String PROPERTY_VERSION = NAMESPACE + "version";

  public static final String PROPERTY_VIDEO = NAMESPACE + "video";

  public static final String PROPERTY_VIDEO_FORMAT = NAMESPACE + "videoFormat";

  public static final String PROPERTY_VIDEO_FRAME_SIZE = NAMESPACE + "videoFrameSize";

  public static final String PROPERTY_VIDEO_QUALITY = NAMESPACE + "videoQuality";

  public static final String PROPERTY_VOLUME_NUMBER = NAMESPACE + "volumeNumber";

  public static final String PROPERTY_WARNING = NAMESPACE + "warning";

  public static final String PROPERTY_WARRANTY = NAMESPACE + "warranty";

  public static final String PROPERTY_WARRANTY_PROMISE = NAMESPACE + "warrantyPromise";

  public static final String PROPERTY_WARRANTY_SCOPE = NAMESPACE + "warrantyScope";

  public static final String PROPERTY_WEB_CHECKIN_TIME = NAMESPACE + "webCheckinTime";

  public static final String PROPERTY_WEIGHT = NAMESPACE + "weight";

  public static final String PROPERTY_WIDTH = NAMESPACE + "width";

  public static final String PROPERTY_WINNER = NAMESPACE + "winner";

  public static final String PROPERTY_WORD_COUNT = NAMESPACE + "wordCount";

  public static final String PROPERTY_WORK_EXAMPLE = NAMESPACE + "workExample";

  public static final String PROPERTY_WORK_FEATURED = NAMESPACE + "workFeatured";

  public static final String PROPERTY_WORK_HOURS = NAMESPACE + "workHours";

  public static final String PROPERTY_WORK_LOCATION = NAMESPACE + "workLocation";

  public static final String PROPERTY_WORK_PERFORMED = NAMESPACE + "workPerformed";

  public static final String PROPERTY_WORK_PRESENTED = NAMESPACE + "workPresented";

  public static final String PROPERTY_WORKLOAD = NAMESPACE + "workload";

  public static final String PROPERTY_WORKS_FOR = NAMESPACE + "worksFor";

  public static final String PROPERTY_WORST_RATING = NAMESPACE + "worstRating";

  public static final String PROPERTY_YEARLY_REVENUE = NAMESPACE + "yearlyRevenue";

  public static final String PROPERTY_YEARS_IN_OPERATION = NAMESPACE + "yearsInOperation";

  public static final String TYPE_API_REFERENCE = NAMESPACE + "APIReference";

  public static final String TYPE_ABOUT_PAGE = NAMESPACE + "AboutPage";

  public static final String TYPE_ACCEPT_ACTION = NAMESPACE + "AcceptAction";

  public static final String TYPE_ACCOUNTING_SERVICE = NAMESPACE + "AccountingService";

  public static final String TYPE_ACHIEVE_ACTION = NAMESPACE + "AchieveAction";

  public static final String TYPE_ACTION = NAMESPACE + "Action";

  public static final String TYPE_ACTION_STATUS_TYPE = NAMESPACE + "ActionStatusType";

  public static final String TYPE_ACTIVATE_ACTION = NAMESPACE + "ActivateAction";

  public static final String TYPE_ADD_ACTION = NAMESPACE + "AddAction";

  public static final String TYPE_ADMINISTRATIVE_AREA = NAMESPACE + "AdministrativeArea";

  public static final String TYPE_ADULT_ENTERTAINMENT = NAMESPACE + "AdultEntertainment";

  public static final String TYPE_AGGREGATE_OFFER = NAMESPACE + "AggregateOffer";

  public static final String TYPE_AGGREGATE_RATING = NAMESPACE + "AggregateRating";

  public static final String TYPE_AGREE_ACTION = NAMESPACE + "AgreeAction";

  public static final String TYPE_AIRLINE = NAMESPACE + "Airline";

  public static final String TYPE_AIRPORT = NAMESPACE + "Airport";

  public static final String TYPE_ALIGNMENT_OBJECT = NAMESPACE + "AlignmentObject";

  public static final String TYPE_ALLOCATE_ACTION = NAMESPACE + "AllocateAction";

  public static final String TYPE_AMUSEMENT_PARK = NAMESPACE + "AmusementPark";

  public static final String TYPE_ANATOMICAL_STRUCTURE = NAMESPACE + "AnatomicalStructure";

  public static final String TYPE_ANATOMICAL_SYSTEM = NAMESPACE + "AnatomicalSystem";

  public static final String TYPE_ANIMAL_SHELTER = NAMESPACE + "AnimalShelter";

  public static final String TYPE_ANSWER = NAMESPACE + "Answer";

  public static final String TYPE_APARTMENT_COMPLEX = NAMESPACE + "ApartmentComplex";

  public static final String TYPE_APPEND_ACTION = NAMESPACE + "AppendAction";

  public static final String TYPE_APPLY_ACTION = NAMESPACE + "ApplyAction";

  public static final String TYPE_APPROVED_INDICATION = NAMESPACE + "ApprovedIndication";

  public static final String TYPE_AQUARIUM = NAMESPACE + "Aquarium";

  public static final String TYPE_ARRIVE_ACTION = NAMESPACE + "ArriveAction";

  public static final String TYPE_ART_GALLERY = NAMESPACE + "ArtGallery";

  public static final String TYPE_ARTERY = NAMESPACE + "Artery";

  public static final String TYPE_ARTICLE = NAMESPACE + "Article";

  public static final String TYPE_ASK_ACTION = NAMESPACE + "AskAction";

  public static final String TYPE_ASSESS_ACTION = NAMESPACE + "AssessAction";

  public static final String TYPE_ASSIGN_ACTION = NAMESPACE + "AssignAction";

  public static final String TYPE_ATTORNEY = NAMESPACE + "Attorney";

  public static final String TYPE_AUDIENCE = NAMESPACE + "Audience";

  public static final String TYPE_AUDIO_OBJECT = NAMESPACE + "AudioObject";

  public static final String TYPE_AUTHORIZE_ACTION = NAMESPACE + "AuthorizeAction";

  public static final String TYPE_AUTO_BODY_SHOP = NAMESPACE + "AutoBodyShop";

  public static final String TYPE_AUTO_DEALER = NAMESPACE + "AutoDealer";

  public static final String TYPE_AUTO_PARTS_STORE = NAMESPACE + "AutoPartsStore";

  public static final String TYPE_AUTO_RENTAL = NAMESPACE + "AutoRental";

  public static final String TYPE_AUTO_REPAIR = NAMESPACE + "AutoRepair";

  public static final String TYPE_AUTO_WASH = NAMESPACE + "AutoWash";

  public static final String TYPE_AUTOMATED_TELLER = NAMESPACE + "AutomatedTeller";

  public static final String TYPE_AUTOMOTIVE_BUSINESS = NAMESPACE + "AutomotiveBusiness";

  public static final String TYPE_BAKERY = NAMESPACE + "Bakery";

  public static final String TYPE_BANK_OR_CREDIT_UNION = NAMESPACE + "BankOrCreditUnion";

  public static final String TYPE_BAR_OR_PUB = NAMESPACE + "BarOrPub";

  public static final String TYPE_BARCODE = NAMESPACE + "Barcode";

  public static final String TYPE_BEACH = NAMESPACE + "Beach";

  public static final String TYPE_BEAUTY_SALON = NAMESPACE + "BeautySalon";

  public static final String TYPE_BED_AND_BREAKFAST = NAMESPACE + "BedAndBreakfast";

  public static final String TYPE_BEFRIEND_ACTION = NAMESPACE + "BefriendAction";

  public static final String TYPE_BIKE_STORE = NAMESPACE + "BikeStore";

  public static final String TYPE_BLOG = NAMESPACE + "Blog";

  public static final String TYPE_BLOG_POSTING = NAMESPACE + "BlogPosting";

  public static final String TYPE_BLOOD_TEST = NAMESPACE + "BloodTest";

  public static final String TYPE_BOARDING_POLICY_TYPE = NAMESPACE + "BoardingPolicyType";

  public static final String TYPE_BODY_OF_WATER = NAMESPACE + "BodyOfWater";

  public static final String TYPE_BONE = NAMESPACE + "Bone";

  public static final String TYPE_BOOK = NAMESPACE + "Book";

  public static final String TYPE_BOOK_FORMAT_TYPE = NAMESPACE + "BookFormatType";

  public static final String TYPE_BOOK_SERIES = NAMESPACE + "BookSeries";

  public static final String TYPE_BOOK_STORE = NAMESPACE + "BookStore";

  public static final String TYPE_BOOKMARK_ACTION = NAMESPACE + "BookmarkAction";

  public static final String TYPE_BOOLEAN = NAMESPACE + "Boolean";

  public static final String TYPE_BORROW_ACTION = NAMESPACE + "BorrowAction";

  public static final String TYPE_BOWLING_ALLEY = NAMESPACE + "BowlingAlley";

  public static final String TYPE_BRAIN_STRUCTURE = NAMESPACE + "BrainStructure";

  public static final String TYPE_BRAND = NAMESPACE + "Brand";

  public static final String TYPE_BREADCRUMB_LIST = NAMESPACE + "BreadcrumbList";

  public static final String TYPE_BREWERY = NAMESPACE + "Brewery";

  public static final String TYPE_BRIDGE = NAMESPACE + "Bridge";

  public static final String TYPE_BROADCAST_CHANNEL = NAMESPACE + "BroadcastChannel";

  public static final String TYPE_BROADCAST_EVENT = NAMESPACE + "BroadcastEvent";

  public static final String TYPE_BROADCAST_FREQUENCY_SPECIFICATION =
      NAMESPACE + "BroadcastFrequencySpecification";

  public static final String TYPE_BROADCAST_SERVICE = NAMESPACE + "BroadcastService";

  public static final String TYPE_BUDDHIST_TEMPLE = NAMESPACE + "BuddhistTemple";

  public static final String TYPE_BUS_RESERVATION = NAMESPACE + "BusReservation";

  public static final String TYPE_BUS_STATION = NAMESPACE + "BusStation";

  public static final String TYPE_BUS_STOP = NAMESPACE + "BusStop";

  public static final String TYPE_BUS_TRIP = NAMESPACE + "BusTrip";

  public static final String TYPE_BUSINESS_AUDIENCE = NAMESPACE + "BusinessAudience";

  public static final String TYPE_BUSINESS_ENTITY_TYPE = NAMESPACE + "BusinessEntityType";

  public static final String TYPE_BUSINESS_EVENT = NAMESPACE + "BusinessEvent";

  public static final String TYPE_BUSINESS_FUNCTION = NAMESPACE + "BusinessFunction";

  public static final String TYPE_BUY_ACTION = NAMESPACE + "BuyAction";

  public static final String TYPE_CABLE_OR_SATELLITE_SERVICE =
      NAMESPACE + "CableOrSatelliteService";

  public static final String TYPE_CAFE_OR_COFFEE_SHOP = NAMESPACE + "CafeOrCoffeeShop";

  public static final String TYPE_CAMPGROUND = NAMESPACE + "Campground";

  public static final String TYPE_CANAL = NAMESPACE + "Canal";

  public static final String TYPE_CANCEL_ACTION = NAMESPACE + "CancelAction";

  public static final String TYPE_CAR = NAMESPACE + "Car";

  public static final String TYPE_CAR_USAGE_TYPE = NAMESPACE + "CarUsageType";

  public static final String TYPE_CASINO = NAMESPACE + "Casino";

  public static final String TYPE_CATHOLIC_CHURCH = NAMESPACE + "CatholicChurch";

  public static final String TYPE_CEMETERY = NAMESPACE + "Cemetery";

  public static final String TYPE_CHECK_ACTION = NAMESPACE + "CheckAction";

  public static final String TYPE_CHECK_IN_ACTION = NAMESPACE + "CheckInAction";

  public static final String TYPE_CHECK_OUT_ACTION = NAMESPACE + "CheckOutAction";

  public static final String TYPE_CHECKOUT_PAGE = NAMESPACE + "CheckoutPage";

  public static final String TYPE_CHILD_CARE = NAMESPACE + "ChildCare";

  public static final String TYPE_CHILDRENS_EVENT = NAMESPACE + "ChildrensEvent";

  public static final String TYPE_CHOOSE_ACTION = NAMESPACE + "ChooseAction";

  public static final String TYPE_CHURCH = NAMESPACE + "Church";

  public static final String TYPE_CITY = NAMESPACE + "City";

  public static final String TYPE_CITY_HALL = NAMESPACE + "CityHall";

  public static final String TYPE_CIVIC_STRUCTURE = NAMESPACE + "CivicStructure";

  public static final String TYPE_CLASS = NAMESPACE + "Class";

  public static final String TYPE_CLIP = NAMESPACE + "Clip";

  public static final String TYPE_CLOTHING_STORE = NAMESPACE + "ClothingStore";

  public static final String TYPE_CODE = NAMESPACE + "Code";

  public static final String TYPE_COLLECTION_PAGE = NAMESPACE + "CollectionPage";

  public static final String TYPE_COLLEGE_OR_UNIVERSITY = NAMESPACE + "CollegeOrUniversity";

  public static final String TYPE_COMEDY_CLUB = NAMESPACE + "ComedyClub";

  public static final String TYPE_COMEDY_EVENT = NAMESPACE + "ComedyEvent";

  public static final String TYPE_COMMENT = NAMESPACE + "Comment";

  public static final String TYPE_COMMENT_ACTION = NAMESPACE + "CommentAction";

  public static final String TYPE_COMMUNICATE_ACTION = NAMESPACE + "CommunicateAction";

  public static final String TYPE_COMPUTER_STORE = NAMESPACE + "ComputerStore";

  public static final String TYPE_CONFIRM_ACTION = NAMESPACE + "ConfirmAction";

  public static final String TYPE_CONSUME_ACTION = NAMESPACE + "ConsumeAction";

  public static final String TYPE_CONTACT_PAGE = NAMESPACE + "ContactPage";

  public static final String TYPE_CONTACT_POINT = NAMESPACE + "ContactPoint";

  public static final String TYPE_CONTACT_POINT_OPTION = NAMESPACE + "ContactPointOption";

  public static final String TYPE_CONTINENT = NAMESPACE + "Continent";

  public static final String TYPE_CONTROL_ACTION = NAMESPACE + "ControlAction";

  public static final String TYPE_CONVENIENCE_STORE = NAMESPACE + "ConvenienceStore";

  public static final String TYPE_COOK_ACTION = NAMESPACE + "CookAction";

  public static final String TYPE_CORPORATION = NAMESPACE + "Corporation";

  public static final String TYPE_COUNTRY = NAMESPACE + "Country";

  public static final String TYPE_COURTHOUSE = NAMESPACE + "Courthouse";

  public static final String TYPE_CREATE_ACTION = NAMESPACE + "CreateAction";

  public static final String TYPE_CREATIVE_WORK = NAMESPACE + "CreativeWork";

  public static final String TYPE_CREATIVE_WORK_SEASON = NAMESPACE + "CreativeWorkSeason";

  public static final String TYPE_CREATIVE_WORK_SERIES = NAMESPACE + "CreativeWorkSeries";

  public static final String TYPE_CREDIT_CARD = NAMESPACE + "CreditCard";

  public static final String TYPE_CREMATORIUM = NAMESPACE + "Crematorium";

  public static final String TYPE_D_DX_ELEMENT = NAMESPACE + "DDxElement";

  public static final String TYPE_DANCE_EVENT = NAMESPACE + "DanceEvent";

  public static final String TYPE_DANCE_GROUP = NAMESPACE + "DanceGroup";

  public static final String TYPE_DATA_CATALOG = NAMESPACE + "DataCatalog";

  public static final String TYPE_DATA_DOWNLOAD = NAMESPACE + "DataDownload";

  public static final String TYPE_DATA_FEED = NAMESPACE + "DataFeed";

  public static final String TYPE_DATA_FEED_ITEM = NAMESPACE + "DataFeedItem";

  public static final String TYPE_DATASET = NAMESPACE + "Dataset";

  public static final String TYPE_DATED_MONEY_SPECIFICATION = NAMESPACE + "DatedMoneySpecification";

  public static final String TYPE_DAY_OF_WEEK = NAMESPACE + "DayOfWeek";

  public static final String TYPE_DAY_SPA = NAMESPACE + "DaySpa";

  public static final String TYPE_DEACTIVATE_ACTION = NAMESPACE + "DeactivateAction";

  public static final String TYPE_DEFENCE_ESTABLISHMENT = NAMESPACE + "DefenceEstablishment";

  public static final String TYPE_DELETE_ACTION = NAMESPACE + "DeleteAction";

  public static final String TYPE_DELIVERY_CHARGE_SPECIFICATION =
      NAMESPACE + "DeliveryChargeSpecification";

  public static final String TYPE_DELIVERY_EVENT = NAMESPACE + "DeliveryEvent";

  public static final String TYPE_DELIVERY_METHOD = NAMESPACE + "DeliveryMethod";

  public static final String TYPE_DEMAND = NAMESPACE + "Demand";

  public static final String TYPE_DENTIST = NAMESPACE + "Dentist";

  public static final String TYPE_DEPART_ACTION = NAMESPACE + "DepartAction";

  public static final String TYPE_DEPARTMENT_STORE = NAMESPACE + "DepartmentStore";

  public static final String TYPE_DIAGNOSTIC_LAB = NAMESPACE + "DiagnosticLab";

  public static final String TYPE_DIAGNOSTIC_PROCEDURE = NAMESPACE + "DiagnosticProcedure";

  public static final String TYPE_DIET = NAMESPACE + "Diet";

  public static final String TYPE_DIETARY_SUPPLEMENT = NAMESPACE + "DietarySupplement";

  public static final String TYPE_DISAGREE_ACTION = NAMESPACE + "DisagreeAction";

  public static final String TYPE_DISCOVER_ACTION = NAMESPACE + "DiscoverAction";

  public static final String TYPE_DISCUSSION_FORUM_POSTING = NAMESPACE + "DiscussionForumPosting";

  public static final String TYPE_DISLIKE_ACTION = NAMESPACE + "DislikeAction";

  public static final String TYPE_DISTANCE = NAMESPACE + "Distance";

  public static final String TYPE_DONATE_ACTION = NAMESPACE + "DonateAction";

  public static final String TYPE_DOSE_SCHEDULE = NAMESPACE + "DoseSchedule";

  public static final String TYPE_DOWNLOAD_ACTION = NAMESPACE + "DownloadAction";

  public static final String TYPE_DRAW_ACTION = NAMESPACE + "DrawAction";

  public static final String TYPE_DRINK_ACTION = NAMESPACE + "DrinkAction";

  public static final String TYPE_DRIVE_WHEEL_CONFIGURATION_VALUE =
      NAMESPACE + "DriveWheelConfigurationValue";

  public static final String TYPE_DRUG = NAMESPACE + "Drug";

  public static final String TYPE_DRUG_CLASS = NAMESPACE + "DrugClass";

  public static final String TYPE_DRUG_COST = NAMESPACE + "DrugCost";

  public static final String TYPE_DRUG_COST_CATEGORY = NAMESPACE + "DrugCostCategory";

  public static final String TYPE_DRUG_LEGAL_STATUS = NAMESPACE + "DrugLegalStatus";

  public static final String TYPE_DRUG_PREGNANCY_CATEGORY = NAMESPACE + "DrugPregnancyCategory";

  public static final String TYPE_DRUG_PRESCRIPTION_STATUS = NAMESPACE + "DrugPrescriptionStatus";

  public static final String TYPE_DRUG_STRENGTH = NAMESPACE + "DrugStrength";

  public static final String TYPE_DRY_CLEANING_OR_LAUNDRY = NAMESPACE + "DryCleaningOrLaundry";

  public static final String TYPE_DURATION = NAMESPACE + "Duration";

  public static final String TYPE_EAT_ACTION = NAMESPACE + "EatAction";

  public static final String TYPE_EDUCATION_EVENT = NAMESPACE + "EducationEvent";

  public static final String TYPE_EDUCATIONAL_AUDIENCE = NAMESPACE + "EducationalAudience";

  public static final String TYPE_EDUCATIONAL_ORGANIZATION = NAMESPACE + "EducationalOrganization";

  public static final String TYPE_ELECTRICIAN = NAMESPACE + "Electrician";

  public static final String TYPE_ELECTRONICS_STORE = NAMESPACE + "ElectronicsStore";

  public static final String TYPE_ELEMENTARY_SCHOOL = NAMESPACE + "ElementarySchool";

  public static final String TYPE_EMAIL_MESSAGE = NAMESPACE + "EmailMessage";

  public static final String TYPE_EMBASSY = NAMESPACE + "Embassy";

  public static final String TYPE_EMERGENCY_SERVICE = NAMESPACE + "EmergencyService";

  public static final String TYPE_EMPLOYEE_ROLE = NAMESPACE + "EmployeeRole";

  public static final String TYPE_EMPLOYMENT_AGENCY = NAMESPACE + "EmploymentAgency";

  public static final String TYPE_ENDORSE_ACTION = NAMESPACE + "EndorseAction";

  public static final String TYPE_ENERGY = NAMESPACE + "Energy";

  public static final String TYPE_ENGINE_SPECIFICATION = NAMESPACE + "EngineSpecification";

  public static final String TYPE_ENTERTAINMENT_BUSINESS = NAMESPACE + "EntertainmentBusiness";

  public static final String TYPE_ENTRY_POINT = NAMESPACE + "EntryPoint";

  public static final String TYPE_ENUMERATION = NAMESPACE + "Enumeration";

  public static final String TYPE_EPISODE = NAMESPACE + "Episode";

  public static final String TYPE_EVENT = NAMESPACE + "Event";

  public static final String TYPE_EVENT_RESERVATION = NAMESPACE + "EventReservation";

  public static final String TYPE_EVENT_STATUS_TYPE = NAMESPACE + "EventStatusType";

  public static final String TYPE_EVENT_VENUE = NAMESPACE + "EventVenue";

  public static final String TYPE_EXERCISE_ACTION = NAMESPACE + "ExerciseAction";

  public static final String TYPE_EXERCISE_GYM = NAMESPACE + "ExerciseGym";

  public static final String TYPE_EXERCISE_PLAN = NAMESPACE + "ExercisePlan";

  public static final String TYPE_EXHIBITION_EVENT = NAMESPACE + "ExhibitionEvent";

  public static final String TYPE_FAST_FOOD_RESTAURANT = NAMESPACE + "FastFoodRestaurant";

  public static final String TYPE_FESTIVAL = NAMESPACE + "Festival";

  public static final String TYPE_FILM_ACTION = NAMESPACE + "FilmAction";

  public static final String TYPE_FINANCIAL_SERVICE = NAMESPACE + "FinancialService";

  public static final String TYPE_FIND_ACTION = NAMESPACE + "FindAction";

  public static final String TYPE_FIRE_STATION = NAMESPACE + "FireStation";

  public static final String TYPE_FLIGHT = NAMESPACE + "Flight";

  public static final String TYPE_FLIGHT_RESERVATION = NAMESPACE + "FlightReservation";

  public static final String TYPE_FLORIST = NAMESPACE + "Florist";

  public static final String TYPE_FOLLOW_ACTION = NAMESPACE + "FollowAction";

  public static final String TYPE_FOOD_ESTABLISHMENT = NAMESPACE + "FoodEstablishment";

  public static final String TYPE_FOOD_ESTABLISHMENT_RESERVATION =
      NAMESPACE + "FoodEstablishmentReservation";

  public static final String TYPE_FOOD_EVENT = NAMESPACE + "FoodEvent";

  public static final String TYPE_FURNITURE_STORE = NAMESPACE + "FurnitureStore";

  public static final String TYPE_GAME = NAMESPACE + "Game";

  public static final String TYPE_GAME_PLAY_MODE = NAMESPACE + "GamePlayMode";

  public static final String TYPE_GAME_SERVER = NAMESPACE + "GameServer";

  public static final String TYPE_GAME_SERVER_STATUS = NAMESPACE + "GameServerStatus";

  public static final String TYPE_GARDEN_STORE = NAMESPACE + "GardenStore";

  public static final String TYPE_GAS_STATION = NAMESPACE + "GasStation";

  public static final String TYPE_GATED_RESIDENCE_COMMUNITY = NAMESPACE + "GatedResidenceCommunity";

  public static final String TYPE_GENERAL_CONTRACTOR = NAMESPACE + "GeneralContractor";

  public static final String TYPE_GEO_CIRCLE = NAMESPACE + "GeoCircle";

  public static final String TYPE_GEO_COORDINATES = NAMESPACE + "GeoCoordinates";

  public static final String TYPE_GEO_SHAPE = NAMESPACE + "GeoShape";

  public static final String TYPE_GIVE_ACTION = NAMESPACE + "GiveAction";

  public static final String TYPE_GOLF_COURSE = NAMESPACE + "GolfCourse";

  public static final String TYPE_GOVERNMENT_BUILDING = NAMESPACE + "GovernmentBuilding";

  public static final String TYPE_GOVERNMENT_OFFICE = NAMESPACE + "GovernmentOffice";

  public static final String TYPE_GOVERNMENT_ORGANIZATION = NAMESPACE + "GovernmentOrganization";

  public static final String TYPE_GOVERNMENT_PERMIT = NAMESPACE + "GovernmentPermit";

  public static final String TYPE_GOVERNMENT_SERVICE = NAMESPACE + "GovernmentService";

  public static final String TYPE_GROCERY_STORE = NAMESPACE + "GroceryStore";

  public static final String TYPE_HVAC_BUSINESS = NAMESPACE + "HVACBusiness";

  public static final String TYPE_HAIR_SALON = NAMESPACE + "HairSalon";

  public static final String TYPE_HARDWARE_STORE = NAMESPACE + "HardwareStore";

  public static final String TYPE_HEALTH_AND_BEAUTY_BUSINESS =
      NAMESPACE + "HealthAndBeautyBusiness";

  public static final String TYPE_HEALTH_CLUB = NAMESPACE + "HealthClub";

  public static final String TYPE_HIGH_SCHOOL = NAMESPACE + "HighSchool";

  public static final String TYPE_HINDU_TEMPLE = NAMESPACE + "HinduTemple";

  public static final String TYPE_HOBBY_SHOP = NAMESPACE + "HobbyShop";

  public static final String TYPE_HOME_AND_CONSTRUCTION_BUSINESS =
      NAMESPACE + "HomeAndConstructionBusiness";

  public static final String TYPE_HOME_GOODS_STORE = NAMESPACE + "HomeGoodsStore";

  public static final String TYPE_HOSPITAL = NAMESPACE + "Hospital";

  public static final String TYPE_HOSTEL = NAMESPACE + "Hostel";

  public static final String TYPE_HOTEL = NAMESPACE + "Hotel";

  public static final String TYPE_HOUSE_PAINTER = NAMESPACE + "HousePainter";

  public static final String TYPE_ICE_CREAM_SHOP = NAMESPACE + "IceCreamShop";

  public static final String TYPE_IGNORE_ACTION = NAMESPACE + "IgnoreAction";

  public static final String TYPE_IMAGE_GALLERY = NAMESPACE + "ImageGallery";

  public static final String TYPE_IMAGE_OBJECT = NAMESPACE + "ImageObject";

  public static final String TYPE_IMAGING_TEST = NAMESPACE + "ImagingTest";

  public static final String TYPE_INDIVIDUAL_PRODUCT = NAMESPACE + "IndividualProduct";

  public static final String TYPE_INFECTIOUS_AGENT_CLASS = NAMESPACE + "InfectiousAgentClass";

  public static final String TYPE_INFECTIOUS_DISEASE = NAMESPACE + "InfectiousDisease";

  public static final String TYPE_INFORM_ACTION = NAMESPACE + "InformAction";

  public static final String TYPE_INSERT_ACTION = NAMESPACE + "InsertAction";

  public static final String TYPE_INSTALL_ACTION = NAMESPACE + "InstallAction";

  public static final String TYPE_INSURANCE_AGENCY = NAMESPACE + "InsuranceAgency";

  public static final String TYPE_INTANGIBLE = NAMESPACE + "Intangible";

  public static final String TYPE_INTERACT_ACTION = NAMESPACE + "InteractAction";

  public static final String TYPE_INTERACTION_COUNTER = NAMESPACE + "InteractionCounter";

  public static final String TYPE_INTERNET_CAFE = NAMESPACE + "InternetCafe";

  public static final String TYPE_INVITE_ACTION = NAMESPACE + "InviteAction";

  public static final String TYPE_INVOICE = NAMESPACE + "Invoice";

  public static final String TYPE_ITEM_AVAILABILITY = NAMESPACE + "ItemAvailability";

  public static final String TYPE_ITEM_LIST = NAMESPACE + "ItemList";

  public static final String TYPE_ITEM_LIST_ORDER_TYPE = NAMESPACE + "ItemListOrderType";

  public static final String TYPE_ITEM_PAGE = NAMESPACE + "ItemPage";

  public static final String TYPE_JEWELRY_STORE = NAMESPACE + "JewelryStore";

  public static final String TYPE_JOB_POSTING = NAMESPACE + "JobPosting";

  public static final String TYPE_JOIN_ACTION = NAMESPACE + "JoinAction";

  public static final String TYPE_JOINT = NAMESPACE + "Joint";

  public static final String TYPE_LAKE_BODY_OF_WATER = NAMESPACE + "LakeBodyOfWater";

  public static final String TYPE_LANDFORM = NAMESPACE + "Landform";

  public static final String TYPE_LANDMARKS_OR_HISTORICAL_BUILDINGS =
      NAMESPACE + "LandmarksOrHistoricalBuildings";

  public static final String TYPE_LANGUAGE = NAMESPACE + "Language";

  public static final String TYPE_LEAVE_ACTION = NAMESPACE + "LeaveAction";

  public static final String TYPE_LEGAL_SERVICE = NAMESPACE + "LegalService";

  public static final String TYPE_LEGISLATIVE_BUILDING = NAMESPACE + "LegislativeBuilding";

  public static final String TYPE_LEND_ACTION = NAMESPACE + "LendAction";

  public static final String TYPE_LIBRARY = NAMESPACE + "Library";

  public static final String TYPE_LIFESTYLE_MODIFICATION = NAMESPACE + "LifestyleModification";

  public static final String TYPE_LIGAMENT = NAMESPACE + "Ligament";

  public static final String TYPE_LIKE_ACTION = NAMESPACE + "LikeAction";

  public static final String TYPE_LIQUOR_STORE = NAMESPACE + "LiquorStore";

  public static final String TYPE_LIST_ITEM = NAMESPACE + "ListItem";

  public static final String TYPE_LISTEN_ACTION = NAMESPACE + "ListenAction";

  public static final String TYPE_LITERARY_EVENT = NAMESPACE + "LiteraryEvent";

  public static final String TYPE_LIVE_BLOG_POSTING = NAMESPACE + "LiveBlogPosting";

  public static final String TYPE_LOCAL_BUSINESS = NAMESPACE + "LocalBusiness";

  public static final String TYPE_LOCAL_BUSINESS_CIVIC_STRUCTURE_COMMON =
      NAMESPACE + "LocalBusinessCivicStructureCommon";

  public static final String TYPE_LOCKER_DELIVERY = NAMESPACE + "LockerDelivery";

  public static final String TYPE_LOCKSMITH = NAMESPACE + "Locksmith";

  public static final String TYPE_LODGING_BUSINESS = NAMESPACE + "LodgingBusiness";

  public static final String TYPE_LODGING_RESERVATION = NAMESPACE + "LodgingReservation";

  public static final String TYPE_LOSE_ACTION = NAMESPACE + "LoseAction";

  public static final String TYPE_LYMPHATIC_VESSEL = NAMESPACE + "LymphaticVessel";

  public static final String TYPE_MAP = NAMESPACE + "Map";

  public static final String TYPE_MAP_CATEGORY_TYPE = NAMESPACE + "MapCategoryType";

  public static final String TYPE_MARRY_ACTION = NAMESPACE + "MarryAction";

  public static final String TYPE_MASS = NAMESPACE + "Mass";

  public static final String TYPE_MAXIMUM_DOSE_SCHEDULE = NAMESPACE + "MaximumDoseSchedule";

  public static final String TYPE_MEDIA_OBJECT = NAMESPACE + "MediaObject";

  public static final String TYPE_MEDICAL_AUDIENCE = NAMESPACE + "MedicalAudience";

  public static final String TYPE_MEDICAL_CAUSE = NAMESPACE + "MedicalCause";

  public static final String TYPE_MEDICAL_CLINIC = NAMESPACE + "MedicalClinic";

  public static final String TYPE_MEDICAL_CODE = NAMESPACE + "MedicalCode";

  public static final String TYPE_MEDICAL_CONDITION = NAMESPACE + "MedicalCondition";

  public static final String TYPE_MEDICAL_CONDITION_STAGE = NAMESPACE + "MedicalConditionStage";

  public static final String TYPE_MEDICAL_CONTRAINDICATION = NAMESPACE + "MedicalContraindication";

  public static final String TYPE_MEDICAL_DEVICE = NAMESPACE + "MedicalDevice";

  public static final String TYPE_MEDICAL_DEVICE_PURPOSE = NAMESPACE + "MedicalDevicePurpose";

  public static final String TYPE_MEDICAL_ENTITY = NAMESPACE + "MedicalEntity";

  public static final String TYPE_MEDICAL_ENUMERATION = NAMESPACE + "MedicalEnumeration";

  public static final String TYPE_MEDICAL_EVIDENCE_LEVEL = NAMESPACE + "MedicalEvidenceLevel";

  public static final String TYPE_MEDICAL_GUIDELINE = NAMESPACE + "MedicalGuideline";

  public static final String TYPE_MEDICAL_GUIDELINE_CONTRAINDICATION =
      NAMESPACE + "MedicalGuidelineContraindication";

  public static final String TYPE_MEDICAL_GUIDELINE_RECOMMENDATION =
      NAMESPACE + "MedicalGuidelineRecommendation";

  public static final String TYPE_MEDICAL_IMAGING_TECHNIQUE = NAMESPACE + "MedicalImagingTechnique";

  public static final String TYPE_MEDICAL_INDICATION = NAMESPACE + "MedicalIndication";

  public static final String TYPE_MEDICAL_INTANGIBLE = NAMESPACE + "MedicalIntangible";

  public static final String TYPE_MEDICAL_OBSERVATIONAL_STUDY =
      NAMESPACE + "MedicalObservationalStudy";

  public static final String TYPE_MEDICAL_OBSERVATIONAL_STUDY_DESIGN =
      NAMESPACE + "MedicalObservationalStudyDesign";

  public static final String TYPE_MEDICAL_ORGANIZATION = NAMESPACE + "MedicalOrganization";

  public static final String TYPE_MEDICAL_PROCEDURE = NAMESPACE + "MedicalProcedure";

  public static final String TYPE_MEDICAL_PROCEDURE_TYPE = NAMESPACE + "MedicalProcedureType";

  public static final String TYPE_MEDICAL_RISK_CALCULATOR = NAMESPACE + "MedicalRiskCalculator";

  public static final String TYPE_MEDICAL_RISK_ESTIMATOR = NAMESPACE + "MedicalRiskEstimator";

  public static final String TYPE_MEDICAL_RISK_FACTOR = NAMESPACE + "MedicalRiskFactor";

  public static final String TYPE_MEDICAL_RISK_SCORE = NAMESPACE + "MedicalRiskScore";

  public static final String TYPE_MEDICAL_SCHOLARLY_ARTICLE = NAMESPACE + "MedicalScholarlyArticle";

  public static final String TYPE_MEDICAL_SIGN = NAMESPACE + "MedicalSign";

  public static final String TYPE_MEDICAL_SIGN_OR_SYMPTOM = NAMESPACE + "MedicalSignOrSymptom";

  public static final String TYPE_MEDICAL_SPECIALTY = NAMESPACE + "MedicalSpecialty";

  public static final String TYPE_MEDICAL_STUDY = NAMESPACE + "MedicalStudy";

  public static final String TYPE_MEDICAL_STUDY_STATUS = NAMESPACE + "MedicalStudyStatus";

  public static final String TYPE_MEDICAL_SYMPTOM = NAMESPACE + "MedicalSymptom";

  public static final String TYPE_MEDICAL_TEST = NAMESPACE + "MedicalTest";

  public static final String TYPE_MEDICAL_TEST_PANEL = NAMESPACE + "MedicalTestPanel";

  public static final String TYPE_MEDICAL_THERAPY = NAMESPACE + "MedicalTherapy";

  public static final String TYPE_MEDICAL_TRIAL = NAMESPACE + "MedicalTrial";

  public static final String TYPE_MEDICAL_TRIAL_DESIGN = NAMESPACE + "MedicalTrialDesign";

  public static final String TYPE_MEDICAL_WEB_PAGE = NAMESPACE + "MedicalWebPage";

  public static final String TYPE_MEDICINE_SYSTEM = NAMESPACE + "MedicineSystem";

  public static final String TYPE_MENS_CLOTHING_STORE = NAMESPACE + "MensClothingStore";

  public static final String TYPE_MIDDLE_SCHOOL = NAMESPACE + "MiddleSchool";

  public static final String TYPE_MOBILE_APPLICATION = NAMESPACE + "MobileApplication";

  public static final String TYPE_MOBILE_PHONE_STORE = NAMESPACE + "MobilePhoneStore";

  public static final String TYPE_MOSQUE = NAMESPACE + "Mosque";

  public static final String TYPE_MOTEL = NAMESPACE + "Motel";

  public static final String TYPE_MOTORCYCLE_DEALER = NAMESPACE + "MotorcycleDealer";

  public static final String TYPE_MOTORCYCLE_REPAIR = NAMESPACE + "MotorcycleRepair";

  public static final String TYPE_MOUNTAIN = NAMESPACE + "Mountain";

  public static final String TYPE_MOVE_ACTION = NAMESPACE + "MoveAction";

  public static final String TYPE_MOVIE = NAMESPACE + "Movie";

  public static final String TYPE_MOVIE_CLIP = NAMESPACE + "MovieClip";

  public static final String TYPE_MOVIE_RENTAL_STORE = NAMESPACE + "MovieRentalStore";

  public static final String TYPE_MOVIE_SERIES = NAMESPACE + "MovieSeries";

  public static final String TYPE_MOVIE_THEATER = NAMESPACE + "MovieTheater";

  public static final String TYPE_MOVING_COMPANY = NAMESPACE + "MovingCompany";

  public static final String TYPE_MUSCLE = NAMESPACE + "Muscle";

  public static final String TYPE_MUSEUM = NAMESPACE + "Museum";

  public static final String TYPE_MUSIC_ALBUM = NAMESPACE + "MusicAlbum";

  public static final String TYPE_MUSIC_ALBUM_PRODUCTION_TYPE =
      NAMESPACE + "MusicAlbumProductionType";

  public static final String TYPE_MUSIC_ALBUM_RELEASE_TYPE = NAMESPACE + "MusicAlbumReleaseType";

  public static final String TYPE_MUSIC_COMPOSITION = NAMESPACE + "MusicComposition";

  public static final String TYPE_MUSIC_EVENT = NAMESPACE + "MusicEvent";

  public static final String TYPE_MUSIC_GROUP = NAMESPACE + "MusicGroup";

  public static final String TYPE_MUSIC_PLAYLIST = NAMESPACE + "MusicPlaylist";

  public static final String TYPE_MUSIC_RECORDING = NAMESPACE + "MusicRecording";

  public static final String TYPE_MUSIC_RELEASE = NAMESPACE + "MusicRelease";

  public static final String TYPE_MUSIC_RELEASE_FORMAT_TYPE = NAMESPACE + "MusicReleaseFormatType";

  public static final String TYPE_MUSIC_STORE = NAMESPACE + "MusicStore";

  public static final String TYPE_MUSIC_VENUE = NAMESPACE + "MusicVenue";

  public static final String TYPE_MUSIC_VIDEO_OBJECT = NAMESPACE + "MusicVideoObject";

  public static final String TYPE_NGO = NAMESPACE + "NGO";

  public static final String TYPE_NAIL_SALON = NAMESPACE + "NailSalon";

  public static final String TYPE_NERVE = NAMESPACE + "Nerve";

  public static final String TYPE_NEWS_ARTICLE = NAMESPACE + "NewsArticle";

  public static final String TYPE_NIGHT_CLUB = NAMESPACE + "NightClub";

  public static final String TYPE_NOTARY = NAMESPACE + "Notary";

  public static final String TYPE_NUTRITION_INFORMATION = NAMESPACE + "NutritionInformation";

  public static final String TYPE_OCEAN_BODY_OF_WATER = NAMESPACE + "OceanBodyOfWater";

  public static final String TYPE_OFFER = NAMESPACE + "Offer";

  public static final String TYPE_OFFER_CATALOG = NAMESPACE + "OfferCatalog";

  public static final String TYPE_OFFER_ITEM_CONDITION = NAMESPACE + "OfferItemCondition";

  public static final String TYPE_OFFICE_EQUIPMENT_STORE = NAMESPACE + "OfficeEquipmentStore";

  public static final String TYPE_ON_DEMAND_EVENT = NAMESPACE + "OnDemandEvent";

  public static final String TYPE_OPENING_HOURS_SPECIFICATION =
      NAMESPACE + "OpeningHoursSpecification";

  public static final String TYPE_OPTICIAN = NAMESPACE + "Optician";

  public static final String TYPE_ORDER = NAMESPACE + "Order";

  public static final String TYPE_ORDER_ACTION = NAMESPACE + "OrderAction";

  public static final String TYPE_ORDER_ITEM = NAMESPACE + "OrderItem";

  public static final String TYPE_ORDER_STATUS = NAMESPACE + "OrderStatus";

  public static final String TYPE_ORGANIZATION = NAMESPACE + "Organization";

  public static final String TYPE_ORGANIZATION_ROLE = NAMESPACE + "OrganizationRole";

  public static final String TYPE_ORGANIZE_ACTION = NAMESPACE + "OrganizeAction";

  public static final String TYPE_OUTLET_STORE = NAMESPACE + "OutletStore";

  public static final String TYPE_OWNERSHIP_INFO = NAMESPACE + "OwnershipInfo";

  public static final String TYPE_PAINT_ACTION = NAMESPACE + "PaintAction";

  public static final String TYPE_PAINTING = NAMESPACE + "Painting";

  public static final String TYPE_PALLIATIVE_PROCEDURE = NAMESPACE + "PalliativeProcedure";

  public static final String TYPE_PARCEL_DELIVERY = NAMESPACE + "ParcelDelivery";

  public static final String TYPE_PARCEL_SERVICE = NAMESPACE + "ParcelService";

  public static final String TYPE_PARENT_AUDIENCE = NAMESPACE + "ParentAudience";

  public static final String TYPE_PARK = NAMESPACE + "Park";

  public static final String TYPE_PARKING_FACILITY = NAMESPACE + "ParkingFacility";

  public static final String TYPE_PATHOLOGY_TEST = NAMESPACE + "PathologyTest";

  public static final String TYPE_PAWN_SHOP = NAMESPACE + "PawnShop";

  public static final String TYPE_PAY_ACTION = NAMESPACE + "PayAction";

  public static final String TYPE_PAYMENT_CHARGE_SPECIFICATION =
      NAMESPACE + "PaymentChargeSpecification";

  public static final String TYPE_PAYMENT_METHOD = NAMESPACE + "PaymentMethod";

  public static final String TYPE_PAYMENT_STATUS_TYPE = NAMESPACE + "PaymentStatusType";

  public static final String TYPE_PEOPLE_AUDIENCE = NAMESPACE + "PeopleAudience";

  public static final String TYPE_PERFORM_ACTION = NAMESPACE + "PerformAction";

  public static final String TYPE_PERFORMANCE_ROLE = NAMESPACE + "PerformanceRole";

  public static final String TYPE_PERFORMING_ARTS_THEATER = NAMESPACE + "PerformingArtsTheater";

  public static final String TYPE_PERFORMING_GROUP = NAMESPACE + "PerformingGroup";

  public static final String TYPE_PERIODICAL = NAMESPACE + "Periodical";

  public static final String TYPE_PERMIT = NAMESPACE + "Permit";

  public static final String TYPE_PERSON = NAMESPACE + "Person";

  public static final String TYPE_PET_STORE = NAMESPACE + "PetStore";

  public static final String TYPE_PHARMACY = NAMESPACE + "Pharmacy";

  public static final String TYPE_PHOTOGRAPH = NAMESPACE + "Photograph";

  public static final String TYPE_PHOTOGRAPH_ACTION = NAMESPACE + "PhotographAction";

  public static final String TYPE_PHYSICAL_ACTIVITY = NAMESPACE + "PhysicalActivity";

  public static final String TYPE_PHYSICAL_ACTIVITY_CATEGORY =
      NAMESPACE + "PhysicalActivityCategory";

  public static final String TYPE_PHYSICAL_EXAM = NAMESPACE + "PhysicalExam";

  public static final String TYPE_PHYSICAL_THERAPY = NAMESPACE + "PhysicalTherapy";

  public static final String TYPE_PHYSICIAN = NAMESPACE + "Physician";

  public static final String TYPE_PLACE = NAMESPACE + "Place";

  public static final String TYPE_PLACE_OF_WORSHIP = NAMESPACE + "PlaceOfWorship";

  public static final String TYPE_PLACE_ORGANIZATION_COMMON = NAMESPACE + "PlaceOrganizationCommon";

  public static final String TYPE_PLAN_ACTION = NAMESPACE + "PlanAction";

  public static final String TYPE_PLAY_ACTION = NAMESPACE + "PlayAction";

  public static final String TYPE_PLAYGROUND = NAMESPACE + "Playground";

  public static final String TYPE_PLUMBER = NAMESPACE + "Plumber";

  public static final String TYPE_POLICE_STATION = NAMESPACE + "PoliceStation";

  public static final String TYPE_POND = NAMESPACE + "Pond";

  public static final String TYPE_POST_OFFICE = NAMESPACE + "PostOffice";

  public static final String TYPE_POSTAL_ADDRESS = NAMESPACE + "PostalAddress";

  public static final String TYPE_PREPEND_ACTION = NAMESPACE + "PrependAction";

  public static final String TYPE_PRESCHOOL = NAMESPACE + "Preschool";

  public static final String TYPE_PREVENTION_INDICATION = NAMESPACE + "PreventionIndication";

  public static final String TYPE_PRICE_SPECIFICATION = NAMESPACE + "PriceSpecification";

  public static final String TYPE_PRODUCT = NAMESPACE + "Product";

  public static final String TYPE_PRODUCT_MODEL = NAMESPACE + "ProductModel";

  public static final String TYPE_PROFESSIONAL_SERVICE = NAMESPACE + "ProfessionalService";

  public static final String TYPE_PROFILE_PAGE = NAMESPACE + "ProfilePage";

  public static final String TYPE_PROGRAM_MEMBERSHIP = NAMESPACE + "ProgramMembership";

  public static final String TYPE_PROPERTY = NAMESPACE + "Property";

  public static final String TYPE_PROPERTY_VALUE = NAMESPACE + "PropertyValue";

  public static final String TYPE_PROPERTY_VALUE_SPECIFICATION =
      NAMESPACE + "PropertyValueSpecification";

  public static final String TYPE_PSYCHOLOGICAL_TREATMENT = NAMESPACE + "PsychologicalTreatment";

  public static final String TYPE_PUBLIC_SWIMMING_POOL = NAMESPACE + "PublicSwimmingPool";

  public static final String TYPE_PUBLICATION_EVENT = NAMESPACE + "PublicationEvent";

  public static final String TYPE_PUBLICATION_ISSUE = NAMESPACE + "PublicationIssue";

  public static final String TYPE_PUBLICATION_VOLUME = NAMESPACE + "PublicationVolume";

  public static final String TYPE_QA_PAGE = NAMESPACE + "QAPage";

  public static final String TYPE_QUALITATIVE_VALUE = NAMESPACE + "QualitativeValue";

  public static final String TYPE_QUANTITATIVE_VALUE = NAMESPACE + "QuantitativeValue";

  public static final String TYPE_QUANTITY = NAMESPACE + "Quantity";

  public static final String TYPE_QUESTION = NAMESPACE + "Question";

  public static final String TYPE_QUOTE_ACTION = NAMESPACE + "QuoteAction";

  public static final String TYPE_RV_PARK = NAMESPACE + "RVPark";

  public static final String TYPE_RADIATION_THERAPY = NAMESPACE + "RadiationTherapy";

  public static final String TYPE_RADIO_CHANNEL = NAMESPACE + "RadioChannel";

  public static final String TYPE_RADIO_CLIP = NAMESPACE + "RadioClip";

  public static final String TYPE_RADIO_EPISODE = NAMESPACE + "RadioEpisode";

  public static final String TYPE_RADIO_SEASON = NAMESPACE + "RadioSeason";

  public static final String TYPE_RADIO_SERIES = NAMESPACE + "RadioSeries";

  public static final String TYPE_RADIO_STATION = NAMESPACE + "RadioStation";

  public static final String TYPE_RATING = NAMESPACE + "Rating";

  public static final String TYPE_REACT_ACTION = NAMESPACE + "ReactAction";

  public static final String TYPE_READ_ACTION = NAMESPACE + "ReadAction";

  public static final String TYPE_REAL_ESTATE_AGENT = NAMESPACE + "RealEstateAgent";

  public static final String TYPE_RECEIVE_ACTION = NAMESPACE + "ReceiveAction";

  public static final String TYPE_RECIPE = NAMESPACE + "Recipe";

  public static final String TYPE_RECOMMENDED_DOSE_SCHEDULE = NAMESPACE + "RecommendedDoseSchedule";

  public static final String TYPE_RECYCLING_CENTER = NAMESPACE + "RecyclingCenter";

  public static final String TYPE_REGISTER_ACTION = NAMESPACE + "RegisterAction";

  public static final String TYPE_REJECT_ACTION = NAMESPACE + "RejectAction";

  public static final String TYPE_RENT_ACTION = NAMESPACE + "RentAction";

  public static final String TYPE_RENTAL_CAR_RESERVATION = NAMESPACE + "RentalCarReservation";

  public static final String TYPE_REPLACE_ACTION = NAMESPACE + "ReplaceAction";

  public static final String TYPE_REPLY_ACTION = NAMESPACE + "ReplyAction";

  public static final String TYPE_REPORT = NAMESPACE + "Report";

  public static final String TYPE_REPORTED_DOSE_SCHEDULE = NAMESPACE + "ReportedDoseSchedule";

  public static final String TYPE_RESERVATION = NAMESPACE + "Reservation";

  public static final String TYPE_RESERVATION_PACKAGE = NAMESPACE + "ReservationPackage";

  public static final String TYPE_RESERVATION_STATUS_TYPE = NAMESPACE + "ReservationStatusType";

  public static final String TYPE_RESERVE_ACTION = NAMESPACE + "ReserveAction";

  public static final String TYPE_RESERVOIR = NAMESPACE + "Reservoir";

  public static final String TYPE_RESIDENCE = NAMESPACE + "Residence";

  public static final String TYPE_RESTAURANT = NAMESPACE + "Restaurant";

  public static final String TYPE_RESUME_ACTION = NAMESPACE + "ResumeAction";

  public static final String TYPE_RETURN_ACTION = NAMESPACE + "ReturnAction";

  public static final String TYPE_REVIEW = NAMESPACE + "Review";

  public static final String TYPE_REVIEW_ACTION = NAMESPACE + "ReviewAction";

  public static final String TYPE_RIVER_BODY_OF_WATER = NAMESPACE + "RiverBodyOfWater";

  public static final String TYPE_ROLE = NAMESPACE + "Role";

  public static final String TYPE_ROOFING_CONTRACTOR = NAMESPACE + "RoofingContractor";

  public static final String TYPE_RSVP_ACTION = NAMESPACE + "RsvpAction";

  public static final String TYPE_RSVP_RESPONSE_TYPE = NAMESPACE + "RsvpResponseType";

  public static final String TYPE_SALE_EVENT = NAMESPACE + "SaleEvent";

  public static final String TYPE_SCHEDULE_ACTION = NAMESPACE + "ScheduleAction";

  public static final String TYPE_SCHOLARLY_ARTICLE = NAMESPACE + "ScholarlyArticle";

  public static final String TYPE_SCHOOL = NAMESPACE + "School";

  public static final String TYPE_SCREENING_EVENT = NAMESPACE + "ScreeningEvent";

  public static final String TYPE_SCULPTURE = NAMESPACE + "Sculpture";

  public static final String TYPE_SEA_BODY_OF_WATER = NAMESPACE + "SeaBodyOfWater";

  public static final String TYPE_SEARCH_ACTION = NAMESPACE + "SearchAction";

  public static final String TYPE_SEARCH_RESULTS_PAGE = NAMESPACE + "SearchResultsPage";

  public static final String TYPE_SEASON = NAMESPACE + "Season";

  public static final String TYPE_SEAT = NAMESPACE + "Seat";

  public static final String TYPE_SELF_STORAGE = NAMESPACE + "SelfStorage";

  public static final String TYPE_SELL_ACTION = NAMESPACE + "SellAction";

  public static final String TYPE_SEND_ACTION = NAMESPACE + "SendAction";

  public static final String TYPE_SERIES = NAMESPACE + "Series";

  public static final String TYPE_SERVICE = NAMESPACE + "Service";

  public static final String TYPE_SERVICE_CHANNEL = NAMESPACE + "ServiceChannel";

  public static final String TYPE_SHARE_ACTION = NAMESPACE + "ShareAction";

  public static final String TYPE_SHOE_STORE = NAMESPACE + "ShoeStore";

  public static final String TYPE_SHOPPING_CENTER = NAMESPACE + "ShoppingCenter";

  public static final String TYPE_SINGLE_FAMILY_RESIDENCE = NAMESPACE + "SingleFamilyResidence";

  public static final String TYPE_SITE_NAVIGATION_ELEMENT = NAMESPACE + "SiteNavigationElement";

  public static final String TYPE_SKI_RESORT = NAMESPACE + "SkiResort";

  public static final String TYPE_SOCIAL_EVENT = NAMESPACE + "SocialEvent";

  public static final String TYPE_SOCIAL_MEDIA_POSTING = NAMESPACE + "SocialMediaPosting";

  public static final String TYPE_SOFTWARE_APPLICATION = NAMESPACE + "SoftwareApplication";

  public static final String TYPE_SOFTWARE_SOURCE_CODE = NAMESPACE + "SoftwareSourceCode";

  public static final String TYPE_SOME_PRODUCTS = NAMESPACE + "SomeProducts";

  public static final String TYPE_SPECIALTY = NAMESPACE + "Specialty";

  public static final String TYPE_SPORTING_GOODS_STORE = NAMESPACE + "SportingGoodsStore";

  public static final String TYPE_SPORTS_ACTIVITY_LOCATION = NAMESPACE + "SportsActivityLocation";

  public static final String TYPE_SPORTS_CLUB = NAMESPACE + "SportsClub";

  public static final String TYPE_SPORTS_EVENT = NAMESPACE + "SportsEvent";

  public static final String TYPE_SPORTS_ORGANIZATION = NAMESPACE + "SportsOrganization";

  public static final String TYPE_SPORTS_TEAM = NAMESPACE + "SportsTeam";

  public static final String TYPE_STADIUM_OR_ARENA = NAMESPACE + "StadiumOrArena";

  public static final String TYPE_STATE = NAMESPACE + "State";

  public static final String TYPE_STEERING_POSITION_VALUE = NAMESPACE + "SteeringPositionValue";

  public static final String TYPE_STORE = NAMESPACE + "Store";

  public static final String TYPE_STRUCTURED_VALUE = NAMESPACE + "StructuredValue";

  public static final String TYPE_SUBSCRIBE_ACTION = NAMESPACE + "SubscribeAction";

  public static final String TYPE_SUBWAY_STATION = NAMESPACE + "SubwayStation";

  public static final String TYPE_SUPERFICIAL_ANATOMY = NAMESPACE + "SuperficialAnatomy";

  public static final String TYPE_SUSPEND_ACTION = NAMESPACE + "SuspendAction";

  public static final String TYPE_SYNAGOGUE = NAMESPACE + "Synagogue";

  public static final String TYPE_TV_CLIP = NAMESPACE + "TVClip";

  public static final String TYPE_TV_EPISODE = NAMESPACE + "TVEpisode";

  public static final String TYPE_TV_SEASON = NAMESPACE + "TVSeason";

  public static final String TYPE_TV_SERIES = NAMESPACE + "TVSeries";

  public static final String TYPE_TABLE = NAMESPACE + "Table";

  public static final String TYPE_TAKE_ACTION = NAMESPACE + "TakeAction";

  public static final String TYPE_TATTOO_PARLOR = NAMESPACE + "TattooParlor";

  public static final String TYPE_TAXI = NAMESPACE + "Taxi";

  public static final String TYPE_TAXI_RESERVATION = NAMESPACE + "TaxiReservation";

  public static final String TYPE_TAXI_SERVICE = NAMESPACE + "TaxiService";

  public static final String TYPE_TAXI_STAND = NAMESPACE + "TaxiStand";

  public static final String TYPE_TECH_ARTICLE = NAMESPACE + "TechArticle";

  public static final String TYPE_TELEVISION_CHANNEL = NAMESPACE + "TelevisionChannel";

  public static final String TYPE_TELEVISION_STATION = NAMESPACE + "TelevisionStation";

  public static final String TYPE_TENNIS_COMPLEX = NAMESPACE + "TennisComplex";

  public static final String TYPE_THEATER_EVENT = NAMESPACE + "TheaterEvent";

  public static final String TYPE_THEATER_GROUP = NAMESPACE + "TheaterGroup";

  public static final String TYPE_THERAPEUTIC_PROCEDURE = NAMESPACE + "TherapeuticProcedure";

  public static final String TYPE_THING = NAMESPACE + "Thing";

  public static final String TYPE_TICKET = NAMESPACE + "Ticket";

  public static final String TYPE_TIE_ACTION = NAMESPACE + "TieAction";

  public static final String TYPE_TIP_ACTION = NAMESPACE + "TipAction";

  public static final String TYPE_TIRE_SHOP = NAMESPACE + "TireShop";

  public static final String TYPE_TOURIST_ATTRACTION = NAMESPACE + "TouristAttraction";

  public static final String TYPE_TOURIST_INFORMATION_CENTER =
      NAMESPACE + "TouristInformationCenter";

  public static final String TYPE_TOY_STORE = NAMESPACE + "ToyStore";

  public static final String TYPE_TRACK_ACTION = NAMESPACE + "TrackAction";

  public static final String TYPE_TRADE_ACTION = NAMESPACE + "TradeAction";

  public static final String TYPE_TRAIN_RESERVATION = NAMESPACE + "TrainReservation";

  public static final String TYPE_TRAIN_STATION = NAMESPACE + "TrainStation";

  public static final String TYPE_TRAIN_TRIP = NAMESPACE + "TrainTrip";

  public static final String TYPE_TRANSFER_ACTION = NAMESPACE + "TransferAction";

  public static final String TYPE_TRAVEL_ACTION = NAMESPACE + "TravelAction";

  public static final String TYPE_TRAVEL_AGENCY = NAMESPACE + "TravelAgency";

  public static final String TYPE_TREATMENT_INDICATION = NAMESPACE + "TreatmentIndication";

  public static final String TYPE_TYPE_AND_QUANTITY_NODE = NAMESPACE + "TypeAndQuantityNode";

  public static final String TYPE_UN_REGISTER_ACTION = NAMESPACE + "UnRegisterAction";

  public static final String TYPE_UNIT_PRICE_SPECIFICATION = NAMESPACE + "UnitPriceSpecification";

  public static final String TYPE_UPDATE_ACTION = NAMESPACE + "UpdateAction";

  public static final String TYPE_USE_ACTION = NAMESPACE + "UseAction";

  public static final String TYPE_USER_BLOCKS = NAMESPACE + "UserBlocks";

  public static final String TYPE_USER_CHECKINS = NAMESPACE + "UserCheckins";

  public static final String TYPE_USER_COMMENTS = NAMESPACE + "UserComments";

  public static final String TYPE_USER_DOWNLOADS = NAMESPACE + "UserDownloads";

  public static final String TYPE_USER_INTERACTION = NAMESPACE + "UserInteraction";

  public static final String TYPE_USER_LIKES = NAMESPACE + "UserLikes";

  public static final String TYPE_USER_PAGE_VISITS = NAMESPACE + "UserPageVisits";

  public static final String TYPE_USER_PLAYS = NAMESPACE + "UserPlays";

  public static final String TYPE_USER_PLUS_ONES = NAMESPACE + "UserPlusOnes";

  public static final String TYPE_USER_TWEETS = NAMESPACE + "UserTweets";

  public static final String TYPE_VEHICLE = NAMESPACE + "Vehicle";

  public static final String TYPE_VEIN = NAMESPACE + "Vein";

  public static final String TYPE_VESSEL = NAMESPACE + "Vessel";

  public static final String TYPE_VETERINARY_CARE = NAMESPACE + "VeterinaryCare";

  public static final String TYPE_VIDEO_GALLERY = NAMESPACE + "VideoGallery";

  public static final String TYPE_VIDEO_GAME = NAMESPACE + "VideoGame";

  public static final String TYPE_VIDEO_GAME_CLIP = NAMESPACE + "VideoGameClip";

  public static final String TYPE_VIDEO_GAME_SERIES = NAMESPACE + "VideoGameSeries";

  public static final String TYPE_VIDEO_OBJECT = NAMESPACE + "VideoObject";

  public static final String TYPE_VIEW_ACTION = NAMESPACE + "ViewAction";

  public static final String TYPE_VISUAL_ARTS_EVENT = NAMESPACE + "VisualArtsEvent";

  public static final String TYPE_VISUAL_ARTWORK = NAMESPACE + "VisualArtwork";

  public static final String TYPE_VOLCANO = NAMESPACE + "Volcano";

  public static final String TYPE_VOTE_ACTION = NAMESPACE + "VoteAction";

  public static final String TYPE_WP_AD_BLOCK = NAMESPACE + "WPAdBlock";

  public static final String TYPE_WP_FOOTER = NAMESPACE + "WPFooter";

  public static final String TYPE_WP_HEADER = NAMESPACE + "WPHeader";

  public static final String TYPE_WP_SIDE_BAR = NAMESPACE + "WPSideBar";

  public static final String TYPE_WANT_ACTION = NAMESPACE + "WantAction";

  public static final String TYPE_WARRANTY_PROMISE = NAMESPACE + "WarrantyPromise";

  public static final String TYPE_WARRANTY_SCOPE = NAMESPACE + "WarrantyScope";

  public static final String TYPE_WATCH_ACTION = NAMESPACE + "WatchAction";

  public static final String TYPE_WATERFALL = NAMESPACE + "Waterfall";

  public static final String TYPE_WEAR_ACTION = NAMESPACE + "WearAction";

  public static final String TYPE_WEB_APPLICATION = NAMESPACE + "WebApplication";

  public static final String TYPE_WEB_PAGE = NAMESPACE + "WebPage";

  public static final String TYPE_WEB_PAGE_ELEMENT = NAMESPACE + "WebPageElement";

  public static final String TYPE_WEB_SITE = NAMESPACE + "WebSite";

  public static final String TYPE_WHOLESALE_STORE = NAMESPACE + "WholesaleStore";

  public static final String TYPE_WIN_ACTION = NAMESPACE + "WinAction";

  public static final String TYPE_WINERY = NAMESPACE + "Winery";

  public static final String TYPE_WRITE_ACTION = NAMESPACE + "WriteAction";

  public static final String TYPE_ZOO = NAMESPACE + "Zoo";
}
