/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.LifestyleModificationImpl;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalContraindication;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalIndication;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PhysicalActivity;
import com.google.schemaorg.core.PhysicalActivityCategory;
import com.google.schemaorg.core.SuperficialAnatomy;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PhysicalActivityImpl
extends LifestyleModificationImpl
implements PhysicalActivity {
    private static final ImmutableSet<String> PROPERTY_SET = PhysicalActivityImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/adverseOutcome");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedAnatomy");
        builder.add((Object)"http://schema.org/category");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/contraindication");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/duplicateTherapy");
        builder.add((Object)"http://schema.org/epidemiology");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/indication");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/pathophysiology");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/seriousAdverseOutcome");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PhysicalActivityImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PhysicalActivity";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedAnatomyList() {
        return this.getProperty("http://schema.org/associatedAnatomy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCategoryList() {
        return this.getProperty("http://schema.org/category");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEpidemiologyList() {
        return this.getProperty("http://schema.org/epidemiology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPathophysiologyList() {
        return this.getProperty("http://schema.org/pathophysiology");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PhysicalActivity.Builder>
    implements PhysicalActivity.Builder {
        BuilderImpl() {
        }

        @Override
        public PhysicalActivity.Builder addAdditionalType(URL value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PhysicalActivity.Builder addAdditionalType(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addAdverseOutcome(MedicalEntity value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/adverseOutcome", value);
        }

        @Override
        public PhysicalActivity.Builder addAdverseOutcome(MedicalEntity.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/adverseOutcome", value.build());
        }

        @Override
        public PhysicalActivity.Builder addAdverseOutcome(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/adverseOutcome", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addAlternateName(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PhysicalActivity.Builder addAlternateName(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(AnatomicalStructure value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(AnatomicalStructure.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(AnatomicalSystem value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(AnatomicalSystem.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(SuperficialAnatomy value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(SuperficialAnatomy.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public PhysicalActivity.Builder addAssociatedAnatomy(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/associatedAnatomy", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addCategory(PhysicalActivityCategory value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public PhysicalActivity.Builder addCategory(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public PhysicalActivity.Builder addCategory(Thing value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/category", value);
        }

        @Override
        public PhysicalActivity.Builder addCategory(Thing.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/category", value.build());
        }

        @Override
        public PhysicalActivity.Builder addCategory(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/category", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addCode(MedicalCode value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public PhysicalActivity.Builder addCode(MedicalCode.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public PhysicalActivity.Builder addCode(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addContraindication(MedicalContraindication value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/contraindication", value);
        }

        @Override
        public PhysicalActivity.Builder addContraindication(MedicalContraindication.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/contraindication", value.build());
        }

        @Override
        public PhysicalActivity.Builder addContraindication(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/contraindication", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addDescription(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PhysicalActivity.Builder addDescription(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addDuplicateTherapy(MedicalTherapy value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/duplicateTherapy", value);
        }

        @Override
        public PhysicalActivity.Builder addDuplicateTherapy(MedicalTherapy.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/duplicateTherapy", value.build());
        }

        @Override
        public PhysicalActivity.Builder addDuplicateTherapy(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/duplicateTherapy", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addEpidemiology(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/epidemiology", value);
        }

        @Override
        public PhysicalActivity.Builder addEpidemiology(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/epidemiology", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addGuideline(MedicalGuideline value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public PhysicalActivity.Builder addGuideline(MedicalGuideline.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public PhysicalActivity.Builder addGuideline(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addImage(ImageObject value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PhysicalActivity.Builder addImage(ImageObject.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PhysicalActivity.Builder addImage(URL value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PhysicalActivity.Builder addImage(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addIndication(MedicalIndication value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/indication", value);
        }

        @Override
        public PhysicalActivity.Builder addIndication(MedicalIndication.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/indication", value.build());
        }

        @Override
        public PhysicalActivity.Builder addIndication(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/indication", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addMainEntityOfPage(CreativeWork value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PhysicalActivity.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PhysicalActivity.Builder addMainEntityOfPage(URL value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PhysicalActivity.Builder addMainEntityOfPage(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addMedicineSystem(MedicineSystem value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public PhysicalActivity.Builder addMedicineSystem(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addName(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PhysicalActivity.Builder addName(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addPathophysiology(Text value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/pathophysiology", value);
        }

        @Override
        public PhysicalActivity.Builder addPathophysiology(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/pathophysiology", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addPotentialAction(Action value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PhysicalActivity.Builder addPotentialAction(Action.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PhysicalActivity.Builder addPotentialAction(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addRecognizingAuthority(Organization value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public PhysicalActivity.Builder addRecognizingAuthority(Organization.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public PhysicalActivity.Builder addRecognizingAuthority(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public PhysicalActivity.Builder addRelevantSpecialty(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addSameAs(URL value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PhysicalActivity.Builder addSameAs(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addSeriousAdverseOutcome(MedicalEntity value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value);
        }

        @Override
        public PhysicalActivity.Builder addSeriousAdverseOutcome(MedicalEntity.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", value.build());
        }

        @Override
        public PhysicalActivity.Builder addSeriousAdverseOutcome(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/seriousAdverseOutcome", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addStudy(MedicalStudy value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public PhysicalActivity.Builder addStudy(MedicalStudy.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public PhysicalActivity.Builder addStudy(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addUrl(URL value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PhysicalActivity.Builder addUrl(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addDetailedDescription(Article value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PhysicalActivity.Builder addDetailedDescription(Article.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PhysicalActivity.Builder addDetailedDescription(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PhysicalActivity.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PhysicalActivity.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PhysicalActivity.Builder addPopularityScore(String value) {
            return (PhysicalActivity.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PhysicalActivity build() {
            return new PhysicalActivityImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

