/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTestImpl;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.PathologyTest;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class PathologyTestImpl
extends MedicalTestImpl
implements PathologyTest {
    private static final ImmutableSet<String> PROPERTY_SET = PathologyTestImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/tissueSample");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public PathologyTestImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/PathologyTest";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getTissueSampleList() {
        return this.getProperty("http://schema.org/tissueSample");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<PathologyTest.Builder>
    implements PathologyTest.Builder {
        BuilderImpl() {
        }

        @Override
        public PathologyTest.Builder addAdditionalType(URL value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public PathologyTest.Builder addAdditionalType(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addAffectedBy(Drug value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public PathologyTest.Builder addAffectedBy(Drug.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public PathologyTest.Builder addAffectedBy(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addAlternateName(Text value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public PathologyTest.Builder addAlternateName(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addCode(MedicalCode value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public PathologyTest.Builder addCode(MedicalCode.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public PathologyTest.Builder addCode(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addDescription(Text value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public PathologyTest.Builder addDescription(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addGuideline(MedicalGuideline value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public PathologyTest.Builder addGuideline(MedicalGuideline.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public PathologyTest.Builder addGuideline(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addImage(ImageObject value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PathologyTest.Builder addImage(ImageObject.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public PathologyTest.Builder addImage(URL value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public PathologyTest.Builder addImage(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addMainEntityOfPage(CreativeWork value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PathologyTest.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public PathologyTest.Builder addMainEntityOfPage(URL value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public PathologyTest.Builder addMainEntityOfPage(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addMedicineSystem(MedicineSystem value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public PathologyTest.Builder addMedicineSystem(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addName(Text value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public PathologyTest.Builder addName(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addNormalRange(Text value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public PathologyTest.Builder addNormalRange(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addPotentialAction(Action value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public PathologyTest.Builder addPotentialAction(Action.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public PathologyTest.Builder addPotentialAction(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addRecognizingAuthority(Organization value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public PathologyTest.Builder addRecognizingAuthority(Organization.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public PathologyTest.Builder addRecognizingAuthority(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public PathologyTest.Builder addRelevantSpecialty(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addSameAs(URL value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public PathologyTest.Builder addSameAs(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addSignDetected(MedicalSign value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public PathologyTest.Builder addSignDetected(MedicalSign.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public PathologyTest.Builder addSignDetected(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addStudy(MedicalStudy value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public PathologyTest.Builder addStudy(MedicalStudy.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public PathologyTest.Builder addStudy(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addTissueSample(Text value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/tissueSample", value);
        }

        @Override
        public PathologyTest.Builder addTissueSample(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/tissueSample", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addUrl(URL value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public PathologyTest.Builder addUrl(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addUsedToDiagnose(MedicalCondition value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public PathologyTest.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public PathologyTest.Builder addUsedToDiagnose(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addUsesDevice(MedicalDevice value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public PathologyTest.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public PathologyTest.Builder addUsesDevice(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addDetailedDescription(Article value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public PathologyTest.Builder addDetailedDescription(Article.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public PathologyTest.Builder addDetailedDescription(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public PathologyTest.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public PathologyTest.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public PathologyTest.Builder addPopularityScore(String value) {
            return (PathologyTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public PathologyTest build() {
            return new PathologyTestImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

