/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.OwnershipInfo;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Product;
import com.google.schemaorg.core.StructuredValueImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class OwnershipInfoImpl
extends StructuredValueImpl
implements OwnershipInfo {
    private static final ImmutableSet<String> PROPERTY_SET = OwnershipInfoImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/acquiredFrom");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/ownedFrom");
        builder.add((Object)"http://schema.org/ownedThrough");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/typeOfGood");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public OwnershipInfoImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/OwnershipInfo";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAcquiredFromList() {
        return this.getProperty("http://schema.org/acquiredFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOwnedFromList() {
        return this.getProperty("http://schema.org/ownedFrom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getOwnedThroughList() {
        return this.getProperty("http://schema.org/ownedThrough");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTypeOfGoodList() {
        return this.getProperty("http://schema.org/typeOfGood");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<OwnershipInfo.Builder>
    implements OwnershipInfo.Builder {
        BuilderImpl() {
        }

        @Override
        public OwnershipInfo.Builder addAcquiredFrom(Organization value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/acquiredFrom", value);
        }

        @Override
        public OwnershipInfo.Builder addAcquiredFrom(Organization.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/acquiredFrom", value.build());
        }

        @Override
        public OwnershipInfo.Builder addAcquiredFrom(Person value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/acquiredFrom", value);
        }

        @Override
        public OwnershipInfo.Builder addAcquiredFrom(Person.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/acquiredFrom", value.build());
        }

        @Override
        public OwnershipInfo.Builder addAcquiredFrom(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/acquiredFrom", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addAdditionalType(URL value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public OwnershipInfo.Builder addAdditionalType(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addAlternateName(Text value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public OwnershipInfo.Builder addAlternateName(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addDescription(Text value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public OwnershipInfo.Builder addDescription(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addImage(ImageObject value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OwnershipInfo.Builder addImage(ImageObject.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public OwnershipInfo.Builder addImage(URL value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public OwnershipInfo.Builder addImage(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addMainEntityOfPage(CreativeWork value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OwnershipInfo.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public OwnershipInfo.Builder addMainEntityOfPage(URL value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public OwnershipInfo.Builder addMainEntityOfPage(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addName(Text value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public OwnershipInfo.Builder addName(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addOwnedFrom(DateTime value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/ownedFrom", value);
        }

        @Override
        public OwnershipInfo.Builder addOwnedFrom(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/ownedFrom", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addOwnedThrough(DateTime value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/ownedThrough", value);
        }

        @Override
        public OwnershipInfo.Builder addOwnedThrough(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/ownedThrough", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addPotentialAction(Action value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public OwnershipInfo.Builder addPotentialAction(Action.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public OwnershipInfo.Builder addPotentialAction(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addSameAs(URL value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public OwnershipInfo.Builder addSameAs(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addTypeOfGood(Product value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/typeOfGood", value);
        }

        @Override
        public OwnershipInfo.Builder addTypeOfGood(Product.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/typeOfGood", value.build());
        }

        @Override
        public OwnershipInfo.Builder addTypeOfGood(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/typeOfGood", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addUrl(URL value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public OwnershipInfo.Builder addUrl(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addDetailedDescription(Article value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public OwnershipInfo.Builder addDetailedDescription(Article.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public OwnershipInfo.Builder addDetailedDescription(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public OwnershipInfo.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public OwnershipInfo.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public OwnershipInfo.Builder addPopularityScore(String value) {
            return (OwnershipInfo.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public OwnershipInfo build() {
            return new OwnershipInfoImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

